// Copyright 2014 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.lib.view;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * This event is fired once build info data is available.
 */
public final class BuildInfoEvent {
  private final Map<String, String> buildInfoMap;

  /**
   * Construct the event from a map.
   */
  public BuildInfoEvent(Map<String, String> buildInfo) {
    buildInfoMap = ImmutableMap.copyOf(buildInfo);
  }

  /**
   * Return immutable map populated with build info key/value pairs.
   */
  public Map<String, String> getBuildInfoMap() {
    return buildInfoMap;
  }
}
