fn main() {
    let output_file = std::path::PathBuf::from("src/chunk_dictionary.rs");
    let generated_file =
        std::path::PathBuf::from(std::env::var("OUT_DIR").unwrap()).join("chunk_dictionary.rs");

    if !output_file.exists() {
        prost_build::Config::new()
            .btree_map(["."])
            .compile_protos(&["proto/chunk_dictionary.proto"], &["proto/"])
            .unwrap();

        let content = format!(
            "// THIS FILE IS AUTOMATICALLY GENERATED\n// EDIT ../proto/chunk_dictionary.proto INSTEAD\n\n{}",
            std::fs::read_to_string(generated_file).unwrap()
        );
        std::fs::write(output_file, content).unwrap();
    }
}
