// Package api provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package api

import (
	"time"
)

const (
	BasicAuthScopes  = "basicAuth.Scopes"
	BearerAuthScopes = "bearerAuth.Scopes"
)

// Disk defines model for Disk.
type Disk struct {
	Dg         string  `json:"dg"`
	Id         string  `json:"id"`
	Model      string  `json:"model"`
	ObjectPath string  `json:"object_path"`
	Region     *string `json:"region,omitempty"`
	Size       int32   `json:"size"`
	Used       int     `json:"used"`
	Vendor     string  `json:"vendor"`
}

// NodeDisks defines model for NodeDisks.
type NodeDisks struct {
	Data *[]Disk `json:"data,omitempty"`
}

// ObjectConfig defines model for ObjectConfig.
type ObjectConfig struct {
	App                    *string   `json:"app,omitempty"`
	Comment                *string   `json:"comment,omitempty"`
	DrpNode                *string   `json:"drp_node,omitempty"`
	DrpNodes               *[]string `json:"drp_nodes,omitempty"`
	Env                    *string   `json:"env,omitempty"`
	FlexMax                *int      `json:"flex_max,omitempty"`
	FlexMin                *int      `json:"flex_min,omitempty"`
	FlexTarget             *int      `json:"flex_target,omitempty"`
	MonitoredResourceCount *int      `json:"monitored_resource_count,omitempty"`
	Orchestrate            *string   `json:"orchestrate,omitempty"`
	Path                   string    `json:"path"`
	RawConfig              *[]byte   `json:"raw_config,omitempty"`
	Scope                  *[]string `json:"scope,omitempty"`
	Topology               *string   `json:"topology,omitempty"`
}

// PostFeedDaemonPing defines model for PostFeedDaemonPing.
type PostFeedDaemonPing struct {
	// Nodes list of cluster node
	Nodes []string `json:"nodes"`

	// Objects list of cluster object names
	Objects []string `json:"objects"`

	// Version the opensvc client data version
	Version string `json:"version"`
}

// PostFeedDaemonStatus defines model for PostFeedDaemonStatus.
type PostFeedDaemonStatus struct {
	Changes           []string               `json:"changes"`
	Data              map[string]interface{} `json:"data"`
	PreviousUpdatedAt *time.Time             `json:"previous_updated_at,omitempty"`
	UpdatedAt         *time.Time             `json:"updated_at,omitempty"`

	// Version the opensvc client data version
	Version string `json:"version"`
}

// Problem defines model for Problem.
type Problem struct {
	// Detail A human-readable explanation specific to this occurrence of the
	// problem.
	Detail string `json:"detail"`

	// Status The HTTP status code ([RFC7231], Section 6) generated by the
	// origin server for this occurrence of the problem.
	Status int `json:"status"`

	// Title A short, human-readable summary of the problem type.  It SHOULD
	// NOT change from occurrence to occurrence of the problem, except
	// for purposes of localization (e.g., using proactive content
	// negotiation; see [RFC7231], Section 3.4).
	Title string `json:"title"`
}

// Package defines model for package.
type Package struct {
	Arch        string     `json:"arch"`
	InstalledAt *time.Time `json:"installed_at,omitempty"`
	Name        string     `json:"name"`
	Sig         string     `json:"sig"`
	Type        string     `json:"type"`
	Version     string     `json:"version"`
}

// System defines model for system.
type System struct {
	Package *[]Package `json:"package,omitempty"`
}

// Version defines model for version.
type Version struct {
	Version string `json:"version"`
}

// N400 defines model for 400.
type N400 = Problem

// N401 defines model for 401.
type N401 = Problem

// N403 defines model for 403.
type N403 = Problem

// N500 defines model for 500.
type N500 = Problem

// FeedDaemonPingAccepted defines model for FeedDaemonPingAccepted.
type FeedDaemonPingAccepted struct {
	// ObjectWithoutConfig list of object names that requires POST /oc3/feed/object/config
	ObjectWithoutConfig *[]string `json:"object_without_config,omitempty"`
}

// FeedDaemonStatusAccepted defines model for FeedDaemonStatusAccepted.
type FeedDaemonStatusAccepted struct {
	// ObjectWithoutConfig list of object names that requires POST /oc3/feed/object/config
	ObjectWithoutConfig *[]string `json:"object_without_config,omitempty"`
}

// PostFeedDaemonPingJSONRequestBody defines body for PostFeedDaemonPing for application/json ContentType.
type PostFeedDaemonPingJSONRequestBody = PostFeedDaemonPing

// PostFeedDaemonStatusJSONRequestBody defines body for PostFeedDaemonStatus for application/json ContentType.
type PostFeedDaemonStatusJSONRequestBody = PostFeedDaemonStatus

// PostFeedNodeDiskJSONRequestBody defines body for PostFeedNodeDisk for application/json ContentType.
type PostFeedNodeDiskJSONRequestBody = NodeDisks

// PostFeedObjectConfigJSONRequestBody defines body for PostFeedObjectConfig for application/json ContentType.
type PostFeedObjectConfigJSONRequestBody = ObjectConfig

// PostFeedSystemJSONRequestBody defines body for PostFeedSystem for application/json ContentType.
type PostFeedSystemJSONRequestBody = System
