# Contributing to OLCUT

We welcome your contributions! There are several directions that OLCUT could
be extended in. New config file formats could be added, more classes can be
added for the `@Config` annotation,  more classes can be supported by the
`CommandInterpreter`'s `@Command` methods.  Have an idea? Talk to us and
let's make it happen. Just file an Issue to get in touch.

## Questions, Bugs, and Features

If you hit a bug or have an enhancement request please file a [GitHub issue](https://github.com/oracle/olcut/issues).
This is also a great way to ask us questions. When filing a bug remember that
the better written the bug is, the more likely it is to be fixed. Please include:

1. Version of OLCUT
1. OS
1. Java version
1. As much code as you can provide to reproduce the bug
1. Any relevant configuration file snippets 
1. Steps to reproduce

## Code

We welcome code contributions, but we need the contributor to sign the
[Oracle Contributor Agreement (OCA)](https://www.oracle.com/technetwork/community/oca-486395.html)
first.

The process:

1. We encourage you to file an [issue](https://github.com/oracle/olcut/issues) to discuss your idea with us before implementing anything.
1. Sign the [OCA](https://www.oracle.com/technetwork/community/oca-486395.html)
1. Fork the repository and work your magic
1. Create a Pull Request
1. We will review your PR and merge as appropriate.

## Code of Conduct

Follow the [Golden Rule](https://en.wikipedia.org/wiki/Golden_Rule). If
you'd like more specific guidelines see the
[Contributor Covenant Code of Conduct](https://www.contributor-covenant.org/version/1/4/code-of-conduct.html)
