# Threw `undefined`/`null`

#### Why This Error Occurred

Somewhere in your code you `throw` an `undefined` or `null` value. Since this isn't a valid error there isn't a stack trace. We show this error instead to let you know what to look for.

```js
function getData() {
  let error
  throw error
}

function Page() {
  const error = data?.error || null
  throw error
}
```

#### Possible Ways to Fix It

Look in your pages and find where an error could be throwing `undefined` or `null` values and ensure `new Error()` is used instead.
