//@ts-nocheck
// DO NOT MODIFY THIS FILE. This file is automatically generated by Tina
export function gql(strings: TemplateStringsArray, ...args: string[]): string {
  let str = ''
  strings.forEach((string, i) => {
    str += string + (args[i] || '')
  })
  return str
}
export type Maybe<T> = T | null
export type InputMaybe<T> = Maybe<T>
export type Exact<T extends { [key: string]: unknown }> = {
  [K in keyof T]: T[K]
}
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]?: Maybe<T[SubKey]>
}
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]: Maybe<T[SubKey]>
}
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string
  String: string
  Boolean: boolean
  Int: number
  Float: number
  /** References another document, used as a foreign key */
  Reference: any
  JSON: any
}

export type SystemInfo = {
  __typename?: 'SystemInfo'
  filename: Scalars['String']
  basename: Scalars['String']
  breadcrumbs: Array<Scalars['String']>
  path: Scalars['String']
  relativePath: Scalars['String']
  extension: Scalars['String']
  template: Scalars['String']
  collection: Collection
}

export type SystemInfoBreadcrumbsArgs = {
  excludeExtension?: InputMaybe<Scalars['Boolean']>
}

export type PageInfo = {
  __typename?: 'PageInfo'
  hasPreviousPage: Scalars['Boolean']
  hasNextPage: Scalars['Boolean']
  startCursor: Scalars['String']
  endCursor: Scalars['String']
}

export type Node = {
  id: Scalars['ID']
}

export type Document = {
  id: Scalars['ID']
  _sys?: Maybe<SystemInfo>
  _values: Scalars['JSON']
}

/** A relay-compliant pagination connection */
export type Connection = {
  totalCount: Scalars['Float']
  pageInfo: PageInfo
}

export type Query = {
  __typename?: 'Query'
  getOptimizedQuery?: Maybe<Scalars['String']>
  collection: Collection
  collections: Array<Collection>
  node: Node
  document: DocumentNode
  posts: Posts
  postsConnection: PostsConnection
}

export type QueryGetOptimizedQueryArgs = {
  queryString: Scalars['String']
}

export type QueryCollectionArgs = {
  collection?: InputMaybe<Scalars['String']>
}

export type QueryNodeArgs = {
  id?: InputMaybe<Scalars['String']>
}

export type QueryDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath?: InputMaybe<Scalars['String']>
}

export type QueryPostsArgs = {
  relativePath?: InputMaybe<Scalars['String']>
}

export type QueryPostsConnectionArgs = {
  before?: InputMaybe<Scalars['String']>
  after?: InputMaybe<Scalars['String']>
  first?: InputMaybe<Scalars['Float']>
  last?: InputMaybe<Scalars['Float']>
  sort?: InputMaybe<Scalars['String']>
}

export type DocumentConnectionEdges = {
  __typename?: 'DocumentConnectionEdges'
  cursor: Scalars['String']
  node?: Maybe<DocumentNode>
}

export type DocumentConnection = Connection & {
  __typename?: 'DocumentConnection'
  pageInfo: PageInfo
  totalCount: Scalars['Float']
  edges?: Maybe<Array<Maybe<DocumentConnectionEdges>>>
}

export type Collection = {
  __typename?: 'Collection'
  name: Scalars['String']
  slug: Scalars['String']
  label?: Maybe<Scalars['String']>
  path: Scalars['String']
  format?: Maybe<Scalars['String']>
  matches?: Maybe<Scalars['String']>
  templates?: Maybe<Array<Maybe<Scalars['JSON']>>>
  fields?: Maybe<Array<Maybe<Scalars['JSON']>>>
  documents: DocumentConnection
}

export type CollectionDocumentsArgs = {
  before?: InputMaybe<Scalars['String']>
  after?: InputMaybe<Scalars['String']>
  first?: InputMaybe<Scalars['Float']>
  last?: InputMaybe<Scalars['Float']>
  sort?: InputMaybe<Scalars['String']>
}

export type DocumentNode = Posts

export type PostsAuthor = {
  __typename?: 'PostsAuthor'
  name?: Maybe<Scalars['String']>
  picture?: Maybe<Scalars['String']>
}

export type PostsOgImage = {
  __typename?: 'PostsOgImage'
  url?: Maybe<Scalars['String']>
}

export type Posts = Node &
  Document & {
    __typename?: 'Posts'
    title?: Maybe<Scalars['String']>
    excerpt?: Maybe<Scalars['String']>
    coverImage?: Maybe<Scalars['String']>
    date?: Maybe<Scalars['String']>
    author?: Maybe<PostsAuthor>
    ogImage?: Maybe<PostsOgImage>
    body?: Maybe<Scalars['String']>
    id: Scalars['ID']
    _sys: SystemInfo
    _values: Scalars['JSON']
  }

export type PostsConnectionEdges = {
  __typename?: 'PostsConnectionEdges'
  cursor: Scalars['String']
  node?: Maybe<Posts>
}

export type PostsConnection = Connection & {
  __typename?: 'PostsConnection'
  pageInfo: PageInfo
  totalCount: Scalars['Float']
  edges?: Maybe<Array<Maybe<PostsConnectionEdges>>>
}

export type Mutation = {
  __typename?: 'Mutation'
  addPendingDocument: DocumentNode
  updateDocument: DocumentNode
  deleteDocument: DocumentNode
  createDocument: DocumentNode
  updatePosts: Posts
  createPosts: Posts
}

export type MutationAddPendingDocumentArgs = {
  collection: Scalars['String']
  relativePath: Scalars['String']
  template?: InputMaybe<Scalars['String']>
}

export type MutationUpdateDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath: Scalars['String']
  params: DocumentMutation
}

export type MutationDeleteDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath: Scalars['String']
}

export type MutationCreateDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath: Scalars['String']
  params: DocumentMutation
}

export type MutationUpdatePostsArgs = {
  relativePath: Scalars['String']
  params: PostsMutation
}

export type MutationCreatePostsArgs = {
  relativePath: Scalars['String']
  params: PostsMutation
}

export type DocumentMutation = {
  posts?: InputMaybe<PostsMutation>
}

export type PostsAuthorMutation = {
  name?: InputMaybe<Scalars['String']>
  picture?: InputMaybe<Scalars['String']>
}

export type PostsOgImageMutation = {
  url?: InputMaybe<Scalars['String']>
}

export type PostsMutation = {
  title?: InputMaybe<Scalars['String']>
  excerpt?: InputMaybe<Scalars['String']>
  coverImage?: InputMaybe<Scalars['String']>
  date?: InputMaybe<Scalars['String']>
  author?: InputMaybe<PostsAuthorMutation>
  ogImage?: InputMaybe<PostsOgImageMutation>
  body?: InputMaybe<Scalars['String']>
}

export type PostsPartsFragment = {
  __typename?: 'Posts'
  title?: string | null
  excerpt?: string | null
  coverImage?: string | null
  date?: string | null
  body?: string | null
  author?: {
    __typename: 'PostsAuthor'
    name?: string | null
    picture?: string | null
  } | null
  ogImage?: { __typename: 'PostsOgImage'; url?: string | null } | null
}

export type PostsQueryVariables = Exact<{
  relativePath: Scalars['String']
}>

export type PostsQuery = {
  __typename?: 'Query'
  posts: {
    __typename?: 'Posts'
    id: string
    title?: string | null
    excerpt?: string | null
    coverImage?: string | null
    date?: string | null
    body?: string | null
    _sys: {
      __typename?: 'SystemInfo'
      filename: string
      basename: string
      breadcrumbs: Array<string>
      path: string
      relativePath: string
      extension: string
    }
    author?: {
      __typename: 'PostsAuthor'
      name?: string | null
      picture?: string | null
    } | null
    ogImage?: { __typename: 'PostsOgImage'; url?: string | null } | null
  }
}

export type PostsConnectionQueryVariables = Exact<{ [key: string]: never }>

export type PostsConnectionQuery = {
  __typename?: 'Query'
  postsConnection: {
    __typename?: 'PostsConnection'
    totalCount: number
    edges?: Array<{
      __typename?: 'PostsConnectionEdges'
      node?: {
        __typename?: 'Posts'
        id: string
        title?: string | null
        excerpt?: string | null
        coverImage?: string | null
        date?: string | null
        body?: string | null
        _sys: {
          __typename?: 'SystemInfo'
          filename: string
          basename: string
          breadcrumbs: Array<string>
          path: string
          relativePath: string
          extension: string
        }
        author?: {
          __typename: 'PostsAuthor'
          name?: string | null
          picture?: string | null
        } | null
        ogImage?: { __typename: 'PostsOgImage'; url?: string | null } | null
      } | null
    } | null> | null
  }
}

export const PostsPartsFragmentDoc = gql`
  fragment PostsParts on Posts {
    title
    excerpt
    coverImage
    date
    author {
      __typename
      name
      picture
    }
    ogImage {
      __typename
      url
    }
    body
  }
`
export const PostsDocument = gql`
  query posts($relativePath: String!) {
    posts(relativePath: $relativePath) {
      _sys {
        filename
        basename
        breadcrumbs
        path
        relativePath
        extension
      }
      id
      ...PostsParts
    }
  }
  ${PostsPartsFragmentDoc}
`
export const PostsConnectionDocument = gql`
  query postsConnection {
    postsConnection {
      totalCount
      edges {
        node {
          id
          _sys {
            filename
            basename
            breadcrumbs
            path
            relativePath
            extension
          }
          ...PostsParts
        }
      }
    }
  }
  ${PostsPartsFragmentDoc}
`
export type Requester<C = {}> = <R, V>(
  doc: DocumentNode,
  vars?: V,
  options?: C
) => Promise<R>
export function getSdk<C>(requester: Requester<C>) {
  return {
    posts(
      variables: PostsQueryVariables,
      options?: C
    ): Promise<{
      data: PostsQuery
      variables: PostsQueryVariables
      query: string
    }> {
      return requester<
        { data: PostsQuery; variables: PostsQueryVariables; query: string },
        PostsQueryVariables
      >(PostsDocument, variables, options)
    },
    postsConnection(
      variables?: PostsConnectionQueryVariables,
      options?: C
    ): Promise<{
      data: PostsConnectionQuery
      variables: PostsConnectionQueryVariables
      query: string
    }> {
      return requester<
        {
          data: PostsConnectionQuery
          variables: PostsConnectionQueryVariables
          query: string
        },
        PostsConnectionQueryVariables
      >(PostsConnectionDocument, variables, options)
    },
  }
}
export type Sdk = ReturnType<typeof getSdk>

// TinaSDK generated code
import { createClient } from 'tinacms/dist/client'
const client = createClient({ url: 'http://localhost:4001/graphql' })

const requester: (doc: any, vars?: any, options?: any) => Promise<any> = async (
  doc,
  vars,
  _options
) => {
  let data = {}
  try {
    data = await client.request({
      query: doc,
      variables: vars,
    })
  } catch (e) {
    // swallow errors related to document creation
    console.warn('Warning: There was an error when fetching data')
    console.warn(e)
  }

  return { data: data?.data, query: doc, variables: vars || {} }
}

/**
 * @experimental this class can be used but may change in the future
 **/
export const ExperimentalGetTinaClient = () => getSdk(requester)
