import sys
from pathlib import Path

from warg import cprint

PACKAGE_ROOT = Path(__file__).parent.parent.parent
cprint(PACKAGE_ROOT)
sys.path.insert(0, str(PACKAGE_ROOT.absolute()))

from jord import (
    PROJECT_AUTHOR,
    PROJECT_NAME,
    PROJECT_ORGANISATION,
    PROJECT_VERSION,
    PROJECT_YEAR,
)

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.

extensions = [
    "sphinx.ext.napoleon",
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.viewcode",
    "sphinx.ext.githubpages",
    "sphinx.ext.graphviz",
]

napoleon_use_ivar = True
autosummary_generate = True
# autosummary_imported_members = False
autosummary_ignore_module_all = False
autosummary_generate_overwrite = True
autoclass_content = "both"
html_show_sourcelink = False
autodoc_inherit_docstrings = True
set_type_checking_flag = True
autodoc_default_flags = ["members"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["../templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
# source_suffix = '.rst'
source_suffix = {".rst": "restructuredtext", ".txt": "markdown", ".md": "markdown"}

# source_parsers = {
#    '.md': CommonMarkParser,
# }

# The master toctree document.
master_doc = "index"

# General information about the project.
project = PROJECT_NAME
author = PROJECT_AUTHOR
copyright_text = f"{PROJECT_YEAR}, {PROJECT_AUTHOR}"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
version = PROJECT_VERSION
release = version  # 'master'

rst_prolog = f"""
.. |project| replace:: {project}
.. |organisation| replace:: {PROJECT_ORGANISATION}
.. |PROJECT_NAME| replace:: {PROJECT_NAME}
"""

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set 'language' from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = [
    "**/*exclude*",
    "**/*Exclude*",
    "**/*exclude*/**",
    "**/*Exclude*/**",
]

# The name of the Pygments (syntax highlighting) style to use.
highlight_language = "python"
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named 'default.css' will overwrite the builtin 'default.css'.
docs_dir = Path(__file__).parent.parent
image_dir = docs_dir.parent / ".github" / "images"
html_static_path = [str(image_dir), str(docs_dir / "style")]
html_logo = str(image_dir / "header.svg")
html_css_files = ["custom.css"]

html_theme_options = {
    # "logo_only": True,
    # "display_version": False,
}

html_baseurl = f"{PROJECT_ORGANISATION}.github.io/{PROJECT_NAME}"

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = f"{PROJECT_NAME}doc"

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        f"{PROJECT_NAME}.tex",
        f"{PROJECT_NAME} Documentation",
        PROJECT_AUTHOR,
        "manual",
    )
]

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, PROJECT_NAME, f"{PROJECT_NAME} Documentation", [PROJECT_AUTHOR], 1)
]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        PROJECT_NAME,
        f"{PROJECT_NAME} Documentation",
        PROJECT_AUTHOR,
        PROJECT_NAME,
        "One line description of project.",
        "Miscellaneous",
    )
]

# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_title = PROJECT_NAME
epub_author = PROJECT_AUTHOR
epub_publisher = PROJECT_AUTHOR
epub_copyright = copyright_text

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    "python": ("https://docs.python.org/", None),
    "numpy": ("http://docs.scipy.org/doc/numpy/", None),
}

# -- A patch that prevents Sphinx from cross-referencing ivar tags -------
# See http://stackoverflow.com/a/41184353/3343043

from docutils import nodes
from sphinx import addnodes
from sphinx.util.docfields import TypedField


def patched_make_field(self, types, domain, items, **kw):
    """description"""

    # `kw` catches `env=None` needed for newer sphinx while maintaining
    #  backwards compatibility when passed along further down!
    # #type: (List, unicode, Tuple) -> nodes.field
    def handle_item(fieldarg, content):
        """description"""
        par = nodes.paragraph()
        par += addnodes.literal_strong("", fieldarg)  # Patch: this line added
        # par.extend(self.make_xrefs(self.rolename, domain, fieldarg,
        #                           addnodes.literal_strong))
        if fieldarg in types:
            par += nodes.Text(" (")
            # NOTE: using .pop() here to prevent a single type node to be
            # inserted twice into the doctree, which leads to
            # inconsistencies later when references are resolved
            fieldtype = types.pop(fieldarg)
            if len(fieldtype) == 1 and isinstance(fieldtype[0], nodes.Text):
                typename = "".join(n.astext() for n in fieldtype)
                typename = typename.replace("int", "python:int")
                typename = typename.replace("long", "python:long")
                typename = typename.replace("float", "python:float")
                typename = typename.replace("type", "python:type")
                par.extend(
                    self.make_xrefs(
                        self.typerolename,
                        domain,
                        typename,
                        addnodes.literal_emphasis,
                        **kw,
                    )
                )
            else:
                par += fieldtype
            par += nodes.Text(")")
        par += nodes.Text(" -- ")
        par += content
        return par

    field_name = nodes.field_name("", self.label)
    if len(items) == 1 and self.can_collapse:
        field_arg, content = items[0]
        body_node = handle_item(field_arg, content)
    else:
        body_node = self.list_type()
        for field_arg, content in items:
            body_node += nodes.list_item("", handle_item(field_arg, content))
    field_body = nodes.field_body("", body_node)
    return nodes.field("", field_name, field_body)


TypedField.make_field = patched_make_field
