﻿' Definition of syntax model.
' DO NOT HAND EDIT

Imports System.Collections.Generic
Imports System.Collections.Immutable
Imports System.Runtime.CompilerServices
Imports Microsoft.CodeAnalysis.Syntax.InternalSyntax
Imports Microsoft.CodeAnalysis.VisualBasic.Syntax
Imports Roslyn.Utilities

Namespace Microsoft.CodeAnalysis.VisualBasic.Syntax

    ''' <summary>
    ''' Represents one of the type characters or literal suffixes of VB. Used to
    ''' describe a) the type character suffixes that can be placed on identifiers, and
    ''' b) the suffixes that can be placed on integer literals.
    ''' </summary>
    Public Enum TypeCharacter

        None

        ''' <summary>
        ''' The "%" type character."
        ''' </summary>
        [Integer]

        ''' <summary>
        ''' The "&amp;" type character."
        ''' </summary>
        [Long]

        ''' <summary>
        ''' The "@" type character."
        ''' </summary>
        [Decimal]

        ''' <summary>
        ''' The "!" type character."
        ''' </summary>
        [Single]

        ''' <summary>
        ''' The "#" type character."
        ''' </summary>
        [Double]

        ''' <summary>
        ''' The "$" type character."
        ''' </summary>
        [String]

        ''' <summary>
        ''' The "S" literal suffix denoting "Short"
        ''' </summary>
        ShortLiteral

        ''' <summary>
        ''' The "US" literal suffix denoting "UShort"
        ''' </summary>
        UShortLiteral

        ''' <summary>
        ''' The "I" literal suffix denoting "Integer"
        ''' </summary>
        IntegerLiteral

        ''' <summary>
        ''' The "UI" literal suffix denoting "UInteger"
        ''' </summary>
        UIntegerLiteral

        ''' <summary>
        ''' The "L" literal suffix denoting "Long"
        ''' </summary>
        LongLiteral

        ''' <summary>
        ''' The "UL" literal suffix denoting "ULong"
        ''' </summary>
        ULongLiteral

        ''' <summary>
        ''' The "F" literal suffix denoting "Single"
        ''' </summary>
        SingleLiteral

        ''' <summary>
        ''' The "R" literal suffix denoting "Double"
        ''' </summary>
        DoubleLiteral

        ''' <summary>
        ''' The "D" literal suffix denoting "Decimal"
        ''' </summary>
        DecimalLiteral
    End Enum

    ''' <summary>
    ''' The four possible number bases that a literal can be written in.
    ''' </summary>
    Public Enum LiteralBase

        [Decimal]

        Hexadecimal

        Octal

        Binary
    End Enum



    ''' <summary>
    ''' The base class for all nodes that represent statements. This includes both
    ''' declaration statements, such as class declarations as well as executable
    ''' statements.
    ''' </summary>
    Public MustInherit Class StatementSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' The base class for all nodes that represent executable statements.
    ''' </summary>
    Public MustInherit Class ExecutableStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' The base class for all nodes that represent statements that declare options,
    ''' imports, members, etc.
    ''' </summary>
    Public MustInherit Class DeclarationStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' A class to represent an empty statement. This can occur when a colon is on a
    ''' line without anything else.
    ''' </summary>
    Public NotInheritable Class EmptyStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), empty As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EmptyStatementSyntax(kind, errors, annotations, empty), Nothing, 0)
        End Sub

        ''' <summary>
        ''' An empty token because all non terminals must have a token.
        ''' </summary>
        Public  ReadOnly Property Empty As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EmptyStatementSyntax)._empty, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Empty property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithEmpty(empty as SyntaxToken) As EmptyStatementSyntax
            return Update(empty)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEmptyStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEmptyStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="empty">
        ''' The value for the Empty property.
        ''' </param>
        Public Function Update(empty As SyntaxToken) As EmptyStatementSyntax
            If empty <> Me.Empty Then
                Dim newNode = SyntaxFactory.EmptyStatement(empty)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an "End XXX" statement, where XXX is a single keyword.
    ''' </summary>
    Public NotInheritable Class EndBlockStatementSyntax
        Inherits DeclarationStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax(kind, errors, annotations, endKeyword, blockKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "End" keyword
        ''' </summary>
        Public  ReadOnly Property EndKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)._endKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEndKeyword(endKeyword as SyntaxToken) As EndBlockStatementSyntax
            return Update(Me.Kind, endKeyword, Me.BlockKeyword)
        End Function

        ''' <summary>
        ''' The keyword that ends the block. Must be one of: "If", "Using", "With",
        ''' "Select", "Structure", "Enum", "Interface", "Class", "Module", "Namespace",
        ''' "Sub", "Function", "Get, "Set", "Property", "Operator", "Event", "AddHandler",
        ''' "RemoveHandler", "RaiseEvent", "While", "Try" or "SyncLock".
        ''' </summary>
        Public  ReadOnly Property BlockKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)._blockKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the BlockKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithBlockKeyword(blockKeyword as SyntaxToken) As EndBlockStatementSyntax
            return Update(Me.Kind, Me.EndKeyword, blockKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEndBlockStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEndBlockStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="endKeyword">
        ''' The value for the EndKeyword property.
        ''' </param>
        ''' <param name="blockKeyword">
        ''' The value for the BlockKeyword property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, endKeyword As SyntaxToken, blockKeyword As SyntaxToken) As EndBlockStatementSyntax
            If kind <> Me.Kind OrElse endKeyword <> Me.EndKeyword OrElse blockKeyword <> Me.BlockKeyword Then
                Dim newNode = SyntaxFactory.EndBlockStatement(kind, endKeyword, blockKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an entire source file of VB code.
    ''' </summary>
    Partial Public NotInheritable Class CompilationUnitSyntax
        Inherits VisualBasicSyntaxNode

        Friend _options as SyntaxNode
        Friend _imports as SyntaxNode
        Friend _attributes as SyntaxNode
        Friend _members as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), options As SyntaxNode, [imports] As SyntaxNode, attributes As SyntaxNode, members As SyntaxNode, endOfFileToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CompilationUnitSyntax(kind, errors, annotations, if(options IsNot Nothing, options.Green, Nothing), if([imports] IsNot Nothing, [imports].Green, Nothing), if(attributes IsNot Nothing, attributes.Green, Nothing), if(members IsNot Nothing, members.Green, Nothing), endOfFileToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' Represents the list of Option statements at the beginning of a source file.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Options As SyntaxList(Of OptionStatementSyntax)
            Get
                Dim listNode = GetRedAtZero(_options)
                Return new SyntaxList(Of OptionStatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Options property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOptions(options as SyntaxList(Of OptionStatementSyntax)) As CompilationUnitSyntax
            return Update(options, Me.Imports, Me.Attributes, Me.Members, Me.EndOfFileToken)
        End Function

        Public Shadows Function AddOptions(ParamArray items As OptionStatementSyntax()) As CompilationUnitSyntax
            Return Me.WithOptions(Me.Options.AddRange(items))
        End Function

        ''' <summary>
        ''' Represents the list of Imports statements at the beginning of a source file.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property [Imports] As SyntaxList(Of ImportsStatementSyntax)
            Get
                Dim listNode = GetRed(_imports, 1)
                Return new SyntaxList(Of ImportsStatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the [Imports] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithImports([imports] as SyntaxList(Of ImportsStatementSyntax)) As CompilationUnitSyntax
            return Update(Me.Options, [imports], Me.Attributes, Me.Members, Me.EndOfFileToken)
        End Function

        Public Shadows Function AddImports(ParamArray items As ImportsStatementSyntax()) As CompilationUnitSyntax
            Return Me.WithImports(Me.Imports.AddRange(items))
        End Function

        ''' <summary>
        ''' Represents the list of AttributeStatements at the beginning of a source file
        ''' that contain the Assembly and Module attributes.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Attributes As SyntaxList(Of AttributesStatementSyntax)
            Get
                Dim listNode = GetRed(_attributes, 2)
                Return new SyntaxList(Of AttributesStatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Attributes property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAttributes(attributes as SyntaxList(Of AttributesStatementSyntax)) As CompilationUnitSyntax
            return Update(Me.Options, Me.Imports, attributes, Me.Members, Me.EndOfFileToken)
        End Function

        Public Shadows Function AddAttributes(ParamArray items As AttributesStatementSyntax()) As CompilationUnitSyntax
            Return Me.WithAttributes(Me.Attributes.AddRange(items))
        End Function

        ''' <summary>
        ''' Represents the members of the default namespace for this source file: all the
        ''' top-level type and namespace declarations in the file. May also contain
        ''' Statements that are not valid
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 3)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As CompilationUnitSyntax
            return Update(Me.Options, Me.Imports, Me.Attributes, members, Me.EndOfFileToken)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As CompilationUnitSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' Represents the end of the source file. This token may have trivia (whitespace,
        ''' comments, ...) attached to it.
        ''' </summary>
        Public  ReadOnly Property EndOfFileToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CompilationUnitSyntax)._endOfFileToken, Me.GetChildPosition(4), Me.GetChildIndex(4))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndOfFileToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndOfFileToken(endOfFileToken as SyntaxToken) As CompilationUnitSyntax
            return Update(Me.Options, Me.Imports, Me.Attributes, Me.Members, endOfFileToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._options
                Case 1
                    Return Me._imports
                Case 2
                    Return Me._attributes
                Case 3
                    Return Me._members
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_options)
                Case 1
                    Return GetRed(_imports, 1)
                Case 2
                    Return GetRed(_attributes, 2)
                Case 3
                    Return GetRed(_members, 3)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCompilationUnit(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCompilationUnit(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="options">
        ''' The value for the Options property.
        ''' </param>
        ''' <param name="imports">
        ''' The value for the Imports property.
        ''' </param>
        ''' <param name="attributes">
        ''' The value for the Attributes property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endOfFileToken">
        ''' The value for the EndOfFileToken property.
        ''' </param>
        Public Function Update(options As SyntaxList(of OptionStatementSyntax), [imports] As SyntaxList(of ImportsStatementSyntax), attributes As SyntaxList(of AttributesStatementSyntax), members As SyntaxList(of StatementSyntax), endOfFileToken As SyntaxToken) As CompilationUnitSyntax
            If options <> Me.Options OrElse [imports] <> Me.[Imports] OrElse attributes <> Me.Attributes OrElse members <> Me.Members OrElse endOfFileToken <> Me.EndOfFileToken Then
                Dim newNode = SyntaxFactory.CompilationUnit(options, [imports], attributes, members, endOfFileToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an Option statement, such as "Option Strict On".
    ''' </summary>
    Public NotInheritable Class OptionStatementSyntax
        Inherits DeclarationStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OptionStatementSyntax(kind, errors, annotations, optionKeyword, nameKeyword, valueKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Option" keyword.
        ''' </summary>
        Public  ReadOnly Property OptionKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OptionStatementSyntax)._optionKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OptionKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOptionKeyword(optionKeyword as SyntaxToken) As OptionStatementSyntax
            return Update(optionKeyword, Me.NameKeyword, Me.ValueKeyword)
        End Function

        ''' <summary>
        ''' The keyword that identifies the option being set: Explicit, Strict, Compare or
        ''' Infer.
        ''' </summary>
        Public  ReadOnly Property NameKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OptionStatementSyntax)._nameKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NameKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNameKeyword(nameKeyword as SyntaxToken) As OptionStatementSyntax
            return Update(Me.OptionKeyword, nameKeyword, Me.ValueKeyword)
        End Function

        ''' <summary>
        ''' The keyword that identifiers the value being set for the option: On, Off, Text
        ''' or Binary.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ValueKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OptionStatementSyntax)._valueKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(2), Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ValueKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithValueKeyword(valueKeyword as SyntaxToken) As OptionStatementSyntax
            return Update(Me.OptionKeyword, Me.NameKeyword, valueKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitOptionStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitOptionStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="optionKeyword">
        ''' The value for the OptionKeyword property.
        ''' </param>
        ''' <param name="nameKeyword">
        ''' The value for the NameKeyword property.
        ''' </param>
        ''' <param name="valueKeyword">
        ''' The value for the ValueKeyword property.
        ''' </param>
        Public Function Update(optionKeyword As SyntaxToken, nameKeyword As SyntaxToken, valueKeyword As SyntaxToken) As OptionStatementSyntax
            If optionKeyword <> Me.OptionKeyword OrElse nameKeyword <> Me.NameKeyword OrElse valueKeyword <> Me.ValueKeyword Then
                Dim newNode = SyntaxFactory.OptionStatement(optionKeyword, nameKeyword, valueKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an Imports statement, which has one or more imports clauses.
    ''' </summary>
    Public NotInheritable Class ImportsStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend _importsClauses as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImportsStatementSyntax(kind, errors, annotations, importsKeyword, if(importsClauses IsNot Nothing, importsClauses.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Imports" keyword.
        ''' </summary>
        Public  ReadOnly Property ImportsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImportsStatementSyntax)._importsKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImportsKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImportsKeyword(importsKeyword as SyntaxToken) As ImportsStatementSyntax
            return Update(importsKeyword, Me.ImportsClauses)
        End Function

        ''' <summary>
        ''' A list of one or more import clauses. Each clause is either an alias, namespace
        ''' or XML namespace import.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property ImportsClauses As SeparatedSyntaxList(Of ImportsClauseSyntax)
            Get
                Dim listNode = GetRed(_importsClauses, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ImportsClauseSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImportsClauses property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImportsClauses(importsClauses as SeparatedSyntaxList(Of ImportsClauseSyntax)) As ImportsStatementSyntax
            return Update(Me.ImportsKeyword, importsClauses)
        End Function

        Public Shadows Function AddImportsClauses(ParamArray items As ImportsClauseSyntax()) As ImportsStatementSyntax
            Return Me.WithImportsClauses(Me.ImportsClauses.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._importsClauses
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_importsClauses, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitImportsStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitImportsStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="importsKeyword">
        ''' The value for the ImportsKeyword property.
        ''' </param>
        ''' <param name="importsClauses">
        ''' The value for the ImportsClauses property.
        ''' </param>
        Public Function Update(importsKeyword As SyntaxToken, importsClauses As SeparatedSyntaxList(Of ImportsClauseSyntax)) As ImportsStatementSyntax
            If importsKeyword <> Me.ImportsKeyword OrElse importsClauses <> Me.ImportsClauses Then
                Dim newNode = SyntaxFactory.ImportsStatement(importsKeyword, importsClauses)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The base class for the possible clauses of an Imports statement.
    ''' </summary>
    Public MustInherit Class ImportsClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' Represents the clause of an Imports statement that imports all members of a
    ''' type or namespace or aliases a type or namespace.
    ''' </summary>
    Public NotInheritable Class SimpleImportsClauseSyntax
        Inherits ImportsClauseSyntax

        Friend _alias as ImportAliasClauseSyntax
        Friend _name as NameSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), [alias] As ImportAliasClauseSyntax, name As NameSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleImportsClauseSyntax(kind, errors, annotations, if([alias] IsNot Nothing , DirectCast([alias].Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImportAliasClauseSyntax), Nothing) , DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NameSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' An optional alias for the namespace or type being imported.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property [Alias] As ImportAliasClauseSyntax
            Get
                Return GetRedAtZero(_alias)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the [Alias] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAlias([alias] as ImportAliasClauseSyntax) As SimpleImportsClauseSyntax
            return Update([alias], Me.Name)
        End Function

        ''' <summary>
        ''' The namespace or type being imported.
        ''' </summary>
        Public  ReadOnly Property Name As NameSyntax
            Get
                Return GetRed(_name, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as NameSyntax) As SimpleImportsClauseSyntax
            return Update(Me.Alias, name)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._alias
                Case 1
                    Return Me._name
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.[Alias]
                Case 1
                    Return Me.Name
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSimpleImportsClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSimpleImportsClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="alias">
        ''' The value for the Alias property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        Public Function Update([alias] As ImportAliasClauseSyntax, name As NameSyntax) As SimpleImportsClauseSyntax
            If [alias] IsNot Me.[Alias] OrElse name IsNot Me.Name Then
                Dim newNode = SyntaxFactory.SimpleImportsClause([alias], name)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an alias identifier followed by an "=" token in an Imports clause.
    ''' </summary>
    Public NotInheritable Class ImportAliasClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImportAliasClauseSyntax(kind, errors, annotations, identifier, equalsToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The identifier being introduced.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImportAliasClauseSyntax)._identifier, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As ImportAliasClauseSyntax
            return Update(identifier, Me.EqualsToken)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Public  ReadOnly Property EqualsToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImportAliasClauseSyntax)._equalsToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EqualsToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEqualsToken(equalsToken as SyntaxToken) As ImportAliasClauseSyntax
            return Update(Me.Identifier, equalsToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitImportAliasClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitImportAliasClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="equalsToken">
        ''' The value for the EqualsToken property.
        ''' </param>
        Public Function Update(identifier As SyntaxToken, equalsToken As SyntaxToken) As ImportAliasClauseSyntax
            If identifier <> Me.Identifier OrElse equalsToken <> Me.EqualsToken Then
                Dim newNode = SyntaxFactory.ImportAliasClause(identifier, equalsToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Defines a XML namespace for XML expressions.
    ''' </summary>
    Public NotInheritable Class XmlNamespaceImportsClauseSyntax
        Inherits ImportsClauseSyntax

        Friend _xmlNamespace as XmlAttributeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlNamespaceImportsClauseSyntax(kind, errors, annotations, lessThanToken, DirectCast(xmlNamespace.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlAttributeSyntax), greaterThanToken), Nothing, 0)
        End Sub

        Public  ReadOnly Property LessThanToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlNamespaceImportsClauseSyntax)._lessThanToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LessThanToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLessThanToken(lessThanToken as SyntaxToken) As XmlNamespaceImportsClauseSyntax
            return Update(lessThanToken, Me.XmlNamespace, Me.GreaterThanToken)
        End Function

        ''' <summary>
        ''' Identifies the XML namespace alias and URI.
        ''' </summary>
        Public  ReadOnly Property XmlNamespace As XmlAttributeSyntax
            Get
                Return GetRed(_xmlNamespace, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the XmlNamespace property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithXmlNamespace(xmlNamespace as XmlAttributeSyntax) As XmlNamespaceImportsClauseSyntax
            return Update(Me.LessThanToken, xmlNamespace, Me.GreaterThanToken)
        End Function

        Public  ReadOnly Property GreaterThanToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlNamespaceImportsClauseSyntax)._greaterThanToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the GreaterThanToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithGreaterThanToken(greaterThanToken as SyntaxToken) As XmlNamespaceImportsClauseSyntax
            return Update(Me.LessThanToken, Me.XmlNamespace, greaterThanToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._xmlNamespace
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.XmlNamespace
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitXmlNamespaceImportsClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitXmlNamespaceImportsClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="lessThanToken">
        ''' The value for the LessThanToken property.
        ''' </param>
        ''' <param name="xmlNamespace">
        ''' The value for the XmlNamespace property.
        ''' </param>
        ''' <param name="greaterThanToken">
        ''' The value for the GreaterThanToken property.
        ''' </param>
        Public Function Update(lessThanToken As SyntaxToken, xmlNamespace As XmlAttributeSyntax, greaterThanToken As SyntaxToken) As XmlNamespaceImportsClauseSyntax
            If lessThanToken <> Me.LessThanToken OrElse xmlNamespace IsNot Me.XmlNamespace OrElse greaterThanToken <> Me.GreaterThanToken Then
                Dim newNode = SyntaxFactory.XmlNamespaceImportsClause(lessThanToken, xmlNamespace, greaterThanToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Namespace statement, its contents and the End Namespace statement.
    ''' </summary>
    Public NotInheritable Class NamespaceBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend _namespaceStatement as NamespaceStatementSyntax
        Friend _members as SyntaxNode
        Friend _endNamespaceStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), namespaceStatement As NamespaceStatementSyntax, members As SyntaxNode, endNamespaceStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamespaceBlockSyntax(kind, errors, annotations, DirectCast(namespaceStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamespaceStatementSyntax), if(members IsNot Nothing, members.Green, Nothing), DirectCast(endNamespaceStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The statement that begins the NamespaceBlock.
        ''' </summary>
        Public  ReadOnly Property NamespaceStatement As NamespaceStatementSyntax
            Get
                Return GetRedAtZero(_namespaceStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NamespaceStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithNamespaceStatement(namespaceStatement as NamespaceStatementSyntax) As NamespaceBlockSyntax
            return Update(namespaceStatement, Me.Members, Me.EndNamespaceStatement)
        End Function

        ''' <summary>
        ''' The declarations contained in the namespace statement.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As NamespaceBlockSyntax
            return Update(Me.NamespaceStatement, members, Me.EndNamespaceStatement)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As NamespaceBlockSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' The End Namespace statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndNamespaceStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endNamespaceStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndNamespaceStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndNamespaceStatement(endNamespaceStatement as EndBlockStatementSyntax) As NamespaceBlockSyntax
            return Update(Me.NamespaceStatement, Me.Members, endNamespaceStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._namespaceStatement
                Case 1
                    Return Me._members
                Case 2
                    Return Me._endNamespaceStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.NamespaceStatement
                Case 1
                    Return GetRed(_members, 1)
                Case 2
                    Return Me.EndNamespaceStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitNamespaceBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitNamespaceBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="namespaceStatement">
        ''' The value for the NamespaceStatement property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endNamespaceStatement">
        ''' The value for the EndNamespaceStatement property.
        ''' </param>
        Public Function Update(namespaceStatement As NamespaceStatementSyntax, members As SyntaxList(of StatementSyntax), endNamespaceStatement As EndBlockStatementSyntax) As NamespaceBlockSyntax
            If namespaceStatement IsNot Me.NamespaceStatement OrElse members <> Me.Members OrElse endNamespaceStatement IsNot Me.EndNamespaceStatement Then
                Dim newNode = SyntaxFactory.NamespaceBlock(namespaceStatement, members, endNamespaceStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a namespace declaration. This node always
    ''' appears as the Begin of a BlockStatement with Kind=NamespaceBlock.
    ''' </summary>
    Public NotInheritable Class NamespaceStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend _name as NameSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamespaceStatementSyntax(kind, errors, annotations, namespaceKeyword, DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NameSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Namespace" keyword.
        ''' </summary>
        Public  ReadOnly Property NamespaceKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamespaceStatementSyntax)._namespaceKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NamespaceKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithNamespaceKeyword(namespaceKeyword as SyntaxToken) As NamespaceStatementSyntax
            return Update(namespaceKeyword, Me.Name)
        End Function

        ''' <summary>
        ''' A (possibly dotted) name denoting the namespace being declared.
        ''' </summary>
        Public  ReadOnly Property Name As NameSyntax
            Get
                Return GetRed(_name, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as NameSyntax) As NamespaceStatementSyntax
            return Update(Me.NamespaceKeyword, name)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._name
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Name
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitNamespaceStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitNamespaceStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="namespaceKeyword">
        ''' The value for the NamespaceKeyword property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        Public Function Update(namespaceKeyword As SyntaxToken, name As NameSyntax) As NamespaceStatementSyntax
            If namespaceKeyword <> Me.NamespaceKeyword OrElse name IsNot Me.Name Then
                Dim newNode = SyntaxFactory.NamespaceStatement(namespaceKeyword, name)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Class, Interface, Structure, Module, its contents
    ''' and the End statement that ends it.
    ''' </summary>
    Public MustInherit Class TypeBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend _inherits as SyntaxNode
        Friend _implements as SyntaxNode
        Friend _members as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property [Inherits] As SyntaxList(Of InheritsStatementSyntax)
            Get
                Return Me.GetInheritsCore()
            End Get
        End Property

        Friend Overridable Function GetInheritsCore() As SyntaxList(Of InheritsStatementSyntax)
                Dim listNode = GetRedAtZero(_inherits)
                Return new SyntaxList(Of InheritsStatementSyntax)(listNode)
        End Function


        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property [Implements] As SyntaxList(Of ImplementsStatementSyntax)
            Get
                Return Me.GetImplementsCore()
            End Get
        End Property

        Friend Overridable Function GetImplementsCore() As SyntaxList(Of ImplementsStatementSyntax)
                Dim listNode = GetRed(_implements, 1)
                Return new SyntaxList(Of ImplementsStatementSyntax)(listNode)
        End Function


        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Return Me.GetMembersCore()
            End Get
        End Property

        Friend Overridable Function GetMembersCore() As SyntaxList(Of StatementSyntax)
                Dim listNode = GetRed(_members, 2)
                Return new SyntaxList(Of StatementSyntax)(listNode)
        End Function


    End Class

    ''' <summary>
    ''' Represents a declaration of Module, its contents and the End statement that
    ''' ends it.
    ''' </summary>
    Public NotInheritable Class ModuleBlockSyntax
        Inherits TypeBlockSyntax

        Friend _moduleStatement as ModuleStatementSyntax
        Friend _endModuleStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), moduleStatement As ModuleStatementSyntax, [inherits] As SyntaxNode, [implements] As SyntaxNode, members As SyntaxNode, endModuleStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModuleBlockSyntax(kind, errors, annotations, DirectCast(moduleStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModuleStatementSyntax), if([inherits] IsNot Nothing, [inherits].Green, Nothing), if([implements] IsNot Nothing, [implements].Green, Nothing), if(members IsNot Nothing, members.Green, Nothing), DirectCast(endModuleStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Module" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property ModuleStatement As ModuleStatementSyntax
            Get
                Return GetRedAtZero(_moduleStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ModuleStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithModuleStatement(moduleStatement as ModuleStatementSyntax) As ModuleBlockSyntax
            return Update(moduleStatement, Me.Inherits, Me.Implements, Me.Members, Me.EndModuleStatement)
        End Function

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Inherits] As SyntaxList(Of InheritsStatementSyntax)
            Get
                Dim listNode = GetRed(_inherits, 1)
                Return new SyntaxList(Of InheritsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetInheritsCore() As SyntaxList(Of InheritsStatementSyntax)
            Return Me.[Inherits]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Inherits] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInherits([inherits] as SyntaxList(Of InheritsStatementSyntax)) As ModuleBlockSyntax
            return Update(Me.ModuleStatement, [inherits], Me.Implements, Me.Members, Me.EndModuleStatement)
        End Function

        Public Shadows Function AddInherits(ParamArray items As InheritsStatementSyntax()) As ModuleBlockSyntax
            Return Me.WithInherits(Me.Inherits.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Implements] As SyntaxList(Of ImplementsStatementSyntax)
            Get
                Dim listNode = GetRed(_implements, 2)
                Return new SyntaxList(Of ImplementsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetImplementsCore() As SyntaxList(Of ImplementsStatementSyntax)
            Return Me.[Implements]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Implements] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithImplements([implements] as SyntaxList(Of ImplementsStatementSyntax)) As ModuleBlockSyntax
            return Update(Me.ModuleStatement, Me.Inherits, [implements], Me.Members, Me.EndModuleStatement)
        End Function

        Public Shadows Function AddImplements(ParamArray items As ImplementsStatementSyntax()) As ModuleBlockSyntax
            Return Me.WithImplements(Me.Implements.AddRange(items))
        End Function

        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 3)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetMembersCore() As SyntaxList(Of StatementSyntax)
            Return Me.Members
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As ModuleBlockSyntax
            return Update(Me.ModuleStatement, Me.Inherits, Me.Implements, members, Me.EndModuleStatement)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As ModuleBlockSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Module" statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndModuleStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endModuleStatement, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndModuleStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndModuleStatement(endModuleStatement as EndBlockStatementSyntax) As ModuleBlockSyntax
            return Update(Me.ModuleStatement, Me.Inherits, Me.Implements, Me.Members, endModuleStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._moduleStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endModuleStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.ModuleStatement
                Case 1
                    Return GetRed(_inherits, 1)
                Case 2
                    Return GetRed(_implements, 2)
                Case 3
                    Return GetRed(_members, 3)
                Case 4
                    Return Me.EndModuleStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitModuleBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitModuleBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="moduleStatement">
        ''' The value for the ModuleStatement property.
        ''' </param>
        ''' <param name="inherits">
        ''' The value for the Inherits property.
        ''' </param>
        ''' <param name="implements">
        ''' The value for the Implements property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endModuleStatement">
        ''' The value for the EndModuleStatement property.
        ''' </param>
        Public Function Update(moduleStatement As ModuleStatementSyntax, [inherits] As SyntaxList(of InheritsStatementSyntax), [implements] As SyntaxList(of ImplementsStatementSyntax), members As SyntaxList(of StatementSyntax), endModuleStatement As EndBlockStatementSyntax) As ModuleBlockSyntax
            If moduleStatement IsNot Me.ModuleStatement OrElse [inherits] <> Me.[Inherits] OrElse [implements] <> Me.[Implements] OrElse members <> Me.Members OrElse endModuleStatement IsNot Me.EndModuleStatement Then
                Dim newNode = SyntaxFactory.ModuleBlock(moduleStatement, [inherits], [implements], members, endModuleStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Structure, its contents and the End statement
    ''' that ends it.
    ''' </summary>
    Public NotInheritable Class StructureBlockSyntax
        Inherits TypeBlockSyntax

        Friend _structureStatement as StructureStatementSyntax
        Friend _endStructureStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), structureStatement As StructureStatementSyntax, [inherits] As SyntaxNode, [implements] As SyntaxNode, members As SyntaxNode, endStructureStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StructureBlockSyntax(kind, errors, annotations, DirectCast(structureStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StructureStatementSyntax), if([inherits] IsNot Nothing, [inherits].Green, Nothing), if([implements] IsNot Nothing, [implements].Green, Nothing), if(members IsNot Nothing, members.Green, Nothing), DirectCast(endStructureStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Structure" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property StructureStatement As StructureStatementSyntax
            Get
                Return GetRedAtZero(_structureStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the StructureStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithStructureStatement(structureStatement as StructureStatementSyntax) As StructureBlockSyntax
            return Update(structureStatement, Me.Inherits, Me.Implements, Me.Members, Me.EndStructureStatement)
        End Function

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Inherits] As SyntaxList(Of InheritsStatementSyntax)
            Get
                Dim listNode = GetRed(_inherits, 1)
                Return new SyntaxList(Of InheritsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetInheritsCore() As SyntaxList(Of InheritsStatementSyntax)
            Return Me.[Inherits]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Inherits] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInherits([inherits] as SyntaxList(Of InheritsStatementSyntax)) As StructureBlockSyntax
            return Update(Me.StructureStatement, [inherits], Me.Implements, Me.Members, Me.EndStructureStatement)
        End Function

        Public Shadows Function AddInherits(ParamArray items As InheritsStatementSyntax()) As StructureBlockSyntax
            Return Me.WithInherits(Me.Inherits.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Implements] As SyntaxList(Of ImplementsStatementSyntax)
            Get
                Dim listNode = GetRed(_implements, 2)
                Return new SyntaxList(Of ImplementsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetImplementsCore() As SyntaxList(Of ImplementsStatementSyntax)
            Return Me.[Implements]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Implements] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithImplements([implements] as SyntaxList(Of ImplementsStatementSyntax)) As StructureBlockSyntax
            return Update(Me.StructureStatement, Me.Inherits, [implements], Me.Members, Me.EndStructureStatement)
        End Function

        Public Shadows Function AddImplements(ParamArray items As ImplementsStatementSyntax()) As StructureBlockSyntax
            Return Me.WithImplements(Me.Implements.AddRange(items))
        End Function

        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 3)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetMembersCore() As SyntaxList(Of StatementSyntax)
            Return Me.Members
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As StructureBlockSyntax
            return Update(Me.StructureStatement, Me.Inherits, Me.Implements, members, Me.EndStructureStatement)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As StructureBlockSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Structure" statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndStructureStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endStructureStatement, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndStructureStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndStructureStatement(endStructureStatement as EndBlockStatementSyntax) As StructureBlockSyntax
            return Update(Me.StructureStatement, Me.Inherits, Me.Implements, Me.Members, endStructureStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._structureStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endStructureStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.StructureStatement
                Case 1
                    Return GetRed(_inherits, 1)
                Case 2
                    Return GetRed(_implements, 2)
                Case 3
                    Return GetRed(_members, 3)
                Case 4
                    Return Me.EndStructureStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitStructureBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitStructureBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="structureStatement">
        ''' The value for the StructureStatement property.
        ''' </param>
        ''' <param name="inherits">
        ''' The value for the Inherits property.
        ''' </param>
        ''' <param name="implements">
        ''' The value for the Implements property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endStructureStatement">
        ''' The value for the EndStructureStatement property.
        ''' </param>
        Public Function Update(structureStatement As StructureStatementSyntax, [inherits] As SyntaxList(of InheritsStatementSyntax), [implements] As SyntaxList(of ImplementsStatementSyntax), members As SyntaxList(of StatementSyntax), endStructureStatement As EndBlockStatementSyntax) As StructureBlockSyntax
            If structureStatement IsNot Me.StructureStatement OrElse [inherits] <> Me.[Inherits] OrElse [implements] <> Me.[Implements] OrElse members <> Me.Members OrElse endStructureStatement IsNot Me.EndStructureStatement Then
                Dim newNode = SyntaxFactory.StructureBlock(structureStatement, [inherits], [implements], members, endStructureStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Interface, its contents and the End statement
    ''' that ends it.
    ''' </summary>
    Public NotInheritable Class InterfaceBlockSyntax
        Inherits TypeBlockSyntax

        Friend _interfaceStatement as InterfaceStatementSyntax
        Friend _endInterfaceStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), interfaceStatement As InterfaceStatementSyntax, [inherits] As SyntaxNode, [implements] As SyntaxNode, members As SyntaxNode, endInterfaceStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InterfaceBlockSyntax(kind, errors, annotations, DirectCast(interfaceStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InterfaceStatementSyntax), if([inherits] IsNot Nothing, [inherits].Green, Nothing), if([implements] IsNot Nothing, [implements].Green, Nothing), if(members IsNot Nothing, members.Green, Nothing), DirectCast(endInterfaceStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Interface" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property InterfaceStatement As InterfaceStatementSyntax
            Get
                Return GetRedAtZero(_interfaceStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the InterfaceStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithInterfaceStatement(interfaceStatement as InterfaceStatementSyntax) As InterfaceBlockSyntax
            return Update(interfaceStatement, Me.Inherits, Me.Implements, Me.Members, Me.EndInterfaceStatement)
        End Function

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Inherits] As SyntaxList(Of InheritsStatementSyntax)
            Get
                Dim listNode = GetRed(_inherits, 1)
                Return new SyntaxList(Of InheritsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetInheritsCore() As SyntaxList(Of InheritsStatementSyntax)
            Return Me.[Inherits]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Inherits] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInherits([inherits] as SyntaxList(Of InheritsStatementSyntax)) As InterfaceBlockSyntax
            return Update(Me.InterfaceStatement, [inherits], Me.Implements, Me.Members, Me.EndInterfaceStatement)
        End Function

        Public Shadows Function AddInherits(ParamArray items As InheritsStatementSyntax()) As InterfaceBlockSyntax
            Return Me.WithInherits(Me.Inherits.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Implements] As SyntaxList(Of ImplementsStatementSyntax)
            Get
                Dim listNode = GetRed(_implements, 2)
                Return new SyntaxList(Of ImplementsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetImplementsCore() As SyntaxList(Of ImplementsStatementSyntax)
            Return Me.[Implements]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Implements] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithImplements([implements] as SyntaxList(Of ImplementsStatementSyntax)) As InterfaceBlockSyntax
            return Update(Me.InterfaceStatement, Me.Inherits, [implements], Me.Members, Me.EndInterfaceStatement)
        End Function

        Public Shadows Function AddImplements(ParamArray items As ImplementsStatementSyntax()) As InterfaceBlockSyntax
            Return Me.WithImplements(Me.Implements.AddRange(items))
        End Function

        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 3)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetMembersCore() As SyntaxList(Of StatementSyntax)
            Return Me.Members
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As InterfaceBlockSyntax
            return Update(Me.InterfaceStatement, Me.Inherits, Me.Implements, members, Me.EndInterfaceStatement)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As InterfaceBlockSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Interface" statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndInterfaceStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endInterfaceStatement, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndInterfaceStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndInterfaceStatement(endInterfaceStatement as EndBlockStatementSyntax) As InterfaceBlockSyntax
            return Update(Me.InterfaceStatement, Me.Inherits, Me.Implements, Me.Members, endInterfaceStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._interfaceStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endInterfaceStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.InterfaceStatement
                Case 1
                    Return GetRed(_inherits, 1)
                Case 2
                    Return GetRed(_implements, 2)
                Case 3
                    Return GetRed(_members, 3)
                Case 4
                    Return Me.EndInterfaceStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitInterfaceBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitInterfaceBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="interfaceStatement">
        ''' The value for the InterfaceStatement property.
        ''' </param>
        ''' <param name="inherits">
        ''' The value for the Inherits property.
        ''' </param>
        ''' <param name="implements">
        ''' The value for the Implements property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endInterfaceStatement">
        ''' The value for the EndInterfaceStatement property.
        ''' </param>
        Public Function Update(interfaceStatement As InterfaceStatementSyntax, [inherits] As SyntaxList(of InheritsStatementSyntax), [implements] As SyntaxList(of ImplementsStatementSyntax), members As SyntaxList(of StatementSyntax), endInterfaceStatement As EndBlockStatementSyntax) As InterfaceBlockSyntax
            If interfaceStatement IsNot Me.InterfaceStatement OrElse [inherits] <> Me.[Inherits] OrElse [implements] <> Me.[Implements] OrElse members <> Me.Members OrElse endInterfaceStatement IsNot Me.EndInterfaceStatement Then
                Dim newNode = SyntaxFactory.InterfaceBlock(interfaceStatement, [inherits], [implements], members, endInterfaceStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Class its contents and the End statement that
    ''' ends it.
    ''' </summary>
    Public NotInheritable Class ClassBlockSyntax
        Inherits TypeBlockSyntax

        Friend _classStatement as ClassStatementSyntax
        Friend _endClassStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), classStatement As ClassStatementSyntax, [inherits] As SyntaxNode, [implements] As SyntaxNode, members As SyntaxNode, endClassStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ClassBlockSyntax(kind, errors, annotations, DirectCast(classStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ClassStatementSyntax), if([inherits] IsNot Nothing, [inherits].Green, Nothing), if([implements] IsNot Nothing, [implements].Green, Nothing), if(members IsNot Nothing, members.Green, Nothing), DirectCast(endClassStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Class" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property ClassStatement As ClassStatementSyntax
            Get
                Return GetRedAtZero(_classStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ClassStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithClassStatement(classStatement as ClassStatementSyntax) As ClassBlockSyntax
            return Update(classStatement, Me.Inherits, Me.Implements, Me.Members, Me.EndClassStatement)
        End Function

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Inherits] As SyntaxList(Of InheritsStatementSyntax)
            Get
                Dim listNode = GetRed(_inherits, 1)
                Return new SyntaxList(Of InheritsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetInheritsCore() As SyntaxList(Of InheritsStatementSyntax)
            Return Me.[Inherits]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Inherits] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInherits([inherits] as SyntaxList(Of InheritsStatementSyntax)) As ClassBlockSyntax
            return Update(Me.ClassStatement, [inherits], Me.Implements, Me.Members, Me.EndClassStatement)
        End Function

        Public Shadows Function AddInherits(ParamArray items As InheritsStatementSyntax()) As ClassBlockSyntax
            Return Me.WithInherits(Me.Inherits.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property [Implements] As SyntaxList(Of ImplementsStatementSyntax)
            Get
                Dim listNode = GetRed(_implements, 2)
                Return new SyntaxList(Of ImplementsStatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetImplementsCore() As SyntaxList(Of ImplementsStatementSyntax)
            Return Me.[Implements]
        End Function

        ''' <summary>
        ''' Returns a copy of this with the [Implements] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithImplements([implements] as SyntaxList(Of ImplementsStatementSyntax)) As ClassBlockSyntax
            return Update(Me.ClassStatement, Me.Inherits, [implements], Me.Members, Me.EndClassStatement)
        End Function

        Public Shadows Function AddImplements(ParamArray items As ImplementsStatementSyntax()) As ClassBlockSyntax
            Return Me.WithImplements(Me.Implements.AddRange(items))
        End Function

        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 3)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetMembersCore() As SyntaxList(Of StatementSyntax)
            Return Me.Members
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As ClassBlockSyntax
            return Update(Me.ClassStatement, Me.Inherits, Me.Implements, members, Me.EndClassStatement)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As ClassBlockSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Class" statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndClassStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endClassStatement, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndClassStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndClassStatement(endClassStatement as EndBlockStatementSyntax) As ClassBlockSyntax
            return Update(Me.ClassStatement, Me.Inherits, Me.Implements, Me.Members, endClassStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._classStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endClassStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.ClassStatement
                Case 1
                    Return GetRed(_inherits, 1)
                Case 2
                    Return GetRed(_implements, 2)
                Case 3
                    Return GetRed(_members, 3)
                Case 4
                    Return Me.EndClassStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitClassBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitClassBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="classStatement">
        ''' The value for the ClassStatement property.
        ''' </param>
        ''' <param name="inherits">
        ''' The value for the Inherits property.
        ''' </param>
        ''' <param name="implements">
        ''' The value for the Implements property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endClassStatement">
        ''' The value for the EndClassStatement property.
        ''' </param>
        Public Function Update(classStatement As ClassStatementSyntax, [inherits] As SyntaxList(of InheritsStatementSyntax), [implements] As SyntaxList(of ImplementsStatementSyntax), members As SyntaxList(of StatementSyntax), endClassStatement As EndBlockStatementSyntax) As ClassBlockSyntax
            If classStatement IsNot Me.ClassStatement OrElse [inherits] <> Me.[Inherits] OrElse [implements] <> Me.[Implements] OrElse members <> Me.Members OrElse endClassStatement IsNot Me.EndClassStatement Then
                Dim newNode = SyntaxFactory.ClassBlock(classStatement, [inherits], [implements], members, endClassStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of an Enum, its contents and the End Enum statement
    ''' that ends it.
    ''' </summary>
    Public NotInheritable Class EnumBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend _enumStatement as EnumStatementSyntax
        Friend _members as SyntaxNode
        Friend _endEnumStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), enumStatement As EnumStatementSyntax, members As SyntaxNode, endEnumStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumBlockSyntax(kind, errors, annotations, DirectCast(enumStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumStatementSyntax), if(members IsNot Nothing, members.Green, Nothing), DirectCast(endEnumStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The statement that begins the type or module.
        ''' </summary>
        Public  ReadOnly Property EnumStatement As EnumStatementSyntax
            Get
                Return GetRedAtZero(_enumStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EnumStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEnumStatement(enumStatement as EnumStatementSyntax) As EnumBlockSyntax
            return Update(enumStatement, Me.Members, Me.EndEnumStatement)
        End Function

        ''' <summary>
        ''' The declarations contained in the enumeration.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Members As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_members, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Members property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithMembers(members as SyntaxList(Of StatementSyntax)) As EnumBlockSyntax
            return Update(Me.EnumStatement, members, Me.EndEnumStatement)
        End Function

        Public Shadows Function AddMembers(ParamArray items As StatementSyntax()) As EnumBlockSyntax
            Return Me.WithMembers(Me.Members.AddRange(items))
        End Function

        ''' <summary>
        ''' The End XXX statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndEnumStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endEnumStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndEnumStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndEnumStatement(endEnumStatement as EndBlockStatementSyntax) As EnumBlockSyntax
            return Update(Me.EnumStatement, Me.Members, endEnumStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._enumStatement
                Case 1
                    Return Me._members
                Case 2
                    Return Me._endEnumStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.EnumStatement
                Case 1
                    Return GetRed(_members, 1)
                Case 2
                    Return Me.EndEnumStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEnumBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEnumBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="enumStatement">
        ''' The value for the EnumStatement property.
        ''' </param>
        ''' <param name="members">
        ''' The value for the Members property.
        ''' </param>
        ''' <param name="endEnumStatement">
        ''' The value for the EndEnumStatement property.
        ''' </param>
        Public Function Update(enumStatement As EnumStatementSyntax, members As SyntaxList(of StatementSyntax), endEnumStatement As EndBlockStatementSyntax) As EnumBlockSyntax
            If enumStatement IsNot Me.EnumStatement OrElse members <> Me.Members OrElse endEnumStatement IsNot Me.EndEnumStatement Then
                Dim newNode = SyntaxFactory.EnumBlock(enumStatement, members, endEnumStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an Inherits or Implements statement in a Class, Structure or
    ''' Interface.
    ''' </summary>
    Public MustInherit Class InheritsOrImplementsStatementSyntax
        Inherits DeclarationStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an Inherits statement in a Class, Structure or Interface.
    ''' </summary>
    Public NotInheritable Class InheritsStatementSyntax
        Inherits InheritsOrImplementsStatementSyntax

        Friend _types as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), inheritsKeyword As InternalSyntax.KeywordSyntax, types As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InheritsStatementSyntax(kind, errors, annotations, inheritsKeyword, if(types IsNot Nothing, types.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Inherits" keyword.
        ''' </summary>
        Public  ReadOnly Property InheritsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InheritsStatementSyntax)._inheritsKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the InheritsKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithInheritsKeyword(inheritsKeyword as SyntaxToken) As InheritsStatementSyntax
            return Update(inheritsKeyword, Me.Types)
        End Function

        ''' <summary>
        ''' A list of the types being inherited.
        ''' </summary>
        Public  ReadOnly Property Types As SeparatedSyntaxList(Of TypeSyntax)
            Get
                Dim listNode = GetRed(_types, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of TypeSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Types property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithTypes(types as SeparatedSyntaxList(Of TypeSyntax)) As InheritsStatementSyntax
            return Update(Me.InheritsKeyword, types)
        End Function

        Public Shadows Function AddTypes(ParamArray items As TypeSyntax()) As InheritsStatementSyntax
            Return Me.WithTypes(Me.Types.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._types
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_types, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitInheritsStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitInheritsStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="inheritsKeyword">
        ''' The value for the InheritsKeyword property.
        ''' </param>
        ''' <param name="types">
        ''' The value for the Types property.
        ''' </param>
        Public Function Update(inheritsKeyword As SyntaxToken, types As SeparatedSyntaxList(Of TypeSyntax)) As InheritsStatementSyntax
            If inheritsKeyword <> Me.InheritsKeyword OrElse types <> Me.Types Then
                Dim newNode = SyntaxFactory.InheritsStatement(inheritsKeyword, types)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an Implements statement in a Class or Structure.
    ''' </summary>
    Public NotInheritable Class ImplementsStatementSyntax
        Inherits InheritsOrImplementsStatementSyntax

        Friend _types as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), implementsKeyword As InternalSyntax.KeywordSyntax, types As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsStatementSyntax(kind, errors, annotations, implementsKeyword, if(types IsNot Nothing, types.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Implements" keyword.
        ''' </summary>
        Public  ReadOnly Property ImplementsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsStatementSyntax)._implementsKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImplementsKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImplementsKeyword(implementsKeyword as SyntaxToken) As ImplementsStatementSyntax
            return Update(implementsKeyword, Me.Types)
        End Function

        ''' <summary>
        ''' A list of the types being implemented.
        ''' </summary>
        Public  ReadOnly Property Types As SeparatedSyntaxList(Of TypeSyntax)
            Get
                Dim listNode = GetRed(_types, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of TypeSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Types property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithTypes(types as SeparatedSyntaxList(Of TypeSyntax)) As ImplementsStatementSyntax
            return Update(Me.ImplementsKeyword, types)
        End Function

        Public Shadows Function AddTypes(ParamArray items As TypeSyntax()) As ImplementsStatementSyntax
            Return Me.WithTypes(Me.Types.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._types
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_types, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitImplementsStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitImplementsStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="implementsKeyword">
        ''' The value for the ImplementsKeyword property.
        ''' </param>
        ''' <param name="types">
        ''' The value for the Types property.
        ''' </param>
        Public Function Update(implementsKeyword As SyntaxToken, types As SeparatedSyntaxList(Of TypeSyntax)) As ImplementsStatementSyntax
            If implementsKeyword <> Me.ImplementsKeyword OrElse types <> Me.Types Then
                Dim newNode = SyntaxFactory.ImplementsStatement(implementsKeyword, types)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Abstract class for the beginning statement of a Module, Class, Interface or
    ''' Structure declaration. This node always appears as the Begin of a TypeBlock
    ''' with Kind=ModuleDeclarationBlock, ClassDeclarationBlock,
    ''' InterfaceDeclarationBlock or StructureDeclarationBlock.
    ''' </summary>
    Public MustInherit Class TypeStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode
        Friend _typeParameterList as TypeParameterListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Return Me.GetAttributeListsCore()
            End Get
        End Property

        Friend Overridable Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
        End Function


        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Return Me.GetModifiersCore()
            End Get
        End Property

        Friend Overridable Function GetModifiersCore() As SyntaxTokenList
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
        End Function


        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Public ReadOnly Property Identifier As SyntaxToken
            Get
                Return Me.GetIdentifierCore()
            End Get
        End Property

        Friend Overridable Function GetIdentifierCore() As SyntaxToken
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeStatementSyntax)._identifier, Me.GetChildPosition(2), Me.GetChildIndex(2))
        End Function


        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return Me.GetTypeParameterListCore()
            End Get
        End Property

        Friend Overridable Function GetTypeParameterListCore() As TypeParameterListSyntax
                Return GetRed(_typeParameterList, 3)
        End Function


    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Module declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=ModuleDeclarationBlock.
    ''' </summary>
    Public NotInheritable Class ModuleStatementSyntax
        Inherits TypeStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModuleStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, moduleKeyword, identifier, if(typeParameterList IsNot Nothing , DirectCast(typeParameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As ModuleStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.ModuleKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As ModuleStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModuleStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As ModuleStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.ModuleKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As ModuleStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Module" keyword.
        ''' </summary>
        Public  ReadOnly Property ModuleKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModuleStatementSyntax)._moduleKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ModuleKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModuleKeyword(moduleKeyword as SyntaxToken) As ModuleStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, moduleKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Public Shadows ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModuleStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        Friend Overrides Function GetIdentifierCore() As SyntaxToken
            Return Me.Identifier
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As ModuleStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.ModuleKeyword, identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return GetRed(_typeParameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetTypeParameterListCore() As TypeParameterListSyntax
            Return Me.TypeParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterList property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterList(typeParameterList as TypeParameterListSyntax) As ModuleStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.ModuleKeyword, Me.Identifier, typeParameterList)
        End Function

        Public Shadows Function AddTypeParameterListParameters(ParamArray items As TypeParameterSyntax()) As ModuleStatementSyntax
            Dim _child = If (Me.TypeParameterList IsNot Nothing, Me.TypeParameterList, SyntaxFactory.TypeParameterList())
            Return Me.WithTypeParameterList(_child.AddParameters(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.TypeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitModuleStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitModuleStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="moduleKeyword">
        ''' The value for the ModuleKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterList">
        ''' The value for the TypeParameterList property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, moduleKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterList As TypeParameterListSyntax) As ModuleStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse moduleKeyword <> Me.ModuleKeyword OrElse identifier <> Me.Identifier OrElse typeParameterList IsNot Me.TypeParameterList Then
                Dim newNode = SyntaxFactory.ModuleStatement(attributeLists, modifiers, moduleKeyword, identifier, typeParameterList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Structure declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=StructureDeclarationBlock.
    ''' </summary>
    Public NotInheritable Class StructureStatementSyntax
        Inherits TypeStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StructureStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, structureKeyword, identifier, if(typeParameterList IsNot Nothing , DirectCast(typeParameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As StructureStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.StructureKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As StructureStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StructureStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As StructureStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.StructureKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As StructureStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Structure" keyword.
        ''' </summary>
        Public  ReadOnly Property StructureKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StructureStatementSyntax)._structureKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the StructureKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithStructureKeyword(structureKeyword as SyntaxToken) As StructureStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, structureKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Public Shadows ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StructureStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        Friend Overrides Function GetIdentifierCore() As SyntaxToken
            Return Me.Identifier
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As StructureStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.StructureKeyword, identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return GetRed(_typeParameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetTypeParameterListCore() As TypeParameterListSyntax
            Return Me.TypeParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterList property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterList(typeParameterList as TypeParameterListSyntax) As StructureStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.StructureKeyword, Me.Identifier, typeParameterList)
        End Function

        Public Shadows Function AddTypeParameterListParameters(ParamArray items As TypeParameterSyntax()) As StructureStatementSyntax
            Dim _child = If (Me.TypeParameterList IsNot Nothing, Me.TypeParameterList, SyntaxFactory.TypeParameterList())
            Return Me.WithTypeParameterList(_child.AddParameters(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.TypeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitStructureStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitStructureStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="structureKeyword">
        ''' The value for the StructureKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterList">
        ''' The value for the TypeParameterList property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, structureKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterList As TypeParameterListSyntax) As StructureStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse structureKeyword <> Me.StructureKeyword OrElse identifier <> Me.Identifier OrElse typeParameterList IsNot Me.TypeParameterList Then
                Dim newNode = SyntaxFactory.StructureStatement(attributeLists, modifiers, structureKeyword, identifier, typeParameterList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Interface declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=InterfaceDeclarationBlock.
    ''' </summary>
    Public NotInheritable Class InterfaceStatementSyntax
        Inherits TypeStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InterfaceStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, interfaceKeyword, identifier, if(typeParameterList IsNot Nothing , DirectCast(typeParameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As InterfaceStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.InterfaceKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As InterfaceStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InterfaceStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As InterfaceStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.InterfaceKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As InterfaceStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Interface" keyword.
        ''' </summary>
        Public  ReadOnly Property InterfaceKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InterfaceStatementSyntax)._interfaceKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the InterfaceKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithInterfaceKeyword(interfaceKeyword as SyntaxToken) As InterfaceStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, interfaceKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Public Shadows ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InterfaceStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        Friend Overrides Function GetIdentifierCore() As SyntaxToken
            Return Me.Identifier
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As InterfaceStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.InterfaceKeyword, identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return GetRed(_typeParameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetTypeParameterListCore() As TypeParameterListSyntax
            Return Me.TypeParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterList property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterList(typeParameterList as TypeParameterListSyntax) As InterfaceStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.InterfaceKeyword, Me.Identifier, typeParameterList)
        End Function

        Public Shadows Function AddTypeParameterListParameters(ParamArray items As TypeParameterSyntax()) As InterfaceStatementSyntax
            Dim _child = If (Me.TypeParameterList IsNot Nothing, Me.TypeParameterList, SyntaxFactory.TypeParameterList())
            Return Me.WithTypeParameterList(_child.AddParameters(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.TypeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitInterfaceStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitInterfaceStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="interfaceKeyword">
        ''' The value for the InterfaceKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterList">
        ''' The value for the TypeParameterList property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, interfaceKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterList As TypeParameterListSyntax) As InterfaceStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse interfaceKeyword <> Me.InterfaceKeyword OrElse identifier <> Me.Identifier OrElse typeParameterList IsNot Me.TypeParameterList Then
                Dim newNode = SyntaxFactory.InterfaceStatement(attributeLists, modifiers, interfaceKeyword, identifier, typeParameterList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Class declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=ClassDeclarationBlock.
    ''' </summary>
    Public NotInheritable Class ClassStatementSyntax
        Inherits TypeStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ClassStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, classKeyword, identifier, if(typeParameterList IsNot Nothing , DirectCast(typeParameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As ClassStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.ClassKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As ClassStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ClassStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As ClassStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.ClassKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As ClassStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Class" keyword.
        ''' </summary>
        Public  ReadOnly Property ClassKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ClassStatementSyntax)._classKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ClassKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithClassKeyword(classKeyword as SyntaxToken) As ClassStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, classKeyword, Me.Identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Public Shadows ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ClassStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        Friend Overrides Function GetIdentifierCore() As SyntaxToken
            Return Me.Identifier
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As ClassStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.ClassKeyword, identifier, Me.TypeParameterList)
        End Function

        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return GetRed(_typeParameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetTypeParameterListCore() As TypeParameterListSyntax
            Return Me.TypeParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterList property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterList(typeParameterList as TypeParameterListSyntax) As ClassStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.ClassKeyword, Me.Identifier, typeParameterList)
        End Function

        Public Shadows Function AddTypeParameterListParameters(ParamArray items As TypeParameterSyntax()) As ClassStatementSyntax
            Dim _child = If (Me.TypeParameterList IsNot Nothing, Me.TypeParameterList, SyntaxFactory.TypeParameterList())
            Return Me.WithTypeParameterList(_child.AddParameters(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.TypeParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitClassStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitClassStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="classKeyword">
        ''' The value for the ClassKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterList">
        ''' The value for the TypeParameterList property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, classKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterList As TypeParameterListSyntax) As ClassStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse classKeyword <> Me.ClassKeyword OrElse identifier <> Me.Identifier OrElse typeParameterList IsNot Me.TypeParameterList Then
                Dim newNode = SyntaxFactory.ClassStatement(attributeLists, modifiers, classKeyword, identifier, typeParameterList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of an Enum declaration. This node always
    ''' appears as the Begin of an EnumBlock with Kind=EnumDeclarationBlock.
    ''' </summary>
    Public NotInheritable Class EnumStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode
        Friend _underlyingType as AsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, enumKeyword, identifier, if(underlyingType IsNot Nothing , DirectCast(underlyingType.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As EnumStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.EnumKeyword, Me.Identifier, Me.UnderlyingType)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As EnumStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As EnumStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.EnumKeyword, Me.Identifier, Me.UnderlyingType)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As EnumStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Enum" keyword.
        ''' </summary>
        Public  ReadOnly Property EnumKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumStatementSyntax)._enumKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EnumKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEnumKeyword(enumKeyword as SyntaxToken) As EnumStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, enumKeyword, Me.Identifier, Me.UnderlyingType)
        End Function

        ''' <summary>
        ''' The name of the enum being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As EnumStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.EnumKeyword, identifier, Me.UnderlyingType)
        End Function

        ''' <summary>
        ''' Optional "As XXX" clause describing the underlying type of the enumeration. If
        ''' no As clause was specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property UnderlyingType As AsClauseSyntax
            Get
                Return GetRed(_underlyingType, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the UnderlyingType property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithUnderlyingType(underlyingType as AsClauseSyntax) As EnumStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.EnumKeyword, Me.Identifier, underlyingType)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._underlyingType
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.UnderlyingType
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEnumStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEnumStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="enumKeyword">
        ''' The value for the EnumKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="underlyingType">
        ''' The value for the UnderlyingType property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, enumKeyword As SyntaxToken, identifier As SyntaxToken, underlyingType As AsClauseSyntax) As EnumStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse enumKeyword <> Me.EnumKeyword OrElse identifier <> Me.Identifier OrElse underlyingType IsNot Me.UnderlyingType Then
                Dim newNode = SyntaxFactory.EnumStatement(attributeLists, modifiers, enumKeyword, identifier, underlyingType)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the type parameter list in a declaration.
    ''' </summary>
    Public NotInheritable Class TypeParameterListSyntax
        Inherits VisualBasicSyntaxNode

        Friend _parameters as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As SyntaxNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax(kind, errors, annotations, openParenToken, ofKeyword, if(parameters IsNot Nothing, parameters.Green, Nothing), closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax)._openParenToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As TypeParameterListSyntax
            return Update(openParenToken, Me.OfKeyword, Me.Parameters, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The "Of" keyword.
        ''' </summary>
        Public  ReadOnly Property OfKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax)._ofKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OfKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOfKeyword(ofKeyword as SyntaxToken) As TypeParameterListSyntax
            return Update(Me.OpenParenToken, ofKeyword, Me.Parameters, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' A list of the type parameters. There must be at least one type parameter in the
        ''' list.
        ''' </summary>
        Public  ReadOnly Property Parameters As SeparatedSyntaxList(Of TypeParameterSyntax)
            Get
                Dim listNode = GetRed(_parameters, 2)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of TypeParameterSyntax)(listNode, Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Parameters property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameters(parameters as SeparatedSyntaxList(Of TypeParameterSyntax)) As TypeParameterListSyntax
            return Update(Me.OpenParenToken, Me.OfKeyword, parameters, Me.CloseParenToken)
        End Function

        Public Shadows Function AddParameters(ParamArray items As TypeParameterSyntax()) As TypeParameterListSyntax
            Return Me.WithParameters(Me.Parameters.AddRange(items))
        End Function

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax)._closeParenToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As TypeParameterListSyntax
            return Update(Me.OpenParenToken, Me.OfKeyword, Me.Parameters, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._parameters
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return GetRed(_parameters, 2)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypeParameterList(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypeParameterList(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="ofKeyword">
        ''' The value for the OfKeyword property.
        ''' </param>
        ''' <param name="parameters">
        ''' The value for the Parameters property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(openParenToken As SyntaxToken, ofKeyword As SyntaxToken, parameters As SeparatedSyntaxList(Of TypeParameterSyntax), closeParenToken As SyntaxToken) As TypeParameterListSyntax
            If openParenToken <> Me.OpenParenToken OrElse ofKeyword <> Me.OfKeyword OrElse parameters <> Me.Parameters OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.TypeParameterList(openParenToken, ofKeyword, parameters, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a type parameter on a generic type declaration.
    ''' </summary>
    Public NotInheritable Class TypeParameterSyntax
        Inherits VisualBasicSyntaxNode

        Friend _typeParameterConstraintClause as TypeParameterConstraintClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterSyntax(kind, errors, annotations, varianceKeyword, identifier, if(typeParameterConstraintClause IsNot Nothing , DirectCast(typeParameterConstraintClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterConstraintClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' Represents the "In" or "Out" variance keyword on a type parameter, if present.
        ''' If no variance modifier was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property VarianceKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterSyntax)._varianceKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.Position, 0)
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the VarianceKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithVarianceKeyword(varianceKeyword as SyntaxToken) As TypeParameterSyntax
            return Update(varianceKeyword, Me.Identifier, Me.TypeParameterConstraintClause)
        End Function

        ''' <summary>
        ''' The name of the type parameter
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterSyntax)._identifier, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As TypeParameterSyntax
            return Update(Me.VarianceKeyword, identifier, Me.TypeParameterConstraintClause)
        End Function

        ''' <summary>
        ''' The "As" keyword, if any type constraints were supplied. If no type constraints
        ''' were supplied, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property TypeParameterConstraintClause As TypeParameterConstraintClauseSyntax
            Get
                Return GetRed(_typeParameterConstraintClause, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterConstraintClause property changed
        ''' to the specified value. Returns this instance if the specified value is the
        ''' same as the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterConstraintClause(typeParameterConstraintClause as TypeParameterConstraintClauseSyntax) As TypeParameterSyntax
            return Update(Me.VarianceKeyword, Me.Identifier, typeParameterConstraintClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._typeParameterConstraintClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.TypeParameterConstraintClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypeParameter(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypeParameter(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="varianceKeyword">
        ''' The value for the VarianceKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterConstraintClause">
        ''' The value for the TypeParameterConstraintClause property.
        ''' </param>
        Public Function Update(varianceKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax) As TypeParameterSyntax
            If varianceKeyword <> Me.VarianceKeyword OrElse identifier <> Me.Identifier OrElse typeParameterConstraintClause IsNot Me.TypeParameterConstraintClause Then
                Dim newNode = SyntaxFactory.TypeParameter(varianceKeyword, identifier, typeParameterConstraintClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent of classes that describe type
    ''' parameter constraint clauses.
    ''' </summary>
    Public MustInherit Class TypeParameterConstraintClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' One of the type parameter constraints clauses. This represents a constraint
    ''' clause in the form of "As Constraint".
    ''' </summary>
    Public NotInheritable Class TypeParameterSingleConstraintClauseSyntax
        Inherits TypeParameterConstraintClauseSyntax

        Friend _constraint as ConstraintSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterSingleConstraintClauseSyntax(kind, errors, annotations, asKeyword, DirectCast(constraint.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ConstraintSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "As" keyword, if any type constraints were supplied. If no type constraints
        ''' were supplied, Nothing is returned.
        ''' </summary>
        Public  ReadOnly Property AsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterSingleConstraintClauseSyntax)._asKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsKeyword(asKeyword as SyntaxToken) As TypeParameterSingleConstraintClauseSyntax
            return Update(asKeyword, Me.Constraint)
        End Function

        ''' <summary>
        ''' A list of the supplied constraints. If no constraints were supplied, Nothing is
        ''' returned.
        ''' </summary>
        Public  ReadOnly Property Constraint As ConstraintSyntax
            Get
                Return GetRed(_constraint, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Constraint property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithConstraint(constraint as ConstraintSyntax) As TypeParameterSingleConstraintClauseSyntax
            return Update(Me.AsKeyword, constraint)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._constraint
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Constraint
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypeParameterSingleConstraintClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypeParameterSingleConstraintClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="asKeyword">
        ''' The value for the AsKeyword property.
        ''' </param>
        ''' <param name="constraint">
        ''' The value for the Constraint property.
        ''' </param>
        Public Function Update(asKeyword As SyntaxToken, constraint As ConstraintSyntax) As TypeParameterSingleConstraintClauseSyntax
            If asKeyword <> Me.AsKeyword OrElse constraint IsNot Me.Constraint Then
                Dim newNode = SyntaxFactory.TypeParameterSingleConstraintClause(asKeyword, constraint)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' One of the type parameter constraints clauses. This represents a constraint
    ''' clause in the form of "As { Constraints }".
    ''' </summary>
    Public NotInheritable Class TypeParameterMultipleConstraintClauseSyntax
        Inherits TypeParameterConstraintClauseSyntax

        Friend _constraints as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As SyntaxNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterMultipleConstraintClauseSyntax(kind, errors, annotations, asKeyword, openBraceToken, if(constraints IsNot Nothing, constraints.Green, Nothing), closeBraceToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Public  ReadOnly Property AsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterMultipleConstraintClauseSyntax)._asKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsKeyword(asKeyword as SyntaxToken) As TypeParameterMultipleConstraintClauseSyntax
            return Update(asKeyword, Me.OpenBraceToken, Me.Constraints, Me.CloseBraceToken)
        End Function

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Public  ReadOnly Property OpenBraceToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterMultipleConstraintClauseSyntax)._openBraceToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenBraceToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenBraceToken(openBraceToken as SyntaxToken) As TypeParameterMultipleConstraintClauseSyntax
            return Update(Me.AsKeyword, openBraceToken, Me.Constraints, Me.CloseBraceToken)
        End Function

        ''' <summary>
        ''' A list of the supplied constraints. If no constraints were supplied, an empty
        ''' list is returned.
        ''' </summary>
        Public  ReadOnly Property Constraints As SeparatedSyntaxList(Of ConstraintSyntax)
            Get
                Dim listNode = GetRed(_constraints, 2)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ConstraintSyntax)(listNode, Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Constraints property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithConstraints(constraints as SeparatedSyntaxList(Of ConstraintSyntax)) As TypeParameterMultipleConstraintClauseSyntax
            return Update(Me.AsKeyword, Me.OpenBraceToken, constraints, Me.CloseBraceToken)
        End Function

        Public Shadows Function AddConstraints(ParamArray items As ConstraintSyntax()) As TypeParameterMultipleConstraintClauseSyntax
            Return Me.WithConstraints(Me.Constraints.AddRange(items))
        End Function

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Public  ReadOnly Property CloseBraceToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterMultipleConstraintClauseSyntax)._closeBraceToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseBraceToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseBraceToken(closeBraceToken as SyntaxToken) As TypeParameterMultipleConstraintClauseSyntax
            return Update(Me.AsKeyword, Me.OpenBraceToken, Me.Constraints, closeBraceToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._constraints
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return GetRed(_constraints, 2)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypeParameterMultipleConstraintClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypeParameterMultipleConstraintClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="asKeyword">
        ''' The value for the AsKeyword property.
        ''' </param>
        ''' <param name="openBraceToken">
        ''' The value for the OpenBraceToken property.
        ''' </param>
        ''' <param name="constraints">
        ''' The value for the Constraints property.
        ''' </param>
        ''' <param name="closeBraceToken">
        ''' The value for the CloseBraceToken property.
        ''' </param>
        Public Function Update(asKeyword As SyntaxToken, openBraceToken As SyntaxToken, constraints As SeparatedSyntaxList(Of ConstraintSyntax), closeBraceToken As SyntaxToken) As TypeParameterMultipleConstraintClauseSyntax
            If asKeyword <> Me.AsKeyword OrElse openBraceToken <> Me.OpenBraceToken OrElse constraints <> Me.Constraints OrElse closeBraceToken <> Me.CloseBraceToken Then
                Dim newNode = SyntaxFactory.TypeParameterMultipleConstraintClause(asKeyword, openBraceToken, constraints, closeBraceToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent of classes that describe type
    ''' parameter constraints.
    ''' </summary>
    Public MustInherit Class ConstraintSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' One of the special type parameter constraints: New, Class or Structure. Which
    ''' kind of special constraint it is can be obtained from the Kind property and is
    ''' one of: NewConstraint, ReferenceConstraint or ValueConstraint.
    ''' </summary>
    Public NotInheritable Class SpecialConstraintSyntax
        Inherits ConstraintSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), constraintKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SpecialConstraintSyntax(kind, errors, annotations, constraintKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "New", "Class" or "Structure" keyword that denotes the kind of special
        ''' constraint.
        ''' </summary>
        Public  ReadOnly Property ConstraintKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SpecialConstraintSyntax)._constraintKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ConstraintKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithConstraintKeyword(constraintKeyword as SyntaxToken) As SpecialConstraintSyntax
            return Update(Me.Kind, constraintKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSpecialConstraint(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSpecialConstraint(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="constraintKeyword">
        ''' The value for the ConstraintKeyword property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, constraintKeyword As SyntaxToken) As SpecialConstraintSyntax
            If kind <> Me.Kind OrElse constraintKeyword <> Me.ConstraintKeyword Then
                Dim newNode = SyntaxFactory.SpecialConstraint(kind, constraintKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a type parameter constraint that is a type.
    ''' </summary>
    Public NotInheritable Class TypeConstraintSyntax
        Inherits ConstraintSyntax

        Friend _type as TypeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), type As TypeSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeConstraintSyntax(kind, errors, annotations, DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The type describing the constraint.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRedAtZero(_type)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As TypeConstraintSyntax
            return Update(type)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me._type
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me.Type
            Else
                Return Nothing
            End If
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypeConstraint(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypeConstraint(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        Public Function Update(type As TypeSyntax) As TypeConstraintSyntax
            If type IsNot Me.Type Then
                Dim newNode = SyntaxFactory.TypeConstraint(type)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a name and value in an EnumDeclarationBlock.
    ''' </summary>
    Public NotInheritable Class EnumMemberDeclarationSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode
        Friend _initializer as EqualsValueSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumMemberDeclarationSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), identifier, if(initializer IsNot Nothing , DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EqualsValueSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As EnumMemberDeclarationSyntax
            return Update(attributeLists, Me.Identifier, Me.Initializer)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As EnumMemberDeclarationSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EnumMemberDeclarationSyntax)._identifier, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As EnumMemberDeclarationSyntax
            return Update(Me.AttributeLists, identifier, Me.Initializer)
        End Function

        ''' <summary>
        ''' An optional value for the enum member.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Initializer As EqualsValueSyntax
            Get
                Return GetRed(_initializer, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as EqualsValueSyntax) As EnumMemberDeclarationSyntax
            return Update(Me.AttributeLists, Me.Identifier, initializer)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 2
                    Return Me._initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 2
                    Return Me.Initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEnumMemberDeclaration(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEnumMemberDeclaration(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), identifier As SyntaxToken, initializer As EqualsValueSyntax) As EnumMemberDeclarationSyntax
            If attributeLists <> Me.AttributeLists OrElse identifier <> Me.Identifier OrElse initializer IsNot Me.Initializer Then
                Dim newNode = SyntaxFactory.EnumMemberDeclaration(attributeLists, identifier, initializer)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a block member declaration: A declaration that has a beginning
    ''' declaration, a body of executable statements and an end statement. Examples
    ''' include methods, constructors, operators, property accessors and custom event
    ''' accessors.
    ''' </summary>
    Public MustInherit Class MethodBlockBaseSyntax
        Inherits DeclarationStatementSyntax

        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Return Me.GetStatementsCore()
            End Get
        End Property

        Friend Overridable Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
                Dim listNode = GetRedAtZero(_statements)
                Return new SyntaxList(Of StatementSyntax)(listNode)
        End Function


    End Class

    ''' <summary>
    ''' Represents a Function or Sub block declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' </summary>
    Public NotInheritable Class MethodBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend _subOrFunctionStatement as MethodStatementSyntax
        Friend _endSubOrFunctionStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionStatement As MethodStatementSyntax, statements As SyntaxNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodBlockSyntax(kind, errors, annotations, DirectCast(subOrFunctionStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endSubOrFunctionStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Sub" or "Function" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property SubOrFunctionStatement As MethodStatementSyntax
            Get
                Return GetRedAtZero(_subOrFunctionStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SubOrFunctionStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSubOrFunctionStatement(subOrFunctionStatement as MethodStatementSyntax) As MethodBlockSyntax
            return Update(Me.Kind, subOrFunctionStatement, Me.Statements, Me.EndSubOrFunctionStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
            Return Me.Statements
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As MethodBlockSyntax
            return Update(Me.Kind, Me.SubOrFunctionStatement, statements, Me.EndSubOrFunctionStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As MethodBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Sub" or "End Function" statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndSubOrFunctionStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endSubOrFunctionStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndSubOrFunctionStatement property changed to
        ''' the specified value. Returns this instance if the specified value is the same
        ''' as the current value.
        ''' </summary>
        Public Shadows Function WithEndSubOrFunctionStatement(endSubOrFunctionStatement as EndBlockStatementSyntax) As MethodBlockSyntax
            return Update(Me.Kind, Me.SubOrFunctionStatement, Me.Statements, endSubOrFunctionStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._subOrFunctionStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubOrFunctionStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.SubOrFunctionStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndSubOrFunctionStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMethodBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMethodBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="subOrFunctionStatement">
        ''' The value for the SubOrFunctionStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endSubOrFunctionStatement">
        ''' The value for the EndSubOrFunctionStatement property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, subOrFunctionStatement As MethodStatementSyntax, statements As SyntaxList(of StatementSyntax), endSubOrFunctionStatement As EndBlockStatementSyntax) As MethodBlockSyntax
            If kind <> Me.Kind OrElse subOrFunctionStatement IsNot Me.SubOrFunctionStatement OrElse statements <> Me.Statements OrElse endSubOrFunctionStatement IsNot Me.EndSubOrFunctionStatement Then
                Dim newNode = SyntaxFactory.MethodBlock(kind, subOrFunctionStatement, statements, endSubOrFunctionStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a constructor block declaration: A declaration that has a beginning
    ''' declaration, a body of executable statements and an end statement.
    ''' </summary>
    Public NotInheritable Class ConstructorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend _subNewStatement as SubNewStatementSyntax
        Friend _endSubStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subNewStatement As SubNewStatementSyntax, statements As SyntaxNode, endSubStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ConstructorBlockSyntax(kind, errors, annotations, DirectCast(subNewStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SubNewStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endSubStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Sub New" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property SubNewStatement As SubNewStatementSyntax
            Get
                Return GetRedAtZero(_subNewStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SubNewStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSubNewStatement(subNewStatement as SubNewStatementSyntax) As ConstructorBlockSyntax
            return Update(subNewStatement, Me.Statements, Me.EndSubStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
            Return Me.Statements
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As ConstructorBlockSyntax
            return Update(Me.SubNewStatement, statements, Me.EndSubStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As ConstructorBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Sub" statement that ends the block declaration.
        ''' </summary>
        Public  ReadOnly Property EndSubStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endSubStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndSubStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndSubStatement(endSubStatement as EndBlockStatementSyntax) As ConstructorBlockSyntax
            return Update(Me.SubNewStatement, Me.Statements, endSubStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._subNewStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.SubNewStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndSubStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitConstructorBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitConstructorBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="subNewStatement">
        ''' The value for the SubNewStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endSubStatement">
        ''' The value for the EndSubStatement property.
        ''' </param>
        Public Function Update(subNewStatement As SubNewStatementSyntax, statements As SyntaxList(of StatementSyntax), endSubStatement As EndBlockStatementSyntax) As ConstructorBlockSyntax
            If subNewStatement IsNot Me.SubNewStatement OrElse statements <> Me.Statements OrElse endSubStatement IsNot Me.EndSubStatement Then
                Dim newNode = SyntaxFactory.ConstructorBlock(subNewStatement, statements, endSubStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an Operator block member declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' </summary>
    Public NotInheritable Class OperatorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend _operatorStatement as OperatorStatementSyntax
        Friend _endOperatorStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), operatorStatement As OperatorStatementSyntax, statements As SyntaxNode, endOperatorStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OperatorBlockSyntax(kind, errors, annotations, DirectCast(operatorStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OperatorStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endOperatorStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Operator" statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property OperatorStatement As OperatorStatementSyntax
            Get
                Return GetRedAtZero(_operatorStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOperatorStatement(operatorStatement as OperatorStatementSyntax) As OperatorBlockSyntax
            return Update(operatorStatement, Me.Statements, Me.EndOperatorStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
            Return Me.Statements
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As OperatorBlockSyntax
            return Update(Me.OperatorStatement, statements, Me.EndOperatorStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As OperatorBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Operator" statement that ends the block declaration.
        ''' </summary>
        Public  ReadOnly Property EndOperatorStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endOperatorStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndOperatorStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndOperatorStatement(endOperatorStatement as EndBlockStatementSyntax) As OperatorBlockSyntax
            return Update(Me.OperatorStatement, Me.Statements, endOperatorStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._operatorStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endOperatorStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.OperatorStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndOperatorStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitOperatorBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitOperatorBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="operatorStatement">
        ''' The value for the OperatorStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endOperatorStatement">
        ''' The value for the EndOperatorStatement property.
        ''' </param>
        Public Function Update(operatorStatement As OperatorStatementSyntax, statements As SyntaxList(of StatementSyntax), endOperatorStatement As EndBlockStatementSyntax) As OperatorBlockSyntax
            If operatorStatement IsNot Me.OperatorStatement OrElse statements <> Me.Statements OrElse endOperatorStatement IsNot Me.EndOperatorStatement Then
                Dim newNode = SyntaxFactory.OperatorBlock(operatorStatement, statements, endOperatorStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an accessor block member declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' Examples include property accessors and custom event accessors.
    ''' </summary>
    Public NotInheritable Class AccessorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend _accessorStatement as AccessorStatementSyntax
        Friend _endAccessorStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), accessorStatement As AccessorStatementSyntax, statements As SyntaxNode, endAccessorStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AccessorBlockSyntax(kind, errors, annotations, DirectCast(accessorStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AccessorStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endAccessorStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Get", "Set", "AddHandler", "RemoveHandler", or "RaiseEvent" statement that
        ''' begins the accessor block.
        ''' </summary>
        Public  ReadOnly Property AccessorStatement As AccessorStatementSyntax
            Get
                Return GetRedAtZero(_accessorStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AccessorStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAccessorStatement(accessorStatement as AccessorStatementSyntax) As AccessorBlockSyntax
            return Update(Me.Kind, accessorStatement, Me.Statements, Me.EndAccessorStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
            Return Me.Statements
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As AccessorBlockSyntax
            return Update(Me.Kind, Me.AccessorStatement, statements, Me.EndAccessorStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As AccessorBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The "End Get", "End Set", "End AddHandler", "End RemoveHandler", or "End
        ''' RaiseEvent" statement that ends the accessor block.
        ''' </summary>
        Public  ReadOnly Property EndAccessorStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endAccessorStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndAccessorStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndAccessorStatement(endAccessorStatement as EndBlockStatementSyntax) As AccessorBlockSyntax
            return Update(Me.Kind, Me.AccessorStatement, Me.Statements, endAccessorStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._accessorStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endAccessorStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.AccessorStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndAccessorStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAccessorBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAccessorBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="accessorStatement">
        ''' The value for the AccessorStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endAccessorStatement">
        ''' The value for the EndAccessorStatement property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, accessorStatement As AccessorStatementSyntax, statements As SyntaxList(of StatementSyntax), endAccessorStatement As EndBlockStatementSyntax) As AccessorBlockSyntax
            If kind <> Me.Kind OrElse accessorStatement IsNot Me.AccessorStatement OrElse statements <> Me.Statements OrElse endAccessorStatement IsNot Me.EndAccessorStatement Then
                Dim newNode = SyntaxFactory.AccessorBlock(kind, accessorStatement, statements, endAccessorStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a block property declaration: A declaration that has a beginning
    ''' declaration, some get or set accessor blocks and an end statement.
    ''' </summary>
    Public NotInheritable Class PropertyBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend _propertyStatement as PropertyStatementSyntax
        Friend _accessors as SyntaxNode
        Friend _endPropertyStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), propertyStatement As PropertyStatementSyntax, accessors As SyntaxNode, endPropertyStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PropertyBlockSyntax(kind, errors, annotations, DirectCast(propertyStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PropertyStatementSyntax), if(accessors IsNot Nothing, accessors.Green, Nothing), DirectCast(endPropertyStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The property declaration that begins the block.
        ''' </summary>
        Public  ReadOnly Property PropertyStatement As PropertyStatementSyntax
            Get
                Return GetRedAtZero(_propertyStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the PropertyStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithPropertyStatement(propertyStatement as PropertyStatementSyntax) As PropertyBlockSyntax
            return Update(propertyStatement, Me.Accessors, Me.EndPropertyStatement)
        End Function

        ''' <summary>
        ''' The accessor blocks contained in the property, between the Property and the End
        ''' Property statements.
        ''' </summary>
        Public  ReadOnly Property Accessors As SyntaxList(Of AccessorBlockSyntax)
            Get
                Dim listNode = GetRed(_accessors, 1)
                Return new SyntaxList(Of AccessorBlockSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Accessors property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAccessors(accessors as SyntaxList(Of AccessorBlockSyntax)) As PropertyBlockSyntax
            return Update(Me.PropertyStatement, accessors, Me.EndPropertyStatement)
        End Function

        Public Shadows Function AddAccessors(ParamArray items As AccessorBlockSyntax()) As PropertyBlockSyntax
            Return Me.WithAccessors(Me.Accessors.AddRange(items))
        End Function

        ''' <summary>
        ''' The End Property statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndPropertyStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endPropertyStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndPropertyStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndPropertyStatement(endPropertyStatement as EndBlockStatementSyntax) As PropertyBlockSyntax
            return Update(Me.PropertyStatement, Me.Accessors, endPropertyStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._propertyStatement
                Case 1
                    Return Me._accessors
                Case 2
                    Return Me._endPropertyStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.PropertyStatement
                Case 1
                    Return GetRed(_accessors, 1)
                Case 2
                    Return Me.EndPropertyStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitPropertyBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitPropertyBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="propertyStatement">
        ''' The value for the PropertyStatement property.
        ''' </param>
        ''' <param name="accessors">
        ''' The value for the Accessors property.
        ''' </param>
        ''' <param name="endPropertyStatement">
        ''' The value for the EndPropertyStatement property.
        ''' </param>
        Public Function Update(propertyStatement As PropertyStatementSyntax, accessors As SyntaxList(of AccessorBlockSyntax), endPropertyStatement As EndBlockStatementSyntax) As PropertyBlockSyntax
            If propertyStatement IsNot Me.PropertyStatement OrElse accessors <> Me.Accessors OrElse endPropertyStatement IsNot Me.EndPropertyStatement Then
                Dim newNode = SyntaxFactory.PropertyBlock(propertyStatement, accessors, endPropertyStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a custom event declaration: A declaration that has a beginning event
    ''' declaration, some accessor blocks and an end statement.
    ''' </summary>
    Public NotInheritable Class EventBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend _eventStatement as EventStatementSyntax
        Friend _accessors as SyntaxNode
        Friend _endEventStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eventStatement As EventStatementSyntax, accessors As SyntaxNode, endEventStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventBlockSyntax(kind, errors, annotations, DirectCast(eventStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventStatementSyntax), if(accessors IsNot Nothing, accessors.Green, Nothing), DirectCast(endEventStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The event declaration that begins the block.
        ''' </summary>
        Public  ReadOnly Property EventStatement As EventStatementSyntax
            Get
                Return GetRedAtZero(_eventStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EventStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEventStatement(eventStatement as EventStatementSyntax) As EventBlockSyntax
            return Update(eventStatement, Me.Accessors, Me.EndEventStatement)
        End Function

        ''' <summary>
        ''' The accessor blocks contained in the custom event declaration, between the
        ''' Event statement and the End Event statement.
        ''' </summary>
        Public  ReadOnly Property Accessors As SyntaxList(Of AccessorBlockSyntax)
            Get
                Dim listNode = GetRed(_accessors, 1)
                Return new SyntaxList(Of AccessorBlockSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Accessors property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAccessors(accessors as SyntaxList(Of AccessorBlockSyntax)) As EventBlockSyntax
            return Update(Me.EventStatement, accessors, Me.EndEventStatement)
        End Function

        Public Shadows Function AddAccessors(ParamArray items As AccessorBlockSyntax()) As EventBlockSyntax
            Return Me.WithAccessors(Me.Accessors.AddRange(items))
        End Function

        ''' <summary>
        ''' The End Event statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndEventStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endEventStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndEventStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndEventStatement(endEventStatement as EndBlockStatementSyntax) As EventBlockSyntax
            return Update(Me.EventStatement, Me.Accessors, endEventStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._eventStatement
                Case 1
                    Return Me._accessors
                Case 2
                    Return Me._endEventStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.EventStatement
                Case 1
                    Return GetRed(_accessors, 1)
                Case 2
                    Return Me.EndEventStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEventBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEventBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="eventStatement">
        ''' The value for the EventStatement property.
        ''' </param>
        ''' <param name="accessors">
        ''' The value for the Accessors property.
        ''' </param>
        ''' <param name="endEventStatement">
        ''' The value for the EndEventStatement property.
        ''' </param>
        Public Function Update(eventStatement As EventStatementSyntax, accessors As SyntaxList(of AccessorBlockSyntax), endEventStatement As EndBlockStatementSyntax) As EventBlockSyntax
            If eventStatement IsNot Me.EventStatement OrElse accessors <> Me.Accessors OrElse endEventStatement IsNot Me.EndEventStatement Then
                Dim newNode = SyntaxFactory.EventBlock(eventStatement, accessors, endEventStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent for declarations that are
    ''' "method-like"; i.e., that have a parameter list and return type. This includes
    ''' methods, constructors, properties, events, operators, declares, delegates,
    ''' property accessors and custom event accessors.
    ''' </summary>
    Public MustInherit Class MethodBaseSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode
        Friend _parameterList as ParameterListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Return Me.GetAttributeListsCore()
            End Get
        End Property

        Friend Overridable Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
        End Function


        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Return Me.GetModifiersCore()
            End Get
        End Property

        Friend Overridable Function GetModifiersCore() As SyntaxTokenList
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodBaseSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
        End Function


        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return Me.GetParameterListCore()
            End Get
        End Property

        Friend Overridable Function GetParameterListCore() As ParameterListSyntax
                Return GetRed(_parameterList, 2)
        End Function


    End Class

    ''' <summary>
    ''' Represents the parameter list in a method declaration.
    ''' </summary>
    Public NotInheritable Class ParameterListSyntax
        Inherits VisualBasicSyntaxNode

        Friend _parameters as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, parameters As SyntaxNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax(kind, errors, annotations, openParenToken, if(parameters IsNot Nothing, parameters.Green, Nothing), closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "(" token that introduces the parameter list. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax)._openParenToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As ParameterListSyntax
            return Update(openParenToken, Me.Parameters, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The list of parameters. If no parameter list was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Parameters As SeparatedSyntaxList(Of ParameterSyntax)
            Get
                Dim listNode = GetRed(_parameters, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ParameterSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Parameters property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameters(parameters as SeparatedSyntaxList(Of ParameterSyntax)) As ParameterListSyntax
            return Update(Me.OpenParenToken, parameters, Me.CloseParenToken)
        End Function

        Public Shadows Function AddParameters(ParamArray items As ParameterSyntax()) As ParameterListSyntax
            Return Me.WithParameters(Me.Parameters.AddRange(items))
        End Function

        ''' <summary>
        ''' The ")" token that concludes the parameter list. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax)._closeParenToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As ParameterListSyntax
            return Update(Me.OpenParenToken, Me.Parameters, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._parameters
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_parameters, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitParameterList(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitParameterList(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="parameters">
        ''' The value for the Parameters property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(openParenToken As SyntaxToken, parameters As SeparatedSyntaxList(Of ParameterSyntax), closeParenToken As SyntaxToken) As ParameterListSyntax
            If openParenToken <> Me.OpenParenToken OrElse parameters <> Me.Parameters OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.ParameterList(openParenToken, parameters, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The statement that declares a Sub or Function. If this method has a body, this
    ''' statement will be the Begin of a BlockStatement with
    ''' Kind=MethodDeclarationBlock, and the body of the method will be the Body of
    ''' that BlockStatement.
    ''' </summary>
    Public NotInheritable Class MethodStatementSyntax
        Inherits MethodBaseSyntax

        Friend _typeParameterList as TypeParameterListSyntax
        Friend _asClause as SimpleAsClauseSyntax
        Friend _handlesClause as HandlesClauseSyntax
        Friend _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, subOrFunctionKeyword, identifier, if(typeParameterList IsNot Nothing , DirectCast(typeParameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax), Nothing) , if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) , if(handlesClause IsNot Nothing , DirectCast(handlesClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.HandlesClauseSyntax), Nothing) , if(implementsClause IsNot Nothing , DirectCast(implementsClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As MethodStatementSyntax
            return Update(Me.Kind, attributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As MethodStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, modifiers, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As MethodStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword that introduces this method declaration.
        ''' </summary>
        Public  ReadOnly Property SubOrFunctionKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodStatementSyntax)._subOrFunctionKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SubOrFunctionKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSubOrFunctionKeyword(subOrFunctionKeyword as SyntaxToken) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, subOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' The name of the method being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MethodStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' If present, a type parameter list with generic type parameters for this method.
        ''' If no generic type parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return GetRed(_typeParameterList, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterList property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterList(typeParameterList as TypeParameterListSyntax) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, Me.Identifier, typeParameterList, Me.ParameterList, Me.AsClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddTypeParameterListParameters(ParamArray items As TypeParameterSyntax()) As MethodStatementSyntax
            Dim _child = If (Me.TypeParameterList IsNot Nothing, Me.TypeParameterList, SyntaxFactory.TypeParameterList())
            Return Me.WithTypeParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 5)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, parameterList, Me.AsClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As MethodStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 6)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, asClause, Me.HandlesClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' If present, a Handles clause indicated the events that this method handles.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property HandlesClause As HandlesClauseSyntax
            Get
                Return GetRed(_handlesClause, 7)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the HandlesClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithHandlesClause(handlesClause as HandlesClauseSyntax) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause, handlesClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddHandlesClauseEvents(ParamArray items As HandlesClauseItemSyntax()) As MethodStatementSyntax
            Dim _child = If (Me.HandlesClause IsNot Nothing, Me.HandlesClause, SyntaxFactory.HandlesClause())
            Return Me.WithHandlesClause(_child.AddEvents(items))
        End Function

        ''' <summary>
        ''' If present, an Implements clause indicated the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ImplementsClause As ImplementsClauseSyntax
            Get
                Return GetRed(_implementsClause, 8)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImplementsClause property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImplementsClause(implementsClause as ImplementsClauseSyntax) As MethodStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause, Me.HandlesClause, implementsClause)
        End Function

        Public Shadows Function AddImplementsClauseInterfaceMembers(ParamArray items As QualifiedNameSyntax()) As MethodStatementSyntax
            Dim _child = If (Me.ImplementsClause IsNot Nothing, Me.ImplementsClause, SyntaxFactory.ImplementsClause())
            Return Me.WithImplementsClause(_child.AddInterfaceMembers(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._typeParameterList
                Case 5
                    Return Me._parameterList
                Case 6
                    Return Me._asClause
                Case 7
                    Return Me._handlesClause
                Case 8
                    Return Me._implementsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.TypeParameterList
                Case 5
                    Return Me.ParameterList
                Case 6
                    Return Me.AsClause
                Case 7
                    Return Me.HandlesClause
                Case 8
                    Return Me.ImplementsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMethodStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMethodStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="subOrFunctionKeyword">
        ''' The value for the SubOrFunctionKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterList">
        ''' The value for the TypeParameterList property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        ''' <param name="handlesClause">
        ''' The value for the HandlesClause property.
        ''' </param>
        ''' <param name="implementsClause">
        ''' The value for the ImplementsClause property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, subOrFunctionKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax) As MethodStatementSyntax
            If kind <> Me.Kind OrElse attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse subOrFunctionKeyword <> Me.SubOrFunctionKeyword OrElse identifier <> Me.Identifier OrElse typeParameterList IsNot Me.TypeParameterList OrElse parameterList IsNot Me.ParameterList OrElse asClause IsNot Me.AsClause OrElse handlesClause IsNot Me.HandlesClause OrElse implementsClause IsNot Me.ImplementsClause Then
                Dim newNode = SyntaxFactory.MethodStatement(kind, attributeLists, modifiers, subOrFunctionKeyword, identifier, typeParameterList, parameterList, asClause, handlesClause, implementsClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares a constructor. This statement will be the Begin of a
    ''' BlockStatement with Kind=MethodDeclarationBlock, and the body of the method
    ''' will be the Body of that BlockStatement.
    ''' </summary>
    Public NotInheritable Class SubNewStatementSyntax
        Inherits MethodBaseSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SubNewStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, subKeyword, newKeyword, if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As SubNewStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.SubKeyword, Me.NewKeyword, Me.ParameterList)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As SubNewStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SubNewStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As SubNewStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.SubKeyword, Me.NewKeyword, Me.ParameterList)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As SubNewStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Sub" keyword.
        ''' </summary>
        Public  ReadOnly Property SubKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SubNewStatementSyntax)._subKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SubKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithSubKeyword(subKeyword as SyntaxToken) As SubNewStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, subKeyword, Me.NewKeyword, Me.ParameterList)
        End Function

        ''' <summary>
        ''' The "New" keyword in the constructor declaration.
        ''' </summary>
        Public  ReadOnly Property NewKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SubNewStatementSyntax)._newKeyword, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NewKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNewKeyword(newKeyword as SyntaxToken) As SubNewStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.SubKeyword, newKeyword, Me.ParameterList)
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As SubNewStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.SubKeyword, Me.NewKeyword, parameterList)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As SubNewStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._parameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.ParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSubNewStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSubNewStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="subKeyword">
        ''' The value for the SubKeyword property.
        ''' </param>
        ''' <param name="newKeyword">
        ''' The value for the NewKeyword property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, subKeyword As SyntaxToken, newKeyword As SyntaxToken, parameterList As ParameterListSyntax) As SubNewStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse subKeyword <> Me.SubKeyword OrElse newKeyword <> Me.NewKeyword OrElse parameterList IsNot Me.ParameterList Then
                Dim newNode = SyntaxFactory.SubNewStatement(attributeLists, modifiers, subKeyword, newKeyword, parameterList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' A Declare statement that declares an external DLL method.
    ''' </summary>
    Public NotInheritable Class DeclareStatementSyntax
        Inherits MethodBaseSyntax

        Friend _libraryName as LiteralExpressionSyntax
        Friend _aliasName as LiteralExpressionSyntax
        Friend _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, declareKeyword, charsetKeyword, subOrFunctionKeyword, identifier, libKeyword, DirectCast(libraryName.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LiteralExpressionSyntax), aliasKeyword, if(aliasName IsNot Nothing , DirectCast(aliasName.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LiteralExpressionSyntax), Nothing) , if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As DeclareStatementSyntax
            return Update(Me.Kind, attributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As DeclareStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As DeclareStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Declare" keyword.
        ''' </summary>
        Public  ReadOnly Property DeclareKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._declareKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DeclareKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithDeclareKeyword(declareKeyword as SyntaxToken) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, declareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' If present, the keyword that defines the string translation semantics of the
        ''' external method.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property CharsetKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._charsetKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(3), Me.GetChildIndex(3))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CharsetKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCharsetKeyword(charsetKeyword as SyntaxToken) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, charsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword.
        ''' </summary>
        Public  ReadOnly Property SubOrFunctionKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._subOrFunctionKeyword, Me.GetChildPosition(4), Me.GetChildIndex(4))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SubOrFunctionKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSubOrFunctionKeyword(subOrFunctionKeyword as SyntaxToken) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, subOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The name of the method being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._identifier, Me.GetChildPosition(5), Me.GetChildIndex(5))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The "Lib" keyword.
        ''' </summary>
        Public  ReadOnly Property LibKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._libKeyword, Me.GetChildPosition(6), Me.GetChildIndex(6))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LibKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLibKeyword(libKeyword as SyntaxToken) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, libKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The string literal with the library name.
        ''' </summary>
        Public  ReadOnly Property LibraryName As LiteralExpressionSyntax
            Get
                Return GetRed(_libraryName, 7)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LibraryName property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLibraryName(libraryName as LiteralExpressionSyntax) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, libraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' If present, the "Alias" keyword. If not present, returns Nothing.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AliasKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DeclareStatementSyntax)._aliasKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(8), Me.GetChildIndex(8))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AliasKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAliasKeyword(aliasKeyword as SyntaxToken) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, aliasKeyword, Me.AliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The string literal with the alias. If not present, returns Nothing.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AliasName As LiteralExpressionSyntax
            Get
                Return GetRed(_aliasName, 9)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AliasName property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAliasName(aliasName as LiteralExpressionSyntax) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, aliasName, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 10)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, parameterList, Me.AsClause)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As DeclareStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 11)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As DeclareStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DeclareKeyword, Me.CharsetKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.LibKeyword, Me.LibraryName, Me.AliasKeyword, Me.AliasName, Me.ParameterList, asClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 7
                    Return Me._libraryName
                Case 9
                    Return Me._aliasName
                Case 10
                    Return Me._parameterList
                Case 11
                    Return Me._asClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 7
                    Return Me.LibraryName
                Case 9
                    Return Me.AliasName
                Case 10
                    Return Me.ParameterList
                Case 11
                    Return Me.AsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitDeclareStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitDeclareStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="declareKeyword">
        ''' The value for the DeclareKeyword property.
        ''' </param>
        ''' <param name="charsetKeyword">
        ''' The value for the CharsetKeyword property.
        ''' </param>
        ''' <param name="subOrFunctionKeyword">
        ''' The value for the SubOrFunctionKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="libKeyword">
        ''' The value for the LibKeyword property.
        ''' </param>
        ''' <param name="libraryName">
        ''' The value for the LibraryName property.
        ''' </param>
        ''' <param name="aliasKeyword">
        ''' The value for the AliasKeyword property.
        ''' </param>
        ''' <param name="aliasName">
        ''' The value for the AliasName property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, declareKeyword As SyntaxToken, charsetKeyword As SyntaxToken, subOrFunctionKeyword As SyntaxToken, identifier As SyntaxToken, libKeyword As SyntaxToken, libraryName As LiteralExpressionSyntax, aliasKeyword As SyntaxToken, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax) As DeclareStatementSyntax
            If kind <> Me.Kind OrElse attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse declareKeyword <> Me.DeclareKeyword OrElse charsetKeyword <> Me.CharsetKeyword OrElse subOrFunctionKeyword <> Me.SubOrFunctionKeyword OrElse identifier <> Me.Identifier OrElse libKeyword <> Me.LibKeyword OrElse libraryName IsNot Me.LibraryName OrElse aliasKeyword <> Me.AliasKeyword OrElse aliasName IsNot Me.AliasName OrElse parameterList IsNot Me.ParameterList OrElse asClause IsNot Me.AsClause Then
                Dim newNode = SyntaxFactory.DeclareStatement(kind, attributeLists, modifiers, declareKeyword, charsetKeyword, subOrFunctionKeyword, identifier, libKeyword, libraryName, aliasKeyword, aliasName, parameterList, asClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares a delegate type.
    ''' </summary>
    Public NotInheritable Class DelegateStatementSyntax
        Inherits MethodBaseSyntax

        Friend _typeParameterList as TypeParameterListSyntax
        Friend _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DelegateStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, delegateKeyword, subOrFunctionKeyword, identifier, if(typeParameterList IsNot Nothing , DirectCast(typeParameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeParameterListSyntax), Nothing) , if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As DelegateStatementSyntax
            return Update(Me.Kind, attributeLists, Me.Modifiers, Me.DelegateKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As DelegateStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DelegateStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, modifiers, Me.DelegateKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As DelegateStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Delegate" keyword.
        ''' </summary>
        Public  ReadOnly Property DelegateKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DelegateStatementSyntax)._delegateKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DelegateKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithDelegateKeyword(delegateKeyword as SyntaxToken) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, delegateKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword.
        ''' </summary>
        Public  ReadOnly Property SubOrFunctionKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DelegateStatementSyntax)._subOrFunctionKeyword, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SubOrFunctionKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSubOrFunctionKeyword(subOrFunctionKeyword as SyntaxToken) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DelegateKeyword, subOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The name of the delegate being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DelegateStatementSyntax)._identifier, Me.GetChildPosition(4), Me.GetChildIndex(4))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DelegateKeyword, Me.SubOrFunctionKeyword, identifier, Me.TypeParameterList, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' If present, a type parameter list with generic type parameters for this
        ''' delegate. If no generic type parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property TypeParameterList As TypeParameterListSyntax
            Get
                Return GetRed(_typeParameterList, 5)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the TypeParameterList property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithTypeParameterList(typeParameterList as TypeParameterListSyntax) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DelegateKeyword, Me.SubOrFunctionKeyword, Me.Identifier, typeParameterList, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddTypeParameterListParameters(ParamArray items As TypeParameterSyntax()) As DelegateStatementSyntax
            Dim _child = If (Me.TypeParameterList IsNot Nothing, Me.TypeParameterList, SyntaxFactory.TypeParameterList())
            Return Me.WithTypeParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 6)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DelegateKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, parameterList, Me.AsClause)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As DelegateStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 7)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As DelegateStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.DelegateKeyword, Me.SubOrFunctionKeyword, Me.Identifier, Me.TypeParameterList, Me.ParameterList, asClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 5
                    Return Me._typeParameterList
                Case 6
                    Return Me._parameterList
                Case 7
                    Return Me._asClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 5
                    Return Me.TypeParameterList
                Case 6
                    Return Me.ParameterList
                Case 7
                    Return Me.AsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitDelegateStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitDelegateStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="delegateKeyword">
        ''' The value for the DelegateKeyword property.
        ''' </param>
        ''' <param name="subOrFunctionKeyword">
        ''' The value for the SubOrFunctionKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="typeParameterList">
        ''' The value for the TypeParameterList property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, delegateKeyword As SyntaxToken, subOrFunctionKeyword As SyntaxToken, identifier As SyntaxToken, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax) As DelegateStatementSyntax
            If kind <> Me.Kind OrElse attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse delegateKeyword <> Me.DelegateKeyword OrElse subOrFunctionKeyword <> Me.SubOrFunctionKeyword OrElse identifier <> Me.Identifier OrElse typeParameterList IsNot Me.TypeParameterList OrElse parameterList IsNot Me.ParameterList OrElse asClause IsNot Me.AsClause Then
                Dim newNode = SyntaxFactory.DelegateStatement(kind, attributeLists, modifiers, delegateKeyword, subOrFunctionKeyword, identifier, typeParameterList, parameterList, asClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares an event. If the event being declared is a custom
    ''' event, this statement will be the Begin of a PropertyOrEventBlock, and the
    ''' accessors will be part of the Accessors of that node.
    ''' </summary>
    Public NotInheritable Class EventStatementSyntax
        Inherits MethodBaseSyntax

        Friend _asClause as SimpleAsClauseSyntax
        Friend _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, customKeyword, eventKeyword, identifier, if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) , if(implementsClause IsNot Nothing , DirectCast(implementsClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As EventStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.CustomKeyword, Me.EventKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As EventStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As EventStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.CustomKeyword, Me.EventKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As EventStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The optional Custom keyword for custom event declarations.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property CustomKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventStatementSyntax)._customKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(2), Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CustomKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCustomKeyword(customKeyword as SyntaxToken) As EventStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, customKeyword, Me.EventKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' The "Event" keyword that introduces this event declaration.
        ''' </summary>
        Public  ReadOnly Property EventKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventStatementSyntax)._eventKeyword, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EventKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEventKeyword(eventKeyword as SyntaxToken) As EventStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.CustomKeyword, eventKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' The name of the event being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventStatementSyntax)._identifier, Me.GetChildPosition(4), Me.GetChildIndex(4))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As EventStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.CustomKeyword, Me.EventKeyword, identifier, Me.ParameterList, Me.AsClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 5)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As EventStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.CustomKeyword, Me.EventKeyword, Me.Identifier, parameterList, Me.AsClause, Me.ImplementsClause)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As EventStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 6)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As EventStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.CustomKeyword, Me.EventKeyword, Me.Identifier, Me.ParameterList, asClause, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' If present, an Implements clause indicates the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ImplementsClause As ImplementsClauseSyntax
            Get
                Return GetRed(_implementsClause, 7)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImplementsClause property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImplementsClause(implementsClause as ImplementsClauseSyntax) As EventStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.CustomKeyword, Me.EventKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, implementsClause)
        End Function

        Public Shadows Function AddImplementsClauseInterfaceMembers(ParamArray items As QualifiedNameSyntax()) As EventStatementSyntax
            Dim _child = If (Me.ImplementsClause IsNot Nothing, Me.ImplementsClause, SyntaxFactory.ImplementsClause())
            Return Me.WithImplementsClause(_child.AddInterfaceMembers(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 5
                    Return Me._parameterList
                Case 6
                    Return Me._asClause
                Case 7
                    Return Me._implementsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 5
                    Return Me.ParameterList
                Case 6
                    Return Me.AsClause
                Case 7
                    Return Me.ImplementsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEventStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEventStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="customKeyword">
        ''' The value for the CustomKeyword property.
        ''' </param>
        ''' <param name="eventKeyword">
        ''' The value for the EventKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        ''' <param name="implementsClause">
        ''' The value for the ImplementsClause property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, customKeyword As SyntaxToken, eventKeyword As SyntaxToken, identifier As SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax) As EventStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse customKeyword <> Me.CustomKeyword OrElse eventKeyword <> Me.EventKeyword OrElse identifier <> Me.Identifier OrElse parameterList IsNot Me.ParameterList OrElse asClause IsNot Me.AsClause OrElse implementsClause IsNot Me.ImplementsClause Then
                Dim newNode = SyntaxFactory.EventStatement(attributeLists, modifiers, customKeyword, eventKeyword, identifier, parameterList, asClause, implementsClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares an operator. If this operator has a body, this
    ''' statement will be the Begin of a BlockStatement with
    ''' Kind=MethodDeclarationBlock, and the body of the method will be the Body of
    ''' that BlockStatement.
    ''' </summary>
    Public NotInheritable Class OperatorStatementSyntax
        Inherits MethodBaseSyntax

        Friend _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OperatorStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, operatorKeyword, operatorToken, if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As OperatorStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.OperatorKeyword, Me.OperatorToken, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As OperatorStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OperatorStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As OperatorStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.OperatorKeyword, Me.OperatorToken, Me.ParameterList, Me.AsClause)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As OperatorStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Operator" keyword that introduces this operator declaration.
        ''' </summary>
        Public  ReadOnly Property OperatorKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OperatorStatementSyntax)._operatorKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOperatorKeyword(operatorKeyword as SyntaxToken) As OperatorStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, operatorKeyword, Me.OperatorToken, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The operator being defined.
        ''' </summary>
        Public  ReadOnly Property OperatorToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OperatorStatementSyntax)._operatorToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOperatorToken(operatorToken as SyntaxToken) As OperatorStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.OperatorKeyword, operatorToken, Me.ParameterList, Me.AsClause)
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As OperatorStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.OperatorKeyword, Me.OperatorToken, parameterList, Me.AsClause)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As OperatorStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 5)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As OperatorStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.OperatorKeyword, Me.OperatorToken, Me.ParameterList, asClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._parameterList
                Case 5
                    Return Me._asClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.ParameterList
                Case 5
                    Return Me.AsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitOperatorStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitOperatorStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="operatorKeyword">
        ''' The value for the OperatorKeyword property.
        ''' </param>
        ''' <param name="operatorToken">
        ''' The value for the OperatorToken property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, operatorKeyword As SyntaxToken, operatorToken As SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax) As OperatorStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse operatorKeyword <> Me.OperatorKeyword OrElse operatorToken <> Me.OperatorToken OrElse parameterList IsNot Me.ParameterList OrElse asClause IsNot Me.AsClause Then
                Dim newNode = SyntaxFactory.OperatorStatement(attributeLists, modifiers, operatorKeyword, operatorToken, parameterList, asClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Statement that declares a property. If this property has accessors declared,
    ''' this statement will be the Begin of a BlockNode, and the accessors will be the
    ''' Body of that node. Auto properties are property declarations without a
    ''' PropertyBlock.
    ''' </summary>
    Public NotInheritable Class PropertyStatementSyntax
        Inherits MethodBaseSyntax

        Friend _asClause as AsClauseSyntax
        Friend _initializer as EqualsValueSyntax
        Friend _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PropertyStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, propertyKeyword, identifier, if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AsClauseSyntax), Nothing) , if(initializer IsNot Nothing , DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EqualsValueSyntax), Nothing) , if(implementsClause IsNot Nothing , DirectCast(implementsClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As PropertyStatementSyntax
            return Update(attributeLists, Me.Modifiers, Me.PropertyKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.Initializer, Me.ImplementsClause)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As PropertyStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PropertyStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As PropertyStatementSyntax
            return Update(Me.AttributeLists, modifiers, Me.PropertyKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.Initializer, Me.ImplementsClause)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As PropertyStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Property" keyword that introduces this property declaration.
        ''' </summary>
        Public  ReadOnly Property PropertyKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PropertyStatementSyntax)._propertyKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the PropertyKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithPropertyKeyword(propertyKeyword as SyntaxToken) As PropertyStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, propertyKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.Initializer, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' The name of the property being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PropertyStatementSyntax)._identifier, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As PropertyStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.PropertyKeyword, identifier, Me.ParameterList, Me.AsClause, Me.Initializer, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 4)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As PropertyStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.PropertyKeyword, Me.Identifier, parameterList, Me.AsClause, Me.Initializer, Me.ImplementsClause)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As PropertyStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As AsClauseSyntax
            Get
                Return GetRed(_asClause, 5)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as AsClauseSyntax) As PropertyStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.PropertyKeyword, Me.Identifier, Me.ParameterList, asClause, Me.Initializer, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' If present, an "= initial-value" clause describing the initial value of the
        ''' property.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Initializer As EqualsValueSyntax
            Get
                Return GetRed(_initializer, 6)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as EqualsValueSyntax) As PropertyStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.PropertyKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, initializer, Me.ImplementsClause)
        End Function

        ''' <summary>
        ''' If present, an Implements clause indicated the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ImplementsClause As ImplementsClauseSyntax
            Get
                Return GetRed(_implementsClause, 7)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImplementsClause property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImplementsClause(implementsClause as ImplementsClauseSyntax) As PropertyStatementSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.PropertyKeyword, Me.Identifier, Me.ParameterList, Me.AsClause, Me.Initializer, implementsClause)
        End Function

        Public Shadows Function AddImplementsClauseInterfaceMembers(ParamArray items As QualifiedNameSyntax()) As PropertyStatementSyntax
            Dim _child = If (Me.ImplementsClause IsNot Nothing, Me.ImplementsClause, SyntaxFactory.ImplementsClause())
            Return Me.WithImplementsClause(_child.AddInterfaceMembers(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 4
                    Return Me._parameterList
                Case 5
                    Return Me._asClause
                Case 6
                    Return Me._initializer
                Case 7
                    Return Me._implementsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 4
                    Return Me.ParameterList
                Case 5
                    Return Me.AsClause
                Case 6
                    Return Me.Initializer
                Case 7
                    Return Me.ImplementsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitPropertyStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitPropertyStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="propertyKeyword">
        ''' The value for the PropertyKeyword property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        ''' <param name="implementsClause">
        ''' The value for the ImplementsClause property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, propertyKeyword As SyntaxToken, identifier As SyntaxToken, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax) As PropertyStatementSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse propertyKeyword <> Me.PropertyKeyword OrElse identifier <> Me.Identifier OrElse parameterList IsNot Me.ParameterList OrElse asClause IsNot Me.AsClause OrElse initializer IsNot Me.Initializer OrElse implementsClause IsNot Me.ImplementsClause Then
                Dim newNode = SyntaxFactory.PropertyStatement(attributeLists, modifiers, propertyKeyword, identifier, parameterList, asClause, initializer, implementsClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Get or Set accessor on a property declaration or an AddHandler,
    ''' RemoveHandler or RaiseEvent accessor on a custom event declaration. The Kind of
    ''' the node determines what kind of accessor this is. This statement is always the
    ''' Begin of a BlockNode, and the body of the accessor is the Body of that node.
    ''' </summary>
    Public NotInheritable Class AccessorStatementSyntax
        Inherits MethodBaseSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AccessorStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, accessorKeyword, if(parameterList IsNot Nothing , DirectCast(parameterList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As AccessorStatementSyntax
            return Update(Me.Kind, attributeLists, Me.Modifiers, Me.AccessorKeyword, Me.ParameterList)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As AccessorStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AccessorStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetModifiersCore() As SyntaxTokenList
            Return Me.Modifiers
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As AccessorStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, modifiers, Me.AccessorKeyword, Me.ParameterList)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As AccessorStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "Get", "Set", "AddHandler", "RemoveHandler", or "RaiseEvent" keyword that
        ''' introduces this accessor declaration.
        ''' </summary>
        Public  ReadOnly Property AccessorKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AccessorStatementSyntax)._accessorKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AccessorKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAccessorKeyword(accessorKeyword as SyntaxToken) As AccessorStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, accessorKeyword, Me.ParameterList)
        End Function

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property ParameterList As ParameterListSyntax
            Get
                Return GetRed(_parameterList, 3)
            End Get
        End Property

        Friend Overrides Function GetParameterListCore() As ParameterListSyntax
            Return Me.ParameterList
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ParameterList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithParameterList(parameterList as ParameterListSyntax) As AccessorStatementSyntax
            return Update(Me.Kind, Me.AttributeLists, Me.Modifiers, Me.AccessorKeyword, parameterList)
        End Function

        Public Shadows Function AddParameterListParameters(ParamArray items As ParameterSyntax()) As AccessorStatementSyntax
            Dim _child = If (Me.ParameterList IsNot Nothing, Me.ParameterList, SyntaxFactory.ParameterList())
            Return Me.WithParameterList(_child.AddParameters(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 3
                    Return Me._parameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 3
                    Return Me.ParameterList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAccessorStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAccessorStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="accessorKeyword">
        ''' The value for the AccessorKeyword property.
        ''' </param>
        ''' <param name="parameterList">
        ''' The value for the ParameterList property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, accessorKeyword As SyntaxToken, parameterList As ParameterListSyntax) As AccessorStatementSyntax
            If kind <> Me.Kind OrElse attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse accessorKeyword <> Me.AccessorKeyword OrElse parameterList IsNot Me.ParameterList Then
                Dim newNode = SyntaxFactory.AccessorStatement(kind, attributeLists, modifiers, accessorKeyword, parameterList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Implements ..." clause on a type member, which describes which
    ''' interface members this member implements.
    ''' </summary>
    Public NotInheritable Class ImplementsClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _interfaceMembers as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsClauseSyntax(kind, errors, annotations, implementsKeyword, if(interfaceMembers IsNot Nothing, interfaceMembers.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Implements" keyword.
        ''' </summary>
        Public  ReadOnly Property ImplementsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ImplementsClauseSyntax)._implementsKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ImplementsKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithImplementsKeyword(implementsKeyword as SyntaxToken) As ImplementsClauseSyntax
            return Update(implementsKeyword, Me.InterfaceMembers)
        End Function

        ''' <summary>
        ''' The list of interface members being implemented.
        ''' </summary>
        Public  ReadOnly Property InterfaceMembers As SeparatedSyntaxList(Of QualifiedNameSyntax)
            Get
                Dim listNode = GetRed(_interfaceMembers, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of QualifiedNameSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the InterfaceMembers property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithInterfaceMembers(interfaceMembers as SeparatedSyntaxList(Of QualifiedNameSyntax)) As ImplementsClauseSyntax
            return Update(Me.ImplementsKeyword, interfaceMembers)
        End Function

        Public Shadows Function AddInterfaceMembers(ParamArray items As QualifiedNameSyntax()) As ImplementsClauseSyntax
            Return Me.WithInterfaceMembers(Me.InterfaceMembers.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._interfaceMembers
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_interfaceMembers, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitImplementsClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitImplementsClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="implementsKeyword">
        ''' The value for the ImplementsKeyword property.
        ''' </param>
        ''' <param name="interfaceMembers">
        ''' The value for the InterfaceMembers property.
        ''' </param>
        Public Function Update(implementsKeyword As SyntaxToken, interfaceMembers As SeparatedSyntaxList(Of QualifiedNameSyntax)) As ImplementsClauseSyntax
            If implementsKeyword <> Me.ImplementsKeyword OrElse interfaceMembers <> Me.InterfaceMembers Then
                Dim newNode = SyntaxFactory.ImplementsClause(implementsKeyword, interfaceMembers)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Handles ..." clause on a method declaration that describes
    ''' which events this method handles.
    ''' </summary>
    Public NotInheritable Class HandlesClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _events as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), handlesKeyword As InternalSyntax.KeywordSyntax, events As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.HandlesClauseSyntax(kind, errors, annotations, handlesKeyword, if(events IsNot Nothing, events.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Handles" keyword.
        ''' </summary>
        Public  ReadOnly Property HandlesKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.HandlesClauseSyntax)._handlesKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the HandlesKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithHandlesKeyword(handlesKeyword as SyntaxToken) As HandlesClauseSyntax
            return Update(handlesKeyword, Me.Events)
        End Function

        ''' <summary>
        ''' The list of event members being handled.
        ''' </summary>
        Public  ReadOnly Property Events As SeparatedSyntaxList(Of HandlesClauseItemSyntax)
            Get
                Dim listNode = GetRed(_events, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of HandlesClauseItemSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Events property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function [WithEvents](events as SeparatedSyntaxList(Of HandlesClauseItemSyntax)) As HandlesClauseSyntax
            return Update(Me.HandlesKeyword, events)
        End Function

        Public Shadows Function AddEvents(ParamArray items As HandlesClauseItemSyntax()) As HandlesClauseSyntax
            Return Me.WithEvents(Me.Events.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._events
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_events, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitHandlesClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitHandlesClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="handlesKeyword">
        ''' The value for the HandlesKeyword property.
        ''' </param>
        ''' <param name="events">
        ''' The value for the Events property.
        ''' </param>
        Public Function Update(handlesKeyword As SyntaxToken, events As SeparatedSyntaxList(Of HandlesClauseItemSyntax)) As HandlesClauseSyntax
            If handlesKeyword <> Me.HandlesKeyword OrElse events <> Me.Events Then
                Dim newNode = SyntaxFactory.HandlesClause(handlesKeyword, events)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents container of an event in a Handles clause item.
    ''' </summary>
    Public MustInherit Class EventContainerSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' Represents event container specified through special keywords "Me", "MyBase" or
    ''' "MyClass"..
    ''' </summary>
    Public NotInheritable Class KeywordEventContainerSyntax
        Inherits EventContainerSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.KeywordEventContainerSyntax(kind, errors, annotations, keyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The container of the event. This can be one of the special keywords: "Me",
        ''' "MyBase" or "MyClass".
        ''' </summary>
        Public  ReadOnly Property Keyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.KeywordEventContainerSyntax)._keyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Keyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithKeyword(keyword as SyntaxToken) As KeywordEventContainerSyntax
            return Update(keyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitKeywordEventContainer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitKeywordEventContainer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="keyword">
        ''' The value for the Keyword property.
        ''' </param>
        Public Function Update(keyword As SyntaxToken) As KeywordEventContainerSyntax
            If keyword <> Me.Keyword Then
                Dim newNode = SyntaxFactory.KeywordEventContainer(keyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents event container that refers to a WithEvents member.
    ''' </summary>
    Public NotInheritable Class WithEventsEventContainerSyntax
        Inherits EventContainerSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithEventsEventContainerSyntax(kind, errors, annotations, identifier), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The container of the event. It is a simple identifier that refers to a
        ''' WithEvents member of the containing type.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithEventsEventContainerSyntax)._identifier, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As WithEventsEventContainerSyntax
            return Update(identifier)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWithEventsEventContainer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWithEventsEventContainer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        Public Function Update(identifier As SyntaxToken) As WithEventsEventContainerSyntax
            If identifier <> Me.Identifier Then
                Dim newNode = SyntaxFactory.WithEventsEventContainer(identifier)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents event container that refers to a WithEvents member's property.
    ''' </summary>
    Public NotInheritable Class WithEventsPropertyEventContainerSyntax
        Inherits EventContainerSyntax

        Friend _withEventsContainer as WithEventsEventContainerSyntax
        Friend _property as IdentifierNameSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithEventsPropertyEventContainerSyntax(kind, errors, annotations, DirectCast(withEventsContainer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithEventsEventContainerSyntax), dotToken, DirectCast([property].Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IdentifierNameSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The container of the event.
        ''' </summary>
        Public  ReadOnly Property WithEventsContainer As WithEventsEventContainerSyntax
            Get
                Return GetRedAtZero(_withEventsContainer)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WithEventsContainer property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithWithEventsContainer(withEventsContainer as WithEventsEventContainerSyntax) As WithEventsPropertyEventContainerSyntax
            return Update(withEventsContainer, Me.DotToken, Me.Property)
        End Function

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Public  ReadOnly Property DotToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithEventsPropertyEventContainerSyntax)._dotToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DotToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDotToken(dotToken as SyntaxToken) As WithEventsPropertyEventContainerSyntax
            return Update(Me.WithEventsContainer, dotToken, Me.Property)
        End Function

        ''' <summary>
        ''' The provider of the event. It is a property of a WithEvents member of the
        ''' containing type.
        ''' </summary>
        Public  ReadOnly Property [Property] As IdentifierNameSyntax
            Get
                Return GetRed(_property, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the [Property] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithProperty([property] as IdentifierNameSyntax) As WithEventsPropertyEventContainerSyntax
            return Update(Me.WithEventsContainer, Me.DotToken, [property])
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._withEventsContainer
                Case 2
                    Return Me._property
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.WithEventsContainer
                Case 2
                    Return Me.[Property]
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWithEventsPropertyEventContainer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWithEventsPropertyEventContainer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="withEventsContainer">
        ''' The value for the WithEventsContainer property.
        ''' </param>
        ''' <param name="dotToken">
        ''' The value for the DotToken property.
        ''' </param>
        ''' <param name="property">
        ''' The value for the Property property.
        ''' </param>
        Public Function Update(withEventsContainer As WithEventsEventContainerSyntax, dotToken As SyntaxToken, [property] As IdentifierNameSyntax) As WithEventsPropertyEventContainerSyntax
            If withEventsContainer IsNot Me.WithEventsContainer OrElse dotToken <> Me.DotToken OrElse [property] IsNot Me.[Property] Then
                Dim newNode = SyntaxFactory.WithEventsPropertyEventContainer(withEventsContainer, dotToken, [property])
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single handled event in a "Handles ..." clause.
    ''' </summary>
    Public NotInheritable Class HandlesClauseItemSyntax
        Inherits VisualBasicSyntaxNode

        Friend _eventContainer as EventContainerSyntax
        Friend _eventMember as IdentifierNameSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.HandlesClauseItemSyntax(kind, errors, annotations, DirectCast(eventContainer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EventContainerSyntax), dotToken, DirectCast(eventMember.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IdentifierNameSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The container of the event. This can either be a simple identifier (identifying
        ''' a members of the containing type) or one of the special keywords "Me", "MyBase"
        ''' or "MyClass".
        ''' </summary>
        Public  ReadOnly Property EventContainer As EventContainerSyntax
            Get
                Return GetRedAtZero(_eventContainer)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EventContainer property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEventContainer(eventContainer as EventContainerSyntax) As HandlesClauseItemSyntax
            return Update(eventContainer, Me.DotToken, Me.EventMember)
        End Function

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Public  ReadOnly Property DotToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.HandlesClauseItemSyntax)._dotToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DotToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDotToken(dotToken as SyntaxToken) As HandlesClauseItemSyntax
            return Update(Me.EventContainer, dotToken, Me.EventMember)
        End Function

        ''' <summary>
        ''' The event being handled. This must be a simple identifier.
        ''' </summary>
        Public  ReadOnly Property EventMember As IdentifierNameSyntax
            Get
                Return GetRed(_eventMember, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EventMember property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEventMember(eventMember as IdentifierNameSyntax) As HandlesClauseItemSyntax
            return Update(Me.EventContainer, Me.DotToken, eventMember)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._eventContainer
                Case 2
                    Return Me._eventMember
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.EventContainer
                Case 2
                    Return Me.EventMember
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitHandlesClauseItem(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitHandlesClauseItem(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="eventContainer">
        ''' The value for the EventContainer property.
        ''' </param>
        ''' <param name="dotToken">
        ''' The value for the DotToken property.
        ''' </param>
        ''' <param name="eventMember">
        ''' The value for the EventMember property.
        ''' </param>
        Public Function Update(eventContainer As EventContainerSyntax, dotToken As SyntaxToken, eventMember As IdentifierNameSyntax) As HandlesClauseItemSyntax
            If eventContainer IsNot Me.EventContainer OrElse dotToken <> Me.DotToken OrElse eventMember IsNot Me.EventMember Then
                Dim newNode = SyntaxFactory.HandlesClauseItem(eventContainer, dotToken, eventMember)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning of a declaration. However, not enough syntax is
    ''' detected to classify this as a field, method, property or event. This is node
    ''' always represents a syntax error.
    ''' </summary>
    Public NotInheritable Class IncompleteMemberSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IncompleteMemberSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, missingIdentifier), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As IncompleteMemberSyntax
            return Update(attributeLists, Me.Modifiers, Me.MissingIdentifier)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As IncompleteMemberSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IncompleteMemberSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As IncompleteMemberSyntax
            return Update(Me.AttributeLists, modifiers, Me.MissingIdentifier)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As IncompleteMemberSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The missing identifier token for this incomplete member. Should only be used to
        ''' have a location for error reporting.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property MissingIdentifier As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IncompleteMemberSyntax)._missingIdentifier
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(2), Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the MissingIdentifier property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithMissingIdentifier(missingIdentifier as SyntaxToken) As IncompleteMemberSyntax
            return Update(Me.AttributeLists, Me.Modifiers, missingIdentifier)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitIncompleteMember(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitIncompleteMember(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="missingIdentifier">
        ''' The value for the MissingIdentifier property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, missingIdentifier As SyntaxToken) As IncompleteMemberSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse missingIdentifier <> Me.MissingIdentifier Then
                Dim newNode = SyntaxFactory.IncompleteMember(attributeLists, modifiers, missingIdentifier)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the declaration of one or more variables or constants, either as
    ''' local variables or as class/structure members. In the case of a constant, it is
    ''' represented by having "Const" in the Modifiers (although technically "Const" is
    ''' not a modifier, it is represented as one in the parse trees.)
    ''' </summary>
    Public NotInheritable Class FieldDeclarationSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode
        Friend _declarators as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, declarators As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FieldDeclarationSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, if(declarators IsNot Nothing, declarators.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As FieldDeclarationSyntax
            return Update(attributeLists, Me.Modifiers, Me.Declarators)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As FieldDeclarationSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FieldDeclarationSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As FieldDeclarationSyntax
            return Update(Me.AttributeLists, modifiers, Me.Declarators)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As FieldDeclarationSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The list of variable declarator. Each declarator specifies one or more variable
        ''' names along with a type and/or initializer.
        ''' </summary>
        Public  ReadOnly Property Declarators As SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Dim listNode = GetRed(_declarators, 2)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of VariableDeclaratorSyntax)(listNode, Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Declarators property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDeclarators(declarators as SeparatedSyntaxList(Of VariableDeclaratorSyntax)) As FieldDeclarationSyntax
            return Update(Me.AttributeLists, Me.Modifiers, declarators)
        End Function

        Public Shadows Function AddDeclarators(ParamArray items As VariableDeclaratorSyntax()) As FieldDeclarationSyntax
            Return Me.WithDeclarators(Me.Declarators.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 2
                    Return Me._declarators
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 2
                    Return GetRed(_declarators, 2)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitFieldDeclaration(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitFieldDeclaration(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="declarators">
        ''' The value for the Declarators property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, declarators As SeparatedSyntaxList(Of VariableDeclaratorSyntax)) As FieldDeclarationSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse declarators <> Me.Declarators Then
                Dim newNode = SyntaxFactory.FieldDeclaration(attributeLists, modifiers, declarators)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the part of a variable or constant declaration statement that
    ''' associated one or more variable names with a type.
    ''' </summary>
    Public NotInheritable Class VariableDeclaratorSyntax
        Inherits VisualBasicSyntaxNode

        Friend _names as SyntaxNode
        Friend _asClause as AsClauseSyntax
        Friend _initializer as EqualsValueSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), names As SyntaxNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.VariableDeclaratorSyntax(kind, errors, annotations, if(names IsNot Nothing, names.Green, Nothing), if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AsClauseSyntax), Nothing) , if(initializer IsNot Nothing , DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EqualsValueSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The names of the variables being declared. Each name might have a "?" or "()"
        ''' modifier(s) attached.
        ''' </summary>
        Public  ReadOnly Property Names As SeparatedSyntaxList(Of ModifiedIdentifierSyntax)
            Get
                Dim listNode = GetRedAtZero(_names)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ModifiedIdentifierSyntax)(listNode, 0)
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Names property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithNames(names as SeparatedSyntaxList(Of ModifiedIdentifierSyntax)) As VariableDeclaratorSyntax
            return Update(names, Me.AsClause, Me.Initializer)
        End Function

        Public Shadows Function AddNames(ParamArray items As ModifiedIdentifierSyntax()) As VariableDeclaratorSyntax
            Return Me.WithNames(Me.Names.AddRange(items))
        End Function

        ''' <summary>
        ''' The "As" clause that describes the return type, and possibly includes "New",
        ''' "With" or "From". If no As clause was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As AsClauseSyntax
            Get
                Return GetRed(_asClause, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as AsClauseSyntax) As VariableDeclaratorSyntax
            return Update(Me.Names, asClause, Me.Initializer)
        End Function

        ''' <summary>
        ''' If present, an "= initial-value" clause describing the initial value of the
        ''' variable or the value of the constant.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Initializer As EqualsValueSyntax
            Get
                Return GetRed(_initializer, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as EqualsValueSyntax) As VariableDeclaratorSyntax
            return Update(Me.Names, Me.AsClause, initializer)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._names
                Case 1
                    Return Me._asClause
                Case 2
                    Return Me._initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_names)
                Case 1
                    Return Me.AsClause
                Case 2
                    Return Me.Initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitVariableDeclarator(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitVariableDeclarator(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="names">
        ''' The value for the Names property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        Public Function Update(names As SeparatedSyntaxList(Of ModifiedIdentifierSyntax), asClause As AsClauseSyntax, initializer As EqualsValueSyntax) As VariableDeclaratorSyntax
            If names <> Me.Names OrElse asClause IsNot Me.AsClause OrElse initializer IsNot Me.Initializer Then
                Dim newNode = SyntaxFactory.VariableDeclarator(names, asClause, initializer)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Abstract node class that represents the different kinds of "As {type-name}"
    ''' clauses in a declaration: simple "As" clauses and "As New" clauses. The type
    ''' has optional attributes associated with it, although attributes are not
    ''' permitted in all possible places where this node occurs.
    ''' </summary>
    Public MustInherit Class AsClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Public ReadOnly Property AsKeyword As SyntaxToken
            Get
                Return Me.GetAsKeywordCore()
            End Get
        End Property

        Friend Overridable Function GetAsKeywordCore() As SyntaxToken
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AsClauseSyntax)._asKeyword, Me.Position, 0)
        End Function


    End Class

    ''' <summary>
    ''' Represents an "As {type-name}" clause that does not have an initializer or
    ''' "New". The type has optional attributes associated with it, although attributes
    ''' are not permitted in all possible places where this node occurs.
    ''' </summary>
    Public NotInheritable Class SimpleAsClauseSyntax
        Inherits AsClauseSyntax

        Friend _attributeLists as SyntaxNode
        Friend _type as TypeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, attributeLists As SyntaxNode, type As TypeSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax(kind, errors, annotations, asKeyword, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property AsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax)._asKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetAsKeywordCore() As SyntaxToken
            Return Me.AsKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AsKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsKeyword(asKeyword as SyntaxToken) As SimpleAsClauseSyntax
            return Update(asKeyword, Me.AttributeLists, Me.Type)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRed(_attributeLists, 1)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As SimpleAsClauseSyntax
            return Update(Me.AsKeyword, attributeLists, Me.Type)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As SimpleAsClauseSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' The type-name part of the As clause.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRed(_type, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As SimpleAsClauseSyntax
            return Update(Me.AsKeyword, Me.AttributeLists, type)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_attributeLists, 1)
                Case 2
                    Return Me.Type
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSimpleAsClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSimpleAsClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="asKeyword">
        ''' The value for the AsKeyword property.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        Public Function Update(asKeyword As SyntaxToken, attributeLists As SyntaxList(of AttributeListSyntax), type As TypeSyntax) As SimpleAsClauseSyntax
            If asKeyword <> Me.AsKeyword OrElse attributeLists <> Me.AttributeLists OrElse type IsNot Me.Type Then
                Dim newNode = SyntaxFactory.SimpleAsClause(asKeyword, attributeLists, type)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an "As New {type-name} [arguments] [initializers]" clause in a
    ''' declaration. The type has optional attributes associated with it, although
    ''' attributes are not permitted in many places where this node occurs (they are
    ''' permitted, for example, on automatically implemented properties.)
    ''' </summary>
    Public NotInheritable Class AsNewClauseSyntax
        Inherits AsClauseSyntax

        Friend _newExpression as NewExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AsNewClauseSyntax(kind, errors, annotations, asKeyword, DirectCast(newExpression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NewExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property AsKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AsNewClauseSyntax)._asKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetAsKeywordCore() As SyntaxToken
            Return Me.AsKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AsKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsKeyword(asKeyword as SyntaxToken) As AsNewClauseSyntax
            return Update(asKeyword, Me.NewExpression)
        End Function

        ''' <summary>
        ''' The New expression
        ''' </summary>
        Public  ReadOnly Property NewExpression As NewExpressionSyntax
            Get
                Return GetRed(_newExpression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NewExpression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNewExpression(newExpression as NewExpressionSyntax) As AsNewClauseSyntax
            return Update(Me.AsKeyword, newExpression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._newExpression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.NewExpression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAsNewClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAsNewClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="asKeyword">
        ''' The value for the AsKeyword property.
        ''' </param>
        ''' <param name="newExpression">
        ''' The value for the NewExpression property.
        ''' </param>
        Public Function Update(asKeyword As SyntaxToken, newExpression As NewExpressionSyntax) As AsNewClauseSyntax
            If asKeyword <> Me.AsKeyword OrElse newExpression IsNot Me.NewExpression Then
                Dim newNode = SyntaxFactory.AsNewClause(asKeyword, newExpression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that represents a "With" or "From" clause used to
    ''' initializer an new object.
    ''' </summary>
    Public MustInherit Class ObjectCreationInitializerSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a "With {...} clause used to initialize a new object's members.
    ''' </summary>
    Public NotInheritable Class ObjectMemberInitializerSyntax
        Inherits ObjectCreationInitializerSyntax

        Friend _initializers as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As SyntaxNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectMemberInitializerSyntax(kind, errors, annotations, withKeyword, openBraceToken, if(initializers IsNot Nothing, initializers.Green, Nothing), closeBraceToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "With" keyword.
        ''' </summary>
        Public  ReadOnly Property WithKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectMemberInitializerSyntax)._withKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WithKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithWithKeyword(withKeyword as SyntaxToken) As ObjectMemberInitializerSyntax
            return Update(withKeyword, Me.OpenBraceToken, Me.Initializers, Me.CloseBraceToken)
        End Function

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Public  ReadOnly Property OpenBraceToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectMemberInitializerSyntax)._openBraceToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenBraceToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenBraceToken(openBraceToken as SyntaxToken) As ObjectMemberInitializerSyntax
            return Update(Me.WithKeyword, openBraceToken, Me.Initializers, Me.CloseBraceToken)
        End Function

        ''' <summary>
        ''' The comma-separated list of field initializers.
        ''' </summary>
        Public  ReadOnly Property Initializers As SeparatedSyntaxList(Of FieldInitializerSyntax)
            Get
                Dim listNode = GetRed(_initializers, 2)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of FieldInitializerSyntax)(listNode, Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializers(initializers as SeparatedSyntaxList(Of FieldInitializerSyntax)) As ObjectMemberInitializerSyntax
            return Update(Me.WithKeyword, Me.OpenBraceToken, initializers, Me.CloseBraceToken)
        End Function

        Public Shadows Function AddInitializers(ParamArray items As FieldInitializerSyntax()) As ObjectMemberInitializerSyntax
            Return Me.WithInitializers(Me.Initializers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Public  ReadOnly Property CloseBraceToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectMemberInitializerSyntax)._closeBraceToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseBraceToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseBraceToken(closeBraceToken as SyntaxToken) As ObjectMemberInitializerSyntax
            return Update(Me.WithKeyword, Me.OpenBraceToken, Me.Initializers, closeBraceToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._initializers
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return GetRed(_initializers, 2)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitObjectMemberInitializer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitObjectMemberInitializer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="withKeyword">
        ''' The value for the WithKeyword property.
        ''' </param>
        ''' <param name="openBraceToken">
        ''' The value for the OpenBraceToken property.
        ''' </param>
        ''' <param name="initializers">
        ''' The value for the Initializers property.
        ''' </param>
        ''' <param name="closeBraceToken">
        ''' The value for the CloseBraceToken property.
        ''' </param>
        Public Function Update(withKeyword As SyntaxToken, openBraceToken As SyntaxToken, initializers As SeparatedSyntaxList(Of FieldInitializerSyntax), closeBraceToken As SyntaxToken) As ObjectMemberInitializerSyntax
            If withKeyword <> Me.WithKeyword OrElse openBraceToken <> Me.OpenBraceToken OrElse initializers <> Me.Initializers OrElse closeBraceToken <> Me.CloseBraceToken Then
                Dim newNode = SyntaxFactory.ObjectMemberInitializer(withKeyword, openBraceToken, initializers, closeBraceToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "From {...} clause used to initialize a new collection object's
    ''' elements.
    ''' </summary>
    Public NotInheritable Class ObjectCollectionInitializerSyntax
        Inherits ObjectCreationInitializerSyntax

        Friend _initializer as CollectionInitializerSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectCollectionInitializerSyntax(kind, errors, annotations, fromKeyword, DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CollectionInitializerSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "From" keyword.
        ''' </summary>
        Public  ReadOnly Property FromKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectCollectionInitializerSyntax)._fromKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the FromKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithFromKeyword(fromKeyword as SyntaxToken) As ObjectCollectionInitializerSyntax
            return Update(fromKeyword, Me.Initializer)
        End Function

        ''' <summary>
        ''' The initializer including the braces.
        ''' </summary>
        Public  ReadOnly Property Initializer As CollectionInitializerSyntax
            Get
                Return GetRed(_initializer, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as CollectionInitializerSyntax) As ObjectCollectionInitializerSyntax
            return Update(Me.FromKeyword, initializer)
        End Function

        Public Shadows Function AddInitializerInitializers(ParamArray items As ExpressionSyntax()) As ObjectCollectionInitializerSyntax
            Dim _child = If (Me.Initializer IsNot Nothing, Me.Initializer, SyntaxFactory.CollectionInitializer())
            Return Me.WithInitializer(_child.AddInitializers(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitObjectCollectionInitializer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitObjectCollectionInitializer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="fromKeyword">
        ''' The value for the FromKeyword property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        Public Function Update(fromKeyword As SyntaxToken, initializer As CollectionInitializerSyntax) As ObjectCollectionInitializerSyntax
            If fromKeyword <> Me.FromKeyword OrElse initializer IsNot Me.Initializer Then
                Dim newNode = SyntaxFactory.ObjectCollectionInitializer(fromKeyword, initializer)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Abstract class that represent a single field initializer used in a "With {...}"
    ''' field initializer list.
    ''' </summary>
    Public MustInherit Class FieldInitializerSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The optional "Key" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public ReadOnly Property KeyKeyword As SyntaxToken
            Get
                Return Me.GetKeyKeywordCore()
            End Get
        End Property

        Friend Overridable Function GetKeyKeywordCore() As SyntaxToken
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FieldInitializerSyntax)._keyKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.Position, 0)
                End If
                Return Nothing
        End Function


    End Class

    ''' <summary>
    ''' Represent a field initializer in a With {...} initializer where the field name
    ''' is inferred from the initializer expression.
    ''' </summary>
    Public NotInheritable Class InferredFieldInitializerSyntax
        Inherits FieldInitializerSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InferredFieldInitializerSyntax(kind, errors, annotations, keyKeyword, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The optional "Key" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property KeyKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InferredFieldInitializerSyntax)._keyKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.Position, 0)
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetKeyKeywordCore() As SyntaxToken
            Return Me.KeyKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the KeyKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithKeyKeyword(keyKeyword as SyntaxToken) As InferredFieldInitializerSyntax
            return Update(keyKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The value being assigned.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As InferredFieldInitializerSyntax
            return Update(Me.KeyKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitInferredFieldInitializer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitInferredFieldInitializer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="keyKeyword">
        ''' The value for the KeyKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(keyKeyword As SyntaxToken, expression As ExpressionSyntax) As InferredFieldInitializerSyntax
            If keyKeyword <> Me.KeyKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.InferredFieldInitializer(keyKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represent a named field initializer in a With {...} initializer, such as ".x =
    ''' expr".
    ''' </summary>
    Public NotInheritable Class NamedFieldInitializerSyntax
        Inherits FieldInitializerSyntax

        Friend _name as IdentifierNameSyntax
        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamedFieldInitializerSyntax(kind, errors, annotations, keyKeyword, dotToken, DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IdentifierNameSyntax), equalsToken, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The optional "Key" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property KeyKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamedFieldInitializerSyntax)._keyKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.Position, 0)
                End If
                Return Nothing
            End Get
        End Property

        Friend Overrides Function GetKeyKeywordCore() As SyntaxToken
            Return Me.KeyKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the KeyKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithKeyKeyword(keyKeyword as SyntaxToken) As NamedFieldInitializerSyntax
            return Update(keyKeyword, Me.DotToken, Me.Name, Me.EqualsToken, Me.Expression)
        End Function

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Public  ReadOnly Property DotToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamedFieldInitializerSyntax)._dotToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DotToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDotToken(dotToken as SyntaxToken) As NamedFieldInitializerSyntax
            return Update(Me.KeyKeyword, dotToken, Me.Name, Me.EqualsToken, Me.Expression)
        End Function

        ''' <summary>
        ''' The name of the field being initialized.
        ''' </summary>
        Public  ReadOnly Property Name As IdentifierNameSyntax
            Get
                Return GetRed(_name, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as IdentifierNameSyntax) As NamedFieldInitializerSyntax
            return Update(Me.KeyKeyword, Me.DotToken, name, Me.EqualsToken, Me.Expression)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Public  ReadOnly Property EqualsToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamedFieldInitializerSyntax)._equalsToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EqualsToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEqualsToken(equalsToken as SyntaxToken) As NamedFieldInitializerSyntax
            return Update(Me.KeyKeyword, Me.DotToken, Me.Name, equalsToken, Me.Expression)
        End Function

        ''' <summary>
        ''' The value being assigned to the field.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As NamedFieldInitializerSyntax
            return Update(Me.KeyKeyword, Me.DotToken, Me.Name, Me.EqualsToken, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._name
                Case 4
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.Name
                Case 4
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitNamedFieldInitializer(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitNamedFieldInitializer(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="keyKeyword">
        ''' The value for the KeyKeyword property.
        ''' </param>
        ''' <param name="dotToken">
        ''' The value for the DotToken property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        ''' <param name="equalsToken">
        ''' The value for the EqualsToken property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(keyKeyword As SyntaxToken, dotToken As SyntaxToken, name As IdentifierNameSyntax, equalsToken As SyntaxToken, expression As ExpressionSyntax) As NamedFieldInitializerSyntax
            If keyKeyword <> Me.KeyKeyword OrElse dotToken <> Me.DotToken OrElse name IsNot Me.Name OrElse equalsToken <> Me.EqualsToken OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.NamedFieldInitializer(keyKeyword, dotToken, name, equalsToken, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an "= initializer" clause in a declaration for a variable, parameter
    ''' or automatic property.
    ''' </summary>
    Public NotInheritable Class EqualsValueSyntax
        Inherits VisualBasicSyntaxNode

        Friend _value as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EqualsValueSyntax(kind, errors, annotations, equalsToken, DirectCast(value.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Public  ReadOnly Property EqualsToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EqualsValueSyntax)._equalsToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EqualsToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEqualsToken(equalsToken as SyntaxToken) As EqualsValueSyntax
            return Update(equalsToken, Me.Value)
        End Function

        ''' <summary>
        ''' The expression used as the initial value.
        ''' </summary>
        Public  ReadOnly Property Value As ExpressionSyntax
            Get
                Return GetRed(_value, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Value property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithValue(value as ExpressionSyntax) As EqualsValueSyntax
            return Update(Me.EqualsToken, value)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._value
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Value
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEqualsValue(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEqualsValue(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="equalsToken">
        ''' The value for the EqualsToken property.
        ''' </param>
        ''' <param name="value">
        ''' The value for the Value property.
        ''' </param>
        Public Function Update(equalsToken As SyntaxToken, value As ExpressionSyntax) As EqualsValueSyntax
            If equalsToken <> Me.EqualsToken OrElse value IsNot Me.Value Then
                Dim newNode = SyntaxFactory.EqualsValue(equalsToken, value)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represent a parameter to a method, property, constructor, etc.
    ''' </summary>
    Public NotInheritable Class ParameterSyntax
        Inherits VisualBasicSyntaxNode

        Friend _attributeLists as SyntaxNode
        Friend _identifier as ModifiedIdentifierSyntax
        Friend _asClause as SimpleAsClauseSyntax
        Friend _default as EqualsValueSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), modifiers, DirectCast(identifier.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModifiedIdentifierSyntax), if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) , if([default] IsNot Nothing , DirectCast([default].Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EqualsValueSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this parameter. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As ParameterSyntax
            return Update(attributeLists, Me.Modifiers, Me.Identifier, Me.AsClause, Me.Default)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As ParameterSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of the modifier tokens "ByVal", "ByRef", "Optional" or "ParamArray" that
        ''' modify this parameter.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParameterSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As ParameterSyntax
            return Update(Me.AttributeLists, modifiers, Me.Identifier, Me.AsClause, Me.Default)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As ParameterSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The name of the parameter, including any "?" or "()" modifiers.
        ''' </summary>
        Public  ReadOnly Property Identifier As ModifiedIdentifierSyntax
            Get
                Return GetRed(_identifier, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as ModifiedIdentifierSyntax) As ParameterSyntax
            return Update(Me.AttributeLists, Me.Modifiers, identifier, Me.AsClause, Me.Default)
        End Function

        ''' <summary>
        ''' If present, the "As type-name" clause describing the type of the parameter. If
        ''' no As clause is present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As ParameterSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.Identifier, asClause, Me.Default)
        End Function

        ''' <summary>
        ''' If present, an initializer with the default value of the parameter. If no
        ''' default value is present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property [Default] As EqualsValueSyntax
            Get
                Return GetRed(_default, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the [Default] property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDefault([default] as EqualsValueSyntax) As ParameterSyntax
            return Update(Me.AttributeLists, Me.Modifiers, Me.Identifier, Me.AsClause, [default])
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 2
                    Return Me._identifier
                Case 3
                    Return Me._asClause
                Case 4
                    Return Me._default
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return GetRedAtZero(_attributeLists)
                Case 2
                    Return Me.Identifier
                Case 3
                    Return Me.AsClause
                Case 4
                    Return Me.[Default]
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitParameter(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitParameter(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        ''' <param name="default">
        ''' The value for the Default property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax), modifiers As SyntaxTokenList, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax) As ParameterSyntax
            If attributeLists <> Me.AttributeLists OrElse modifiers <> Me.Modifiers OrElse identifier IsNot Me.Identifier OrElse asClause IsNot Me.AsClause OrElse [default] IsNot Me.[Default] Then
                Dim newNode = SyntaxFactory.Parameter(attributeLists, modifiers, identifier, asClause, [default])
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an identifier with optional "?" or "()" or "(,,,)" modifiers, as
    ''' used in parameter declarations and variable declarations.
    ''' </summary>
    Public NotInheritable Class ModifiedIdentifierSyntax
        Inherits VisualBasicSyntaxNode

        Friend _arrayBounds as ArgumentListSyntax
        Friend _arrayRankSpecifiers as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModifiedIdentifierSyntax(kind, errors, annotations, identifier, nullable, if(arrayBounds IsNot Nothing , DirectCast(arrayBounds.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax), Nothing) , if(arrayRankSpecifiers IsNot Nothing, arrayRankSpecifiers.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The identifier that names the item being declared.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModifiedIdentifierSyntax)._identifier, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As ModifiedIdentifierSyntax
            return Update(identifier, Me.Nullable, Me.ArrayBounds, Me.ArrayRankSpecifiers)
        End Function

        ''' <summary>
        ''' The "?" token that indicates a nullable type.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Nullable As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ModifiedIdentifierSyntax)._nullable
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Nullable property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNullable(nullable as SyntaxToken) As ModifiedIdentifierSyntax
            return Update(Me.Identifier, nullable, Me.ArrayBounds, Me.ArrayRankSpecifiers)
        End Function

        ''' <summary>
        ''' The optional array bounds, such as "(4)" or "(0 to 5, 0 To 6)".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ArrayBounds As ArgumentListSyntax
            Get
                Return GetRed(_arrayBounds, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArrayBounds property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArrayBounds(arrayBounds as ArgumentListSyntax) As ModifiedIdentifierSyntax
            return Update(Me.Identifier, Me.Nullable, arrayBounds, Me.ArrayRankSpecifiers)
        End Function

        Public Shadows Function AddArrayBoundsArguments(ParamArray items As ArgumentSyntax()) As ModifiedIdentifierSyntax
            Dim _child = If (Me.ArrayBounds IsNot Nothing, Me.ArrayBounds, SyntaxFactory.ArgumentList())
            Return Me.WithArrayBounds(_child.AddArguments(items))
        End Function

        ''' <summary>
        ''' A list of array modifiers for the type. If no array modifiers were present, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property ArrayRankSpecifiers As SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Dim listNode = GetRed(_arrayRankSpecifiers, 3)
                Return new SyntaxList(Of ArrayRankSpecifierSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArrayRankSpecifiers property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithArrayRankSpecifiers(arrayRankSpecifiers as SyntaxList(Of ArrayRankSpecifierSyntax)) As ModifiedIdentifierSyntax
            return Update(Me.Identifier, Me.Nullable, Me.ArrayBounds, arrayRankSpecifiers)
        End Function

        Public Shadows Function AddArrayRankSpecifiers(ParamArray items As ArrayRankSpecifierSyntax()) As ModifiedIdentifierSyntax
            Return Me.WithArrayRankSpecifiers(Me.ArrayRankSpecifiers.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._arrayBounds
                Case 3
                    Return Me._arrayRankSpecifiers
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.ArrayBounds
                Case 3
                    Return GetRed(_arrayRankSpecifiers, 3)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitModifiedIdentifier(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitModifiedIdentifier(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="nullable">
        ''' The value for the Nullable property.
        ''' </param>
        ''' <param name="arrayBounds">
        ''' The value for the ArrayBounds property.
        ''' </param>
        ''' <param name="arrayRankSpecifiers">
        ''' The value for the ArrayRankSpecifiers property.
        ''' </param>
        Public Function Update(identifier As SyntaxToken, nullable As SyntaxToken, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As SyntaxList(of ArrayRankSpecifierSyntax)) As ModifiedIdentifierSyntax
            If identifier <> Me.Identifier OrElse nullable <> Me.Nullable OrElse arrayBounds IsNot Me.ArrayBounds OrElse arrayRankSpecifiers <> Me.ArrayRankSpecifiers Then
                Dim newNode = SyntaxFactory.ModifiedIdentifier(identifier, nullable, arrayBounds, arrayRankSpecifiers)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a modifier that describes an array type, without bounds, such as
    ''' "()" or "(,)".
    ''' </summary>
    Public NotInheritable Class ArrayRankSpecifierSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArrayRankSpecifierSyntax(kind, errors, annotations, openParenToken, commaTokens, closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArrayRankSpecifierSyntax)._openParenToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As ArrayRankSpecifierSyntax
            return Update(openParenToken, Me.CommaTokens, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The comma tokens in the array type. There is one less comma than the rank.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property CommaTokens As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArrayRankSpecifierSyntax)._commaTokens
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CommaTokens property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCommaTokens(commaTokens as SyntaxTokenList) As ArrayRankSpecifierSyntax
            return Update(Me.OpenParenToken, commaTokens, Me.CloseParenToken)
        End Function

        Public Shadows Function AddCommaTokens(ParamArray items As SyntaxToken()) As ArrayRankSpecifierSyntax
            Return Me.WithCommaTokens(Me.CommaTokens.AddRange(items))
        End Function

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArrayRankSpecifierSyntax)._closeParenToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As ArrayRankSpecifierSyntax
            return Update(Me.OpenParenToken, Me.CommaTokens, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitArrayRankSpecifier(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitArrayRankSpecifier(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="commaTokens">
        ''' The value for the CommaTokens property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(openParenToken As SyntaxToken, commaTokens As SyntaxTokenList, closeParenToken As SyntaxToken) As ArrayRankSpecifierSyntax
            If openParenToken <> Me.OpenParenToken OrElse commaTokens <> Me.CommaTokens OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.ArrayRankSpecifier(openParenToken, commaTokens, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a group of attributes within "&lt;" and "&gt;" brackets.
    ''' </summary>
    Public NotInheritable Class AttributeListSyntax
        Inherits VisualBasicSyntaxNode

        Friend _attributes as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, attributes As SyntaxNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeListSyntax(kind, errors, annotations, lessThanToken, if(attributes IsNot Nothing, attributes.Green, Nothing), greaterThanToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "&lt;" token.
        ''' </summary>
        Public  ReadOnly Property LessThanToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeListSyntax)._lessThanToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LessThanToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLessThanToken(lessThanToken as SyntaxToken) As AttributeListSyntax
            return Update(lessThanToken, Me.Attributes, Me.GreaterThanToken)
        End Function

        ''' <summary>
        ''' A comma separated list of attribute declarations in this attribute list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Attributes As SeparatedSyntaxList(Of AttributeSyntax)
            Get
                Dim listNode = GetRed(_attributes, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of AttributeSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Attributes property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAttributes(attributes as SeparatedSyntaxList(Of AttributeSyntax)) As AttributeListSyntax
            return Update(Me.LessThanToken, attributes, Me.GreaterThanToken)
        End Function

        Public Shadows Function AddAttributes(ParamArray items As AttributeSyntax()) As AttributeListSyntax
            Return Me.WithAttributes(Me.Attributes.AddRange(items))
        End Function

        ''' <summary>
        ''' The "&gt;" token.
        ''' </summary>
        Public  ReadOnly Property GreaterThanToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeListSyntax)._greaterThanToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the GreaterThanToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithGreaterThanToken(greaterThanToken as SyntaxToken) As AttributeListSyntax
            return Update(Me.LessThanToken, Me.Attributes, greaterThanToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._attributes
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_attributes, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAttributeList(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAttributeList(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="lessThanToken">
        ''' The value for the LessThanToken property.
        ''' </param>
        ''' <param name="attributes">
        ''' The value for the Attributes property.
        ''' </param>
        ''' <param name="greaterThanToken">
        ''' The value for the GreaterThanToken property.
        ''' </param>
        Public Function Update(lessThanToken As SyntaxToken, attributes As SeparatedSyntaxList(Of AttributeSyntax), greaterThanToken As SyntaxToken) As AttributeListSyntax
            If lessThanToken <> Me.LessThanToken OrElse attributes <> Me.Attributes OrElse greaterThanToken <> Me.GreaterThanToken Then
                Dim newNode = SyntaxFactory.AttributeList(lessThanToken, attributes, greaterThanToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single attribute declaration within an attribute list.
    ''' </summary>
    Public NotInheritable Class AttributeSyntax
        Inherits VisualBasicSyntaxNode

        Friend _target as AttributeTargetSyntax
        Friend _name as TypeSyntax
        Friend _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeSyntax(kind, errors, annotations, if(target IsNot Nothing , DirectCast(target.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeTargetSyntax), Nothing) , DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax), if(argumentList IsNot Nothing , DirectCast(argumentList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' Optional attribute target. Assembly|Module :
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Target As AttributeTargetSyntax
            Get
                Return GetRedAtZero(_target)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Target property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithTarget(target as AttributeTargetSyntax) As AttributeSyntax
            return Update(target, Me.Name, Me.ArgumentList)
        End Function

        ''' <summary>
        ''' The name of the attribute.
        ''' </summary>
        Public  ReadOnly Property Name As TypeSyntax
            Get
                Return GetRed(_name, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as TypeSyntax) As AttributeSyntax
            return Update(Me.Target, name, Me.ArgumentList)
        End Function

        ''' <summary>
        ''' The argument list, if present. If no argument list was supplied, Nothing is
        ''' returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ArgumentList As ArgumentListSyntax
            Get
                Return GetRed(_argumentList, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArgumentList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArgumentList(argumentList as ArgumentListSyntax) As AttributeSyntax
            return Update(Me.Target, Me.Name, argumentList)
        End Function

        Public Shadows Function AddArgumentListArguments(ParamArray items As ArgumentSyntax()) As AttributeSyntax
            Dim _child = If (Me.ArgumentList IsNot Nothing, Me.ArgumentList, SyntaxFactory.ArgumentList())
            Return Me.WithArgumentList(_child.AddArguments(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._target
                Case 1
                    Return Me._name
                Case 2
                    Return Me._argumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.Target
                Case 1
                    Return Me.Name
                Case 2
                    Return Me.ArgumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAttribute(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAttribute(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="target">
        ''' The value for the Target property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        ''' <param name="argumentList">
        ''' The value for the ArgumentList property.
        ''' </param>
        Public Function Update(target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax) As AttributeSyntax
            If target IsNot Me.Target OrElse name IsNot Me.Name OrElse argumentList IsNot Me.ArgumentList Then
                Dim newNode = SyntaxFactory.Attribute(target, name, argumentList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single attribute declaration within an attribute list.
    ''' </summary>
    Public NotInheritable Class AttributeTargetSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeTargetSyntax(kind, errors, annotations, attributeModifier, colonToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Assembly" or "Module" attribute modifier, is present. If no attribute
        ''' modifier is present, Nothing is returned.
        ''' </summary>
        Public  ReadOnly Property AttributeModifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeTargetSyntax)._attributeModifier, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeModifier property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeModifier(attributeModifier as SyntaxToken) As AttributeTargetSyntax
            return Update(attributeModifier, Me.ColonToken)
        End Function

        ''' <summary>
        ''' The ":" token, if an attribute modifier is present. If no attribute modifier is
        ''' present, Nothing is returned.
        ''' </summary>
        Public  ReadOnly Property ColonToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributeTargetSyntax)._colonToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ColonToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithColonToken(colonToken as SyntaxToken) As AttributeTargetSyntax
            return Update(Me.AttributeModifier, colonToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAttributeTarget(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAttributeTarget(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeModifier">
        ''' The value for the AttributeModifier property.
        ''' </param>
        ''' <param name="colonToken">
        ''' The value for the ColonToken property.
        ''' </param>
        Public Function Update(attributeModifier As SyntaxToken, colonToken As SyntaxToken) As AttributeTargetSyntax
            If attributeModifier <> Me.AttributeModifier OrElse colonToken <> Me.ColonToken Then
                Dim newNode = SyntaxFactory.AttributeTarget(attributeModifier, colonToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a file-level attribute, in which the attributes have no other
    ''' syntactic element they are attached to.
    ''' </summary>
    Public NotInheritable Class AttributesStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend _attributeLists as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AttributesStatementSyntax(kind, errors, annotations, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The list of attribute lists.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRedAtZero(_attributeLists)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As AttributesStatementSyntax
            return Update(attributeLists)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As AttributesStatementSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me._attributeLists
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            If i = 0 Then
               Return GetRedAtZero(_attributeLists)
            Else
                Return Nothing
            End If
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAttributesStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAttributesStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        Public Function Update(attributeLists As SyntaxList(of AttributeListSyntax)) As AttributesStatementSyntax
            If attributeLists <> Me.AttributeLists Then
                Dim newNode = SyntaxFactory.AttributesStatement(attributeLists)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represent an expression in a statement context. This may only be a invocation
    ''' or await expression in standard code but may be any expression in VB
    ''' Interactive code.
    ''' </summary>
    Public NotInheritable Class ExpressionStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionStatementSyntax(kind, errors, annotations, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The expression.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRedAtZero(_expression)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As ExpressionStatementSyntax
            return Update(expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me._expression
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me.Expression
            Else
                Return Nothing
            End If
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitExpressionStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitExpressionStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(expression As ExpressionSyntax) As ExpressionStatementSyntax
            If expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.ExpressionStatement(expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represent a "? expression" "Print" statement in VB Interactive code.
    ''' </summary>
    Public NotInheritable Class PrintStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PrintStatementSyntax(kind, errors, annotations, questionToken, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' "?" token.
        ''' </summary>
        Public  ReadOnly Property QuestionToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.PrintStatementSyntax)._questionToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the QuestionToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithQuestionToken(questionToken as SyntaxToken) As PrintStatementSyntax
            return Update(questionToken, Me.Expression)
        End Function

        ''' <summary>
        ''' The expression whose value is being output.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As PrintStatementSyntax
            return Update(Me.QuestionToken, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitPrintStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitPrintStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="questionToken">
        ''' The value for the QuestionToken property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(questionToken As SyntaxToken, expression As ExpressionSyntax) As PrintStatementSyntax
            If questionToken <> Me.QuestionToken OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.PrintStatement(questionToken, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a While...End While statement, including the While, body and End
    ''' While.
    ''' </summary>
    Public NotInheritable Class WhileBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _whileStatement as WhileStatementSyntax
        Friend _statements as SyntaxNode
        Friend _endWhileStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileStatement As WhileStatementSyntax, statements As SyntaxNode, endWhileStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileBlockSyntax(kind, errors, annotations, DirectCast(whileStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endWhileStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The While statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property WhileStatement As WhileStatementSyntax
            Get
                Return GetRedAtZero(_whileStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhileStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithWhileStatement(whileStatement as WhileStatementSyntax) As WhileBlockSyntax
            return Update(whileStatement, Me.Statements, Me.EndWhileStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the While...End While. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As WhileBlockSyntax
            return Update(Me.WhileStatement, statements, Me.EndWhileStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As WhileBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The End While statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndWhileStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endWhileStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndWhileStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndWhileStatement(endWhileStatement as EndBlockStatementSyntax) As WhileBlockSyntax
            return Update(Me.WhileStatement, Me.Statements, endWhileStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._whileStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endWhileStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.WhileStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndWhileStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWhileBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWhileBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="whileStatement">
        ''' The value for the WhileStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endWhileStatement">
        ''' The value for the EndWhileStatement property.
        ''' </param>
        Public Function Update(whileStatement As WhileStatementSyntax, statements As SyntaxList(of StatementSyntax), endWhileStatement As EndBlockStatementSyntax) As WhileBlockSyntax
            If whileStatement IsNot Me.WhileStatement OrElse statements <> Me.Statements OrElse endWhileStatement IsNot Me.EndWhileStatement Then
                Dim newNode = SyntaxFactory.WhileBlock(whileStatement, statements, endWhileStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an entire Using...End Using statement, including the Using, body and
    ''' End Using statements.
    ''' </summary>
    Public NotInheritable Class UsingBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _usingStatement as UsingStatementSyntax
        Friend _statements as SyntaxNode
        Friend _endUsingStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), usingStatement As UsingStatementSyntax, statements As SyntaxNode, endUsingStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.UsingBlockSyntax(kind, errors, annotations, DirectCast(usingStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.UsingStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endUsingStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The UsingStatement that begins the Using...End Using block.
        ''' </summary>
        Public  ReadOnly Property UsingStatement As UsingStatementSyntax
            Get
                Return GetRedAtZero(_usingStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the UsingStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithUsingStatement(usingStatement as UsingStatementSyntax) As UsingBlockSyntax
            return Update(usingStatement, Me.Statements, Me.EndUsingStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the Using...End Using block. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As UsingBlockSyntax
            return Update(Me.UsingStatement, statements, Me.EndUsingStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As UsingBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The End Using statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndUsingStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endUsingStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndUsingStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndUsingStatement(endUsingStatement as EndBlockStatementSyntax) As UsingBlockSyntax
            return Update(Me.UsingStatement, Me.Statements, endUsingStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._usingStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endUsingStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.UsingStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndUsingStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitUsingBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitUsingBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="usingStatement">
        ''' The value for the UsingStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endUsingStatement">
        ''' The value for the EndUsingStatement property.
        ''' </param>
        Public Function Update(usingStatement As UsingStatementSyntax, statements As SyntaxList(of StatementSyntax), endUsingStatement As EndBlockStatementSyntax) As UsingBlockSyntax
            If usingStatement IsNot Me.UsingStatement OrElse statements <> Me.Statements OrElse endUsingStatement IsNot Me.EndUsingStatement Then
                Dim newNode = SyntaxFactory.UsingBlock(usingStatement, statements, endUsingStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a entire SyncLock...End SyncLock block, including the SyncLock
    ''' statement, the enclosed statements, and the End SyncLock statement.
    ''' </summary>
    Public NotInheritable Class SyncLockBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _syncLockStatement as SyncLockStatementSyntax
        Friend _statements as SyntaxNode
        Friend _endSyncLockStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), syncLockStatement As SyncLockStatementSyntax, statements As SyntaxNode, endSyncLockStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SyncLockBlockSyntax(kind, errors, annotations, DirectCast(syncLockStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SyncLockStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endSyncLockStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The SyncLock statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property SyncLockStatement As SyncLockStatementSyntax
            Get
                Return GetRedAtZero(_syncLockStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SyncLockStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSyncLockStatement(syncLockStatement as SyncLockStatementSyntax) As SyncLockBlockSyntax
            return Update(syncLockStatement, Me.Statements, Me.EndSyncLockStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the SyncLock...End SyncLock statement. This might
        ''' be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As SyncLockBlockSyntax
            return Update(Me.SyncLockStatement, statements, Me.EndSyncLockStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As SyncLockBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The End SyncLock statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndSyncLockStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endSyncLockStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndSyncLockStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndSyncLockStatement(endSyncLockStatement as EndBlockStatementSyntax) As SyncLockBlockSyntax
            return Update(Me.SyncLockStatement, Me.Statements, endSyncLockStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._syncLockStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSyncLockStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.SyncLockStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndSyncLockStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSyncLockBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSyncLockBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="syncLockStatement">
        ''' The value for the SyncLockStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endSyncLockStatement">
        ''' The value for the EndSyncLockStatement property.
        ''' </param>
        Public Function Update(syncLockStatement As SyncLockStatementSyntax, statements As SyntaxList(of StatementSyntax), endSyncLockStatement As EndBlockStatementSyntax) As SyncLockBlockSyntax
            If syncLockStatement IsNot Me.SyncLockStatement OrElse statements <> Me.Statements OrElse endSyncLockStatement IsNot Me.EndSyncLockStatement Then
                Dim newNode = SyntaxFactory.SyncLockBlock(syncLockStatement, statements, endSyncLockStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a With...End With block, include the With statement, the body of the
    ''' block and the End With statement.
    ''' </summary>
    Public NotInheritable Class WithBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _withStatement as WithStatementSyntax
        Friend _statements as SyntaxNode
        Friend _endWithStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withStatement As WithStatementSyntax, statements As SyntaxNode, endWithStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithBlockSyntax(kind, errors, annotations, DirectCast(withStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(endWithStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The WithStatement that begins the With...End With block.
        ''' </summary>
        Public  ReadOnly Property WithStatement As WithStatementSyntax
            Get
                Return GetRedAtZero(_withStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WithStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithWithStatement(withStatement as WithStatementSyntax) As WithBlockSyntax
            return Update(withStatement, Me.Statements, Me.EndWithStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the With...End With block. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As WithBlockSyntax
            return Update(Me.WithStatement, statements, Me.EndWithStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As WithBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The End With statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndWithStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endWithStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndWithStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndWithStatement(endWithStatement as EndBlockStatementSyntax) As WithBlockSyntax
            return Update(Me.WithStatement, Me.Statements, endWithStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._withStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endWithStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.WithStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.EndWithStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWithBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWithBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="withStatement">
        ''' The value for the WithStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="endWithStatement">
        ''' The value for the EndWithStatement property.
        ''' </param>
        Public Function Update(withStatement As WithStatementSyntax, statements As SyntaxList(of StatementSyntax), endWithStatement As EndBlockStatementSyntax) As WithBlockSyntax
            If withStatement IsNot Me.WithStatement OrElse statements <> Me.Statements OrElse endWithStatement IsNot Me.EndWithStatement Then
                Dim newNode = SyntaxFactory.WithBlock(withStatement, statements, endWithStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the declaration of one or more local variables or constants.
    ''' </summary>
    Public NotInheritable Class LocalDeclarationStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _declarators as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), modifiers As GreenNode, declarators As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LocalDeclarationStatementSyntax(kind, errors, annotations, modifiers, if(declarators IsNot Nothing, declarators.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The modifier token (Static, Dim or Const) that introduces this local variable
        ''' declaration.
        ''' </summary>
        Public  ReadOnly Property Modifiers As SyntaxTokenList
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LocalDeclarationStatementSyntax)._modifiers
                If slot IsNot Nothing
                    return new SyntaxTokenList(Me, slot, Me.Position, 0)
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Modifiers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithModifiers(modifiers as SyntaxTokenList) As LocalDeclarationStatementSyntax
            return Update(modifiers, Me.Declarators)
        End Function

        Public Shadows Function AddModifiers(ParamArray items As SyntaxToken()) As LocalDeclarationStatementSyntax
            Return Me.WithModifiers(Me.Modifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The list of variable declarator. Each declarator specifies one or more variable
        ''' names along with a type and/or initializer.
        ''' </summary>
        Public  ReadOnly Property Declarators As SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Dim listNode = GetRed(_declarators, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of VariableDeclaratorSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Declarators property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDeclarators(declarators as SeparatedSyntaxList(Of VariableDeclaratorSyntax)) As LocalDeclarationStatementSyntax
            return Update(Me.Modifiers, declarators)
        End Function

        Public Shadows Function AddDeclarators(ParamArray items As VariableDeclaratorSyntax()) As LocalDeclarationStatementSyntax
            Return Me.WithDeclarators(Me.Declarators.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._declarators
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_declarators, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitLocalDeclarationStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitLocalDeclarationStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="modifiers">
        ''' The value for the Modifiers property.
        ''' </param>
        ''' <param name="declarators">
        ''' The value for the Declarators property.
        ''' </param>
        Public Function Update(modifiers As SyntaxTokenList, declarators As SeparatedSyntaxList(Of VariableDeclaratorSyntax)) As LocalDeclarationStatementSyntax
            If modifiers <> Me.Modifiers OrElse declarators <> Me.Declarators Then
                Dim newNode = SyntaxFactory.LocalDeclarationStatement(modifiers, declarators)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a label statement.
    ''' </summary>
    Public NotInheritable Class LabelStatementSyntax
        Inherits ExecutableStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelStatementSyntax(kind, errors, annotations, labelToken, colonToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The name of the label. If the label is a line number, returns an IntegerLiteral
        ''' that is the line number, otherwise, returns an Identifier.
        ''' </summary>
        Public  ReadOnly Property LabelToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelStatementSyntax)._labelToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LabelToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLabelToken(labelToken as SyntaxToken) As LabelStatementSyntax
            return Update(labelToken, Me.ColonToken)
        End Function

        ''' <summary>
        ''' The ":" token of the label statement.
        ''' </summary>
        Public  ReadOnly Property ColonToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelStatementSyntax)._colonToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ColonToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithColonToken(colonToken as SyntaxToken) As LabelStatementSyntax
            return Update(Me.LabelToken, colonToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitLabelStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitLabelStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="labelToken">
        ''' The value for the LabelToken property.
        ''' </param>
        ''' <param name="colonToken">
        ''' The value for the ColonToken property.
        ''' </param>
        Public Function Update(labelToken As SyntaxToken, colonToken As SyntaxToken) As LabelStatementSyntax
            If labelToken <> Me.LabelToken OrElse colonToken <> Me.ColonToken Then
                Dim newNode = SyntaxFactory.LabelStatement(labelToken, colonToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "GoTo" statement.
    ''' </summary>
    Public NotInheritable Class GoToStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _label as LabelSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GoToStatementSyntax(kind, errors, annotations, goToKeyword, DirectCast(label.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "GoTo" keyword.
        ''' </summary>
        Public  ReadOnly Property GoToKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GoToStatementSyntax)._goToKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the GoToKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithGoToKeyword(goToKeyword as SyntaxToken) As GoToStatementSyntax
            return Update(goToKeyword, Me.Label)
        End Function

        ''' <summary>
        ''' The name of the label. If the label is a line number, wraps an IntegerLiteral
        ''' that is the line number, otherwise, wraps an Identifier.
        ''' </summary>
        Public  ReadOnly Property Label As LabelSyntax
            Get
                Return GetRed(_label, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Label property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithLabel(label as LabelSyntax) As GoToStatementSyntax
            return Update(Me.GoToKeyword, label)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._label
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Label
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitGoToStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitGoToStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="goToKeyword">
        ''' The value for the GoToKeyword property.
        ''' </param>
        ''' <param name="label">
        ''' The value for the Label property.
        ''' </param>
        Public Function Update(goToKeyword As SyntaxToken, label As LabelSyntax) As GoToStatementSyntax
            If goToKeyword <> Me.GoToKeyword OrElse label IsNot Me.Label Then
                Dim newNode = SyntaxFactory.GoToStatement(goToKeyword, label)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' A label for a GoTo, Resume, or On Error statement. An identifier, line number,
    ''' or next keyword.
    ''' </summary>
    Public NotInheritable Class LabelSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), labelToken As InternalSyntax.SyntaxToken)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelSyntax(kind, errors, annotations, labelToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The label name (identifier), line number (integer literal), or next keyword
        ''' token.
        ''' </summary>
        Public  ReadOnly Property LabelToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelSyntax)._labelToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LabelToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLabelToken(labelToken as SyntaxToken) As LabelSyntax
            return Update(Me.Kind, labelToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitLabel(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitLabel(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="labelToken">
        ''' The value for the LabelToken property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, labelToken As SyntaxToken) As LabelSyntax
            If kind <> Me.Kind OrElse labelToken <> Me.LabelToken Then
                Dim newNode = SyntaxFactory.Label(kind, labelToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Stop" or "End" statement. The Kind can be used to determine which
    ''' kind of statement this is.
    ''' </summary>
    Public NotInheritable Class StopOrEndStatementSyntax
        Inherits ExecutableStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), stopOrEndKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StopOrEndStatementSyntax(kind, errors, annotations, stopOrEndKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Stop" or "End" keyword.
        ''' </summary>
        Public  ReadOnly Property StopOrEndKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.StopOrEndStatementSyntax)._stopOrEndKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the StopOrEndKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithStopOrEndKeyword(stopOrEndKeyword as SyntaxToken) As StopOrEndStatementSyntax
            return Update(Me.Kind, stopOrEndKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitStopOrEndStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitStopOrEndStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="stopOrEndKeyword">
        ''' The value for the StopOrEndKeyword property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, stopOrEndKeyword As SyntaxToken) As StopOrEndStatementSyntax
            If kind <> Me.Kind OrElse stopOrEndKeyword <> Me.StopOrEndKeyword Then
                Dim newNode = SyntaxFactory.StopOrEndStatement(kind, stopOrEndKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' An exit statement. The kind of block being exited can be found by examining the
    ''' Kind.
    ''' </summary>
    Public NotInheritable Class ExitStatementSyntax
        Inherits ExecutableStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExitStatementSyntax(kind, errors, annotations, exitKeyword, blockKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Exit" keyword.
        ''' </summary>
        Public  ReadOnly Property ExitKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExitStatementSyntax)._exitKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ExitKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExitKeyword(exitKeyword as SyntaxToken) As ExitStatementSyntax
            return Update(Me.Kind, exitKeyword, Me.BlockKeyword)
        End Function

        ''' <summary>
        ''' The keyword describing the block to exit.
        ''' </summary>
        Public  ReadOnly Property BlockKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExitStatementSyntax)._blockKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the BlockKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithBlockKeyword(blockKeyword as SyntaxToken) As ExitStatementSyntax
            return Update(Me.Kind, Me.ExitKeyword, blockKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitExitStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitExitStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="exitKeyword">
        ''' The value for the ExitKeyword property.
        ''' </param>
        ''' <param name="blockKeyword">
        ''' The value for the BlockKeyword property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, exitKeyword As SyntaxToken, blockKeyword As SyntaxToken) As ExitStatementSyntax
            If kind <> Me.Kind OrElse exitKeyword <> Me.ExitKeyword OrElse blockKeyword <> Me.BlockKeyword Then
                Dim newNode = SyntaxFactory.ExitStatement(kind, exitKeyword, blockKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Continue (block)" statement. THe kind of block referenced can be
    ''' determined by examining the Kind.
    ''' </summary>
    Public NotInheritable Class ContinueStatementSyntax
        Inherits ExecutableStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ContinueStatementSyntax(kind, errors, annotations, continueKeyword, blockKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Continue" keyword.
        ''' </summary>
        Public  ReadOnly Property ContinueKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ContinueStatementSyntax)._continueKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ContinueKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithContinueKeyword(continueKeyword as SyntaxToken) As ContinueStatementSyntax
            return Update(Me.Kind, continueKeyword, Me.BlockKeyword)
        End Function

        ''' <summary>
        ''' The "Do", "For" or "While" keyword that identifies the kind of loop being
        ''' continued.
        ''' </summary>
        Public  ReadOnly Property BlockKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ContinueStatementSyntax)._blockKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the BlockKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithBlockKeyword(blockKeyword as SyntaxToken) As ContinueStatementSyntax
            return Update(Me.Kind, Me.ContinueKeyword, blockKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitContinueStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitContinueStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="continueKeyword">
        ''' The value for the ContinueKeyword property.
        ''' </param>
        ''' <param name="blockKeyword">
        ''' The value for the BlockKeyword property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, continueKeyword As SyntaxToken, blockKeyword As SyntaxToken) As ContinueStatementSyntax
            If kind <> Me.Kind OrElse continueKeyword <> Me.ContinueKeyword OrElse blockKeyword <> Me.BlockKeyword Then
                Dim newNode = SyntaxFactory.ContinueStatement(kind, continueKeyword, blockKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Return" statement.
    ''' </summary>
    Public NotInheritable Class ReturnStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ReturnStatementSyntax(kind, errors, annotations, returnKeyword, if(expression IsNot Nothing , DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Return" keyword.
        ''' </summary>
        Public  ReadOnly Property ReturnKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ReturnStatementSyntax)._returnKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ReturnKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithReturnKeyword(returnKeyword as SyntaxToken) As ReturnStatementSyntax
            return Update(returnKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The expression being returned, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As ReturnStatementSyntax
            return Update(Me.ReturnKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitReturnStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitReturnStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="returnKeyword">
        ''' The value for the ReturnKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(returnKeyword As SyntaxToken, expression As ExpressionSyntax) As ReturnStatementSyntax
            If returnKeyword <> Me.ReturnKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.ReturnStatement(returnKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single-line "If ... Then ... Else ..." statement.
    ''' </summary>
    Public NotInheritable Class SingleLineIfStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _condition as ExpressionSyntax
        Friend _statements as SyntaxNode
        Friend _elseClause as SingleLineElseClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As SyntaxNode, elseClause As SingleLineElseClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SingleLineIfStatementSyntax(kind, errors, annotations, ifKeyword, DirectCast(condition.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), thenKeyword, if(statements IsNot Nothing, statements.Green, Nothing), if(elseClause IsNot Nothing , DirectCast(elseClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SingleLineElseClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "If" keyword.
        ''' </summary>
        Public  ReadOnly Property IfKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SingleLineIfStatementSyntax)._ifKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the IfKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIfKeyword(ifKeyword as SyntaxToken) As SingleLineIfStatementSyntax
            return Update(ifKeyword, Me.Condition, Me.ThenKeyword, Me.Statements, Me.ElseClause)
        End Function

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Public  ReadOnly Property Condition As ExpressionSyntax
            Get
                Return GetRed(_condition, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Condition property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCondition(condition as ExpressionSyntax) As SingleLineIfStatementSyntax
            return Update(Me.IfKeyword, condition, Me.ThenKeyword, Me.Statements, Me.ElseClause)
        End Function

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        Public  ReadOnly Property ThenKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SingleLineIfStatementSyntax)._thenKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ThenKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithThenKeyword(thenKeyword as SyntaxToken) As SingleLineIfStatementSyntax
            return Update(Me.IfKeyword, Me.Condition, thenKeyword, Me.Statements, Me.ElseClause)
        End Function

        ''' <summary>
        ''' A list of statements to be executed if the condition expression evaluates as
        ''' true. Multiple statements must be separated by colons.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 3)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As SingleLineIfStatementSyntax
            return Update(Me.IfKeyword, Me.Condition, Me.ThenKeyword, statements, Me.ElseClause)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As SingleLineIfStatementSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' An "Else" clause to be executed if the condition expression evaluates as false.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ElseClause As SingleLineElseClauseSyntax
            Get
                Return GetRed(_elseClause, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseClause(elseClause as SingleLineElseClauseSyntax) As SingleLineIfStatementSyntax
            return Update(Me.IfKeyword, Me.Condition, Me.ThenKeyword, Me.Statements, elseClause)
        End Function

        Public Shadows Function AddElseClauseStatements(ParamArray items As StatementSyntax()) As SingleLineIfStatementSyntax
            Dim _child = If (Me.ElseClause IsNot Nothing, Me.ElseClause, SyntaxFactory.SingleLineElseClause())
            Return Me.WithElseClause(_child.AddStatements(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._condition
                Case 3
                    Return Me._statements
                Case 4
                    Return Me._elseClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Condition
                Case 3
                    Return GetRed(_statements, 3)
                Case 4
                    Return Me.ElseClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSingleLineIfStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSingleLineIfStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="ifKeyword">
        ''' The value for the IfKeyword property.
        ''' </param>
        ''' <param name="condition">
        ''' The value for the Condition property.
        ''' </param>
        ''' <param name="thenKeyword">
        ''' The value for the ThenKeyword property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="elseClause">
        ''' The value for the ElseClause property.
        ''' </param>
        Public Function Update(ifKeyword As SyntaxToken, condition As ExpressionSyntax, thenKeyword As SyntaxToken, statements As SyntaxList(of StatementSyntax), elseClause As SingleLineElseClauseSyntax) As SingleLineIfStatementSyntax
            If ifKeyword <> Me.IfKeyword OrElse condition IsNot Me.Condition OrElse thenKeyword <> Me.ThenKeyword OrElse statements <> Me.Statements OrElse elseClause IsNot Me.ElseClause Then
                Dim newNode = SyntaxFactory.SingleLineIfStatement(ifKeyword, condition, thenKeyword, statements, elseClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Else ..." clause of a single-line "If" statement.
    ''' </summary>
    Public NotInheritable Class SingleLineElseClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax, statements As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SingleLineElseClauseSyntax(kind, errors, annotations, elseKeyword, if(statements IsNot Nothing, statements.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Public  ReadOnly Property ElseKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SingleLineElseClauseSyntax)._elseKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseKeyword(elseKeyword as SyntaxToken) As SingleLineElseClauseSyntax
            return Update(elseKeyword, Me.Statements)
        End Function

        ''' <summary>
        ''' A list of statements to be executed. Multiple statements must be separated by
        ''' colons.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As SingleLineElseClauseSyntax
            return Update(Me.ElseKeyword, statements)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As SingleLineElseClauseSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._statements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_statements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSingleLineElseClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSingleLineElseClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="elseKeyword">
        ''' The value for the ElseKeyword property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        Public Function Update(elseKeyword As SyntaxToken, statements As SyntaxList(of StatementSyntax)) As SingleLineElseClauseSyntax
            If elseKeyword <> Me.ElseKeyword OrElse statements <> Me.Statements Then
                Dim newNode = SyntaxFactory.SingleLineElseClause(elseKeyword, statements)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a multi-line "If ... Then ... ElseIf ... Then ... Else ... End If"
    ''' block.
    ''' </summary>
    Public NotInheritable Class MultiLineIfBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _ifStatement as IfStatementSyntax
        Friend _statements as SyntaxNode
        Friend _elseIfBlocks as SyntaxNode
        Friend _elseBlock as ElseBlockSyntax
        Friend _endIfStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifStatement As IfStatementSyntax, statements As SyntaxNode, elseIfBlocks As SyntaxNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MultiLineIfBlockSyntax(kind, errors, annotations, DirectCast(ifStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IfStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), if(elseIfBlocks IsNot Nothing, elseIfBlocks.Green, Nothing), if(elseBlock IsNot Nothing , DirectCast(elseBlock.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseBlockSyntax), Nothing) , DirectCast(endIfStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "If" statement that begins the "If" block.
        ''' </summary>
        Public  ReadOnly Property IfStatement As IfStatementSyntax
            Get
                Return GetRedAtZero(_ifStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the IfStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIfStatement(ifStatement as IfStatementSyntax) As MultiLineIfBlockSyntax
            return Update(ifStatement, Me.Statements, Me.ElseIfBlocks, Me.ElseBlock, Me.EndIfStatement)
        End Function

        ''' <summary>
        ''' A list of statements to be executed if the condition expression evaluates as
        ''' true.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As MultiLineIfBlockSyntax
            return Update(Me.IfStatement, statements, Me.ElseIfBlocks, Me.ElseBlock, Me.EndIfStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As MultiLineIfBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of "ElseIf" blocks to be evaluated, in order, if the condition
        ''' expression of the "If" statement evaluates as false.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property ElseIfBlocks As SyntaxList(Of ElseIfBlockSyntax)
            Get
                Dim listNode = GetRed(_elseIfBlocks, 2)
                Return new SyntaxList(Of ElseIfBlockSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseIfBlocks property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseIfBlocks(elseIfBlocks as SyntaxList(Of ElseIfBlockSyntax)) As MultiLineIfBlockSyntax
            return Update(Me.IfStatement, Me.Statements, elseIfBlocks, Me.ElseBlock, Me.EndIfStatement)
        End Function

        Public Shadows Function AddElseIfBlocks(ParamArray items As ElseIfBlockSyntax()) As MultiLineIfBlockSyntax
            Return Me.WithElseIfBlocks(Me.ElseIfBlocks.AddRange(items))
        End Function

        ''' <summary>
        ''' An "Else" block to be executed if the condition expression of the "If"
        ''' statement and all "ElseIf" blocks evaluate as false.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ElseBlock As ElseBlockSyntax
            Get
                Return GetRed(_elseBlock, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseBlock property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseBlock(elseBlock as ElseBlockSyntax) As MultiLineIfBlockSyntax
            return Update(Me.IfStatement, Me.Statements, Me.ElseIfBlocks, elseBlock, Me.EndIfStatement)
        End Function

        Public Shadows Function AddElseBlockStatements(ParamArray items As StatementSyntax()) As MultiLineIfBlockSyntax
            Dim _child = If (Me.ElseBlock IsNot Nothing, Me.ElseBlock, SyntaxFactory.ElseBlock())
            Return Me.WithElseBlock(_child.AddStatements(items))
        End Function

        ''' <summary>
        ''' Then "End If" statement.
        ''' </summary>
        Public  ReadOnly Property EndIfStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endIfStatement, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndIfStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndIfStatement(endIfStatement as EndBlockStatementSyntax) As MultiLineIfBlockSyntax
            return Update(Me.IfStatement, Me.Statements, Me.ElseIfBlocks, Me.ElseBlock, endIfStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._ifStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._elseIfBlocks
                Case 3
                    Return Me._elseBlock
                Case 4
                    Return Me._endIfStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.IfStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return GetRed(_elseIfBlocks, 2)
                Case 3
                    Return Me.ElseBlock
                Case 4
                    Return Me.EndIfStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMultiLineIfBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMultiLineIfBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="ifStatement">
        ''' The value for the IfStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="elseIfBlocks">
        ''' The value for the ElseIfBlocks property.
        ''' </param>
        ''' <param name="elseBlock">
        ''' The value for the ElseBlock property.
        ''' </param>
        ''' <param name="endIfStatement">
        ''' The value for the EndIfStatement property.
        ''' </param>
        Public Function Update(ifStatement As IfStatementSyntax, statements As SyntaxList(of StatementSyntax), elseIfBlocks As SyntaxList(of ElseIfBlockSyntax), elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax) As MultiLineIfBlockSyntax
            If ifStatement IsNot Me.IfStatement OrElse statements <> Me.Statements OrElse elseIfBlocks <> Me.ElseIfBlocks OrElse elseBlock IsNot Me.ElseBlock OrElse endIfStatement IsNot Me.EndIfStatement Then
                Dim newNode = SyntaxFactory.MultiLineIfBlock(ifStatement, statements, elseIfBlocks, elseBlock, endIfStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "If ... Then" statement that begins a multi-line "If" block.
    ''' </summary>
    Public NotInheritable Class IfStatementSyntax
        Inherits StatementSyntax

        Friend _condition as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IfStatementSyntax(kind, errors, annotations, ifKeyword, DirectCast(condition.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), thenKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "If" keyword.
        ''' </summary>
        Public  ReadOnly Property IfKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IfStatementSyntax)._ifKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the IfKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIfKeyword(ifKeyword as SyntaxToken) As IfStatementSyntax
            return Update(ifKeyword, Me.Condition, Me.ThenKeyword)
        End Function

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Public  ReadOnly Property Condition As ExpressionSyntax
            Get
                Return GetRed(_condition, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Condition property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCondition(condition as ExpressionSyntax) As IfStatementSyntax
            return Update(Me.IfKeyword, condition, Me.ThenKeyword)
        End Function

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ThenKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IfStatementSyntax)._thenKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(2), Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ThenKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithThenKeyword(thenKeyword as SyntaxToken) As IfStatementSyntax
            return Update(Me.IfKeyword, Me.Condition, thenKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitIfStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitIfStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="ifKeyword">
        ''' The value for the IfKeyword property.
        ''' </param>
        ''' <param name="condition">
        ''' The value for the Condition property.
        ''' </param>
        ''' <param name="thenKeyword">
        ''' The value for the ThenKeyword property.
        ''' </param>
        Public Function Update(ifKeyword As SyntaxToken, condition As ExpressionSyntax, thenKeyword As SyntaxToken) As IfStatementSyntax
            If ifKeyword <> Me.IfKeyword OrElse condition IsNot Me.Condition OrElse thenKeyword <> Me.ThenKeyword Then
                Dim newNode = SyntaxFactory.IfStatement(ifKeyword, condition, thenKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an "ElseIf ... Then ..." block.
    ''' </summary>
    Public NotInheritable Class ElseIfBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend _elseIfStatement as ElseIfStatementSyntax
        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseIfStatement As ElseIfStatementSyntax, statements As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseIfBlockSyntax(kind, errors, annotations, DirectCast(elseIfStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseIfStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "ElseIf ... Then" statement the begins the "ElseIf" block.
        ''' </summary>
        Public  ReadOnly Property ElseIfStatement As ElseIfStatementSyntax
            Get
                Return GetRedAtZero(_elseIfStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseIfStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithElseIfStatement(elseIfStatement as ElseIfStatementSyntax) As ElseIfBlockSyntax
            return Update(elseIfStatement, Me.Statements)
        End Function

        ''' <summary>
        ''' A list of statements to be executed if the condition expression of the "ElseIf"
        ''' statement evaluates as true.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As ElseIfBlockSyntax
            return Update(Me.ElseIfStatement, statements)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As ElseIfBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._elseIfStatement
                Case 1
                    Return Me._statements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.ElseIfStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitElseIfBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitElseIfBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="elseIfStatement">
        ''' The value for the ElseIfStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        Public Function Update(elseIfStatement As ElseIfStatementSyntax, statements As SyntaxList(of StatementSyntax)) As ElseIfBlockSyntax
            If elseIfStatement IsNot Me.ElseIfStatement OrElse statements <> Me.Statements Then
                Dim newNode = SyntaxFactory.ElseIfBlock(elseIfStatement, statements)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "ElseIf ... Then" statement that begins an "ElseIf" block.
    ''' </summary>
    Public NotInheritable Class ElseIfStatementSyntax
        Inherits StatementSyntax

        Friend _condition as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseIfStatementSyntax(kind, errors, annotations, elseIfKeyword, DirectCast(condition.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), thenKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "ElseIf" keyword.
        ''' </summary>
        Public  ReadOnly Property ElseIfKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseIfStatementSyntax)._elseIfKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseIfKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseIfKeyword(elseIfKeyword as SyntaxToken) As ElseIfStatementSyntax
            return Update(elseIfKeyword, Me.Condition, Me.ThenKeyword)
        End Function

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Public  ReadOnly Property Condition As ExpressionSyntax
            Get
                Return GetRed(_condition, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Condition property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCondition(condition as ExpressionSyntax) As ElseIfStatementSyntax
            return Update(Me.ElseIfKeyword, condition, Me.ThenKeyword)
        End Function

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ThenKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseIfStatementSyntax)._thenKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(2), Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ThenKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithThenKeyword(thenKeyword as SyntaxToken) As ElseIfStatementSyntax
            return Update(Me.ElseIfKeyword, Me.Condition, thenKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitElseIfStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitElseIfStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="elseIfKeyword">
        ''' The value for the ElseIfKeyword property.
        ''' </param>
        ''' <param name="condition">
        ''' The value for the Condition property.
        ''' </param>
        ''' <param name="thenKeyword">
        ''' The value for the ThenKeyword property.
        ''' </param>
        Public Function Update(elseIfKeyword As SyntaxToken, condition As ExpressionSyntax, thenKeyword As SyntaxToken) As ElseIfStatementSyntax
            If elseIfKeyword <> Me.ElseIfKeyword OrElse condition IsNot Me.Condition OrElse thenKeyword <> Me.ThenKeyword Then
                Dim newNode = SyntaxFactory.ElseIfStatement(elseIfKeyword, condition, thenKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an "Else ..." block.
    ''' </summary>
    Public NotInheritable Class ElseBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend _elseStatement as ElseStatementSyntax
        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseStatement As ElseStatementSyntax, statements As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseBlockSyntax(kind, errors, annotations, DirectCast(elseStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Else" statement that begins the "Else" block.
        ''' </summary>
        Public  ReadOnly Property ElseStatement As ElseStatementSyntax
            Get
                Return GetRedAtZero(_elseStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseStatement(elseStatement as ElseStatementSyntax) As ElseBlockSyntax
            return Update(elseStatement, Me.Statements)
        End Function

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As ElseBlockSyntax
            return Update(Me.ElseStatement, statements)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As ElseBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._elseStatement
                Case 1
                    Return Me._statements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.ElseStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitElseBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitElseBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="elseStatement">
        ''' The value for the ElseStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        Public Function Update(elseStatement As ElseStatementSyntax, statements As SyntaxList(of StatementSyntax)) As ElseBlockSyntax
            If elseStatement IsNot Me.ElseStatement OrElse statements <> Me.Statements Then
                Dim newNode = SyntaxFactory.ElseBlock(elseStatement, statements)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Else" statement that begins an "Else" block.
    ''' </summary>
    Public NotInheritable Class ElseStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseStatementSyntax(kind, errors, annotations, elseKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Public  ReadOnly Property ElseKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseStatementSyntax)._elseKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseKeyword(elseKeyword as SyntaxToken) As ElseStatementSyntax
            return Update(elseKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitElseStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitElseStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="elseKeyword">
        ''' The value for the ElseKeyword property.
        ''' </param>
        Public Function Update(elseKeyword As SyntaxToken) As ElseStatementSyntax
            If elseKeyword <> Me.ElseKeyword Then
                Dim newNode = SyntaxFactory.ElseStatement(elseKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Try ... Catch ... Finally ... End Try" block.
    ''' </summary>
    Public NotInheritable Class TryBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _tryStatement as TryStatementSyntax
        Friend _statements as SyntaxNode
        Friend _catchBlocks as SyntaxNode
        Friend _finallyBlock as FinallyBlockSyntax
        Friend _endTryStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), tryStatement As TryStatementSyntax, statements As SyntaxNode, catchBlocks As SyntaxNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TryBlockSyntax(kind, errors, annotations, DirectCast(tryStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TryStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), if(catchBlocks IsNot Nothing, catchBlocks.Green, Nothing), if(finallyBlock IsNot Nothing , DirectCast(finallyBlock.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FinallyBlockSyntax), Nothing) , DirectCast(endTryStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Try" statement that begins the "Try" block.
        ''' </summary>
        Public  ReadOnly Property TryStatement As TryStatementSyntax
            Get
                Return GetRedAtZero(_tryStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the TryStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithTryStatement(tryStatement as TryStatementSyntax) As TryBlockSyntax
            return Update(tryStatement, Me.Statements, Me.CatchBlocks, Me.FinallyBlock, Me.EndTryStatement)
        End Function

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As TryBlockSyntax
            return Update(Me.TryStatement, statements, Me.CatchBlocks, Me.FinallyBlock, Me.EndTryStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As TryBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' A list of "Catch" blocks which may be executed if an exception is thrown while
        ''' executing the statements in the "Try" block.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property CatchBlocks As SyntaxList(Of CatchBlockSyntax)
            Get
                Dim listNode = GetRed(_catchBlocks, 2)
                Return new SyntaxList(Of CatchBlockSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CatchBlocks property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCatchBlocks(catchBlocks as SyntaxList(Of CatchBlockSyntax)) As TryBlockSyntax
            return Update(Me.TryStatement, Me.Statements, catchBlocks, Me.FinallyBlock, Me.EndTryStatement)
        End Function

        Public Shadows Function AddCatchBlocks(ParamArray items As CatchBlockSyntax()) As TryBlockSyntax
            Return Me.WithCatchBlocks(Me.CatchBlocks.AddRange(items))
        End Function

        ''' <summary>
        ''' A "Finally" block to be executed before execution leaves the "Try" block.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property FinallyBlock As FinallyBlockSyntax
            Get
                Return GetRed(_finallyBlock, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the FinallyBlock property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithFinallyBlock(finallyBlock as FinallyBlockSyntax) As TryBlockSyntax
            return Update(Me.TryStatement, Me.Statements, Me.CatchBlocks, finallyBlock, Me.EndTryStatement)
        End Function

        Public Shadows Function AddFinallyBlockStatements(ParamArray items As StatementSyntax()) As TryBlockSyntax
            Dim _child = If (Me.FinallyBlock IsNot Nothing, Me.FinallyBlock, SyntaxFactory.FinallyBlock())
            Return Me.WithFinallyBlock(_child.AddStatements(items))
        End Function

        ''' <summary>
        ''' The "End Try" statement.
        ''' </summary>
        Public  ReadOnly Property EndTryStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endTryStatement, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndTryStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndTryStatement(endTryStatement as EndBlockStatementSyntax) As TryBlockSyntax
            return Update(Me.TryStatement, Me.Statements, Me.CatchBlocks, Me.FinallyBlock, endTryStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._tryStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._catchBlocks
                Case 3
                    Return Me._finallyBlock
                Case 4
                    Return Me._endTryStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.TryStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return GetRed(_catchBlocks, 2)
                Case 3
                    Return Me.FinallyBlock
                Case 4
                    Return Me.EndTryStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTryBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTryBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="tryStatement">
        ''' The value for the TryStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="catchBlocks">
        ''' The value for the CatchBlocks property.
        ''' </param>
        ''' <param name="finallyBlock">
        ''' The value for the FinallyBlock property.
        ''' </param>
        ''' <param name="endTryStatement">
        ''' The value for the EndTryStatement property.
        ''' </param>
        Public Function Update(tryStatement As TryStatementSyntax, statements As SyntaxList(of StatementSyntax), catchBlocks As SyntaxList(of CatchBlockSyntax), finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax) As TryBlockSyntax
            If tryStatement IsNot Me.TryStatement OrElse statements <> Me.Statements OrElse catchBlocks <> Me.CatchBlocks OrElse finallyBlock IsNot Me.FinallyBlock OrElse endTryStatement IsNot Me.EndTryStatement Then
                Dim newNode = SyntaxFactory.TryBlock(tryStatement, statements, catchBlocks, finallyBlock, endTryStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Try" statement that begins a "Try" block.
    ''' </summary>
    Public NotInheritable Class TryStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), tryKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TryStatementSyntax(kind, errors, annotations, tryKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Try" keyword.
        ''' </summary>
        Public  ReadOnly Property TryKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TryStatementSyntax)._tryKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the TryKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithTryKeyword(tryKeyword as SyntaxToken) As TryStatementSyntax
            return Update(tryKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTryStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTryStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="tryKeyword">
        ''' The value for the TryKeyword property.
        ''' </param>
        Public Function Update(tryKeyword As SyntaxToken) As TryStatementSyntax
            If tryKeyword <> Me.TryKeyword Then
                Dim newNode = SyntaxFactory.TryStatement(tryKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Catch ..." block.
    ''' </summary>
    Public NotInheritable Class CatchBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend _catchStatement as CatchStatementSyntax
        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), catchStatement As CatchStatementSyntax, statements As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchBlockSyntax(kind, errors, annotations, DirectCast(catchStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Catch" statement that begins the "Catch" block.
        ''' </summary>
        Public  ReadOnly Property CatchStatement As CatchStatementSyntax
            Get
                Return GetRedAtZero(_catchStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CatchStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCatchStatement(catchStatement as CatchStatementSyntax) As CatchBlockSyntax
            return Update(catchStatement, Me.Statements)
        End Function

        ''' <summary>
        ''' A list of statements to be executed if an exception is caught by the "Catch"
        ''' block.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As CatchBlockSyntax
            return Update(Me.CatchStatement, statements)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As CatchBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._catchStatement
                Case 1
                    Return Me._statements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.CatchStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCatchBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCatchBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="catchStatement">
        ''' The value for the CatchStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        Public Function Update(catchStatement As CatchStatementSyntax, statements As SyntaxList(of StatementSyntax)) As CatchBlockSyntax
            If catchStatement IsNot Me.CatchStatement OrElse statements <> Me.Statements Then
                Dim newNode = SyntaxFactory.CatchBlock(catchStatement, statements)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Catch ... When ..." statement that begins a "Catch" block.
    ''' </summary>
    Public NotInheritable Class CatchStatementSyntax
        Inherits StatementSyntax

        Friend _identifierName as IdentifierNameSyntax
        Friend _asClause as SimpleAsClauseSyntax
        Friend _whenClause as CatchFilterClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchStatementSyntax(kind, errors, annotations, catchKeyword, if(identifierName IsNot Nothing , DirectCast(identifierName.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IdentifierNameSyntax), Nothing) , if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) , if(whenClause IsNot Nothing , DirectCast(whenClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchFilterClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Catch" keyword.
        ''' </summary>
        Public  ReadOnly Property CatchKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchStatementSyntax)._catchKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CatchKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCatchKeyword(catchKeyword as SyntaxToken) As CatchStatementSyntax
            return Update(catchKeyword, Me.IdentifierName, Me.AsClause, Me.WhenClause)
        End Function

        ''' <summary>
        ''' An identifier declaring a new variable or naming an existing variable to store
        ''' the exception caught by the "Catch" statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property IdentifierName As IdentifierNameSyntax
            Get
                Return GetRed(_identifierName, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the IdentifierName property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithIdentifierName(identifierName as IdentifierNameSyntax) As CatchStatementSyntax
            return Update(Me.CatchKeyword, identifierName, Me.AsClause, Me.WhenClause)
        End Function

        ''' <summary>
        ''' A simple "As" clause specifying the type of exception to catch.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As CatchStatementSyntax
            return Update(Me.CatchKeyword, Me.IdentifierName, asClause, Me.WhenClause)
        End Function

        ''' <summary>
        ''' A "When" clause to filter exceptions before catching.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property WhenClause As CatchFilterClauseSyntax
            Get
                Return GetRed(_whenClause, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhenClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithWhenClause(whenClause as CatchFilterClauseSyntax) As CatchStatementSyntax
            return Update(Me.CatchKeyword, Me.IdentifierName, Me.AsClause, whenClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._identifierName
                Case 2
                    Return Me._asClause
                Case 3
                    Return Me._whenClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.IdentifierName
                Case 2
                    Return Me.AsClause
                Case 3
                    Return Me.WhenClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCatchStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCatchStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="catchKeyword">
        ''' The value for the CatchKeyword property.
        ''' </param>
        ''' <param name="identifierName">
        ''' The value for the IdentifierName property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        ''' <param name="whenClause">
        ''' The value for the WhenClause property.
        ''' </param>
        Public Function Update(catchKeyword As SyntaxToken, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax) As CatchStatementSyntax
            If catchKeyword <> Me.CatchKeyword OrElse identifierName IsNot Me.IdentifierName OrElse asClause IsNot Me.AsClause OrElse whenClause IsNot Me.WhenClause Then
                Dim newNode = SyntaxFactory.CatchStatement(catchKeyword, identifierName, asClause, whenClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "When ..." clause of a "Catch" statement.
    ''' </summary>
    Public NotInheritable Class CatchFilterClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _filter as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchFilterClauseSyntax(kind, errors, annotations, whenKeyword, DirectCast(filter.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "When" keyword.
        ''' </summary>
        Public  ReadOnly Property WhenKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CatchFilterClauseSyntax)._whenKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhenKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithWhenKeyword(whenKeyword as SyntaxToken) As CatchFilterClauseSyntax
            return Update(whenKeyword, Me.Filter)
        End Function

        ''' <summary>
        ''' The filter expression to be evaluated.
        ''' </summary>
        Public  ReadOnly Property Filter As ExpressionSyntax
            Get
                Return GetRed(_filter, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Filter property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithFilter(filter as ExpressionSyntax) As CatchFilterClauseSyntax
            return Update(Me.WhenKeyword, filter)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._filter
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Filter
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCatchFilterClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCatchFilterClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="whenKeyword">
        ''' The value for the WhenKeyword property.
        ''' </param>
        ''' <param name="filter">
        ''' The value for the Filter property.
        ''' </param>
        Public Function Update(whenKeyword As SyntaxToken, filter As ExpressionSyntax) As CatchFilterClauseSyntax
            If whenKeyword <> Me.WhenKeyword OrElse filter IsNot Me.Filter Then
                Dim newNode = SyntaxFactory.CatchFilterClause(whenKeyword, filter)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Finally ..." block of a "Try" block.
    ''' </summary>
    Public NotInheritable Class FinallyBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend _finallyStatement as FinallyStatementSyntax
        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), finallyStatement As FinallyStatementSyntax, statements As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FinallyBlockSyntax(kind, errors, annotations, DirectCast(finallyStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FinallyStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Finally" statement that begins the "Finally" block.
        ''' </summary>
        Public  ReadOnly Property FinallyStatement As FinallyStatementSyntax
            Get
                Return GetRedAtZero(_finallyStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the FinallyStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithFinallyStatement(finallyStatement as FinallyStatementSyntax) As FinallyBlockSyntax
            return Update(finallyStatement, Me.Statements)
        End Function

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As FinallyBlockSyntax
            return Update(Me.FinallyStatement, statements)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As FinallyBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._finallyStatement
                Case 1
                    Return Me._statements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.FinallyStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitFinallyBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitFinallyBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="finallyStatement">
        ''' The value for the FinallyStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        Public Function Update(finallyStatement As FinallyStatementSyntax, statements As SyntaxList(of StatementSyntax)) As FinallyBlockSyntax
            If finallyStatement IsNot Me.FinallyStatement OrElse statements <> Me.Statements Then
                Dim newNode = SyntaxFactory.FinallyBlock(finallyStatement, statements)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Finally" statement that begins a "Finally" block.
    ''' </summary>
    Public NotInheritable Class FinallyStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), finallyKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FinallyStatementSyntax(kind, errors, annotations, finallyKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Finally" keyword.
        ''' </summary>
        Public  ReadOnly Property FinallyKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.FinallyStatementSyntax)._finallyKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the FinallyKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithFinallyKeyword(finallyKeyword as SyntaxToken) As FinallyStatementSyntax
            return Update(finallyKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitFinallyStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitFinallyStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="finallyKeyword">
        ''' The value for the FinallyKeyword property.
        ''' </param>
        Public Function Update(finallyKeyword As SyntaxToken) As FinallyStatementSyntax
            If finallyKeyword <> Me.FinallyKeyword Then
                Dim newNode = SyntaxFactory.FinallyStatement(finallyKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Error" statement.
    ''' </summary>
    Public NotInheritable Class ErrorStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _errorNumber as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ErrorStatementSyntax(kind, errors, annotations, errorKeyword, DirectCast(errorNumber.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Public  ReadOnly Property ErrorKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ErrorStatementSyntax)._errorKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ErrorKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithErrorKeyword(errorKeyword as SyntaxToken) As ErrorStatementSyntax
            return Update(errorKeyword, Me.ErrorNumber)
        End Function

        ''' <summary>
        ''' The expression that represents the error number.
        ''' </summary>
        Public  ReadOnly Property ErrorNumber As ExpressionSyntax
            Get
                Return GetRed(_errorNumber, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ErrorNumber property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithErrorNumber(errorNumber as ExpressionSyntax) As ErrorStatementSyntax
            return Update(Me.ErrorKeyword, errorNumber)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._errorNumber
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.ErrorNumber
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitErrorStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitErrorStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="errorKeyword">
        ''' The value for the ErrorKeyword property.
        ''' </param>
        ''' <param name="errorNumber">
        ''' The value for the ErrorNumber property.
        ''' </param>
        Public Function Update(errorKeyword As SyntaxToken, errorNumber As ExpressionSyntax) As ErrorStatementSyntax
            If errorKeyword <> Me.ErrorKeyword OrElse errorNumber IsNot Me.ErrorNumber Then
                Dim newNode = SyntaxFactory.ErrorStatement(errorKeyword, errorNumber)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an OnError Goto statement.
    ''' </summary>
    Public NotInheritable Class OnErrorGoToStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _label as LabelSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorGoToStatementSyntax(kind, errors, annotations, onKeyword, errorKeyword, goToKeyword, minus, DirectCast(label.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "On" keyword
        ''' </summary>
        Public  ReadOnly Property OnKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorGoToStatementSyntax)._onKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OnKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOnKeyword(onKeyword as SyntaxToken) As OnErrorGoToStatementSyntax
            return Update(Me.Kind, onKeyword, Me.ErrorKeyword, Me.GoToKeyword, Me.Minus, Me.Label)
        End Function

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Public  ReadOnly Property ErrorKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorGoToStatementSyntax)._errorKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ErrorKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithErrorKeyword(errorKeyword as SyntaxToken) As OnErrorGoToStatementSyntax
            return Update(Me.Kind, Me.OnKeyword, errorKeyword, Me.GoToKeyword, Me.Minus, Me.Label)
        End Function

        ''' <summary>
        ''' The "GoTo" keyword
        ''' </summary>
        Public  ReadOnly Property GoToKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorGoToStatementSyntax)._goToKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the GoToKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithGoToKeyword(goToKeyword as SyntaxToken) As OnErrorGoToStatementSyntax
            return Update(Me.Kind, Me.OnKeyword, Me.ErrorKeyword, goToKeyword, Me.Minus, Me.Label)
        End Function

        ''' <summary>
        ''' An optional minus for On Error Goto -1
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Minus As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorGoToStatementSyntax)._minus
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(3), Me.GetChildIndex(3))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Minus property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithMinus(minus as SyntaxToken) As OnErrorGoToStatementSyntax
            return Update(Me.Kind, Me.OnKeyword, Me.ErrorKeyword, Me.GoToKeyword, minus, Me.Label)
        End Function

        ''' <summary>
        ''' The name of the label. If the label is a line number, 0 or -1, wraps an
        ''' IntegerLiteralToken that is the line number, otherwise, wraps an Identifier.
        ''' </summary>
        Public  ReadOnly Property Label As LabelSyntax
            Get
                Return GetRed(_label, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Label property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithLabel(label as LabelSyntax) As OnErrorGoToStatementSyntax
            return Update(Me.Kind, Me.OnKeyword, Me.ErrorKeyword, Me.GoToKeyword, Me.Minus, label)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 4
                    Return Me._label
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 4
                    Return Me.Label
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitOnErrorGoToStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitOnErrorGoToStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="onKeyword">
        ''' The value for the OnKeyword property.
        ''' </param>
        ''' <param name="errorKeyword">
        ''' The value for the ErrorKeyword property.
        ''' </param>
        ''' <param name="goToKeyword">
        ''' The value for the GoToKeyword property.
        ''' </param>
        ''' <param name="minus">
        ''' The value for the Minus property.
        ''' </param>
        ''' <param name="label">
        ''' The value for the Label property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, onKeyword As SyntaxToken, errorKeyword As SyntaxToken, goToKeyword As SyntaxToken, minus As SyntaxToken, label As LabelSyntax) As OnErrorGoToStatementSyntax
            If kind <> Me.Kind OrElse onKeyword <> Me.OnKeyword OrElse errorKeyword <> Me.ErrorKeyword OrElse goToKeyword <> Me.GoToKeyword OrElse minus <> Me.Minus OrElse label IsNot Me.Label Then
                Dim newNode = SyntaxFactory.OnErrorGoToStatement(kind, onKeyword, errorKeyword, goToKeyword, minus, label)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an OnError Resume Next statement.
    ''' </summary>
    Public NotInheritable Class OnErrorResumeNextStatementSyntax
        Inherits ExecutableStatementSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorResumeNextStatementSyntax(kind, errors, annotations, onKeyword, errorKeyword, resumeKeyword, nextKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "On" keyword
        ''' </summary>
        Public  ReadOnly Property OnKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorResumeNextStatementSyntax)._onKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OnKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOnKeyword(onKeyword as SyntaxToken) As OnErrorResumeNextStatementSyntax
            return Update(onKeyword, Me.ErrorKeyword, Me.ResumeKeyword, Me.NextKeyword)
        End Function

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Public  ReadOnly Property ErrorKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorResumeNextStatementSyntax)._errorKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ErrorKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithErrorKeyword(errorKeyword as SyntaxToken) As OnErrorResumeNextStatementSyntax
            return Update(Me.OnKeyword, errorKeyword, Me.ResumeKeyword, Me.NextKeyword)
        End Function

        ''' <summary>
        ''' The "Resume" keyword.
        ''' </summary>
        Public  ReadOnly Property ResumeKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorResumeNextStatementSyntax)._resumeKeyword, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ResumeKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithResumeKeyword(resumeKeyword as SyntaxToken) As OnErrorResumeNextStatementSyntax
            return Update(Me.OnKeyword, Me.ErrorKeyword, resumeKeyword, Me.NextKeyword)
        End Function

        ''' <summary>
        ''' The "Next"
        ''' </summary>
        Public  ReadOnly Property NextKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.OnErrorResumeNextStatementSyntax)._nextKeyword, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NextKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNextKeyword(nextKeyword as SyntaxToken) As OnErrorResumeNextStatementSyntax
            return Update(Me.OnKeyword, Me.ErrorKeyword, Me.ResumeKeyword, nextKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitOnErrorResumeNextStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitOnErrorResumeNextStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="onKeyword">
        ''' The value for the OnKeyword property.
        ''' </param>
        ''' <param name="errorKeyword">
        ''' The value for the ErrorKeyword property.
        ''' </param>
        ''' <param name="resumeKeyword">
        ''' The value for the ResumeKeyword property.
        ''' </param>
        ''' <param name="nextKeyword">
        ''' The value for the NextKeyword property.
        ''' </param>
        Public Function Update(onKeyword As SyntaxToken, errorKeyword As SyntaxToken, resumeKeyword As SyntaxToken, nextKeyword As SyntaxToken) As OnErrorResumeNextStatementSyntax
            If onKeyword <> Me.OnKeyword OrElse errorKeyword <> Me.ErrorKeyword OrElse resumeKeyword <> Me.ResumeKeyword OrElse nextKeyword <> Me.NextKeyword Then
                Dim newNode = SyntaxFactory.OnErrorResumeNextStatement(onKeyword, errorKeyword, resumeKeyword, nextKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Resume" statement. The Kind property can be used to determine if
    ''' this is a "Resume", "Resume Next" or "Resume label" statement.
    ''' </summary>
    Public NotInheritable Class ResumeStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _label as LabelSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ResumeStatementSyntax(kind, errors, annotations, resumeKeyword, if(label IsNot Nothing , DirectCast(label.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LabelSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Resume" keyword.
        ''' </summary>
        Public  ReadOnly Property ResumeKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ResumeStatementSyntax)._resumeKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ResumeKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithResumeKeyword(resumeKeyword as SyntaxToken) As ResumeStatementSyntax
            return Update(Me.Kind, resumeKeyword, Me.Label)
        End Function

        ''' <summary>
        ''' The label. The value of this depends on the Kind. If Kind=Resume, returns
        ''' Nothing. If Kind=ResumeNext, wraps the keyword "Next", If Kind=ResumeLabel,
        ''' wraps an Identifier or IntegerLiteralToken with the label or line number.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Label As LabelSyntax
            Get
                Return GetRed(_label, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Label property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithLabel(label as LabelSyntax) As ResumeStatementSyntax
            return Update(Me.Kind, Me.ResumeKeyword, label)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._label
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Label
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitResumeStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitResumeStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="resumeKeyword">
        ''' The value for the ResumeKeyword property.
        ''' </param>
        ''' <param name="label">
        ''' The value for the Label property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, resumeKeyword As SyntaxToken, label As LabelSyntax) As ResumeStatementSyntax
            If kind <> Me.Kind OrElse resumeKeyword <> Me.ResumeKeyword OrElse label IsNot Me.Label Then
                Dim newNode = SyntaxFactory.ResumeStatement(kind, resumeKeyword, label)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Select Case block, including the Select Case that begins it, the
    ''' contains Case blocks and the End Select.
    ''' </summary>
    Public NotInheritable Class SelectBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _selectStatement as SelectStatementSyntax
        Friend _caseBlocks as SyntaxNode
        Friend _endSelectStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectStatement As SelectStatementSyntax, caseBlocks As SyntaxNode, endSelectStatement As EndBlockStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SelectBlockSyntax(kind, errors, annotations, DirectCast(selectStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SelectStatementSyntax), if(caseBlocks IsNot Nothing, caseBlocks.Green, Nothing), DirectCast(endSelectStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EndBlockStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The Select Case statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property SelectStatement As SelectStatementSyntax
            Get
                Return GetRedAtZero(_selectStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SelectStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSelectStatement(selectStatement as SelectStatementSyntax) As SelectBlockSyntax
            return Update(selectStatement, Me.CaseBlocks, Me.EndSelectStatement)
        End Function

        ''' <summary>
        ''' A list of the contained Case blocks.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property CaseBlocks As SyntaxList(Of CaseBlockSyntax)
            Get
                Dim listNode = GetRed(_caseBlocks, 1)
                Return new SyntaxList(Of CaseBlockSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CaseBlocks property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCaseBlocks(caseBlocks as SyntaxList(Of CaseBlockSyntax)) As SelectBlockSyntax
            return Update(Me.SelectStatement, caseBlocks, Me.EndSelectStatement)
        End Function

        Public Shadows Function AddCaseBlocks(ParamArray items As CaseBlockSyntax()) As SelectBlockSyntax
            Return Me.WithCaseBlocks(Me.CaseBlocks.AddRange(items))
        End Function

        ''' <summary>
        ''' The End Select statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property EndSelectStatement As EndBlockStatementSyntax
            Get
                Return GetRed(_endSelectStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EndSelectStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEndSelectStatement(endSelectStatement as EndBlockStatementSyntax) As SelectBlockSyntax
            return Update(Me.SelectStatement, Me.CaseBlocks, endSelectStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._selectStatement
                Case 1
                    Return Me._caseBlocks
                Case 2
                    Return Me._endSelectStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.SelectStatement
                Case 1
                    Return GetRed(_caseBlocks, 1)
                Case 2
                    Return Me.EndSelectStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSelectBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSelectBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="selectStatement">
        ''' The value for the SelectStatement property.
        ''' </param>
        ''' <param name="caseBlocks">
        ''' The value for the CaseBlocks property.
        ''' </param>
        ''' <param name="endSelectStatement">
        ''' The value for the EndSelectStatement property.
        ''' </param>
        Public Function Update(selectStatement As SelectStatementSyntax, caseBlocks As SyntaxList(of CaseBlockSyntax), endSelectStatement As EndBlockStatementSyntax) As SelectBlockSyntax
            If selectStatement IsNot Me.SelectStatement OrElse caseBlocks <> Me.CaseBlocks OrElse endSelectStatement IsNot Me.EndSelectStatement Then
                Dim newNode = SyntaxFactory.SelectBlock(selectStatement, caseBlocks, endSelectStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Select Case statement. This statement always occurs as the Begin
    ''' of a SelectBlock.
    ''' </summary>
    Public NotInheritable Class SelectStatementSyntax
        Inherits StatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SelectStatementSyntax(kind, errors, annotations, selectKeyword, caseKeyword, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Select" keyword.
        ''' </summary>
        Public  ReadOnly Property SelectKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SelectStatementSyntax)._selectKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SelectKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithSelectKeyword(selectKeyword as SyntaxToken) As SelectStatementSyntax
            return Update(selectKeyword, Me.CaseKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The "Case" keyword, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property CaseKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SelectStatementSyntax)._caseKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CaseKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCaseKeyword(caseKeyword as SyntaxToken) As SelectStatementSyntax
            return Update(Me.SelectKeyword, caseKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The value that branching is based on.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As SelectStatementSyntax
            return Update(Me.SelectKeyword, Me.CaseKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSelectStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSelectStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="selectKeyword">
        ''' The value for the SelectKeyword property.
        ''' </param>
        ''' <param name="caseKeyword">
        ''' The value for the CaseKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(selectKeyword As SyntaxToken, caseKeyword As SyntaxToken, expression As ExpressionSyntax) As SelectStatementSyntax
            If selectKeyword <> Me.SelectKeyword OrElse caseKeyword <> Me.CaseKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.SelectStatement(selectKeyword, caseKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a case statement and its subsequent block.
    ''' </summary>
    Public NotInheritable Class CaseBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend _caseStatement as CaseStatementSyntax
        Friend _statements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), caseStatement As CaseStatementSyntax, statements As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CaseBlockSyntax(kind, errors, annotations, DirectCast(caseStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CaseStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The statement that begins the case block.
        ''' </summary>
        Public  ReadOnly Property CaseStatement As CaseStatementSyntax
            Get
                Return GetRedAtZero(_caseStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CaseStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCaseStatement(caseStatement as CaseStatementSyntax) As CaseBlockSyntax
            return Update(Me.Kind, caseStatement, Me.Statements)
        End Function

        Public Shadows Function AddCaseStatementCases(ParamArray items As CaseClauseSyntax()) As CaseBlockSyntax
            Dim _child = If (Me.CaseStatement IsNot Nothing, Me.CaseStatement, SyntaxFactory.CaseStatement())
            Return Me.WithCaseStatement(_child.AddCases(items))
        End Function

        ''' <summary>
        ''' The statements contained in the case block. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As CaseBlockSyntax
            return Update(Me.Kind, Me.CaseStatement, statements)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As CaseBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._caseStatement
                Case 1
                    Return Me._statements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.CaseStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCaseBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCaseBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="caseStatement">
        ''' The value for the CaseStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, caseStatement As CaseStatementSyntax, statements As SyntaxList(of StatementSyntax)) As CaseBlockSyntax
            If kind <> Me.Kind OrElse caseStatement IsNot Me.CaseStatement OrElse statements <> Me.Statements Then
                Dim newNode = SyntaxFactory.CaseBlock(kind, caseStatement, statements)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Case or Case Else statement. This statement is always the Begin of
    ''' a CaseBlock. If this is a Case Else statement, the Kind=CaseElse, otherwise the
    ''' Kind=Case.
    ''' </summary>
    Public NotInheritable Class CaseStatementSyntax
        Inherits StatementSyntax

        Friend _cases as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), caseKeyword As InternalSyntax.KeywordSyntax, cases As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CaseStatementSyntax(kind, errors, annotations, caseKeyword, if(cases IsNot Nothing, cases.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Case" keyword
        ''' </summary>
        Public  ReadOnly Property CaseKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CaseStatementSyntax)._caseKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CaseKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCaseKeyword(caseKeyword as SyntaxToken) As CaseStatementSyntax
            return Update(Me.Kind, caseKeyword, Me.Cases)
        End Function

        ''' <summary>
        ''' A list of clauses associated with this Case. If Kind=CaseElse, then this list
        ''' has exactly one child, which is a ElseCaseClause.
        ''' </summary>
        Public  ReadOnly Property Cases As SeparatedSyntaxList(Of CaseClauseSyntax)
            Get
                Dim listNode = GetRed(_cases, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of CaseClauseSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Cases property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithCases(cases as SeparatedSyntaxList(Of CaseClauseSyntax)) As CaseStatementSyntax
            return Update(Me.Kind, Me.CaseKeyword, cases)
        End Function

        Public Shadows Function AddCases(ParamArray items As CaseClauseSyntax()) As CaseStatementSyntax
            Return Me.WithCases(Me.Cases.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._cases
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_cases, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCaseStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCaseStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="caseKeyword">
        ''' The value for the CaseKeyword property.
        ''' </param>
        ''' <param name="cases">
        ''' The value for the Cases property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, caseKeyword As SyntaxToken, cases As SeparatedSyntaxList(Of CaseClauseSyntax)) As CaseStatementSyntax
            If kind <> Me.Kind OrElse caseKeyword <> Me.CaseKeyword OrElse cases <> Me.Cases Then
                Dim newNode = SyntaxFactory.CaseStatement(kind, caseKeyword, cases)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single clause in a case statement. An abstract node that is the
    ''' parent of different kinds of Case clauses.
    ''' </summary>
    Public MustInherit Class CaseClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' The "Else" part in a Case Else statement.
    ''' </summary>
    Public NotInheritable Class ElseCaseClauseSyntax
        Inherits CaseClauseSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseCaseClauseSyntax(kind, errors, annotations, elseKeyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Public  ReadOnly Property ElseKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ElseCaseClauseSyntax)._elseKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ElseKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElseKeyword(elseKeyword as SyntaxToken) As ElseCaseClauseSyntax
            return Update(elseKeyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitElseCaseClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitElseCaseClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="elseKeyword">
        ''' The value for the ElseKeyword property.
        ''' </param>
        Public Function Update(elseKeyword As SyntaxToken) As ElseCaseClauseSyntax
            If elseKeyword <> Me.ElseKeyword Then
                Dim newNode = SyntaxFactory.ElseCaseClause(elseKeyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single value in a Case.
    ''' </summary>
    Public NotInheritable Class SimpleCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend _value as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), value As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleCaseClauseSyntax(kind, errors, annotations, DirectCast(value.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The expression that denotes the value being tested against.
        ''' </summary>
        Public  ReadOnly Property Value As ExpressionSyntax
            Get
                Return GetRedAtZero(_value)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Value property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithValue(value as ExpressionSyntax) As SimpleCaseClauseSyntax
            return Update(value)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me._value
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me.Value
            Else
                Return Nothing
            End If
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSimpleCaseClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSimpleCaseClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="value">
        ''' The value for the Value property.
        ''' </param>
        Public Function Update(value As ExpressionSyntax) As SimpleCaseClauseSyntax
            If value IsNot Me.Value Then
                Dim newNode = SyntaxFactory.SimpleCaseClause(value)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a range "expression To expression" in a Case.
    ''' </summary>
    Public NotInheritable Class RangeCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend _lowerBound as ExpressionSyntax
        Friend _upperBound as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RangeCaseClauseSyntax(kind, errors, annotations, DirectCast(lowerBound.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), toKeyword, DirectCast(upperBound.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The lower bound of the range.
        ''' </summary>
        Public  ReadOnly Property LowerBound As ExpressionSyntax
            Get
                Return GetRedAtZero(_lowerBound)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LowerBound property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLowerBound(lowerBound as ExpressionSyntax) As RangeCaseClauseSyntax
            return Update(lowerBound, Me.ToKeyword, Me.UpperBound)
        End Function

        ''' <summary>
        ''' The "To" keyword
        ''' </summary>
        Public  ReadOnly Property ToKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RangeCaseClauseSyntax)._toKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ToKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithToKeyword(toKeyword as SyntaxToken) As RangeCaseClauseSyntax
            return Update(Me.LowerBound, toKeyword, Me.UpperBound)
        End Function

        ''' <summary>
        ''' The upper bound of the range.
        ''' </summary>
        Public  ReadOnly Property UpperBound As ExpressionSyntax
            Get
                Return GetRed(_upperBound, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the UpperBound property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithUpperBound(upperBound as ExpressionSyntax) As RangeCaseClauseSyntax
            return Update(Me.LowerBound, Me.ToKeyword, upperBound)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._lowerBound
                Case 2
                    Return Me._upperBound
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.LowerBound
                Case 2
                    Return Me.UpperBound
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitRangeCaseClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitRangeCaseClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="lowerBound">
        ''' The value for the LowerBound property.
        ''' </param>
        ''' <param name="toKeyword">
        ''' The value for the ToKeyword property.
        ''' </param>
        ''' <param name="upperBound">
        ''' The value for the UpperBound property.
        ''' </param>
        Public Function Update(lowerBound As ExpressionSyntax, toKeyword As SyntaxToken, upperBound As ExpressionSyntax) As RangeCaseClauseSyntax
            If lowerBound IsNot Me.LowerBound OrElse toKeyword <> Me.ToKeyword OrElse upperBound IsNot Me.UpperBound Then
                Dim newNode = SyntaxFactory.RangeCaseClause(lowerBound, toKeyword, upperBound)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a relation clause in a Case statement, such as "Is &gt; expression".
    ''' </summary>
    Public NotInheritable Class RelationalCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend _value as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RelationalCaseClauseSyntax(kind, errors, annotations, isKeyword, operatorToken, DirectCast(value.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Is" keyword, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property IsKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RelationalCaseClauseSyntax)._isKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.Position, 0)
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the IsKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIsKeyword(isKeyword as SyntaxToken) As RelationalCaseClauseSyntax
            return Update(Me.Kind, isKeyword, Me.OperatorToken, Me.Value)
        End Function

        ''' <summary>
        ''' The operator in the relational clause. One of "=", "&lt;", "&gt;", "&lt;=" or
        ''' "&gt;=".
        ''' </summary>
        Public  ReadOnly Property OperatorToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RelationalCaseClauseSyntax)._operatorToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOperatorToken(operatorToken as SyntaxToken) As RelationalCaseClauseSyntax
            return Update(Me.Kind, Me.IsKeyword, operatorToken, Me.Value)
        End Function

        ''' <summary>
        ''' The expression that denotes the value being tested against.
        ''' </summary>
        Public  ReadOnly Property Value As ExpressionSyntax
            Get
                Return GetRed(_value, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Value property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithValue(value as ExpressionSyntax) As RelationalCaseClauseSyntax
            return Update(Me.Kind, Me.IsKeyword, Me.OperatorToken, value)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._value
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.Value
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitRelationalCaseClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitRelationalCaseClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="isKeyword">
        ''' The value for the IsKeyword property.
        ''' </param>
        ''' <param name="operatorToken">
        ''' The value for the OperatorToken property.
        ''' </param>
        ''' <param name="value">
        ''' The value for the Value property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, isKeyword As SyntaxToken, operatorToken As SyntaxToken, value As ExpressionSyntax) As RelationalCaseClauseSyntax
            If kind <> Me.Kind OrElse isKeyword <> Me.IsKeyword OrElse operatorToken <> Me.OperatorToken OrElse value IsNot Me.Value Then
                Dim newNode = SyntaxFactory.RelationalCaseClause(kind, isKeyword, operatorToken, value)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents the "SyncLock" statement. This statement always occurs as the Begin
    ''' of a SyncLockBlock.
    ''' </summary>
    Public NotInheritable Class SyncLockStatementSyntax
        Inherits StatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SyncLockStatementSyntax(kind, errors, annotations, syncLockKeyword, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "SyncLock" keyword.
        ''' </summary>
        Public  ReadOnly Property SyncLockKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SyncLockStatementSyntax)._syncLockKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the SyncLockKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithSyncLockKeyword(syncLockKeyword as SyntaxToken) As SyncLockStatementSyntax
            return Update(syncLockKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The expression being synchronized on.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As SyncLockStatementSyntax
            return Update(Me.SyncLockKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitSyncLockStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitSyncLockStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="syncLockKeyword">
        ''' The value for the SyncLockKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(syncLockKeyword As SyntaxToken, expression As ExpressionSyntax) As SyncLockStatementSyntax
            If syncLockKeyword <> Me.SyncLockKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.SyncLockStatement(syncLockKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Do-Loop block. The Kind property can be used to determine if this
    ''' is a Do While, Do Until, Do Loop While, Do Loop Until, or infinite Do Loop.
    ''' </summary>
    Public NotInheritable Class DoLoopBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _doStatement as DoStatementSyntax
        Friend _statements as SyntaxNode
        Friend _loopStatement as LoopStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), doStatement As DoStatementSyntax, statements As SyntaxNode, loopStatement As LoopStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DoLoopBlockSyntax(kind, errors, annotations, DirectCast(doStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DoStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), DirectCast(loopStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LoopStatementSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The Do statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property DoStatement As DoStatementSyntax
            Get
                Return GetRedAtZero(_doStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DoStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDoStatement(doStatement as DoStatementSyntax) As DoLoopBlockSyntax
            return Update(Me.Kind, doStatement, Me.Statements, Me.LoopStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As DoLoopBlockSyntax
            return Update(Me.Kind, Me.DoStatement, statements, Me.LoopStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As DoLoopBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The Loop statement that ends the block.
        ''' </summary>
        Public  ReadOnly Property LoopStatement As LoopStatementSyntax
            Get
                Return GetRed(_loopStatement, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LoopStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLoopStatement(loopStatement as LoopStatementSyntax) As DoLoopBlockSyntax
            return Update(Me.Kind, Me.DoStatement, Me.Statements, loopStatement)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._doStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._loopStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.DoStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.LoopStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitDoLoopBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitDoLoopBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="doStatement">
        ''' The value for the DoStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="loopStatement">
        ''' The value for the LoopStatement property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, doStatement As DoStatementSyntax, statements As SyntaxList(of StatementSyntax), loopStatement As LoopStatementSyntax) As DoLoopBlockSyntax
            If kind <> Me.Kind OrElse doStatement IsNot Me.DoStatement OrElse statements <> Me.Statements OrElse loopStatement IsNot Me.LoopStatement Then
                Dim newNode = SyntaxFactory.DoLoopBlock(kind, doStatement, statements, loopStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The Do statement that begins a Do-Loop block.
    ''' </summary>
    Public NotInheritable Class DoStatementSyntax
        Inherits StatementSyntax

        Friend _whileOrUntilClause as WhileOrUntilClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DoStatementSyntax(kind, errors, annotations, doKeyword, if(whileOrUntilClause IsNot Nothing , DirectCast(whileOrUntilClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileOrUntilClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Do" keyword.
        ''' </summary>
        Public  ReadOnly Property DoKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.DoStatementSyntax)._doKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DoKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithDoKeyword(doKeyword as SyntaxToken) As DoStatementSyntax
            return Update(Me.Kind, doKeyword, Me.WhileOrUntilClause)
        End Function

        ''' <summary>
        ''' The "While expression" or "Until expression" clause of the Do statement, if
        ''' present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property WhileOrUntilClause As WhileOrUntilClauseSyntax
            Get
                Return GetRed(_whileOrUntilClause, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhileOrUntilClause property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithWhileOrUntilClause(whileOrUntilClause as WhileOrUntilClauseSyntax) As DoStatementSyntax
            return Update(Me.Kind, Me.DoKeyword, whileOrUntilClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._whileOrUntilClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.WhileOrUntilClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitDoStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitDoStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="doKeyword">
        ''' The value for the DoKeyword property.
        ''' </param>
        ''' <param name="whileOrUntilClause">
        ''' The value for the WhileOrUntilClause property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, doKeyword As SyntaxToken, whileOrUntilClause As WhileOrUntilClauseSyntax) As DoStatementSyntax
            If kind <> Me.Kind OrElse doKeyword <> Me.DoKeyword OrElse whileOrUntilClause IsNot Me.WhileOrUntilClause Then
                Dim newNode = SyntaxFactory.DoStatement(kind, doKeyword, whileOrUntilClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The Loop statement that begins a Do-Loop block.
    ''' </summary>
    Public NotInheritable Class LoopStatementSyntax
        Inherits StatementSyntax

        Friend _whileOrUntilClause as WhileOrUntilClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LoopStatementSyntax(kind, errors, annotations, loopKeyword, if(whileOrUntilClause IsNot Nothing , DirectCast(whileOrUntilClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileOrUntilClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Loop" keyword.
        ''' </summary>
        Public  ReadOnly Property LoopKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LoopStatementSyntax)._loopKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the LoopKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithLoopKeyword(loopKeyword as SyntaxToken) As LoopStatementSyntax
            return Update(Me.Kind, loopKeyword, Me.WhileOrUntilClause)
        End Function

        ''' <summary>
        ''' The "While expression" or "Until expression" clause of the Loop statement, if
        ''' present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property WhileOrUntilClause As WhileOrUntilClauseSyntax
            Get
                Return GetRed(_whileOrUntilClause, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhileOrUntilClause property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithWhileOrUntilClause(whileOrUntilClause as WhileOrUntilClauseSyntax) As LoopStatementSyntax
            return Update(Me.Kind, Me.LoopKeyword, whileOrUntilClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._whileOrUntilClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.WhileOrUntilClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitLoopStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitLoopStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="loopKeyword">
        ''' The value for the LoopKeyword property.
        ''' </param>
        ''' <param name="whileOrUntilClause">
        ''' The value for the WhileOrUntilClause property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, loopKeyword As SyntaxToken, whileOrUntilClause As WhileOrUntilClauseSyntax) As LoopStatementSyntax
            If kind <> Me.Kind OrElse loopKeyword <> Me.LoopKeyword OrElse whileOrUntilClause IsNot Me.WhileOrUntilClause Then
                Dim newNode = SyntaxFactory.LoopStatement(kind, loopKeyword, whileOrUntilClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "While expression" or "Until expression" in a Do or Loop
    ''' statement. The Kind of the clause can be "WhileClause" or "UntilClause" to
    ''' indicate which kind of clause.
    ''' </summary>
    Public NotInheritable Class WhileOrUntilClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _condition as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileOrUntilClauseSyntax(kind, errors, annotations, whileOrUntilKeyword, DirectCast(condition.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "While" or "Until" keyword.
        ''' </summary>
        Public  ReadOnly Property WhileOrUntilKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileOrUntilClauseSyntax)._whileOrUntilKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhileOrUntilKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithWhileOrUntilKeyword(whileOrUntilKeyword as SyntaxToken) As WhileOrUntilClauseSyntax
            return Update(Me.Kind, whileOrUntilKeyword, Me.Condition)
        End Function

        ''' <summary>
        ''' The boolean expression after the While or Until.
        ''' </summary>
        Public  ReadOnly Property Condition As ExpressionSyntax
            Get
                Return GetRed(_condition, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Condition property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCondition(condition as ExpressionSyntax) As WhileOrUntilClauseSyntax
            return Update(Me.Kind, Me.WhileOrUntilKeyword, condition)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWhileOrUntilClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWhileOrUntilClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="whileOrUntilKeyword">
        ''' The value for the WhileOrUntilKeyword property.
        ''' </param>
        ''' <param name="condition">
        ''' The value for the Condition property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, whileOrUntilKeyword As SyntaxToken, condition As ExpressionSyntax) As WhileOrUntilClauseSyntax
            If kind <> Me.Kind OrElse whileOrUntilKeyword <> Me.WhileOrUntilKeyword OrElse condition IsNot Me.Condition Then
                Dim newNode = SyntaxFactory.WhileOrUntilClause(kind, whileOrUntilKeyword, condition)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The While statement that begins a While...End While block. This statement
    ''' always occurs as the Begin of a WhileBlock.
    ''' </summary>
    Public NotInheritable Class WhileStatementSyntax
        Inherits StatementSyntax

        Friend _condition as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileStatementSyntax(kind, errors, annotations, whileKeyword, DirectCast(condition.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "While" keyword.
        ''' </summary>
        Public  ReadOnly Property WhileKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WhileStatementSyntax)._whileKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WhileKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithWhileKeyword(whileKeyword as SyntaxToken) As WhileStatementSyntax
            return Update(whileKeyword, Me.Condition)
        End Function

        ''' <summary>
        ''' The boolean expression that controls the While loop.
        ''' </summary>
        Public  ReadOnly Property Condition As ExpressionSyntax
            Get
                Return GetRed(_condition, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Condition property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCondition(condition as ExpressionSyntax) As WhileStatementSyntax
            return Update(Me.WhileKeyword, condition)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Condition
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWhileStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWhileStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="whileKeyword">
        ''' The value for the WhileKeyword property.
        ''' </param>
        ''' <param name="condition">
        ''' The value for the Condition property.
        ''' </param>
        Public Function Update(whileKeyword As SyntaxToken, condition As ExpressionSyntax) As WhileStatementSyntax
            If whileKeyword <> Me.WhileKeyword OrElse condition IsNot Me.Condition Then
                Dim newNode = SyntaxFactory.WhileStatement(whileKeyword, condition)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a For or For Each block.
    ''' </summary>
    Public MustInherit Class ForOrForEachBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend _statements as SyntaxNode
        Friend _nextStatement as NextStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The statements contained in the For or For Each loop. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Return Me.GetStatementsCore()
            End Get
        End Property

        Friend Overridable Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
                Dim listNode = GetRedAtZero(_statements)
                Return new SyntaxList(Of StatementSyntax)(listNode)
        End Function


        ''' <summary>
        ''' The Next statement that ends the block. If two For or For Each statements are
        ''' ended by a single Next statement, the inner For will not have a Next statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public ReadOnly Property NextStatement As NextStatementSyntax
            Get
                Return Me.GetNextStatementCore()
            End Get
        End Property

        Friend Overridable Function GetNextStatementCore() As NextStatementSyntax
                Return GetRed(_nextStatement, 1)
        End Function


    End Class

    ''' <summary>
    ''' Represents a For block, including the introducing statement, the body and the
    ''' "Next" (which can be omitted if a containing For has a Next with multiple
    ''' variables).
    ''' </summary>
    Public NotInheritable Class ForBlockSyntax
        Inherits ForOrForEachBlockSyntax

        Friend _forStatement as ForStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forStatement As ForStatementSyntax, statements As SyntaxNode, nextStatement As NextStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForBlockSyntax(kind, errors, annotations, DirectCast(forStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), if(nextStatement IsNot Nothing , DirectCast(nextStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NextStatementSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The For statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property ForStatement As ForStatementSyntax
            Get
                Return GetRedAtZero(_forStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ForStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithForStatement(forStatement as ForStatementSyntax) As ForBlockSyntax
            return Update(forStatement, Me.Statements, Me.NextStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the For or For Each loop. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
            Return Me.Statements
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As ForBlockSyntax
            return Update(Me.ForStatement, statements, Me.NextStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As ForBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The Next statement that ends the block. If two For or For Each statements are
        ''' ended by a single Next statement, the inner For will not have a Next statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property NextStatement As NextStatementSyntax
            Get
                Return GetRed(_nextStatement, 2)
            End Get
        End Property

        Friend Overrides Function GetNextStatementCore() As NextStatementSyntax
            Return Me.NextStatement
        End Function

        ''' <summary>
        ''' Returns a copy of this with the NextStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNextStatement(nextStatement as NextStatementSyntax) As ForBlockSyntax
            return Update(Me.ForStatement, Me.Statements, nextStatement)
        End Function

        Public Shadows Function AddNextStatementControlVariables(ParamArray items As ExpressionSyntax()) As ForBlockSyntax
            Dim _child = If (Me.NextStatement IsNot Nothing, Me.NextStatement, SyntaxFactory.NextStatement())
            Return Me.WithNextStatement(_child.AddControlVariables(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._forStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._nextStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.ForStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.NextStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitForBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitForBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="forStatement">
        ''' The value for the ForStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="nextStatement">
        ''' The value for the NextStatement property.
        ''' </param>
        Public Function Update(forStatement As ForStatementSyntax, statements As SyntaxList(of StatementSyntax), nextStatement As NextStatementSyntax) As ForBlockSyntax
            If forStatement IsNot Me.ForStatement OrElse statements <> Me.Statements OrElse nextStatement IsNot Me.NextStatement Then
                Dim newNode = SyntaxFactory.ForBlock(forStatement, statements, nextStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a For Each block, including the introducing statement, the body and
    ''' the "Next" (which can be omitted if a containing For has a Next with multiple
    ''' variables).
    ''' </summary>
    Public NotInheritable Class ForEachBlockSyntax
        Inherits ForOrForEachBlockSyntax

        Friend _forEachStatement as ForEachStatementSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forEachStatement As ForEachStatementSyntax, statements As SyntaxNode, nextStatement As NextStatementSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForEachBlockSyntax(kind, errors, annotations, DirectCast(forEachStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForEachStatementSyntax), if(statements IsNot Nothing, statements.Green, Nothing), if(nextStatement IsNot Nothing , DirectCast(nextStatement.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NextStatementSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The For Each statement that begins the block.
        ''' </summary>
        Public  ReadOnly Property ForEachStatement As ForEachStatementSyntax
            Get
                Return GetRedAtZero(_forEachStatement)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ForEachStatement property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithForEachStatement(forEachStatement as ForEachStatementSyntax) As ForEachBlockSyntax
            return Update(forEachStatement, Me.Statements, Me.NextStatement)
        End Function

        ''' <summary>
        ''' The statements contained in the For or For Each loop. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property Statements As SyntaxList(Of StatementSyntax)
            Get
                Dim listNode = GetRed(_statements, 1)
                Return new SyntaxList(Of StatementSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetStatementsCore() As SyntaxList(Of StatementSyntax)
            Return Me.Statements
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Statements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStatements(statements as SyntaxList(Of StatementSyntax)) As ForEachBlockSyntax
            return Update(Me.ForEachStatement, statements, Me.NextStatement)
        End Function

        Public Shadows Function AddStatements(ParamArray items As StatementSyntax()) As ForEachBlockSyntax
            Return Me.WithStatements(Me.Statements.AddRange(items))
        End Function

        ''' <summary>
        ''' The Next statement that ends the block. If two For or For Each statements are
        ''' ended by a single Next statement, the inner For will not have a Next statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property NextStatement As NextStatementSyntax
            Get
                Return GetRed(_nextStatement, 2)
            End Get
        End Property

        Friend Overrides Function GetNextStatementCore() As NextStatementSyntax
            Return Me.NextStatement
        End Function

        ''' <summary>
        ''' Returns a copy of this with the NextStatement property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNextStatement(nextStatement as NextStatementSyntax) As ForEachBlockSyntax
            return Update(Me.ForEachStatement, Me.Statements, nextStatement)
        End Function

        Public Shadows Function AddNextStatementControlVariables(ParamArray items As ExpressionSyntax()) As ForEachBlockSyntax
            Dim _child = If (Me.NextStatement IsNot Nothing, Me.NextStatement, SyntaxFactory.NextStatement())
            Return Me.WithNextStatement(_child.AddControlVariables(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._forEachStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._nextStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.ForEachStatement
                Case 1
                    Return GetRed(_statements, 1)
                Case 2
                    Return Me.NextStatement
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitForEachBlock(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitForEachBlock(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="forEachStatement">
        ''' The value for the ForEachStatement property.
        ''' </param>
        ''' <param name="statements">
        ''' The value for the Statements property.
        ''' </param>
        ''' <param name="nextStatement">
        ''' The value for the NextStatement property.
        ''' </param>
        Public Function Update(forEachStatement As ForEachStatementSyntax, statements As SyntaxList(of StatementSyntax), nextStatement As NextStatementSyntax) As ForEachBlockSyntax
            If forEachStatement IsNot Me.ForEachStatement OrElse statements <> Me.Statements OrElse nextStatement IsNot Me.NextStatement Then
                Dim newNode = SyntaxFactory.ForEachBlock(forEachStatement, statements, nextStatement)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a For or For Each statement.
    ''' </summary>
    Public MustInherit Class ForOrForEachStatementSyntax
        Inherits StatementSyntax

        Friend _controlVariable as VisualBasicSyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The "For" keyword.
        ''' </summary>
        Public ReadOnly Property ForKeyword As SyntaxToken
            Get
                Return Me.GetForKeywordCore()
            End Get
        End Property

        Friend Overridable Function GetForKeywordCore() As SyntaxToken
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForOrForEachStatementSyntax)._forKeyword, Me.Position, 0)
        End Function


        ''' <summary>
        ''' If the For or For Each statement is of a form that does not declare a new loop
        ''' control variable, this is the expression that denotes the loop control
        ''' variable. If this loop is of a form that does declare a new control variable,
        ''' this is a VariableDeclarator that has the variable being declared.
        ''' </summary>
        Public ReadOnly Property ControlVariable As VisualBasicSyntaxNode
            Get
                Return Me.GetControlVariableCore()
            End Get
        End Property

        Friend Overridable Function GetControlVariableCore() As VisualBasicSyntaxNode
                Return GetRed(_controlVariable, 1)
        End Function


    End Class

    ''' <summary>
    ''' The For statement that begins a For-Next block. This statement always occurs as
    ''' the Begin of a ForBlock. Most of the time, the End of that ForBlock is the
    ''' corresponding Next statement. However, multiple nested For statements are ended
    ''' by a single Next statement with multiple variables, then the inner For
    ''' statements will have End set to Nothing, and the Next statement is the End of
    ''' the outermost For statement that is being ended.
    ''' </summary>
    Public NotInheritable Class ForStatementSyntax
        Inherits ForOrForEachStatementSyntax

        Friend _fromValue as ExpressionSyntax
        Friend _toValue as ExpressionSyntax
        Friend _stepClause as ForStepClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStatementSyntax(kind, errors, annotations, forKeyword, DirectCast(controlVariable.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.VisualBasicSyntaxNode), equalsToken, DirectCast(fromValue.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), toKeyword, DirectCast(toValue.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), if(stepClause IsNot Nothing , DirectCast(stepClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStepClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "For" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property ForKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStatementSyntax)._forKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetForKeywordCore() As SyntaxToken
            Return Me.ForKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ForKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithForKeyword(forKeyword as SyntaxToken) As ForStatementSyntax
            return Update(forKeyword, Me.ControlVariable, Me.EqualsToken, Me.FromValue, Me.ToKeyword, Me.ToValue, Me.StepClause)
        End Function

        ''' <summary>
        ''' If the For or For Each statement is of a form that does not declare a new loop
        ''' control variable, this is the expression that denotes the loop control
        ''' variable. If this loop is of a form that does declare a new control variable,
        ''' this is a VariableDeclarator that has the variable being declared.
        ''' </summary>
        Public Shadows ReadOnly Property ControlVariable As VisualBasicSyntaxNode
            Get
                Return GetRed(_controlVariable, 1)
            End Get
        End Property

        Friend Overrides Function GetControlVariableCore() As VisualBasicSyntaxNode
            Return Me.ControlVariable
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ControlVariable property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithControlVariable(controlVariable as VisualBasicSyntaxNode) As ForStatementSyntax
            return Update(Me.ForKeyword, controlVariable, Me.EqualsToken, Me.FromValue, Me.ToKeyword, Me.ToValue, Me.StepClause)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Public  ReadOnly Property EqualsToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStatementSyntax)._equalsToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EqualsToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEqualsToken(equalsToken as SyntaxToken) As ForStatementSyntax
            return Update(Me.ForKeyword, Me.ControlVariable, equalsToken, Me.FromValue, Me.ToKeyword, Me.ToValue, Me.StepClause)
        End Function

        ''' <summary>
        ''' The expression denoting the initial value of the iteration.
        ''' </summary>
        Public  ReadOnly Property FromValue As ExpressionSyntax
            Get
                Return GetRed(_fromValue, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the FromValue property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithFromValue(fromValue as ExpressionSyntax) As ForStatementSyntax
            return Update(Me.ForKeyword, Me.ControlVariable, Me.EqualsToken, fromValue, Me.ToKeyword, Me.ToValue, Me.StepClause)
        End Function

        ''' <summary>
        ''' The "To" keyword.
        ''' </summary>
        Public  ReadOnly Property ToKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStatementSyntax)._toKeyword, Me.GetChildPosition(4), Me.GetChildIndex(4))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ToKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithToKeyword(toKeyword as SyntaxToken) As ForStatementSyntax
            return Update(Me.ForKeyword, Me.ControlVariable, Me.EqualsToken, Me.FromValue, toKeyword, Me.ToValue, Me.StepClause)
        End Function

        ''' <summary>
        ''' The expression denoting the final value of the iteration.
        ''' </summary>
        Public  ReadOnly Property ToValue As ExpressionSyntax
            Get
                Return GetRed(_toValue, 5)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ToValue property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithToValue(toValue as ExpressionSyntax) As ForStatementSyntax
            return Update(Me.ForKeyword, Me.ControlVariable, Me.EqualsToken, Me.FromValue, Me.ToKeyword, toValue, Me.StepClause)
        End Function

        ''' <summary>
        ''' The optional Step clause.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property StepClause As ForStepClauseSyntax
            Get
                Return GetRed(_stepClause, 6)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the StepClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStepClause(stepClause as ForStepClauseSyntax) As ForStatementSyntax
            return Update(Me.ForKeyword, Me.ControlVariable, Me.EqualsToken, Me.FromValue, Me.ToKeyword, Me.ToValue, stepClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._controlVariable
                Case 3
                    Return Me._fromValue
                Case 5
                    Return Me._toValue
                Case 6
                    Return Me._stepClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.ControlVariable
                Case 3
                    Return Me.FromValue
                Case 5
                    Return Me.ToValue
                Case 6
                    Return Me.StepClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitForStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitForStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="forKeyword">
        ''' The value for the ForKeyword property.
        ''' </param>
        ''' <param name="controlVariable">
        ''' The value for the ControlVariable property.
        ''' </param>
        ''' <param name="equalsToken">
        ''' The value for the EqualsToken property.
        ''' </param>
        ''' <param name="fromValue">
        ''' The value for the FromValue property.
        ''' </param>
        ''' <param name="toKeyword">
        ''' The value for the ToKeyword property.
        ''' </param>
        ''' <param name="toValue">
        ''' The value for the ToValue property.
        ''' </param>
        ''' <param name="stepClause">
        ''' The value for the StepClause property.
        ''' </param>
        Public Function Update(forKeyword As SyntaxToken, controlVariable As VisualBasicSyntaxNode, equalsToken As SyntaxToken, fromValue As ExpressionSyntax, toKeyword As SyntaxToken, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax) As ForStatementSyntax
            If forKeyword <> Me.ForKeyword OrElse controlVariable IsNot Me.ControlVariable OrElse equalsToken <> Me.EqualsToken OrElse fromValue IsNot Me.FromValue OrElse toKeyword <> Me.ToKeyword OrElse toValue IsNot Me.ToValue OrElse stepClause IsNot Me.StepClause Then
                Dim newNode = SyntaxFactory.ForStatement(forKeyword, controlVariable, equalsToken, fromValue, toKeyword, toValue, stepClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The Step clause in a For Statement.
    ''' </summary>
    Public NotInheritable Class ForStepClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _stepValue as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStepClauseSyntax(kind, errors, annotations, stepKeyword, DirectCast(stepValue.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Step" keyword.
        ''' </summary>
        Public  ReadOnly Property StepKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForStepClauseSyntax)._stepKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the StepKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStepKeyword(stepKeyword as SyntaxToken) As ForStepClauseSyntax
            return Update(stepKeyword, Me.StepValue)
        End Function

        ''' <summary>
        ''' The expression denoting the step increment.
        ''' </summary>
        Public  ReadOnly Property StepValue As ExpressionSyntax
            Get
                Return GetRed(_stepValue, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the StepValue property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithStepValue(stepValue as ExpressionSyntax) As ForStepClauseSyntax
            return Update(Me.StepKeyword, stepValue)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._stepValue
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.StepValue
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitForStepClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitForStepClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="stepKeyword">
        ''' The value for the StepKeyword property.
        ''' </param>
        ''' <param name="stepValue">
        ''' The value for the StepValue property.
        ''' </param>
        Public Function Update(stepKeyword As SyntaxToken, stepValue As ExpressionSyntax) As ForStepClauseSyntax
            If stepKeyword <> Me.StepKeyword OrElse stepValue IsNot Me.StepValue Then
                Dim newNode = SyntaxFactory.ForStepClause(stepKeyword, stepValue)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The For Each statement that begins a For Each-Next block. This statement always
    ''' occurs as the Begin of a ForBlock, and the body of the For Each-Next is the
    ''' Body of that ForBlock. Most of the time, the End of that ForBlock is the
    ''' corresponding Next statement. However, multiple nested For statements are ended
    ''' by a single Next statement with multiple variables, then the inner For
    ''' statements will have End set to Nothing, and the Next statement is the End of
    ''' the outermost For statement that is being ended.
    ''' </summary>
    Public NotInheritable Class ForEachStatementSyntax
        Inherits ForOrForEachStatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForEachStatementSyntax(kind, errors, annotations, forKeyword, eachKeyword, DirectCast(controlVariable.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.VisualBasicSyntaxNode), inKeyword, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "For" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property ForKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForEachStatementSyntax)._forKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetForKeywordCore() As SyntaxToken
            Return Me.ForKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ForKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithForKeyword(forKeyword as SyntaxToken) As ForEachStatementSyntax
            return Update(forKeyword, Me.EachKeyword, Me.ControlVariable, Me.InKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The "Each" keyword.
        ''' </summary>
        Public  ReadOnly Property EachKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForEachStatementSyntax)._eachKeyword, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EachKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEachKeyword(eachKeyword as SyntaxToken) As ForEachStatementSyntax
            return Update(Me.ForKeyword, eachKeyword, Me.ControlVariable, Me.InKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' If the For or For Each statement is of a form that does not declare a new loop
        ''' control variable, this is the expression that denotes the loop control
        ''' variable. If this loop is of a form that does declare a new control variable,
        ''' this is a VariableDeclarator that has the variable being declared.
        ''' </summary>
        Public Shadows ReadOnly Property ControlVariable As VisualBasicSyntaxNode
            Get
                Return GetRed(_controlVariable, 2)
            End Get
        End Property

        Friend Overrides Function GetControlVariableCore() As VisualBasicSyntaxNode
            Return Me.ControlVariable
        End Function

        ''' <summary>
        ''' Returns a copy of this with the ControlVariable property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithControlVariable(controlVariable as VisualBasicSyntaxNode) As ForEachStatementSyntax
            return Update(Me.ForKeyword, Me.EachKeyword, controlVariable, Me.InKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The "In" keyword.
        ''' </summary>
        Public  ReadOnly Property InKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ForEachStatementSyntax)._inKeyword, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the InKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInKeyword(inKeyword as SyntaxToken) As ForEachStatementSyntax
            return Update(Me.ForKeyword, Me.EachKeyword, Me.ControlVariable, inKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The expression denoting the collection to iterate over.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As ForEachStatementSyntax
            return Update(Me.ForKeyword, Me.EachKeyword, Me.ControlVariable, Me.InKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._controlVariable
                Case 4
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.ControlVariable
                Case 4
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitForEachStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitForEachStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="forKeyword">
        ''' The value for the ForKeyword property.
        ''' </param>
        ''' <param name="eachKeyword">
        ''' The value for the EachKeyword property.
        ''' </param>
        ''' <param name="controlVariable">
        ''' The value for the ControlVariable property.
        ''' </param>
        ''' <param name="inKeyword">
        ''' The value for the InKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(forKeyword As SyntaxToken, eachKeyword As SyntaxToken, controlVariable As VisualBasicSyntaxNode, inKeyword As SyntaxToken, expression As ExpressionSyntax) As ForEachStatementSyntax
            If forKeyword <> Me.ForKeyword OrElse eachKeyword <> Me.EachKeyword OrElse controlVariable IsNot Me.ControlVariable OrElse inKeyword <> Me.InKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.ForEachStatement(forKeyword, eachKeyword, controlVariable, inKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The Next statement that ends a For-Next or For Each-Next block. This statement
    ''' always occurs as the End of a ForBlock (with Kind=ForBlock or ForEachBlock),
    ''' and the body of the For-Next is the Body of that ForBlock. The Begin of that
    ''' ForBlock has the corresponding For or For Each statement.
    ''' </summary>
    Public NotInheritable Class NextStatementSyntax
        Inherits StatementSyntax

        Friend _controlVariables as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NextStatementSyntax(kind, errors, annotations, nextKeyword, if(controlVariables IsNot Nothing, controlVariables.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Next" keyword.
        ''' </summary>
        Public  ReadOnly Property NextKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NextStatementSyntax)._nextKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the NextKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNextKeyword(nextKeyword as SyntaxToken) As NextStatementSyntax
            return Update(nextKeyword, Me.ControlVariables)
        End Function

        ''' <summary>
        ''' The variables in the Next statement, if present
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property ControlVariables As SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Dim listNode = GetRed(_controlVariables, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ExpressionSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ControlVariables property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithControlVariables(controlVariables as SeparatedSyntaxList(Of ExpressionSyntax)) As NextStatementSyntax
            return Update(Me.NextKeyword, controlVariables)
        End Function

        Public Shadows Function AddControlVariables(ParamArray items As ExpressionSyntax()) As NextStatementSyntax
            Return Me.WithControlVariables(Me.ControlVariables.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._controlVariables
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_controlVariables, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitNextStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitNextStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="nextKeyword">
        ''' The value for the NextKeyword property.
        ''' </param>
        ''' <param name="controlVariables">
        ''' The value for the ControlVariables property.
        ''' </param>
        Public Function Update(nextKeyword As SyntaxToken, controlVariables As SeparatedSyntaxList(Of ExpressionSyntax)) As NextStatementSyntax
            If nextKeyword <> Me.NextKeyword OrElse controlVariables <> Me.ControlVariables Then
                Dim newNode = SyntaxFactory.NextStatement(nextKeyword, controlVariables)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' The Using statement that begins a Using block. This statement always occurs as
    ''' the Begin of a UsingBlock, and the body of the Using is the Body of that
    ''' UsingBlock.
    ''' </summary>
    Public NotInheritable Class UsingStatementSyntax
        Inherits StatementSyntax

        Friend _expression as ExpressionSyntax
        Friend _variables as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.UsingStatementSyntax(kind, errors, annotations, usingKeyword, if(expression IsNot Nothing , DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), Nothing) , if(variables IsNot Nothing, variables.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Using" keyword.
        ''' </summary>
        Public  ReadOnly Property UsingKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.UsingStatementSyntax)._usingKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the UsingKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithUsingKeyword(usingKeyword as SyntaxToken) As UsingStatementSyntax
            return Update(usingKeyword, Me.Expression, Me.Variables)
        End Function

        ''' <summary>
        ''' If the Using statement is of a form that does not declare a new variable, this
        ''' is the expression used in the using. Otherwise, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As UsingStatementSyntax
            return Update(Me.UsingKeyword, expression, Me.Variables)
        End Function

        ''' <summary>
        ''' If the Using statement is of a form that declares one or more new variables,
        ''' this is the list of variable declarations. Otherwise, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Variables As SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Dim listNode = GetRed(_variables, 2)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of VariableDeclaratorSyntax)(listNode, Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Variables property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithVariables(variables as SeparatedSyntaxList(Of VariableDeclaratorSyntax)) As UsingStatementSyntax
            return Update(Me.UsingKeyword, Me.Expression, variables)
        End Function

        Public Shadows Function AddVariables(ParamArray items As VariableDeclaratorSyntax()) As UsingStatementSyntax
            Return Me.WithVariables(Me.Variables.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._variables
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case 2
                    Return GetRed(_variables, 2)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitUsingStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitUsingStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="usingKeyword">
        ''' The value for the UsingKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        ''' <param name="variables">
        ''' The value for the Variables property.
        ''' </param>
        Public Function Update(usingKeyword As SyntaxToken, expression As ExpressionSyntax, variables As SeparatedSyntaxList(Of VariableDeclaratorSyntax)) As UsingStatementSyntax
            If usingKeyword <> Me.UsingKeyword OrElse expression IsNot Me.Expression OrElse variables <> Me.Variables Then
                Dim newNode = SyntaxFactory.UsingStatement(usingKeyword, expression, variables)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a Throw statement.
    ''' </summary>
    Public NotInheritable Class ThrowStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ThrowStatementSyntax(kind, errors, annotations, throwKeyword, if(expression IsNot Nothing , DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Throw" keyword
        ''' </summary>
        Public  ReadOnly Property ThrowKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ThrowStatementSyntax)._throwKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ThrowKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithThrowKeyword(throwKeyword as SyntaxToken) As ThrowStatementSyntax
            return Update(throwKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The expression denoting the value being thrown.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As ThrowStatementSyntax
            return Update(Me.ThrowKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitThrowStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitThrowStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="throwKeyword">
        ''' The value for the ThrowKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(throwKeyword As SyntaxToken, expression As ExpressionSyntax) As ThrowStatementSyntax
            If throwKeyword <> Me.ThrowKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.ThrowStatement(throwKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a simple, compound, or Mid assignment statement. Which one can be
    ''' determined by checking the Kind.
    ''' </summary>
    Public NotInheritable Class AssignmentStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _left as ExpressionSyntax
        Friend _right as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AssignmentStatementSyntax(kind, errors, annotations, DirectCast(left.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), operatorToken, DirectCast(right.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The target (left hand side) of the assignment.
        ''' </summary>
        Public  ReadOnly Property Left As ExpressionSyntax
            Get
                Return GetRedAtZero(_left)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Left property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithLeft(left as ExpressionSyntax) As AssignmentStatementSyntax
            return Update(Me.Kind, left, Me.OperatorToken, Me.Right)
        End Function

        ''' <summary>
        ''' The operator used in the assignment statement. One of "=", "+=", "-=", "*=",
        ''' "/=", "\=", "^=", "&amp;=", "&lt;&lt;=" or "&gt;&gt;=".
        ''' </summary>
        Public  ReadOnly Property OperatorToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AssignmentStatementSyntax)._operatorToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOperatorToken(operatorToken as SyntaxToken) As AssignmentStatementSyntax
            return Update(Me.Kind, Me.Left, operatorToken, Me.Right)
        End Function

        ''' <summary>
        ''' The source (right hand side) of the assignment.
        ''' </summary>
        Public  ReadOnly Property Right As ExpressionSyntax
            Get
                Return GetRed(_right, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Right property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithRight(right as ExpressionSyntax) As AssignmentStatementSyntax
            return Update(Me.Kind, Me.Left, Me.OperatorToken, right)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._left
                Case 2
                    Return Me._right
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.Left
                Case 2
                    Return Me.Right
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAssignmentStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAssignmentStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="left">
        ''' The value for the Left property.
        ''' </param>
        ''' <param name="operatorToken">
        ''' The value for the OperatorToken property.
        ''' </param>
        ''' <param name="right">
        ''' The value for the Right property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, left As ExpressionSyntax, operatorToken As SyntaxToken, right As ExpressionSyntax) As AssignmentStatementSyntax
            If kind <> Me.Kind OrElse left IsNot Me.Left OrElse operatorToken <> Me.OperatorToken OrElse right IsNot Me.Right Then
                Dim newNode = SyntaxFactory.AssignmentStatement(kind, left, operatorToken, right)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a left-hand side of a MidAssignment statement.
    ''' </summary>
    Public NotInheritable Class MidExpressionSyntax
        Inherits ExpressionSyntax

        Friend _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MidExpressionSyntax(kind, errors, annotations, mid, DirectCast(argumentList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Mid" possibly followed by a type character.
        ''' </summary>
        Public  ReadOnly Property Mid As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MidExpressionSyntax)._mid, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Mid property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithMid(mid as SyntaxToken) As MidExpressionSyntax
            return Update(mid, Me.ArgumentList)
        End Function

        ''' <summary>
        ''' The argument list.
        ''' </summary>
        Public  ReadOnly Property ArgumentList As ArgumentListSyntax
            Get
                Return GetRed(_argumentList, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArgumentList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArgumentList(argumentList as ArgumentListSyntax) As MidExpressionSyntax
            return Update(Me.Mid, argumentList)
        End Function

        Public Shadows Function AddArgumentListArguments(ParamArray items As ArgumentSyntax()) As MidExpressionSyntax
            Dim _child = If (Me.ArgumentList IsNot Nothing, Me.ArgumentList, SyntaxFactory.ArgumentList())
            Return Me.WithArgumentList(_child.AddArguments(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._argumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.ArgumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMidExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMidExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="mid">
        ''' The value for the Mid property.
        ''' </param>
        ''' <param name="argumentList">
        ''' The value for the ArgumentList property.
        ''' </param>
        Public Function Update(mid As SyntaxToken, argumentList As ArgumentListSyntax) As MidExpressionSyntax
            If mid <> Me.Mid OrElse argumentList IsNot Me.ArgumentList Then
                Dim newNode = SyntaxFactory.MidExpression(mid, argumentList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represent an call statement (also known as a invocation statement).
    ''' </summary>
    Public NotInheritable Class CallStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _invocation as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CallStatementSyntax(kind, errors, annotations, callKeyword, DirectCast(invocation.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Call" keyword.
        ''' </summary>
        Public  ReadOnly Property CallKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CallStatementSyntax)._callKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CallKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCallKeyword(callKeyword as SyntaxToken) As CallStatementSyntax
            return Update(callKeyword, Me.Invocation)
        End Function

        ''' <summary>
        ''' The expression denoting the call. This could be an Invocation or a MemberAccess
        ''' (in the case where no parentheses were supplied.)
        ''' </summary>
        Public  ReadOnly Property Invocation As ExpressionSyntax
            Get
                Return GetRed(_invocation, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Invocation property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInvocation(invocation as ExpressionSyntax) As CallStatementSyntax
            return Update(Me.CallKeyword, invocation)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._invocation
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Invocation
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitCallStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitCallStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="callKeyword">
        ''' The value for the CallKeyword property.
        ''' </param>
        ''' <param name="invocation">
        ''' The value for the Invocation property.
        ''' </param>
        Public Function Update(callKeyword As SyntaxToken, invocation As ExpressionSyntax) As CallStatementSyntax
            If callKeyword <> Me.CallKeyword OrElse invocation IsNot Me.Invocation Then
                Dim newNode = SyntaxFactory.CallStatement(callKeyword, invocation)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an AddHandler or RemoveHandler statement. The Kind property
    ''' determines which one.
    ''' </summary>
    Public NotInheritable Class AddRemoveHandlerStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _eventExpression as ExpressionSyntax
        Friend _delegateExpression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AddRemoveHandlerStatementSyntax(kind, errors, annotations, addHandlerOrRemoveHandlerKeyword, DirectCast(eventExpression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), commaToken, DirectCast(delegateExpression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "AddHandler" or "RemoveHandler" keyword.
        ''' </summary>
        Public  ReadOnly Property AddHandlerOrRemoveHandlerKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AddRemoveHandlerStatementSyntax)._addHandlerOrRemoveHandlerKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AddHandlerOrRemoveHandlerKeyword property
        ''' changed to the specified value. Returns this instance if the specified value is
        ''' the same as the current value.
        ''' </summary>
        Public Shadows Function WithAddHandlerOrRemoveHandlerKeyword(addHandlerOrRemoveHandlerKeyword as SyntaxToken) As AddRemoveHandlerStatementSyntax
            return Update(Me.Kind, addHandlerOrRemoveHandlerKeyword, Me.EventExpression, Me.CommaToken, Me.DelegateExpression)
        End Function

        ''' <summary>
        ''' The event being accessed.
        ''' </summary>
        Public  ReadOnly Property EventExpression As ExpressionSyntax
            Get
                Return GetRed(_eventExpression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EventExpression property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithEventExpression(eventExpression as ExpressionSyntax) As AddRemoveHandlerStatementSyntax
            return Update(Me.Kind, Me.AddHandlerOrRemoveHandlerKeyword, eventExpression, Me.CommaToken, Me.DelegateExpression)
        End Function

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Public  ReadOnly Property CommaToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AddRemoveHandlerStatementSyntax)._commaToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CommaToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithCommaToken(commaToken as SyntaxToken) As AddRemoveHandlerStatementSyntax
            return Update(Me.Kind, Me.AddHandlerOrRemoveHandlerKeyword, Me.EventExpression, commaToken, Me.DelegateExpression)
        End Function

        ''' <summary>
        ''' The delegate being added or removed.
        ''' </summary>
        Public  ReadOnly Property DelegateExpression As ExpressionSyntax
            Get
                Return GetRed(_delegateExpression, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the DelegateExpression property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithDelegateExpression(delegateExpression as ExpressionSyntax) As AddRemoveHandlerStatementSyntax
            return Update(Me.Kind, Me.AddHandlerOrRemoveHandlerKeyword, Me.EventExpression, Me.CommaToken, delegateExpression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._eventExpression
                Case 3
                    Return Me._delegateExpression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.EventExpression
                Case 3
                    Return Me.DelegateExpression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAddRemoveHandlerStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAddRemoveHandlerStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="addHandlerOrRemoveHandlerKeyword">
        ''' The value for the AddHandlerOrRemoveHandlerKeyword property.
        ''' </param>
        ''' <param name="eventExpression">
        ''' The value for the EventExpression property.
        ''' </param>
        ''' <param name="commaToken">
        ''' The value for the CommaToken property.
        ''' </param>
        ''' <param name="delegateExpression">
        ''' The value for the DelegateExpression property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, addHandlerOrRemoveHandlerKeyword As SyntaxToken, eventExpression As ExpressionSyntax, commaToken As SyntaxToken, delegateExpression As ExpressionSyntax) As AddRemoveHandlerStatementSyntax
            If kind <> Me.Kind OrElse addHandlerOrRemoveHandlerKeyword <> Me.AddHandlerOrRemoveHandlerKeyword OrElse eventExpression IsNot Me.EventExpression OrElse commaToken <> Me.CommaToken OrElse delegateExpression IsNot Me.DelegateExpression Then
                Dim newNode = SyntaxFactory.AddRemoveHandlerStatement(kind, addHandlerOrRemoveHandlerKeyword, eventExpression, commaToken, delegateExpression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represent a RaiseEvent statement.
    ''' </summary>
    Public NotInheritable Class RaiseEventStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _name as IdentifierNameSyntax
        Friend _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RaiseEventStatementSyntax(kind, errors, annotations, raiseEventKeyword, DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.IdentifierNameSyntax), if(argumentList IsNot Nothing , DirectCast(argumentList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "RaiseEvent" keyword
        ''' </summary>
        Public  ReadOnly Property RaiseEventKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RaiseEventStatementSyntax)._raiseEventKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the RaiseEventKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithRaiseEventKeyword(raiseEventKeyword as SyntaxToken) As RaiseEventStatementSyntax
            return Update(raiseEventKeyword, Me.Name, Me.ArgumentList)
        End Function

        ''' <summary>
        ''' The name of the event being raised.
        ''' </summary>
        Public  ReadOnly Property Name As IdentifierNameSyntax
            Get
                Return GetRed(_name, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as IdentifierNameSyntax) As RaiseEventStatementSyntax
            return Update(Me.RaiseEventKeyword, name, Me.ArgumentList)
        End Function

        ''' <summary>
        ''' The argument list, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ArgumentList As ArgumentListSyntax
            Get
                Return GetRed(_argumentList, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArgumentList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArgumentList(argumentList as ArgumentListSyntax) As RaiseEventStatementSyntax
            return Update(Me.RaiseEventKeyword, Me.Name, argumentList)
        End Function

        Public Shadows Function AddArgumentListArguments(ParamArray items As ArgumentSyntax()) As RaiseEventStatementSyntax
            Dim _child = If (Me.ArgumentList IsNot Nothing, Me.ArgumentList, SyntaxFactory.ArgumentList())
            Return Me.WithArgumentList(_child.AddArguments(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._name
                Case 2
                    Return Me._argumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Name
                Case 2
                    Return Me.ArgumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitRaiseEventStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitRaiseEventStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="raiseEventKeyword">
        ''' The value for the RaiseEventKeyword property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        ''' <param name="argumentList">
        ''' The value for the ArgumentList property.
        ''' </param>
        Public Function Update(raiseEventKeyword As SyntaxToken, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax) As RaiseEventStatementSyntax
            If raiseEventKeyword <> Me.RaiseEventKeyword OrElse name IsNot Me.Name OrElse argumentList IsNot Me.ArgumentList Then
                Dim newNode = SyntaxFactory.RaiseEventStatement(raiseEventKeyword, name, argumentList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a "With" statement. This statement always occurs as the
    ''' BeginStatement of a WithBlock, and the body of the With is the Body of that
    ''' WithBlock.
    ''' </summary>
    Public NotInheritable Class WithStatementSyntax
        Inherits StatementSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithStatementSyntax(kind, errors, annotations, withKeyword, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "With" keyword.
        ''' </summary>
        Public  ReadOnly Property WithKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.WithStatementSyntax)._withKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the WithKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithWithKeyword(withKeyword as SyntaxToken) As WithStatementSyntax
            return Update(withKeyword, Me.Expression)
        End Function

        ''' <summary>
        ''' The expression that is the operand of the With statement.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As WithStatementSyntax
            return Update(Me.WithKeyword, expression)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitWithStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitWithStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="withKeyword">
        ''' The value for the WithKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        Public Function Update(withKeyword As SyntaxToken, expression As ExpressionSyntax) As WithStatementSyntax
            If withKeyword <> Me.WithKeyword OrElse expression IsNot Me.Expression Then
                Dim newNode = SyntaxFactory.WithStatement(withKeyword, expression)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a ReDim statement.
    ''' </summary>
    Public NotInheritable Class ReDimStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _clauses as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ReDimStatementSyntax(kind, errors, annotations, reDimKeyword, preserveKeyword, if(clauses IsNot Nothing, clauses.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "ReDim" keyword.
        ''' </summary>
        Public  ReadOnly Property ReDimKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ReDimStatementSyntax)._reDimKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ReDimKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithReDimKeyword(reDimKeyword as SyntaxToken) As ReDimStatementSyntax
            return Update(Me.Kind, reDimKeyword, Me.PreserveKeyword, Me.Clauses)
        End Function

        ''' <summary>
        ''' Returns Nothing if Kind=ReDim, returns the "Preserve" keyword if
        ''' Kind=RedimPreserve.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property PreserveKeyword As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ReDimStatementSyntax)._preserveKeyword
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(1), Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the PreserveKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithPreserveKeyword(preserveKeyword as SyntaxToken) As ReDimStatementSyntax
            return Update(Me.Kind, Me.ReDimKeyword, preserveKeyword, Me.Clauses)
        End Function

        ''' <summary>
        ''' The list of ReDim clauses.
        ''' </summary>
        Public  ReadOnly Property Clauses As SeparatedSyntaxList(Of RedimClauseSyntax)
            Get
                Dim listNode = GetRed(_clauses, 2)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of RedimClauseSyntax)(listNode, Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Clauses property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithClauses(clauses as SeparatedSyntaxList(Of RedimClauseSyntax)) As ReDimStatementSyntax
            return Update(Me.Kind, Me.ReDimKeyword, Me.PreserveKeyword, clauses)
        End Function

        Public Shadows Function AddClauses(ParamArray items As RedimClauseSyntax()) As ReDimStatementSyntax
            Return Me.WithClauses(Me.Clauses.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._clauses
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return GetRed(_clauses, 2)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitReDimStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitReDimStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="reDimKeyword">
        ''' The value for the ReDimKeyword property.
        ''' </param>
        ''' <param name="preserveKeyword">
        ''' The value for the PreserveKeyword property.
        ''' </param>
        ''' <param name="clauses">
        ''' The value for the Clauses property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, reDimKeyword As SyntaxToken, preserveKeyword As SyntaxToken, clauses As SeparatedSyntaxList(Of RedimClauseSyntax)) As ReDimStatementSyntax
            If kind <> Me.Kind OrElse reDimKeyword <> Me.ReDimKeyword OrElse preserveKeyword <> Me.PreserveKeyword OrElse clauses <> Me.Clauses Then
                Dim newNode = SyntaxFactory.ReDimStatement(kind, reDimKeyword, preserveKeyword, clauses)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a ReDim statement clause.
    ''' </summary>
    Public NotInheritable Class RedimClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend _expression as ExpressionSyntax
        Friend _arrayBounds as ArgumentListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.RedimClauseSyntax(kind, errors, annotations, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), DirectCast(arrayBounds.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The target of the ReDim statement.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRedAtZero(_expression)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As RedimClauseSyntax
            return Update(expression, Me.ArrayBounds)
        End Function

        ''' <summary>
        ''' The ArraySizeInitializationModifier.
        ''' </summary>
        Public  ReadOnly Property ArrayBounds As ArgumentListSyntax
            Get
                Return GetRed(_arrayBounds, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArrayBounds property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArrayBounds(arrayBounds as ArgumentListSyntax) As RedimClauseSyntax
            return Update(Me.Expression, arrayBounds)
        End Function

        Public Shadows Function AddArrayBoundsArguments(ParamArray items As ArgumentSyntax()) As RedimClauseSyntax
            Dim _child = If (Me.ArrayBounds IsNot Nothing, Me.ArrayBounds, SyntaxFactory.ArgumentList())
            Return Me.WithArrayBounds(_child.AddArguments(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._arrayBounds
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.Expression
                Case 1
                    Return Me.ArrayBounds
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitRedimClause(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitRedimClause(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        ''' <param name="arrayBounds">
        ''' The value for the ArrayBounds property.
        ''' </param>
        Public Function Update(expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax) As RedimClauseSyntax
            If expression IsNot Me.Expression OrElse arrayBounds IsNot Me.ArrayBounds Then
                Dim newNode = SyntaxFactory.RedimClause(expression, arrayBounds)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an "Erase" statement.
    ''' </summary>
    Public NotInheritable Class EraseStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend _expressions as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eraseKeyword As InternalSyntax.KeywordSyntax, expressions As SyntaxNode)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EraseStatementSyntax(kind, errors, annotations, eraseKeyword, if(expressions IsNot Nothing, expressions.Green, Nothing)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Erase" keyword.
        ''' </summary>
        Public  ReadOnly Property EraseKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.EraseStatementSyntax)._eraseKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the EraseKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithEraseKeyword(eraseKeyword as SyntaxToken) As EraseStatementSyntax
            return Update(eraseKeyword, Me.Expressions)
        End Function

        ''' <summary>
        ''' A list of expressions denoting the arrays to erase.
        ''' </summary>
        Public  ReadOnly Property Expressions As SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Dim listNode = GetRed(_expressions, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ExpressionSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expressions property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpressions(expressions as SeparatedSyntaxList(Of ExpressionSyntax)) As EraseStatementSyntax
            return Update(Me.EraseKeyword, expressions)
        End Function

        Public Shadows Function AddExpressions(ParamArray items As ExpressionSyntax()) As EraseStatementSyntax
            Return Me.WithExpressions(Me.Expressions.AddRange(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expressions
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_expressions, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitEraseStatement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitEraseStatement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="eraseKeyword">
        ''' The value for the EraseKeyword property.
        ''' </param>
        ''' <param name="expressions">
        ''' The value for the Expressions property.
        ''' </param>
        Public Function Update(eraseKeyword As SyntaxToken, expressions As SeparatedSyntaxList(Of ExpressionSyntax)) As EraseStatementSyntax
            If eraseKeyword <> Me.EraseKeyword OrElse expressions <> Me.Expressions Then
                Dim newNode = SyntaxFactory.EraseStatement(eraseKeyword, expressions)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' An abstract base class for all node classes that define expressions.
    ''' </summary>
    Public MustInherit Class ExpressionSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a literal. The kind of literal is determined by the Kind property:
    ''' IntegerLiteral, CharacterLiteral, BooleanLiteral, DecimalLiteral,
    ''' FloatingLiteral, DateLiteral or StringLiteral. The value of the literal can be
    ''' determined by casting the associated Token to the correct type and getting the
    ''' value from the token.
    ''' </summary>
    Public NotInheritable Class LiteralExpressionSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), token As InternalSyntax.SyntaxToken)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LiteralExpressionSyntax(kind, errors, annotations, token), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The token that represents the literal. The Kind property determines what type
        ''' this property returns: Kind=IntegerLiteral ==&gt; Returns IntegerLiteralToken.
        ''' Kind=CharacterLiteral ==&gt; Returns CharacterLiteralToken. Kind=DecimalLiteral
        ''' ==&gt; Returns DecimalLiteralToken Kind=FloatingLiteral ==&gt; Returns
        ''' FloatingLiteralToken Kind=DateLiteral ==&gt; Returns DateLiteralToken
        ''' Kind=StringLiteral ==&gt; Returns StringLiteralToken Kind=BooleanLiteral ==&gt;
        ''' Returns Keyword (with it's kind being TrueKeyword or FalseKeyword)
        ''' Kind=NothingLiteral ==&gt; Returns Keyword (with it's kind being
        ''' NothingKeyword)
        ''' </summary>
        Public  ReadOnly Property Token As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.LiteralExpressionSyntax)._token, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Token property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithToken(token as SyntaxToken) As LiteralExpressionSyntax
            return Update(Me.Kind, token)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitLiteralExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitLiteralExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="token">
        ''' The value for the Token property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, token As SyntaxToken) As LiteralExpressionSyntax
            If kind <> Me.Kind OrElse token <> Me.Token Then
                Dim newNode = SyntaxFactory.LiteralExpression(kind, token)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a parenthesized expression.
    ''' </summary>
    Public NotInheritable Class ParenthesizedExpressionSyntax
        Inherits ExpressionSyntax

        Friend _expression as ExpressionSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParenthesizedExpressionSyntax(kind, errors, annotations, openParenToken, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParenthesizedExpressionSyntax)._openParenToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As ParenthesizedExpressionSyntax
            return Update(openParenToken, Me.Expression, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The expression inside the parentheses.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As ParenthesizedExpressionSyntax
            return Update(Me.OpenParenToken, expression, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ParenthesizedExpressionSyntax)._closeParenToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As ParenthesizedExpressionSyntax
            return Update(Me.OpenParenToken, Me.Expression, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitParenthesizedExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitParenthesizedExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(openParenToken As SyntaxToken, expression As ExpressionSyntax, closeParenToken As SyntaxToken) As ParenthesizedExpressionSyntax
            If openParenToken <> Me.OpenParenToken OrElse expression IsNot Me.Expression OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.ParenthesizedExpression(openParenToken, expression, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a tuple literal expression.
    ''' </summary>
    Public NotInheritable Class TupleExpressionSyntax
        Inherits ExpressionSyntax

        Friend _arguments as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, arguments As SyntaxNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TupleExpressionSyntax(kind, errors, annotations, openParenToken, if(arguments IsNot Nothing, arguments.Green, Nothing), closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TupleExpressionSyntax)._openParenToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As TupleExpressionSyntax
            return Update(openParenToken, Me.Arguments, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The list of tuple arguments.
        ''' </summary>
        Public  ReadOnly Property Arguments As SeparatedSyntaxList(Of SimpleArgumentSyntax)
            Get
                Dim listNode = GetRed(_arguments, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of SimpleArgumentSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Arguments property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArguments(arguments as SeparatedSyntaxList(Of SimpleArgumentSyntax)) As TupleExpressionSyntax
            return Update(Me.OpenParenToken, arguments, Me.CloseParenToken)
        End Function

        Public Shadows Function AddArguments(ParamArray items As SimpleArgumentSyntax()) As TupleExpressionSyntax
            Return Me.WithArguments(Me.Arguments.AddRange(items))
        End Function

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TupleExpressionSyntax)._closeParenToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As TupleExpressionSyntax
            return Update(Me.OpenParenToken, Me.Arguments, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._arguments
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_arguments, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTupleExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTupleExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="arguments">
        ''' The value for the Arguments property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(openParenToken As SyntaxToken, arguments As SeparatedSyntaxList(Of SimpleArgumentSyntax), closeParenToken As SyntaxToken) As TupleExpressionSyntax
            If openParenToken <> Me.OpenParenToken OrElse arguments <> Me.Arguments OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.TupleExpression(openParenToken, arguments, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a tuple type expression.
    ''' </summary>
    Public NotInheritable Class TupleTypeSyntax
        Inherits TypeSyntax

        Friend _elements as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, elements As SyntaxNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TupleTypeSyntax(kind, errors, annotations, openParenToken, if(elements IsNot Nothing, elements.Green, Nothing), closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TupleTypeSyntax)._openParenToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As TupleTypeSyntax
            return Update(openParenToken, Me.Elements, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The list of tuple elements.
        ''' </summary>
        Public  ReadOnly Property Elements As SeparatedSyntaxList(Of TupleElementSyntax)
            Get
                Dim listNode = GetRed(_elements, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of TupleElementSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Elements property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithElements(elements as SeparatedSyntaxList(Of TupleElementSyntax)) As TupleTypeSyntax
            return Update(Me.OpenParenToken, elements, Me.CloseParenToken)
        End Function

        Public Shadows Function AddElements(ParamArray items As TupleElementSyntax()) As TupleTypeSyntax
            Return Me.WithElements(Me.Elements.AddRange(items))
        End Function

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TupleTypeSyntax)._closeParenToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As TupleTypeSyntax
            return Update(Me.OpenParenToken, Me.Elements, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._elements
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_elements, 1)
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTupleType(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTupleType(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="elements">
        ''' The value for the Elements property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(openParenToken As SyntaxToken, elements As SeparatedSyntaxList(Of TupleElementSyntax), closeParenToken As SyntaxToken) As TupleTypeSyntax
            If openParenToken <> Me.OpenParenToken OrElse elements <> Me.Elements OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.TupleType(openParenToken, elements, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element.
    ''' </summary>
    Public MustInherit Class TupleElementSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element supplying only the type.
    ''' </summary>
    Public NotInheritable Class TypedTupleElementSyntax
        Inherits TupleElementSyntax

        Friend _type as TypeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), type As TypeSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypedTupleElementSyntax(kind, errors, annotations, DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The type-name part of the tuple element syntax.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRedAtZero(_type)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As TypedTupleElementSyntax
            return Update(type)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me._type
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Me.Type
            Else
                Return Nothing
            End If
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypedTupleElement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypedTupleElement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        Public Function Update(type As TypeSyntax) As TypedTupleElementSyntax
            If type IsNot Me.Type Then
                Dim newNode = SyntaxFactory.TypedTupleElement(type)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element supplying element name and
    ''' optionally a type.
    ''' </summary>
    Public NotInheritable Class NamedTupleElementSyntax
        Inherits TupleElementSyntax

        Friend _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamedTupleElementSyntax(kind, errors, annotations, identifier, if(asClause IsNot Nothing , DirectCast(asClause.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleAsClauseSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The name of the element.
        ''' </summary>
        Public  ReadOnly Property Identifier As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NamedTupleElementSyntax)._identifier, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Identifier property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithIdentifier(identifier as SyntaxToken) As NamedTupleElementSyntax
            return Update(identifier, Me.AsClause)
        End Function

        ''' <summary>
        ''' A simple "As" clause specifying the type of the tuple element.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property AsClause As SimpleAsClauseSyntax
            Get
                Return GetRed(_asClause, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the AsClause property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithAsClause(asClause as SimpleAsClauseSyntax) As NamedTupleElementSyntax
            return Update(Me.Identifier, asClause)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._asClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.AsClause
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitNamedTupleElement(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitNamedTupleElement(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="identifier">
        ''' The value for the Identifier property.
        ''' </param>
        ''' <param name="asClause">
        ''' The value for the AsClause property.
        ''' </param>
        Public Function Update(identifier As SyntaxToken, asClause As SimpleAsClauseSyntax) As NamedTupleElementSyntax
            If identifier <> Me.Identifier OrElse asClause IsNot Me.AsClause Then
                Dim newNode = SyntaxFactory.NamedTupleElement(identifier, asClause)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Identifies one of the special instances "Me", "MyClass" or "MyBase". The Kind
    ''' property identifies which.
    ''' </summary>
    Public MustInherit Class InstanceExpressionSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The "Me", "MyClass" or "MyBase" keyword.
        ''' </summary>
        Public ReadOnly Property Keyword As SyntaxToken
            Get
                Return Me.GetKeywordCore()
            End Get
        End Property

        Friend Overridable Function GetKeywordCore() As SyntaxToken
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InstanceExpressionSyntax)._keyword, Me.Position, 0)
        End Function


    End Class

    ''' <summary>
    ''' Identifies the special instance "Me"
    ''' </summary>
    Public NotInheritable Class MeExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MeExpressionSyntax(kind, errors, annotations, keyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Me", "MyClass" or "MyBase" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property Keyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MeExpressionSyntax)._keyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetKeywordCore() As SyntaxToken
            Return Me.Keyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Keyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithKeyword(keyword as SyntaxToken) As MeExpressionSyntax
            return Update(keyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMeExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMeExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="keyword">
        ''' The value for the Keyword property.
        ''' </param>
        Public Function Update(keyword As SyntaxToken) As MeExpressionSyntax
            If keyword <> Me.Keyword Then
                Dim newNode = SyntaxFactory.MeExpression(keyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Identifies the special instance "MyBase"
    ''' </summary>
    Public NotInheritable Class MyBaseExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MyBaseExpressionSyntax(kind, errors, annotations, keyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Me", "MyClass" or "MyBase" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property Keyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MyBaseExpressionSyntax)._keyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetKeywordCore() As SyntaxToken
            Return Me.Keyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Keyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithKeyword(keyword as SyntaxToken) As MyBaseExpressionSyntax
            return Update(keyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMyBaseExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMyBaseExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="keyword">
        ''' The value for the Keyword property.
        ''' </param>
        Public Function Update(keyword As SyntaxToken) As MyBaseExpressionSyntax
            If keyword <> Me.Keyword Then
                Dim newNode = SyntaxFactory.MyBaseExpression(keyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Identifies the special instance "MyClass"
    ''' </summary>
    Public NotInheritable Class MyClassExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MyClassExpressionSyntax(kind, errors, annotations, keyword), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "Me", "MyClass" or "MyBase" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property Keyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MyClassExpressionSyntax)._keyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetKeywordCore() As SyntaxToken
            Return Me.Keyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the Keyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithKeyword(keyword as SyntaxToken) As MyClassExpressionSyntax
            return Update(keyword)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            If i = 0 Then
                Return Nothing
            Else
                Return Nothing
            End If
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
                Return Nothing
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMyClassExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMyClassExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="keyword">
        ''' The value for the Keyword property.
        ''' </param>
        Public Function Update(keyword As SyntaxToken) As MyClassExpressionSyntax
            If keyword <> Me.Keyword Then
                Dim newNode = SyntaxFactory.MyClassExpression(keyword)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a GetType expression.
    ''' </summary>
    Public NotInheritable Class GetTypeExpressionSyntax
        Inherits ExpressionSyntax

        Friend _type as TypeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetTypeExpressionSyntax(kind, errors, annotations, getTypeKeyword, openParenToken, DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax), closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "GetType" keyword.
        ''' </summary>
        Public  ReadOnly Property GetTypeKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetTypeExpressionSyntax)._getTypeKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the GetTypeKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithGetTypeKeyword(getTypeKeyword as SyntaxToken) As GetTypeExpressionSyntax
            return Update(getTypeKeyword, Me.OpenParenToken, Me.Type, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetTypeExpressionSyntax)._openParenToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As GetTypeExpressionSyntax
            return Update(Me.GetTypeKeyword, openParenToken, Me.Type, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The type to get the Type object for. This can be an open generic type.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRed(_type, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As GetTypeExpressionSyntax
            return Update(Me.GetTypeKeyword, Me.OpenParenToken, type, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetTypeExpressionSyntax)._closeParenToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As GetTypeExpressionSyntax
            return Update(Me.GetTypeKeyword, Me.OpenParenToken, Me.Type, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._type
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.Type
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitGetTypeExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitGetTypeExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="getTypeKeyword">
        ''' The value for the GetTypeKeyword property.
        ''' </param>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(getTypeKeyword As SyntaxToken, openParenToken As SyntaxToken, type As TypeSyntax, closeParenToken As SyntaxToken) As GetTypeExpressionSyntax
            If getTypeKeyword <> Me.GetTypeKeyword OrElse openParenToken <> Me.OpenParenToken OrElse type IsNot Me.Type OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.GetTypeExpression(getTypeKeyword, openParenToken, type, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a TypeOf...Is or IsNot expression.
    ''' </summary>
    Public NotInheritable Class TypeOfExpressionSyntax
        Inherits ExpressionSyntax

        Friend _expression as ExpressionSyntax
        Friend _type as TypeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeOfExpressionSyntax(kind, errors, annotations, typeOfKeyword, DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), operatorToken, DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "TypeOf" keyword.
        ''' </summary>
        Public  ReadOnly Property TypeOfKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeOfExpressionSyntax)._typeOfKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the TypeOfKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithTypeOfKeyword(typeOfKeyword as SyntaxToken) As TypeOfExpressionSyntax
            return Update(Me.Kind, typeOfKeyword, Me.Expression, Me.OperatorToken, Me.Type)
        End Function

        ''' <summary>
        ''' The expression being tested.
        ''' </summary>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRed(_expression, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As TypeOfExpressionSyntax
            return Update(Me.Kind, Me.TypeOfKeyword, expression, Me.OperatorToken, Me.Type)
        End Function

        ''' <summary>
        ''' The "Is" or "IsNot" keyword.
        ''' </summary>
        Public  ReadOnly Property OperatorToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeOfExpressionSyntax)._operatorToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOperatorToken(operatorToken as SyntaxToken) As TypeOfExpressionSyntax
            return Update(Me.Kind, Me.TypeOfKeyword, Me.Expression, operatorToken, Me.Type)
        End Function

        ''' <summary>
        ''' The name of the type being tested against.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRed(_type, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As TypeOfExpressionSyntax
            return Update(Me.Kind, Me.TypeOfKeyword, Me.Expression, Me.OperatorToken, type)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._expression
                Case 3
                    Return Me._type
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me.Expression
                Case 3
                    Return Me.Type
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitTypeOfExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitTypeOfExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="typeOfKeyword">
        ''' The value for the TypeOfKeyword property.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        ''' <param name="operatorToken">
        ''' The value for the OperatorToken property.
        ''' </param>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, typeOfKeyword As SyntaxToken, expression As ExpressionSyntax, operatorToken As SyntaxToken, type As TypeSyntax) As TypeOfExpressionSyntax
            If kind <> Me.Kind OrElse typeOfKeyword <> Me.TypeOfKeyword OrElse expression IsNot Me.Expression OrElse operatorToken <> Me.OperatorToken OrElse type IsNot Me.Type Then
                Dim newNode = SyntaxFactory.TypeOfExpression(kind, typeOfKeyword, expression, operatorToken, type)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a GetXmlNamespace expression.
    ''' </summary>
    Public NotInheritable Class GetXmlNamespaceExpressionSyntax
        Inherits ExpressionSyntax

        Friend _name as XmlPrefixNameSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetXmlNamespaceExpressionSyntax(kind, errors, annotations, getXmlNamespaceKeyword, openParenToken, if(name IsNot Nothing , DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlPrefixNameSyntax), Nothing) , closeParenToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "GetXmlNamespace" keyword.
        ''' </summary>
        Public  ReadOnly Property GetXmlNamespaceKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetXmlNamespaceExpressionSyntax)._getXmlNamespaceKeyword, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the GetXmlNamespaceKeyword property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithGetXmlNamespaceKeyword(getXmlNamespaceKeyword as SyntaxToken) As GetXmlNamespaceExpressionSyntax
            return Update(getXmlNamespaceKeyword, Me.OpenParenToken, Me.Name, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Public  ReadOnly Property OpenParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetXmlNamespaceExpressionSyntax)._openParenToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenParenToken(openParenToken as SyntaxToken) As GetXmlNamespaceExpressionSyntax
            return Update(Me.GetXmlNamespaceKeyword, openParenToken, Me.Name, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The Xml namespace name being referenced.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Name As XmlPrefixNameSyntax
            Get
                Return GetRed(_name, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as XmlPrefixNameSyntax) As GetXmlNamespaceExpressionSyntax
            return Update(Me.GetXmlNamespaceKeyword, Me.OpenParenToken, name, Me.CloseParenToken)
        End Function

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Public  ReadOnly Property CloseParenToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.GetXmlNamespaceExpressionSyntax)._closeParenToken, Me.GetChildPosition(3), Me.GetChildIndex(3))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseParenToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithCloseParenToken(closeParenToken as SyntaxToken) As GetXmlNamespaceExpressionSyntax
            return Update(Me.GetXmlNamespaceKeyword, Me.OpenParenToken, Me.Name, closeParenToken)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me._name
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 2
                    Return Me.Name
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitGetXmlNamespaceExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitGetXmlNamespaceExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="getXmlNamespaceKeyword">
        ''' The value for the GetXmlNamespaceKeyword property.
        ''' </param>
        ''' <param name="openParenToken">
        ''' The value for the OpenParenToken property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        ''' <param name="closeParenToken">
        ''' The value for the CloseParenToken property.
        ''' </param>
        Public Function Update(getXmlNamespaceKeyword As SyntaxToken, openParenToken As SyntaxToken, name As XmlPrefixNameSyntax, closeParenToken As SyntaxToken) As GetXmlNamespaceExpressionSyntax
            If getXmlNamespaceKeyword <> Me.GetXmlNamespaceKeyword OrElse openParenToken <> Me.OpenParenToken OrElse name IsNot Me.Name OrElse closeParenToken <> Me.CloseParenToken Then
                Dim newNode = SyntaxFactory.GetXmlNamespaceExpression(getXmlNamespaceKeyword, openParenToken, name, closeParenToken)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents member access (.name) or dictionary access (!name). The Kind
    ''' property determines which kind of access.
    ''' </summary>
    Public NotInheritable Class MemberAccessExpressionSyntax
        Inherits ExpressionSyntax

        Friend _expression as ExpressionSyntax
        Friend _name as SimpleNameSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MemberAccessExpressionSyntax(kind, errors, annotations, if(expression IsNot Nothing , DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), Nothing) , operatorToken, DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.SimpleNameSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The expression on the left-hand-side of the "." or "!" token.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRedAtZero(_expression)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As MemberAccessExpressionSyntax
            return Update(Me.Kind, expression, Me.OperatorToken, Me.Name)
        End Function

        ''' <summary>
        ''' The "." or "!" token.
        ''' </summary>
        Public  ReadOnly Property OperatorToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.MemberAccessExpressionSyntax)._operatorToken, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OperatorToken property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithOperatorToken(operatorToken as SyntaxToken) As MemberAccessExpressionSyntax
            return Update(Me.Kind, Me.Expression, operatorToken, Me.Name)
        End Function

        ''' <summary>
        ''' The identifier after the "." or "!" token.
        ''' </summary>
        Public  ReadOnly Property Name As SimpleNameSyntax
            Get
                Return GetRed(_name, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as SimpleNameSyntax) As MemberAccessExpressionSyntax
            return Update(Me.Kind, Me.Expression, Me.OperatorToken, name)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._expression
                Case 2
                    Return Me._name
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.Expression
                Case 2
                    Return Me.Name
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitMemberAccessExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitMemberAccessExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        ''' <param name="operatorToken">
        ''' The value for the OperatorToken property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, expression As ExpressionSyntax, operatorToken As SyntaxToken, name As SimpleNameSyntax) As MemberAccessExpressionSyntax
            If kind <> Me.Kind OrElse expression IsNot Me.Expression OrElse operatorToken <> Me.OperatorToken OrElse name IsNot Me.Name Then
                Dim newNode = SyntaxFactory.MemberAccessExpression(kind, expression, operatorToken, name)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML member element access (node.&lt;Element&gt;), attribute
    ''' access (node.@Attribute) or descendants access (node...&lt;Descendant&gt;). The
    ''' Kind property determines which kind of access.
    ''' </summary>
    Public NotInheritable Class XmlMemberAccessExpressionSyntax
        Inherits ExpressionSyntax

        Friend _base as ExpressionSyntax
        Friend _name as XmlNodeSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlMemberAccessExpressionSyntax(kind, errors, annotations, if(base IsNot Nothing , DirectCast(base.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), Nothing) , token1, token2, token3, DirectCast(name.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlNodeSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The expression on the left-hand-side of the ".", ".@" or "..." .
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Base As ExpressionSyntax
            Get
                Return GetRedAtZero(_base)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Base property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithBase(base as ExpressionSyntax) As XmlMemberAccessExpressionSyntax
            return Update(Me.Kind, base, Me.Token1, Me.Token2, Me.Token3, Me.Name)
        End Function

        ''' <summary>
        ''' The initial dot "." part of the separator.
        ''' </summary>
        Public  ReadOnly Property Token1 As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlMemberAccessExpressionSyntax)._token1, Me.GetChildPosition(1), Me.GetChildIndex(1))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Token1 property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithToken1(token1 as SyntaxToken) As XmlMemberAccessExpressionSyntax
            return Update(Me.Kind, Me.Base, token1, Me.Token2, Me.Token3, Me.Name)
        End Function

        ''' <summary>
        ''' The "@" part of .@ or the second "." of "...".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Token2 As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlMemberAccessExpressionSyntax)._token2
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(2), Me.GetChildIndex(2))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Token2 property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithToken2(token2 as SyntaxToken) As XmlMemberAccessExpressionSyntax
            return Update(Me.Kind, Me.Base, Me.Token1, token2, Me.Token3, Me.Name)
        End Function

        ''' <summary>
        ''' The third "." in a "..." separator.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Token3 As SyntaxToken
            Get
                Dim slot = DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.XmlMemberAccessExpressionSyntax)._token3
                If slot IsNot Nothing
                    return new SyntaxToken(Me, slot, Me.GetChildPosition(3), Me.GetChildIndex(3))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Token3 property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithToken3(token3 as SyntaxToken) As XmlMemberAccessExpressionSyntax
            return Update(Me.Kind, Me.Base, Me.Token1, Me.Token2, token3, Me.Name)
        End Function

        ''' <summary>
        ''' The identifier after the ".", ".@" or "..."
        ''' </summary>
        Public  ReadOnly Property Name As XmlNodeSyntax
            Get
                Return GetRed(_name, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Name property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithName(name as XmlNodeSyntax) As XmlMemberAccessExpressionSyntax
            return Update(Me.Kind, Me.Base, Me.Token1, Me.Token2, Me.Token3, name)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._base
                Case 4
                    Return Me._name
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.Base
                Case 4
                    Return Me.Name
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitXmlMemberAccessExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitXmlMemberAccessExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="kind">
        ''' The new kind.
        ''' </param>
        ''' <param name="base">
        ''' The value for the Base property.
        ''' </param>
        ''' <param name="token1">
        ''' The value for the Token1 property.
        ''' </param>
        ''' <param name="token2">
        ''' The value for the Token2 property.
        ''' </param>
        ''' <param name="token3">
        ''' The value for the Token3 property.
        ''' </param>
        ''' <param name="name">
        ''' The value for the Name property.
        ''' </param>
        Public Function Update(kind As SyntaxKind, base As ExpressionSyntax, token1 As SyntaxToken, token2 As SyntaxToken, token3 As SyntaxToken, name As XmlNodeSyntax) As XmlMemberAccessExpressionSyntax
            If kind <> Me.Kind OrElse base IsNot Me.Base OrElse token1 <> Me.Token1 OrElse token2 <> Me.Token2 OrElse token3 <> Me.Token3 OrElse name IsNot Me.Name Then
                Dim newNode = SyntaxFactory.XmlMemberAccessExpression(kind, base, token1, token2, token3, name)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an invocation expression consisting of an invocation target and an
    ''' optional argument list or an array, parameterized property or object default
    ''' property index.
    ''' </summary>
    Public NotInheritable Class InvocationExpressionSyntax
        Inherits ExpressionSyntax

        Friend _expression as ExpressionSyntax
        Friend _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, argumentList As ArgumentListSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.InvocationExpressionSyntax(kind, errors, annotations, if(expression IsNot Nothing , DirectCast(expression.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ExpressionSyntax), Nothing) , if(argumentList IsNot Nothing , DirectCast(argumentList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The target of the call or index expression.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Expression As ExpressionSyntax
            Get
                Return GetRedAtZero(_expression)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Expression property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithExpression(expression as ExpressionSyntax) As InvocationExpressionSyntax
            return Update(expression, Me.ArgumentList)
        End Function

        ''' <summary>
        ''' The argument list.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ArgumentList As ArgumentListSyntax
            Get
                Return GetRed(_argumentList, 1)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArgumentList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArgumentList(argumentList as ArgumentListSyntax) As InvocationExpressionSyntax
            return Update(Me.Expression, argumentList)
        End Function

        Public Shadows Function AddArgumentListArguments(ParamArray items As ArgumentSyntax()) As InvocationExpressionSyntax
            Dim _child = If (Me.ArgumentList IsNot Nothing, Me.ArgumentList, SyntaxFactory.ArgumentList())
            Return Me.WithArgumentList(_child.AddArguments(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._argumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 0
                    Return Me.Expression
                Case 1
                    Return Me.ArgumentList
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitInvocationExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitInvocationExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="expression">
        ''' The value for the Expression property.
        ''' </param>
        ''' <param name="argumentList">
        ''' The value for the ArgumentList property.
        ''' </param>
        Public Function Update(expression As ExpressionSyntax, argumentList As ArgumentListSyntax) As InvocationExpressionSyntax
            If expression IsNot Me.Expression OrElse argumentList IsNot Me.ArgumentList Then
                Dim newNode = SyntaxFactory.InvocationExpression(expression, argumentList)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Base class for object, array and anonymous object creation expressions
    ''' </summary>
    Partial Public MustInherit Class NewExpressionSyntax
        Inherits ExpressionSyntax

        Friend _attributeLists as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        ''' <summary>
        ''' The "New" keyword.
        ''' </summary>
        Public ReadOnly Property NewKeyword As SyntaxToken
            Get
                Return Me.GetNewKeywordCore()
            End Get
        End Property

        Friend Overridable Function GetNewKeywordCore() As SyntaxToken
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.NewExpressionSyntax)._newKeyword, Me.Position, 0)
        End Function


        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Return Me.GetAttributeListsCore()
            End Get
        End Property

        Friend Overridable Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
                Dim listNode = GetRed(_attributeLists, 1)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
        End Function


    End Class

    ''' <summary>
    ''' Represents a New expression that creates a new non-array object, possibly with
    ''' a "With" or "From" clause.
    ''' </summary>
    Public NotInheritable Class ObjectCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend _type as TypeSyntax
        Friend _argumentList as ArgumentListSyntax
        Friend _initializer as ObjectCreationInitializerSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As SyntaxNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectCreationExpressionSyntax(kind, errors, annotations, newKeyword, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax), if(argumentList IsNot Nothing , DirectCast(argumentList.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax), Nothing) , if(initializer IsNot Nothing , DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectCreationInitializerSyntax), Nothing) ), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "New" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property NewKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectCreationExpressionSyntax)._newKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetNewKeywordCore() As SyntaxToken
            Return Me.NewKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the NewKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNewKeyword(newKeyword as SyntaxToken) As ObjectCreationExpressionSyntax
            return Update(newKeyword, Me.AttributeLists, Me.Type, Me.ArgumentList, Me.Initializer)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRed(_attributeLists, 1)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As ObjectCreationExpressionSyntax
            return Update(Me.NewKeyword, attributeLists, Me.Type, Me.ArgumentList, Me.Initializer)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As ObjectCreationExpressionSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' The type of the object being initialized.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRed(_type, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As ObjectCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, type, Me.ArgumentList, Me.Initializer)
        End Function

        ''' <summary>
        ''' The argument list, if present. If no argument list was supplied, Nothing is
        ''' returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ArgumentList As ArgumentListSyntax
            Get
                Return GetRed(_argumentList, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArgumentList property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArgumentList(argumentList as ArgumentListSyntax) As ObjectCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, Me.Type, argumentList, Me.Initializer)
        End Function

        Public Shadows Function AddArgumentListArguments(ParamArray items As ArgumentSyntax()) As ObjectCreationExpressionSyntax
            Dim _child = If (Me.ArgumentList IsNot Nothing, Me.ArgumentList, SyntaxFactory.ArgumentList())
            Return Me.WithArgumentList(_child.AddArguments(items))
        End Function

        ''' <summary>
        ''' An optional From or With clause to initialize the new object.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property Initializer As ObjectCreationInitializerSyntax
            Get
                Return GetRed(_initializer, 4)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as ObjectCreationInitializerSyntax) As ObjectCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, Me.Type, Me.ArgumentList, initializer)
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case 3
                    Return Me._argumentList
                Case 4
                    Return Me._initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_attributeLists, 1)
                Case 2
                    Return Me.Type
                Case 3
                    Return Me.ArgumentList
                Case 4
                    Return Me.Initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitObjectCreationExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitObjectCreationExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="newKeyword">
        ''' The value for the NewKeyword property.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        ''' <param name="argumentList">
        ''' The value for the ArgumentList property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        Public Function Update(newKeyword As SyntaxToken, attributeLists As SyntaxList(of AttributeListSyntax), type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax) As ObjectCreationExpressionSyntax
            If newKeyword <> Me.NewKeyword OrElse attributeLists <> Me.AttributeLists OrElse type IsNot Me.Type OrElse argumentList IsNot Me.ArgumentList OrElse initializer IsNot Me.Initializer Then
                Dim newNode = SyntaxFactory.ObjectCreationExpression(newKeyword, attributeLists, type, argumentList, initializer)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents a New expression that create an object of anonymous type.
    ''' </summary>
    Public NotInheritable Class AnonymousObjectCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend _initializer as ObjectMemberInitializerSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As SyntaxNode, initializer As ObjectMemberInitializerSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AnonymousObjectCreationExpressionSyntax(kind, errors, annotations, newKeyword, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ObjectMemberInitializerSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "New" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property NewKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.AnonymousObjectCreationExpressionSyntax)._newKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetNewKeywordCore() As SyntaxToken
            Return Me.NewKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the NewKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNewKeyword(newKeyword as SyntaxToken) As AnonymousObjectCreationExpressionSyntax
            return Update(newKeyword, Me.AttributeLists, Me.Initializer)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRed(_attributeLists, 1)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As AnonymousObjectCreationExpressionSyntax
            return Update(Me.NewKeyword, attributeLists, Me.Initializer)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As AnonymousObjectCreationExpressionSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' The With clause to initialize the new object.
        ''' </summary>
        Public  ReadOnly Property Initializer As ObjectMemberInitializerSyntax
            Get
                Return GetRed(_initializer, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as ObjectMemberInitializerSyntax) As AnonymousObjectCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, initializer)
        End Function

        Public Shadows Function AddInitializerInitializers(ParamArray items As FieldInitializerSyntax()) As AnonymousObjectCreationExpressionSyntax
            Dim _child = If (Me.Initializer IsNot Nothing, Me.Initializer, SyntaxFactory.ObjectMemberInitializer())
            Return Me.WithInitializer(_child.AddInitializers(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_attributeLists, 1)
                Case 2
                    Return Me.Initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitAnonymousObjectCreationExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitAnonymousObjectCreationExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="newKeyword">
        ''' The value for the NewKeyword property.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        Public Function Update(newKeyword As SyntaxToken, attributeLists As SyntaxList(of AttributeListSyntax), initializer As ObjectMemberInitializerSyntax) As AnonymousObjectCreationExpressionSyntax
            If newKeyword <> Me.NewKeyword OrElse attributeLists <> Me.AttributeLists OrElse initializer IsNot Me.Initializer Then
                Dim newNode = SyntaxFactory.AnonymousObjectCreationExpression(newKeyword, attributeLists, initializer)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an expression that creates a new array.
    ''' </summary>
    Public NotInheritable Class ArrayCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend _type as TypeSyntax
        Friend _arrayBounds as ArgumentListSyntax
        Friend _rankSpecifiers as SyntaxNode
        Friend _initializer as CollectionInitializerSyntax

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As SyntaxNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As SyntaxNode, initializer As CollectionInitializerSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArrayCreationExpressionSyntax(kind, errors, annotations, newKeyword, if(attributeLists IsNot Nothing, attributeLists.Green, Nothing), DirectCast(type.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.TypeSyntax), if(arrayBounds IsNot Nothing , DirectCast(arrayBounds.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArgumentListSyntax), Nothing) , if(rankSpecifiers IsNot Nothing, rankSpecifiers.Green, Nothing), DirectCast(initializer.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CollectionInitializerSyntax)), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "New" keyword.
        ''' </summary>
        Public Shadows ReadOnly Property NewKeyword As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.ArrayCreationExpressionSyntax)._newKeyword, Me.Position, 0)
            End Get
        End Property

        Friend Overrides Function GetNewKeywordCore() As SyntaxToken
            Return Me.NewKeyword
        End Function

        ''' <summary>
        ''' Returns a copy of this with the NewKeyword property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithNewKeyword(newKeyword as SyntaxToken) As ArrayCreationExpressionSyntax
            return Update(newKeyword, Me.AttributeLists, Me.Type, Me.ArrayBounds, Me.RankSpecifiers, Me.Initializer)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public Shadows ReadOnly Property AttributeLists As SyntaxList(Of AttributeListSyntax)
            Get
                Dim listNode = GetRed(_attributeLists, 1)
                Return new SyntaxList(Of AttributeListSyntax)(listNode)
            End Get
        End Property

        Friend Overrides Function GetAttributeListsCore() As SyntaxList(Of AttributeListSyntax)
            Return Me.AttributeLists
        End Function

        ''' <summary>
        ''' Returns a copy of this with the AttributeLists property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithAttributeLists(attributeLists as SyntaxList(Of AttributeListSyntax)) As ArrayCreationExpressionSyntax
            return Update(Me.NewKeyword, attributeLists, Me.Type, Me.ArrayBounds, Me.RankSpecifiers, Me.Initializer)
        End Function

        Public Shadows Function AddAttributeLists(ParamArray items As AttributeListSyntax()) As ArrayCreationExpressionSyntax
            Return Me.WithAttributeLists(Me.AttributeLists.AddRange(items))
        End Function

        ''' <summary>
        ''' The element type of the array being created.
        ''' </summary>
        Public  ReadOnly Property Type As TypeSyntax
            Get
                Return GetRed(_type, 2)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Type property changed to the specified value.
        ''' Returns this instance if the specified value is the same as the current value.
        ''' </summary>
        Public Shadows Function WithType(type as TypeSyntax) As ArrayCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, type, Me.ArrayBounds, Me.RankSpecifiers, Me.Initializer)
        End Function

        ''' <summary>
        ''' The optional array bounds, such as "(4)" or "(0 to 5, 0 To 6)".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Public  ReadOnly Property ArrayBounds As ArgumentListSyntax
            Get
                Return GetRed(_arrayBounds, 3)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the ArrayBounds property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithArrayBounds(arrayBounds as ArgumentListSyntax) As ArrayCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, Me.Type, arrayBounds, Me.RankSpecifiers, Me.Initializer)
        End Function

        Public Shadows Function AddArrayBoundsArguments(ParamArray items As ArgumentSyntax()) As ArrayCreationExpressionSyntax
            Dim _child = If (Me.ArrayBounds IsNot Nothing, Me.ArrayBounds, SyntaxFactory.ArgumentList())
            Return Me.WithArrayBounds(_child.AddArguments(items))
        End Function

        ''' <summary>
        ''' A list of array modifiers such as "()" or "(,)". If no array modifiers were
        ''' present, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property RankSpecifiers As SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Dim listNode = GetRed(_rankSpecifiers, 4)
                Return new SyntaxList(Of ArrayRankSpecifierSyntax)(listNode)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the RankSpecifiers property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithRankSpecifiers(rankSpecifiers as SyntaxList(Of ArrayRankSpecifierSyntax)) As ArrayCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, Me.Type, Me.ArrayBounds, rankSpecifiers, Me.Initializer)
        End Function

        Public Shadows Function AddRankSpecifiers(ParamArray items As ArrayRankSpecifierSyntax()) As ArrayCreationExpressionSyntax
            Return Me.WithRankSpecifiers(Me.RankSpecifiers.AddRange(items))
        End Function

        ''' <summary>
        ''' The initializer including the braces.
        ''' </summary>
        Public  ReadOnly Property Initializer As CollectionInitializerSyntax
            Get
                Return GetRed(_initializer, 5)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializer property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializer(initializer as CollectionInitializerSyntax) As ArrayCreationExpressionSyntax
            return Update(Me.NewKeyword, Me.AttributeLists, Me.Type, Me.ArrayBounds, Me.RankSpecifiers, initializer)
        End Function

        Public Shadows Function AddInitializerInitializers(ParamArray items As ExpressionSyntax()) As ArrayCreationExpressionSyntax
            Dim _child = If (Me.Initializer IsNot Nothing, Me.Initializer, SyntaxFactory.CollectionInitializer())
            Return Me.WithInitializer(_child.AddInitializers(items))
        End Function

        Friend Overrides Function GetCachedSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case 3
                    Return Me._arrayBounds
                Case 4
                    Return Me._rankSpecifiers
                Case 5
                    Return Me._initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Friend Overrides Function GetNodeSlot(i as Integer) as SyntaxNode
            Select case i
                Case 1
                    Return GetRed(_attributeLists, 1)
                Case 2
                    Return Me.Type
                Case 3
                    Return Me.ArrayBounds
                Case 4
                    Return GetRed(_rankSpecifiers, 4)
                Case 5
                    Return Me.Initializer
                Case Else
                     Return Nothing
            End Select
        End Function

        Public Overrides Function Accept(Of TResult)(ByVal visitor As VisualBasicSyntaxVisitor(Of TResult)) As TResult
            Return visitor.VisitArrayCreationExpression(Me)
        End Function

        Public Overrides Sub Accept(ByVal visitor As VisualBasicSyntaxVisitor)
            visitor.VisitArrayCreationExpression(Me)
        End Sub


        ''' <summary>
        ''' Returns a copy of this with the specified changes. Returns this instance if
        ''' there are no actual changes.
        ''' </summary>
        ''' <param name="newKeyword">
        ''' The value for the NewKeyword property.
        ''' </param>
        ''' <param name="attributeLists">
        ''' The value for the AttributeLists property.
        ''' </param>
        ''' <param name="type">
        ''' The value for the Type property.
        ''' </param>
        ''' <param name="arrayBounds">
        ''' The value for the ArrayBounds property.
        ''' </param>
        ''' <param name="rankSpecifiers">
        ''' The value for the RankSpecifiers property.
        ''' </param>
        ''' <param name="initializer">
        ''' The value for the Initializer property.
        ''' </param>
        Public Function Update(newKeyword As SyntaxToken, attributeLists As SyntaxList(of AttributeListSyntax), type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As SyntaxList(of ArrayRankSpecifierSyntax), initializer As CollectionInitializerSyntax) As ArrayCreationExpressionSyntax
            If newKeyword <> Me.NewKeyword OrElse attributeLists <> Me.AttributeLists OrElse type IsNot Me.Type OrElse arrayBounds IsNot Me.ArrayBounds OrElse rankSpecifiers <> Me.RankSpecifiers OrElse initializer IsNot Me.Initializer Then
                Dim newNode = SyntaxFactory.ArrayCreationExpression(newKeyword, attributeLists, type, arrayBounds, rankSpecifiers, initializer)
                Dim annotations = Me.GetAnnotations()
                If annotations IsNot Nothing AndAlso annotations.Length > 0
                    return newNode.WithAnnotations(annotations)
                End If
                Return newNode
            End If
            Return Me
        End Function

    End Class

    ''' <summary>
    ''' Represents an expression that creates a new array without naming the element
    ''' type.
    ''' </summary>
    Public NotInheritable Class CollectionInitializerSyntax
        Inherits ExpressionSyntax

        Friend _initializers as SyntaxNode

        Friend Sub New(ByVal green As GreenNode, ByVal parent as SyntaxNode, ByVal startLocation As Integer)
            MyBase.New(green, parent, startLocation)
            Debug.Assert(green IsNot Nothing)
            Debug.Assert(startLocation >= 0)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openBraceToken As InternalSyntax.PunctuationSyntax, initializers As SyntaxNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            Me.New(New Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CollectionInitializerSyntax(kind, errors, annotations, openBraceToken, if(initializers IsNot Nothing, initializers.Green, Nothing), closeBraceToken), Nothing, 0)
        End Sub

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Public  ReadOnly Property OpenBraceToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CollectionInitializerSyntax)._openBraceToken, Me.Position, 0)
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the OpenBraceToken property changed to the
        ''' specified value. Returns this instance if the specified value is the same as
        ''' the current value.
        ''' </summary>
        Public Shadows Function WithOpenBraceToken(openBraceToken as SyntaxToken) As CollectionInitializerSyntax
            return Update(openBraceToken, Me.Initializers, Me.CloseBraceToken)
        End Function

        ''' <summary>
        ''' The list of initializers between the braces.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Public  ReadOnly Property Initializers As SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Dim listNode = GetRed(_initializers, 1)
                If listNode IsNot Nothing
                    Return new SeparatedSyntaxList(Of ExpressionSyntax)(listNode, Me.GetChildIndex(1))
                End If
                Return Nothing
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the Initializers property changed to the specified
        ''' value. Returns this instance if the specified value is the same as the current
        ''' value.
        ''' </summary>
        Public Shadows Function WithInitializers(initializers as SeparatedSyntaxList(Of ExpressionSyntax)) As CollectionInitializerSyntax
            return Update(Me.OpenBraceToken, initializers, Me.CloseBraceToken)
        End Function

        Public Shadows Function AddInitializers(ParamArray items As ExpressionSyntax()) As CollectionInitializerSyntax
            Return Me.WithInitializers(Me.Initializers.AddRange(items))
        End Function

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Public  ReadOnly Property CloseBraceToken As SyntaxToken
            Get
                return new SyntaxToken(Me, DirectCast(Me.Green, Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax.CollectionInitializerSyntax)._closeBraceToken, Me.GetChildPosition(2), Me.GetChildIndex(2))
            End Get
        End Property

        ''' <summary>
        ''' Returns a copy of this with the CloseBraceToken prop