﻿using Orleans.Providers;
using Orleans.Runtime;
using System;
using System.Reflection;
using Microsoft.Extensions.DependencyInjection;
using System.Linq;

namespace Orleans.Storage
{
    public static class GrainStorageExtensions
    {
        /// <summary>
        /// Aquire the storage provider associated with the grain type.
        /// </summary>
        /// <returns></returns>
        public static IStorageProvider GetStorageProvider(this Grain grain, IServiceProvider services)
        {
            StorageProviderAttribute attr = grain.GetType().GetTypeInfo().GetCustomAttributes<StorageProviderAttribute>(true).FirstOrDefault();
            IStorageProvider storageProvider = attr != null
                ? services.GetServiceByName<IStorageProvider>(attr.ProviderName)
                : services.GetService<IStorageProvider>();
            if (storageProvider == null)
            {
                var errMsg = string.Format("No storage providers found loading grain type {0}", grain.GetType().FullName);
                throw new BadProviderConfigException(errMsg);
            }
            return storageProvider;
        }
    }
}
