/******************************************************************************
 * Copyright (C) 2010-2016 CERN. All rights not expressly granted are reserved.
 * 
 * This file is part of the CERN Control and Monitoring Platform 'C2MON'.
 * C2MON is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the license.
 * 
 * C2MON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with C2MON. If not, see <http://www.gnu.org/licenses/>.
 *****************************************************************************/
package cern.c2mon.server.cache.dbaccess;

import cern.c2mon.server.common.command.CommandTagCacheObject;
import cern.c2mon.shared.common.command.CommandTag;

/**
 * Interface to bean for persisting the CommandTagCacheObject
 * in the cache persistence DB.
 * 
 * @author Mark Brightwell
 *
 */
public interface CommandTagMapper extends LoaderMapper<CommandTag> {

  /**
   * Insert into DB.
   * @param commandTag cache object to persist
   */
  void insertCommandTag(CommandTagCacheObject commandTag);

  /**
   * Remove the command from the DB.
   * @param id of the command
   */
  void deleteCommandTag(Long id);

  /**
   * Updates the command
   * @param modifiedCommand the modified cache object
   */
  void updateCommandTag(CommandTagCacheObject modifiedCommand);

}
