## v0.11.0 - 2025-11-30

This release switches doc2go to using Go type analysis (via go/types)
instead of syntactic analysis (via go/ast) which was deprecated in Go 1.22.

This improves accuracy around which identifiers are rendered as links
in the generated HTML, covering many cases that were previously missed.

This has only a small negative impact on performance, as shown below:

```
❯ hyperfine './doc2go.old -out old std' './doc2go.new -out new std'
Benchmark 1: ./doc2go.old -out old std
  Time (mean ± σ):      2.178 s ±  0.057 s    [User: 3.010 s, System: 0.530 s]
  Range (min … max):    2.143 s …  2.332 s    10 runs

Benchmark 2: ./doc2go.new -out new std
  Time (mean ± σ):      2.324 s ±  0.110 s    [User: 3.296 s, System: 0.538 s]
  Range (min … max):    2.255 s …  2.630 s    10 runs
```

If you see any issues with Go source code
that was previously rendered correctly but is now incorrect,
please file an issue at <https://github.com/abhinav/doc2go/issues>.
