# Initial design

## Introduction

doc2go is a tool to do one thing:
generate static HTML documentation from Go source code.

## Requirements

The bare minimum UX for the system is intended to be:

```
$ doc2go ./...
```

This will generate API Reference for all packages
in the current directory and its subdirectories.

The output will be standalone HTML files
generated into a `_site` directory,
that are ready for viewing right away.
Users who want minimal ceremony will likely use this
to host the HTML on custom GitHub Pages or similar.

Beyond that, the following additional features
can be tacked on in the order of priority:

* Write to directory:
  An `-out DIR` flag will be added
  to change the output directory.
  The files will be written in a layout
  matching the package hierarchy.
* Cross-linking:
  Entities within the scope of the HTML generation
  will be linked with relative links.
  For entities outside this scope,
  we’ll add a `-link PATH=TEMPLATE` flag
  which will use the given template to generate links
  to entities under PATH.
  To link the correct versions of dependencies,
  we may need a `-mod go.mod` flag.
* Source-linking:
  Similarly to cross-linking,
  we’ll add a `-source-link PATH=TEMPLATE` flag
  to link to the source code entities defined in the scope.
* Embedded mode:
  When the `-embedded` flag will is set,
  we’ll generate HTML without `<body>` or `<head>` tags -- just the content.
  This will make it suitable for embedding inside custom layouts
  or use with other static site generators.
  Projects that want to host API Reference alongside project documentation
  will use this.

### Future ideas

#### "`Added in release`" markers

To mark which release an API was added in, we may need to generate a
data file containing APIs for that release, and expect both the name of
the current release, and the API file for the previous release. How this
would work is unclear right now.
