# Including example tests in generated documentation

**Issue**: [#15](https://github.com/abhinav/doc2go/issues/15)

This is a proposal to add support for including example tests
in documentation generated by doc2go.

## Background

doc2go generates static HTML documentation by inspecting Go source code.
It aims to provide functionality comparable to [pkgsite](https://pkg.go.dev/)
but without a complex hosting service.

Among the features of pkgsite is the ability to show examples
next to the documentation of various symbols.
The examples come from example tests defined in the source code itself.

### Example association

Example tests are associated to symbols based on the name of the test.
They may be associated with a package, a function, a type, or a method.

| Test name    | Associated with        |
|--------------|------------------------|
| `Example`    | package                |
| `ExampleF`   | function `F`           |
| `ExampleT`   | type `T`               |
| `ExampleT_M` | method `M` of type `T` |

An arbitrary `_suffix` may be appended to any of these names
starting with a lower-case letter to indicate that
the example is a sub-example.
The suffix is used as the name of the sub-example.

### Example output

Example tests can optionally include expected output.
When running `go test`,
the example output is compared against the actual output.
In documentation, it is displayed next to the example.
On pkgsite, the examples are runnable in a sandboxed environment.

## Proposal

The functionality should be added to doc2go as it exists in pkgsite
with one difference:
we will not support running the examples,
but we’ll still display the example output.

### Pipeline changes

The relevant parts of doc2go’s processing pipeline are:

* `gosrc` parses Go source code
* `godoc` assembles documentation data from `gosrc` output
* `html` generates HTML from `godoc` output

To support example tests, we need to:

* change `gosrc` to also parse test file source code
* in `godoc`, pass this additional information to `go/doc.NewFromFiles`;
  it will will automatically associate example tests with symbols
* in `html`, render the example tests

### Output HTML

The examples must be collapsible, and be collapsed by default.
The output HTML should require minimal styling or JavaScript.
With HTML5,
we can use the `details` and `summary` elements to achieve this.

```html
<details>
<summary>Example</summary>

<!-- render source here -->
</details>
```

This will be a collapsible block with the text "Example" as the summary,
and it will be collapsed by default.
