---
title: Changelog
---

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).

## v0.11.0 - 2025-11-30

This release switches doc2go to using Go type analysis (via go/types)
instead of syntactic analysis (via go/ast) which was deprecated in Go 1.22.

This improves accuracy around which identifiers are rendered as links
in the generated HTML, covering many cases that were previously missed.

This has only a small negative impact on performance, as shown below:

```
❯ hyperfine './doc2go.old -out old std' './doc2go.new -out new std'
Benchmark 1: ./doc2go.old -out old std
  Time (mean ± σ):      2.178 s ±  0.057 s    [User: 3.010 s, System: 0.530 s]
  Range (min … max):    2.143 s …  2.332 s    10 runs

Benchmark 2: ./doc2go.new -out new std
  Time (mean ± σ):      2.324 s ±  0.110 s    [User: 3.296 s, System: 0.538 s]
  Range (min … max):    2.255 s …  2.630 s    10 runs
```

If you see any issues with Go source code
that was previously rendered correctly but is now incorrect,
please file an issue at <https://github.com/abhinav/doc2go/issues>.

## v0.10.0 - 2025-11-29
### Added
- Add -rel-link-style=index option for rendering relative links with explicit index file (e.g., foo/index.html). Supports custom index basenames set with the -basename flag.

## v0.9.2 - 2025-11-29
### Fixed
- Fix panic in highlighting certain corner cases.

## v0.9.1 - 2025-08-27
### Fixed
- Fix binary from Homebrew Cask not running on macOS
  because of unsigned binary.

## v0.9.0 - 2025-08-27
### Added
- Go 1.25 support.
### Changed
- Don't render types and functions in main packages. The only consumable part of these is the command itself. Subpackages will still be rendered as before.
- Homebrew Tap now publishes Casks instead of Formulae.

## v0.8.1 - 2024-02-12
### Fixed
- -rel-link-style: Don't generate trailling '/' for static assets.

## v0.8.0 - 2024-02-11
### Added
- Standalone website: Include a favicon on all generated pages.
- Standalone: Add a "Root" link to the navbar, going to the top-level page.
With `-subdir`, this will be the sub-directory listing.
- Add -pkg-version flag to include a version number on pages in the standalone website.
- Add -pagefind flag to enable or disable client-side search. By default, it's enabled if [pagefind](https://pagefind.app) is found on `$PATH`.
### Changed
- Standalone website: Include a link to the package index on top.
### Fixed
- Standalone: Don't show "Index" link in navbar on pages without an Index.

## v0.7.0 - 2024-01-19
### Added
- Initial support for versioned documentation with -subdir. Thanks to @3052.
### Fixed
- Fix some internal packages still being listed without -internal. Thanks to @3052.
- Don't include vendor directories.

## v0.6.0 - 2023-11-14
### Added
- Include example tests in generated documentation.
- Frontmatter templates may now use `.Name` to handle the various title selection cases.
### Changed
- Standalone website shows deprecated elements as collapsed by default.

## v0.5.2 - 2023-11-10
### Fixed
- Re-release to fix partially broken release process.

## v0.5.1 - 2023-11-10
### Fixed
- Fix -rel-link-style being ignored for links inside source code blocks.

## v0.5.0 - 2023-08-03
### Added
- Add a `-rel-link-style` flag to change how relative links are rendered. Use 'directory' as an argument to add trailing slashes to relative links.

## v0.4.1 - 2023-01-26
### Fixed
- Fix paths to subdirectories on Windows.

## v0.4.0 - 2023-01-19
### Added
- Include a small footer on standalone pages
  indicating the page was generated by doc2go.
- Add support for reading configuration from a file.
  Defaults to reading from doc2go.rc;
  can be changed with the '-config' flag.

## v0.3.0 - 2023-01-18
### Added
- Added `-highlight` flag to control syntax highlighting.
- Added `-highlight-print-css` flag to
  extract the CSS for a syntax highlighting theme.
- Added `-highlight-list-themes` flag to
  list available syntax highlighting themes.
### Changed
- Code blocks in generated HTML are now syntax highlighted server-side.
  The default theme is richer than the prior default.
  Use `-highlight=plain` for output similar to the old behavior.

## v0.2.0 - 2023-01-14
### Added
- Add '-home' flag to change the landing page of the generated website.

## v0.1.1 - 2023-01-10
### Fixed
- Resolve intermittent "No non-test Go files" messages for uncompiled packages.

## v0.1.0 - 2023-01-08
- Initial release.
