from __future__ import absolute_import, unicode_literals, print_function

from markdown.extensions import Extension
from markdown.preprocessors import Preprocessor


class MarkdownInclude(Extension):
    def __init__(self, configs={}):
        self.config = {
            'base_path': ['.', 'Default location from which to evaluate ' \
                'relative paths for the include statement.'],
            'encoding': ['utf-8', 'Encoding of the files used by the include statement.']
        }
        for key, value in configs.items():
            self.setConfig(key, value)

    #def extendMarkdown(self, md, md_globals):
    def extendMarkdown(self, md):
        #md.preprocessors.add(
        md.preprocessors.register(
            #'include', IncludePreprocessor(md, self.getConfigs()), '_begin')
            IncludePreprocessor(md, self.getConfigs()), 'include', +10000000000)


class IncludePreprocessor(Preprocessor):
    """
    This provides an "include" function for Markdown, similar to that found in
    LaTeX (also the C pre-processor and Fortran). The syntax is {% filename %},
    which will be replaced by the contents of filename. Any such statements in
    filename will also be replaced. This replacement is done prior to any other
    Markdown processing. All file-names are evaluated relative to the location
    from which Markdown is being called.
    """
    def __init__(self, md, config):
        super(IncludePreprocessor, self).__init__(md)
        self.base_path = config['base_path']
        self.encoding = config['encoding']

    def run(self, lines):
        from abimkdocs.website import Website
        website = Website.get()
        return website.preprocess_mdlines(lines)


def makeExtension(*args,**kwargs):
    return MarkdownInclude(*args, **kwargs)
