## Information on the format 6 for pseudopotentials

The format 6 for ABINIT pseudopotentials allows to use pseudopotentials
generated from the FHI98PP code (Fritz-Haber-Institute, Berlin).
This code is available at this [URL](http://www.FHI-Berlin.MPG.DE/th/fhi98md/fhi98PP).

A few lines must be added to the file generated by the FHI98PP code,
and are described in the present file. ABINITv1.9 is able to
read format 6 pseudopotential files without core correction.
ABINITv2.2 is able to read them with core correction (thanks to AF).

# The original cpi file

We will suppose that the user has been able to generate a `cpi` file from the FHI98PP code.
There is one such file in the `~abinit/tests/Pspdir` directory,
with the name `al_h.cpi` (the FHI98PP code generated a file named `al:h.cpi`,
but the name was changed, to allow portability under DOS/Windows) .
It begins by:

    0.30000000000000E+01   3
  0.0000    0.0000    0.0000   0.0000
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
  0.0000    .00e+00   .00e+00
    493  0.10247000000000E+01
   1 0.48076923076923E-03 0.91926957204792E-04 0.72762392428392E+00
   2 0.49264423076923E-03 0.94197553047751E-04 0.72762434262851E+00
   3 0.50481254326923E-03 0.96524232608030E-04 0.72762477651319E+00
    ...
    ...

From these numbers, we will make direct use of:

- those on the first line, i.e. the number of valence electrons ( 0.30000000000000E+01 )
   and the number of pseudopotential components ( 3 )
- the first on the 12th line, i.e. the number of mesh points ( 493 )


# The new file

For the purpose of generating the corresponding file readable by ABINIT (also
found in the `~abinit/tests/Pspdir` directory, with the name `13al.981214.fhi`),
the following seven lines have been added at the beginning of the `al_h.cpi file`:

    Aluminum, fhi98PP : Hamann-type, LDA CA PerdewWang, l=2 local
 13.000  3.000    981214              zatom,zion,pspdat
 6       7        2   2    493     0  pspcod,pspxc,lmax,lloc,mmax,r2well
 0.0     0.0     0.0                  rchrg, fchrg, qchrg
    5--- These two lines are available for giving more information, later
    6
    7-Here follows the cpi file from the fhi98pp code-


Similar lines must be added at the beginning of other cpi files, in order
to make them readable by ABINIT.

Line 1 is simply a header, that might include any information, and that will
be printed without modification in the output of ABINIT.

Line 2 describes:

- the atomic number (zatom);
- the ionic charge (zion, number of valence electrons);
- the date of pseudopotential generation.

The two first information are crucial, the third one is not
really important. The atomic number is 1 for Hydrogen, 8 for Oxygen, and so on.
The ionic charge should be the same number as the first number mentioned
in the cpi file (called 'number of valence electrons').

Line 3 describes:

- the format of the pseudopotential (pspcod; must be 6 for this format);
- the XC functional used to generate the pseudopotential (pspxc ; the
   same numbers as for the input variable ixc should be used,
   see `~abinit/doc/users/abinit_help.html`)
- the maximal angular momentum of the wavefunctions described
   in the pseudopotential file (lmax=0 if only s-wavefunctions are present,
   lmax=1 for s and p wfs, lmax=2 for s, p and d wfs ... ; lmax+1 must be
   equal to the 'number of pseudopotential components' mentioned in the cpi
   file, as the second number of the first line)
- the angular momentum of the potential to be used as local pseudopotential
   (lloc=0 if s-potential is local; lloc=1 if p-potential is local ; ... )
- the number of radial mesh points (mmax, same meaning as in the cpi file;
   first number on the 12th line)
- the last number can be set to 0 .

Line 4 describes 3 parameters needed to read the model core-charge
   if core correction is needed.
- rchrg: radius at which the core charge vanish (i.e. cut-off in a.u.)
- fchrg: amplitude of core charge (if =0 non core-correction performed,
         if >0 core-correction is applied). The specific value of fchrg
         has no physical meaning in fhi98pp scheme of core correction.
- qchrg: integrated model core charge (it's not actually used by
         abinit, and can be set to any value)

  rchrg can be inferred by the pp file. Indeed, if the pp has been generated
  with the core-correction option, at the end of 'cpi' file there will be:

     do i=1,mmax
        rad(i), f(i), f1(i), f2(i)
     end do

  that is, the radial grid, the core charge (f), and their first(f1)
  and second (f2) derivative on the radial mesh; rchrg can be equal
  to any value of rad(i) to which f,f1 and f2 are reasonably vanished.

Line 5-7 have no interest up to now.

A pseudopotential with format 6 will be treated by
the routine `psp6in.f`, that calls `psp5lo.f` (local part) and `psp5nl.f` (non-local part).
There is no `psp6lo.f` or `psp6nl.f`.

The integral of (V(r)+Zion/r) r^2 in psp5lo.f is performed
from 0 to the highest allowed radius (usually about 100 a.u.),
except that beyond 20 a.u. no value of abs(V(r)) larger than 2.0d-8 is tolerated.
This will allow to cut off spurious behaviour of pseudopotential whose data file
is written in single precision.
