# -*- Autoconf -*-
#
# Copyright (C) 2005-2014 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2024/04/01 16:40:00 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# AFB_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([AFB_OPTIONS_DEFINE],[

  dnl
  dnl --enable arguments
  dnl

  AC_ARG_ENABLE(hdf5,
    AC_HELP_STRING([--enable-hdf5],
      [Enable HDF5 support in NetCDF4 (default: yes)]))
  AC_SUBST(enable_hdf5)

  AC_ARG_ENABLE(local-build,
    AC_HELP_STRING([--enable-local-build],
      [Build and install the fallbacks within the source tree (default: no)]))
  AC_SUBST(enable_local_build)

  dnl
  dnl --with arguments
  dnl

  AC_ARG_WITH(fc-vendor,
    AC_HELP_STRING([--with-fc-vendor],
      [Fortran compiler vendor to be used by the build system (default: None)]))
  AC_SUBST(with_fc_vendor)

  AC_ARG_WITH(fc-version,
    AC_HELP_STRING([--with-fc-version],
      [Fortran compiler version to be used by the build system (default: None)]))
  AC_SUBST(with_fc_version)

  AC_ARG_WITH(tardir,
    AC_HELP_STRING([--with-tardir],
      [Repository of tarballs for fallbacks (default: None)]))
  AC_SUBST(with_tardir)
]) # AFB_OPTIONS_DEFINE



# AFB_OPTIONS_SETUP()
# -------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([AFB_OPTIONS_SETUP],[

  dnl
  dnl --enable arguments
  dnl

  if test "${enable_hdf5}" = ""; then
    enable_hdf5="yes"
  fi
  if test "${enable_local_build}" = ""; then
    enable_local_build="no"
  fi

  dnl
  dnl --with arguments
  dnl

  if test "${with_fc_vendor}" = "no"; then
    with_fc_vendor=""
  fi
  if test "${with_fc_version}" = "no"; then
    with_fc_version=""
  fi
  if test "${with_tardir}" = "no"; then
    with_tardir=""
  fi
]) # AFB_OPTIONS_SETUP



# AFB_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([AFB_OPTIONS_BACKUP],[

  dnl
  dnl --enable arguments
  dnl
  cmd_enable_hdf5="${enable_hdf5}"
  cmd_enable_local_build="${enable_local_build}"

  dnl
  dnl --with arguments
  dnl
  cmd_with_fc_vendor="${with_fc_vendor}"
  cmd_with_fc_version="${with_fc_version}"
  cmd_with_tardir="${with_tardir}"

  dnl
  dnl Prefix
  dnl
  if test "${prefix}" != "NONE"; then
    cmd_prefix="${prefix}"
  fi
]) # AFB_OPTIONS_BACKUP



# AFB_OPTIONS_RECALL()
# --------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([AFB_OPTIONS_RECALL],[

  dnl
  dnl --enable arguments
  dnl

  if test "${cmd_enable_hdf5}" != ""; then
    enable_hdf5="${cmd_enable_hdf5}"
  fi

  if test "${cmd_enable_local_build}" != ""; then
    enable_local_build="${cmd_enable_local_build}"
  fi

  dnl
  dnl --with arguments
  dnl

  if test "${cmd_with_fc_vendor}" != ""; then
    with_fc_vendor="${cmd_with_fc_vendor}"
  fi

  if test "${cmd_with_fc_version}" != ""; then
    with_fc_version="${cmd_with_fc_version}"
  fi

  if test "${cmd_with_tardir}" != ""; then
    with_tardir="${cmd_with_tardir}"
  fi

  dnl
  dnl Prefix
  dnl
  if test "${cmd_prefix}" != ""; then
    prefix="${cmd_prefix}"
  fi
]) # AFB_OPTIONS_RECALL



dnl AFB_OPTIONS_CHANGED()
dnl ---------------------
dnl
dnl Display changes of user interface between versions and warns about
dnl obsolete uses.
dnl
AC_DEFUN([AFB_OPTIONS_CHANGED],[
  AC_MSG_NOTICE([reporting user interface changes:])

  dnl New --enable-hdf5 option
  AC_MSG_NOTICE([ * new option --enable-hdf5 is available])

]) dnl AFB_OPTIONS_CHANGED



dnl AFB_OPTIONS_PARSE()
dnl -------------------
dnl
dnl Parses command-line arguments.
dnl
AC_DEFUN([AFB_OPTIONS_PARSE],[
  AC_REQUIRE([AC_PROG_EGREP])
  AC_MSG_NOTICE([parsing command-line options])

  dnl Parse enable_hdf5
  if test "${enable_hdf5}" != ""; then
    for v in `echo "${enable_hdf5}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_hdf5 = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_hdf5 = ${v}])
    fi
  fi

  dnl Parse enable_local_build
  if test "${enable_local_build}" != ""; then
    for v in `echo "${enable_local_build}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_local_build = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_local_build = ${v}])
    fi
  fi

]) dnl AFB_OPTIONS_PARSE



dnl AFB_OPTIONS_TRIGGERS()
dnl ----------------------
dnl
dnl Set triggers associated to 'enable_*' options (AC_DEFINE and
dnl AM_CONDTIONAL).
dnl
AC_DEFUN([AFB_OPTIONS_TRIGGERS],[
  AC_MSG_NOTICE([setting triggers associated to command-line options])

]) dnl AFB_OPTIONS_TRIGGERS
