﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using System;
using System.Linq;
using Microsoft.Build.Framework;
using Microsoft.CodeAnalysis.BuildTasks;
using Xunit;
using Moq;
using Roslyn.Test.Utilities;
using Microsoft.CodeAnalysis.CSharp;
using System.Collections.Immutable;

namespace Microsoft.CodeAnalysis.BuildTasks.UnitTests
{
    public sealed class MiscTests
    {
        /// <summary>
        /// The build task very deliberately does not depend on any of our shipping binaries.  This is to avoid
        /// potential load conflicts for dependencies when loading custom versions of our task.
        /// </summary>
        [Fact]
        [WorkItem(1183, "https://github.com/Microsoft/msbuild/issues/1183")]
        public void EnsureDependencies()
        {
            var assembly = typeof(ManagedCompiler).Assembly;
            foreach (var name in assembly.GetReferencedAssemblies())
            {
                var isBadRef =
                    name.Name == typeof(Compilation).Assembly.GetName().Name ||
                    name.Name == typeof(CSharpCompilation).Assembly.GetName().Name ||
                    name.Name == typeof(ImmutableArray<string>).Assembly.GetName().Name;
                Assert.False(isBadRef);
            }
        }
    }
}
