/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import java.util.List;

public abstract class AbstractArraySubject<S extends AbstractArraySubject<S, T>, T>
extends Subject<S, T> {
    AbstractArraySubject(FailureStrategy failureStrategy, T subject) {
        super(failureStrategy, subject);
    }

    public void isEmpty() {
        if (!this.listRepresentation().isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (this.listRepresentation().isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasLength(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length (%s) must be >= 0");
        if (this.listRepresentation().size() != length) {
            this.fail("has length", (Object)length);
        }
    }

    @Override
    public S named(String name) {
        return (S)((AbstractArraySubject)super.named(name));
    }

    abstract String underlyingType();

    abstract List<?> listRepresentation();

    @Override
    protected String getDisplaySubject() {
        String string;
        if (this.internalCustomName() == null) {
            String string2 = String.valueOf(String.valueOf(this.underlyingType()));
            String string3 = String.valueOf(String.valueOf(this.listRepresentation()));
            string = new StringBuilder(7 + string2.length() + string3.length()).append("<(").append(string2).append("[]) ").append(string3).append(">").toString();
        } else {
            String string4 = String.valueOf(String.valueOf(this.internalCustomName()));
            string = new StringBuilder(2 + string4.length()).append("\"").append(string4).append("\"").toString();
        }
        return string;
    }

    void failWithBadType(Object expected) {
        String expectedType = expected.getClass().isArray() ? String.valueOf(expected.getClass().getComponentType().getName()).concat("[]") : expected.getClass().getName();
        this.failWithRawMessage("Incompatible types compared. expected: %s, actual: %s[]", Platform.compressType(expectedType), this.underlyingType());
    }
}

