#!/usr/bin/perl
# $Id: text2c.pl,v 1.1 2023/09/30 05:39:55 cvsuser Exp $
# text2c
# etxt to c converter
#
#
#

BEGIN {
    my $var = $ENV{"PERLINC"};

    if (defined($var) && -d $var) {             # import PERLINC
        my ($quoted_var) = quotemeta($var);
        push (@INC, $var)
            if (! grep /^$quoted_var$/, @INC);

    } elsif ($^O eq "MSWin32") {                # ActivePerl (defaults)
        if (! grep /\/perl\/lib/, @INC) {
            push (@INC, "c:/perl/lib")  if (-d "c:/perl/lib");
            push (@INC, "/perl/lib") if (-d "/perl/lib");
        }
    }
}

use strict;
use POSIX 'asctime';

sub Process($$);

exit &main();

sub
main()
{
    Usage("missing parameters") 
        if (scalar @ARGV < 2);

    my $name = shift @ARGV;
    my $src  = shift @ARGV;

    Usage("unexpected arguments $ARGV[1] ...") 
        if (scalar @ARGV);

    Process($name, $src);
    return 0;
}


sub
Usage                   # (message)
{
    print "\ntext2c @_\n\n" if (@_);
    print <<EOU;
Usage: perl text2c.pl <name> <input>

EOU
    exit(42);
}


sub
Process($$)             # (name, src)
{
    my ($name, $src) = @_;

    # import
    open(FILE, "<${src}") or
        die "cannot open <${src}> : $!\n";

    # export
    my $timestamp = asctime(localtime);
    chomp($timestamp);

    my $header = <<EOT;
// Auto-generated by text2c ${timestamp} from <${src}>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /*HAVE_CONFIG_H*/
#include "common.h"

const char *const ${name}_text[] = {
EOT

    my $footer = <<EOT;
        NULL
        };
EOT

    print $header;
    while (<FILE>) {
        chomp;
        s{\"}{\\\"}g;
        print "\t\"".$_."\",\n";
    }
    close FILE;
    print $footer;

}

#end

