#ifndef UNICODE_CP437_H_INCLUDED
#define UNICODE_CP437_H_INCLUDED
/* -*- mode: c; indent-width: 4; -*- */
/* $Id: unicode_cp437.h,v 1.3 2024/02/02 15:18:41 cvsuser Exp $
 *
 *  UNICODE to CP437 table
 */

#include "unicode_table.h"

//
//  General unicode/cp437 table mapping.
//
//  (*) extension.
//
static const struct unicode_table
unicode_cp437[] = {
    { 0x00a0, 0xff },	// #NO-BREAK SPACE
    { 0x00a1, 0xad },	// #INVERTED EXCLAMATION MARK
    { 0x00a2, 0x9b },	// #CENT SIGN
    { 0x00a3, 0x9c },	// #POUND SIGN
//  { 0x00a4, 	        // #CURRENCY SIGN
    { 0x00a5, 0x9d },	// #YEN SIGN
//  { 0x00a6, 	        // #BROKEN BAR
//  { 0x00a7, 	        // #SECTION SIGN
//  { 0x00a8, 	        // #DIAERESIS
//  { 0x00a9, 	        // #COPYRIGHT SIGN
    { 0x00aa, 0xa6 },	// #FEMININE ORDINAL INDICATOR
    { 0x00ab, 0xae },	// #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    { 0x00ac, 0xaa },	// #NOT SIGN
//  { 0x00ad, 	        // #SOFT HYPHEN
//  { 0x00ae, 	        // #REGISTERED SIGN
//  { 0x00af, 	        // #MACRON
    { 0x00b0, 0xf8 },	// #DEGREE SIGN
    { 0x00b1, 0xf1 },	// #PLUS-MINUS SIGN
    { 0x00b2, 0xfd },	// #SUPERSCRIPT TWO
//  { 0x00b3, 	        // #SUPERSCRIPT THREE
//  { 0x00b4, 	        // #ACUTE ACCENT
    { 0x00b5, 0xe6 },	// #MICRO SIGN
//  { 0x00b6, 	        // #PILCROW SIGN
    { 0x00b7, 0xfa },	// #MIDDLE DOT
//  { 0x00b8, 	        // #CEDILLA
//  { 0x00b9, 	        // #SUPERSCRIPT ONE
    { 0x00ba, 0xa7 },	// #MASCULINE ORDINAL INDICATOR
    { 0x00bb, 0xaf },	// #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    { 0x00bc, 0xac },	// #VULGAR FRACTION ONE QUARTER
    { 0x00bd, 0xab },	// #VULGAR FRACTION ONE HALF
//  { 0x00be, 	        // #VULGAR FRACTION THREE QUARTERS
    { 0x00bf, 0xa8 },	// #INVERTED QUESTION MARK
//  { 0x00c0, 	        // #LATIN CAPITAL LETTER A WITH GRAVE
//  { 0x00c1, 	        // #LATIN CAPITAL LETTER A WITH ACUTE
//  { 0x00c2, 	        // #LATIN CAPITAL LETTER A WITH CIRCUMFLEX
//  { 0x00c3, 	        // #LATIN CAPITAL LETTER A WITH TILDE
    { 0x00c4, 0x8e },	// #LATIN CAPITAL LETTER A WITH DIAERESIS
    { 0x00c5, 0x8f },	// #LATIN CAPITAL LETTER A WITH RING ABOVE
    { 0x00c6, 0x92 },	// #LATIN CAPITAL LIGATURE AE
    { 0x00c7, 0x80 },	// #LATIN CAPITAL LETTER C WITH CEDILLA
//  { 0x00c8, 	        // #LATIN CAPITAL LETTER E WITH GRAVE
    { 0x00c9, 0x90 },	// #LATIN CAPITAL LETTER E WITH ACUTE
//  { 0x00ca, 	        // #LATIN CAPITAL LETTER E WITH CIRCUMFLEX
//  { 0x00cb, 	        // #LATIN CAPITAL LETTER E WITH DIAERESIS
//  { 0x00cc, 	        // #LATIN CAPITAL LETTER I WITH GRAVE
//  { 0x00cd, 	        // #LATIN CAPITAL LETTER I WITH ACUTE
//  { 0x00ce, 	        // #LATIN CAPITAL LETTER I WITH CIRCUMFLEX
//  { 0x00cf, 	        // #LATIN CAPITAL LETTER I WITH DIAERESIS
//  { 0x00d0, 	        // #LATIN CAPITAL LETTER ETH
    { 0x00d1, 0xa5 },	// #LATIN CAPITAL LETTER N WITH TILDE
//  { 0x00d2, 	        // #LATIN CAPITAL LETTER O WITH GRAVE
//  { 0x00d3, 	        // #LATIN CAPITAL LETTER O WITH ACUTE
//  { 0x00d4, 	        // #LATIN CAPITAL LETTER O WITH CIRCUMFLEX
//  { 0x00d5, 	        // #LATIN CAPITAL LETTER O WITH TILDE
    { 0x00d6, 0x99 },	// #LATIN CAPITAL LETTER O WITH DIAERESIS
//  { 0x00d7, 	        // #MULTIPLICATION SIGN
//  { 0x00d8, 	        // #LATIN CAPITAL LETTER O WITH STROKE
//  { 0x00d9, 	        // #LATIN CAPITAL LETTER U WITH GRAVE
//  { 0x00da, 	        // #LATIN CAPITAL LETTER U WITH ACUTE
//  { 0x00db, 	        // #LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    { 0x00dc, 0x9a },	// #LATIN CAPITAL LETTER U WITH DIAERESIS
//  { 0x00dd, 	        // #LATIN CAPITAL LETTER Y WITH ACUTE
//  { 0x00de, 	        // #LATIN CAPITAL LETTER THORN
    { 0x00df, 0xe1 },	// #LATIN SMALL LETTER SHARP S
    { 0x00e0, 0x85 },	// #LATIN SMALL LETTER A WITH GRAVE
    { 0x00e1, 0xa0 },	// #LATIN SMALL LETTER A WITH ACUTE
    { 0x00e2, 0x83 },	// #LATIN SMALL LETTER A WITH CIRCUMFLEX
//  { 0x00e3, 	        // #LATIN SMALL LETTER A WITH TILDE
    { 0x00e4, 0x84 },	// #LATIN SMALL LETTER A WITH DIAERESIS
    { 0x00e5, 0x86 },	// #LATIN SMALL LETTER A WITH RING ABOVE
    { 0x00e6, 0x91 },	// #LATIN SMALL LIGATURE AE
    { 0x00e7, 0x87 },	// #LATIN SMALL LETTER C WITH CEDILLA
    { 0x00e8, 0x8a },	// #LATIN SMALL LETTER E WITH GRAVE
    { 0x00e9, 0x82 },	// #LATIN SMALL LETTER E WITH ACUTE
    { 0x00ea, 0x88 },	// #LATIN SMALL LETTER E WITH CIRCUMFLEX
    { 0x00eb, 0x89 },	// #LATIN SMALL LETTER E WITH DIAERESIS
    { 0x00ec, 0x8d },	// #LATIN SMALL LETTER I WITH GRAVE
    { 0x00ed, 0xa1 },	// #LATIN SMALL LETTER I WITH ACUTE
    { 0x00ee, 0x8c },	// #LATIN SMALL LETTER I WITH CIRCUMFLEX
    { 0x00ef, 0x8b },	// #LATIN SMALL LETTER I WITH DIAERESIS
//  { 0x00f0, 	        // #LATIN SMALL LETTER ETH
    { 0x00f1, 0xa4 },	// #LATIN SMALL LETTER N WITH TILDE
    { 0x00f2, 0x95 },	// #LATIN SMALL LETTER O WITH GRAVE
    { 0x00f3, 0xa2 },	// #LATIN SMALL LETTER O WITH ACUTE
    { 0x00f4, 0x93 },	// #LATIN SMALL LETTER O WITH CIRCUMFLEX
//  { 0x00f5, 	        // #LATIN SMALL LETTER O WITH TILDE
    { 0x00f6, 0x94 },	// #LATIN SMALL LETTER O WITH DIAERESIS
    { 0x00f7, 0xf6 },	// #DIVISION SIGN
//  { 0x00f8, 	        // #LATIN SMALL LETTER O WITH STROKE
    { 0x00f9, 0x97 },	// #LATIN SMALL LETTER U WITH GRAVE
    { 0x00fa, 0xa3 },	// #LATIN SMALL LETTER U WITH ACUTE
    { 0x00fb, 0x96 },	// #LATIN SMALL LETTER U WITH CIRCUMFLEX
    { 0x00fc, 0x81 },	// #LATIN SMALL LETTER U WITH DIAERESIS
//  { 0x00fd, 	        // #LATIN SMALL LETTER Y WITH ACUTE
//  { 0x00fe, 	        // #LATIN SMALL LETTER THORN
    { 0x00ff, 0x98 },	// #LATIN SMALL LETTER Y WITH DIAERESIS

    { 0x0192, 0x9f },	// #LATIN SMALL LETTER F WITH HOOK
    { 0x0393, 0xe2 },	// #GREEK CAPITAL LETTER GAMMA
    { 0x0398, 0xe9 },	// #GREEK CAPITAL LETTER THETA
    { 0x03a3, 0xe4 },	// #GREEK CAPITAL LETTER SIGMA
    { 0x03a6, 0xe8 },	// #GREEK CAPITAL LETTER PHI
    { 0x03a9, 0xea },	// #GREEK CAPITAL LETTER OMEGA
    { 0x03b1, 0xe0 },	// #GREEK SMALL LETTER ALPHA
    { 0x03b4, 0xeb },	// #GREEK SMALL LETTER DELTA
    { 0x03b5, 0xee },	// #GREEK SMALL LETTER EPSILON
    { 0x03c0, 0xe3 },	// #GREEK SMALL LETTER PI
    { 0x03c3, 0xe5 },	// #GREEK SMALL LETTER SIGMA
    { 0x03c4, 0xe7 },	// #GREEK SMALL LETTER TAU
    { 0x03c6, 0xed },	// #GREEK SMALL LETTER PHI
//  { 0x04f4,	   },	// #CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
    { 0x2018, '\'' },	// #LEFT SINGLE QUOTATION MARK
    { 0x2019, '\'' },	// #RIGHT SINGLE QUOTATION MARK
    { 0x2022, 0xf8 },	// BULLET (*)
    { 0x207f, 0xfc },	// #SUPERSCRIPT LATIN SMALL LETTER N
    { 0x20a7, 0x9e },	// #PESETA SIGN
    { 0x2192, 0x18 },	// RIGHTWARDS ARROW (*)
    { 0x2193, 0x19 },	// DOWNWARDS ARROW (*)
    { 0x2219, 0xf9 },	// #BULLET OPERATOR
    { 0x221a, 0xfb },	// #SQUARE ROOT
    { 0x221e, 0xec },	// #INFINITY
    { 0x2229, 0xef },	// #INTERSECTION
    { 0x2248, 0xf7 },	// #ALMOST EQUAL TO
    { 0x2261, 0xf0 },	// #IDENTICAL TO
    { 0x2264, 0xf3 },	// #LESS-THAN OR EQUAL TO
    { 0x2265, 0xf2 },	// #GREATER-THAN OR EQUAL TO
    { 0x2310, 0xa9 },	// #REVERSED NOT SIGN
    { 0x2320, 0xf4 },	// #TOP HALF INTEGRAL
    { 0x2321, 0xf5 },	// #BOTTOM HALF INTEGRAL
    { 0x2500, 0xc4 },	// #BOX DRAWINGS LIGHT HORIZONTAL
    { 0x2502, 0xb3 },	// #BOX DRAWINGS LIGHT VERTICAL
    { 0x250c, 0xda },	// #BOX DRAWINGS LIGHT DOWN AND RIGHT
    { 0x2510, 0xbf },	// #BOX DRAWINGS LIGHT DOWN AND LEFT
    { 0x2514, 0xc0 },	// #BOX DRAWINGS LIGHT UP AND RIGHT
    { 0x2518, 0xd9 },	// #BOX DRAWINGS LIGHT UP AND LEFT
    { 0x251c, 0xc3 },	// #BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    { 0x2524, 0xb4 },	// #BOX DRAWINGS LIGHT VERTICAL AND LEFT
    { 0x252c, 0xc2 },	// #BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    { 0x2534, 0xc1 },	// #BOX DRAWINGS LIGHT UP AND HORIZONTAL
    { 0x253c, 0xc5 },	// #BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    { 0x2550, 0xcd },	// #BOX DRAWINGS DOUBLE HORIZONTAL
    { 0x2551, 0xba },	// #BOX DRAWINGS DOUBLE VERTICAL
    { 0x2552, 0xd5 },	// #BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
    { 0x2553, 0xd6 },	// #BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
    { 0x2554, 0xc9 },	// #BOX DRAWINGS DOUBLE DOWN AND RIGHT
    { 0x2555, 0xb8 },	// #BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
    { 0x2556, 0xb7 },	// #BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
    { 0x2557, 0xbb },	// #BOX DRAWINGS DOUBLE DOWN AND LEFT
    { 0x2558, 0xd4 },	// #BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
    { 0x2559, 0xd3 },	// #BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
    { 0x255a, 0xc8 },	// #BOX DRAWINGS DOUBLE UP AND RIGHT
    { 0x255b, 0xbe },	// #BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
    { 0x255c, 0xbd },	// #BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
    { 0x255d, 0xbc },	// #BOX DRAWINGS DOUBLE UP AND LEFT
    { 0x255e, 0xc6 },	// #BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    { 0x255f, 0xc7 },	// #BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
    { 0x2560, 0xcc },	// #BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
    { 0x2561, 0xb5 },	// #BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    { 0x2562, 0xb6 },	// #BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
    { 0x2563, 0xb9 },	// #BOX DRAWINGS DOUBLE VERTICAL AND LEFT
    { 0x2564, 0xd1 },	// #BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
    { 0x2565, 0xd2 },	// #BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
    { 0x2566, 0xcb },	// #BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
    { 0x2567, 0xcf },	// #BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
    { 0x2568, 0xd0 },	// #BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
    { 0x2569, 0xca },	// #BOX DRAWINGS DOUBLE UP AND HORIZONTAL
    { 0x256a, 0xd8 },	// #BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    { 0x256b, 0xd7 },	// #BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
    { 0x256c, 0xce },	// #BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
    { 0x2580, 0xdf },	// #UPPER HALF BLOCK
    { 0x2584, 0xdc },	// #LOWER HALF BLOCK
    { 0x2588, 0xdb },	// #FULL BLOCK
    { 0x258c, 0xdd },	// #LEFT HALF BLOCK
    { 0x2590, 0xde },	// #RIGHT HALF BLOCK
    { 0x2591, 0xb0 },	// #LIGHT SHADE
    { 0x2592, 0xb1 },	// #MEDIUM SHADE
    { 0x2593, 0xb2 },	// #DARK SHADE
    { 0x25a0, 0xfe },	// #BLACK SQUARE
    };

#endif	//UNICODE_CP437_H_INCLUDED
