#!/usr/bin/perl -w
# -*- mode: perl; -*-
# $Id: mdocversion.pl,v 1.1 2025/04/02 16:17:20 cvsuser Exp $
# grmandoc mdocversion generation
#
# Copyright Adam Young 2020 - 2025
#

use strict;
use warnings 'all';
use Getopt::Long;
use POSIX qw(strftime);

my $output      = "mdocversion.h";
my $version     = "1.0.0";
my $released    = undef;
my $date        = undef;
my $year        = undef;
my $month       = undef;
my $mday        = undef;
my $build       = "1";

my $help        = 0;

Usage() if (0 == GetOptions(
		'output=s'	=> \$output,
		'version=s'	=> \$version,
		'released=s'	=> \$released,
		'date=s'	=> \$date,
		'build=i'	=> \$build,
		'help'		=> \$help)
			|| $help);

$version = "1.0.0" if (! $version);
$date = strftime('%Y%m%d', localtime) if (! $date);
($year, $month, $mday) = ($1,$2,$3)
	if ($date =~ /^(\d\d\d\d)(\d\d)(\d\d)$/);
$released = strftime('%d %B %Y', localtime) if (! $released);


Generate();

sub
Generate	#()
{
	open(FILE, ">${output}") or
		die "cannot create <${output}> : $!\n";

	my ($version1, $version2, $version3) =
		split(/\./, $version);

	$version2 = 0 if (! $version2);
	$version3 = 0 if (! $version3);

	print FILE <<"EOT";
// Auto-generated by Makefile
#define VERSION "${version}"
#define VERSION_1 ${version1}
#define VERSION_2 ${version2}
#define VERSION_3 ${version3}
#define RELEASED "${released}"
#define BUILD_DATE "${date}"
#define BUILD_YEAR "${year}"
#define BUILD_MONTH "${month}"
#define BUILD_MDAY "${mday}"
#define BUILD_NUMBER "${build}"
#define BINM_APROPOS "grapropos"
#define BINM_MAKEWHATIS "grmakewhatis"
#define BINM_MAN "grman"
#define BINM_SOELIM "grsoelim"
#define BINM_WHATIS "grwhatis"
#define MAN_CONF_FILE "/etc/grman.conf"
#define MANPATH_BASE "/usr/share/man:/usr/X11R6/man"
#define MANPATH_DEFAULT "/usr/share/man:/usr/X11R6/man:/usr/local/man"
EOT

	close(FILE);
}


sub
Usage		# ([message])
{
	print "\nbuildinfo.h @_\n\n" if (@_);
	print <<EOU;

Usage: perl buildinfo.pl [options]

Options:
    --output <file>         Output file.
    --version <version>     Package version.
    --date <date>           Build date.
    --help                  Help.

EOU
	exit 3;
}

1;

#end


