/*
 * Copyright (c) 2014 DeNA Co., Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the &quot;Software&quot;), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED &quot;AS IS&quot;, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* DO NOT EDIT! generated by tokens.pl */
h2o_token_t h2o__tokens[] = {{{H2O_STRLIT(":authority")}, 1, 0, 0, 0, 0},
                             {{H2O_STRLIT(":method")}, 2, 0, 0, 0, 0},
                             {{H2O_STRLIT(":path")}, 4, 0, 0, 0, 0},
                             {{H2O_STRLIT(":scheme")}, 6, 0, 0, 0, 0},
                             {{H2O_STRLIT(":status")}, 8, 0, 0, 0, 0},
                             {{H2O_STRLIT("accept")}, 19, 0, 0, 0, 1},
                             {{H2O_STRLIT("accept-charset")}, 15, 0, 0, 0, 1},
                             {{H2O_STRLIT("accept-encoding")}, 16, 0, 0, 0, 1},
                             {{H2O_STRLIT("accept-language")}, 17, 0, 0, 0, 1},
                             {{H2O_STRLIT("accept-ranges")}, 18, 0, 0, 0, 0},
                             {{H2O_STRLIT("access-control-allow-origin")}, 20, 0, 0, 0, 0},
                             {{H2O_STRLIT("age")}, 21, 0, 0, 0, 0},
                             {{H2O_STRLIT("allow")}, 22, 0, 0, 0, 0},
                             {{H2O_STRLIT("authorization")}, 23, 0, 0, 0, 0},
                             {{H2O_STRLIT("cache-control")}, 24, 0, 0, 0, 0},
                             {{H2O_STRLIT("connection")}, 0, 1, 0, 1, 0},
                             {{H2O_STRLIT("content-disposition")}, 25, 0, 0, 0, 0},
                             {{H2O_STRLIT("content-encoding")}, 26, 0, 0, 0, 0},
                             {{H2O_STRLIT("content-language")}, 27, 0, 0, 0, 0},
                             {{H2O_STRLIT("content-length")}, 28, 0, 1, 0, 0},
                             {{H2O_STRLIT("content-location")}, 29, 0, 0, 0, 0},
                             {{H2O_STRLIT("content-range")}, 30, 0, 0, 0, 0},
                             {{H2O_STRLIT("content-type")}, 31, 0, 0, 0, 0},
                             {{H2O_STRLIT("cookie")}, 32, 0, 0, 0, 0},
                             {{H2O_STRLIT("date")}, 33, 1, 0, 0, 0},
                             {{H2O_STRLIT("etag")}, 34, 0, 0, 0, 0},
                             {{H2O_STRLIT("expect")}, 35, 0, 1, 0, 0},
                             {{H2O_STRLIT("expires")}, 36, 0, 0, 0, 0},
                             {{H2O_STRLIT("from")}, 37, 0, 0, 0, 0},
                             {{H2O_STRLIT("host")}, 38, 0, 1, 0, 0},
                             {{H2O_STRLIT("http2-settings")}, 0, 1, 0, 1, 0},
                             {{H2O_STRLIT("if-match")}, 39, 0, 0, 0, 0},
                             {{H2O_STRLIT("if-modified-since")}, 40, 0, 0, 0, 0},
                             {{H2O_STRLIT("if-none-match")}, 41, 0, 0, 0, 0},
                             {{H2O_STRLIT("if-range")}, 42, 0, 0, 0, 0},
                             {{H2O_STRLIT("if-unmodified-since")}, 43, 0, 0, 0, 0},
                             {{H2O_STRLIT("keep-alive")}, 0, 1, 0, 0, 0},
                             {{H2O_STRLIT("last-modified")}, 44, 0, 0, 0, 0},
                             {{H2O_STRLIT("link")}, 45, 0, 0, 0, 0},
                             {{H2O_STRLIT("location")}, 46, 0, 0, 0, 0},
                             {{H2O_STRLIT("max-forwards")}, 47, 0, 0, 0, 0},
                             {{H2O_STRLIT("proxy-authenticate")}, 48, 1, 0, 0, 0},
                             {{H2O_STRLIT("proxy-authorization")}, 49, 1, 0, 0, 0},
                             {{H2O_STRLIT("range")}, 50, 0, 0, 0, 0},
                             {{H2O_STRLIT("referer")}, 51, 0, 0, 0, 0},
                             {{H2O_STRLIT("refresh")}, 52, 0, 0, 0, 0},
                             {{H2O_STRLIT("retry-after")}, 53, 0, 0, 0, 0},
                             {{H2O_STRLIT("server")}, 54, 1, 0, 0, 0},
                             {{H2O_STRLIT("set-cookie")}, 55, 0, 0, 0, 0},
                             {{H2O_STRLIT("strict-transport-security")}, 56, 0, 0, 0, 0},
                             {{H2O_STRLIT("te")}, 0, 1, 0, 1, 0},
                             {{H2O_STRLIT("transfer-encoding")}, 57, 1, 1, 1, 0},
                             {{H2O_STRLIT("upgrade")}, 0, 1, 1, 1, 0},
                             {{H2O_STRLIT("user-agent")}, 58, 0, 0, 0, 1},
                             {{H2O_STRLIT("vary")}, 59, 0, 0, 0, 0},
                             {{H2O_STRLIT("via")}, 60, 0, 0, 0, 0},
                             {{H2O_STRLIT("www-authenticate")}, 61, 0, 0, 0, 0},
                             {{H2O_STRLIT("x-reproxy-url")}, 0, 0, 0, 0, 0}};
size_t h2o__num_tokens = 58;

const h2o_token_t *h2o_lookup_token(const char *name, size_t len)
{
    switch (len) {
    case 2:
        switch (name[1]) {
        case 'e':
            if (memcmp(name, "t", 1) == 0)
                return H2O_TOKEN_TE;
            break;
        }
        break;
    case 3:
        switch (name[2]) {
        case 'a':
            if (memcmp(name, "vi", 2) == 0)
                return H2O_TOKEN_VIA;
            break;
        case 'e':
            if (memcmp(name, "ag", 2) == 0)
                return H2O_TOKEN_AGE;
            break;
        }
        break;
    case 4:
        switch (name[3]) {
        case 'e':
            if (memcmp(name, "dat", 3) == 0)
                return H2O_TOKEN_DATE;
            break;
        case 'g':
            if (memcmp(name, "eta", 3) == 0)
                return H2O_TOKEN_ETAG;
            break;
        case 'k':
            if (memcmp(name, "lin", 3) == 0)
                return H2O_TOKEN_LINK;
            break;
        case 'm':
            if (memcmp(name, "fro", 3) == 0)
                return H2O_TOKEN_FROM;
            break;
        case 't':
            if (memcmp(name, "hos", 3) == 0)
                return H2O_TOKEN_HOST;
            break;
        case 'y':
            if (memcmp(name, "var", 3) == 0)
                return H2O_TOKEN_VARY;
            break;
        }
        break;
    case 5:
        switch (name[4]) {
        case 'e':
            if (memcmp(name, "rang", 4) == 0)
                return H2O_TOKEN_RANGE;
            break;
        case 'h':
            if (memcmp(name, ":pat", 4) == 0)
                return H2O_TOKEN_PATH;
            break;
        case 'w':
            if (memcmp(name, "allo", 4) == 0)
                return H2O_TOKEN_ALLOW;
            break;
        }
        break;
    case 6:
        switch (name[5]) {
        case 'e':
            if (memcmp(name, "cooki", 5) == 0)
                return H2O_TOKEN_COOKIE;
            break;
        case 'r':
            if (memcmp(name, "serve", 5) == 0)
                return H2O_TOKEN_SERVER;
            break;
        case 't':
            if (memcmp(name, "accep", 5) == 0)
                return H2O_TOKEN_ACCEPT;
            if (memcmp(name, "expec", 5) == 0)
                return H2O_TOKEN_EXPECT;
            break;
        }
        break;
    case 7:
        switch (name[6]) {
        case 'd':
            if (memcmp(name, ":metho", 6) == 0)
                return H2O_TOKEN_METHOD;
            break;
        case 'e':
            if (memcmp(name, ":schem", 6) == 0)
                return H2O_TOKEN_SCHEME;
            if (memcmp(name, "upgrad", 6) == 0)
                return H2O_TOKEN_UPGRADE;
            break;
        case 'h':
            if (memcmp(name, "refres", 6) == 0)
                return H2O_TOKEN_REFRESH;
            break;
        case 'r':
            if (memcmp(name, "refere", 6) == 0)
                return H2O_TOKEN_REFERER;
            break;
        case 's':
            if (memcmp(name, ":statu", 6) == 0)
                return H2O_TOKEN_STATUS;
            if (memcmp(name, "expire", 6) == 0)
                return H2O_TOKEN_EXPIRES;
            break;
        }
        break;
    case 8:
        switch (name[7]) {
        case 'e':
            if (memcmp(name, "if-rang", 7) == 0)
                return H2O_TOKEN_IF_RANGE;
            break;
        case 'h':
            if (memcmp(name, "if-matc", 7) == 0)
                return H2O_TOKEN_IF_MATCH;
            break;
        case 'n':
            if (memcmp(name, "locatio", 7) == 0)
                return H2O_TOKEN_LOCATION;
            break;
        }
        break;
    case 10:
        switch (name[9]) {
        case 'e':
            if (memcmp(name, "keep-aliv", 9) == 0)
                return H2O_TOKEN_KEEP_ALIVE;
            if (memcmp(name, "set-cooki", 9) == 0)
                return H2O_TOKEN_SET_COOKIE;
            break;
        case 'n':
            if (memcmp(name, "connectio", 9) == 0)
                return H2O_TOKEN_CONNECTION;
            break;
        case 't':
            if (memcmp(name, "user-agen", 9) == 0)
                return H2O_TOKEN_USER_AGENT;
            break;
        case 'y':
            if (memcmp(name, ":authorit", 9) == 0)
                return H2O_TOKEN_AUTHORITY;
            break;
        }
        break;
    case 11:
        switch (name[10]) {
        case 'r':
            if (memcmp(name, "retry-afte", 10) == 0)
                return H2O_TOKEN_RETRY_AFTER;
            break;
        }
        break;
    case 12:
        switch (name[11]) {
        case 'e':
            if (memcmp(name, "content-typ", 11) == 0)
                return H2O_TOKEN_CONTENT_TYPE;
            break;
        case 's':
            if (memcmp(name, "max-forward", 11) == 0)
                return H2O_TOKEN_MAX_FORWARDS;
            break;
        }
        break;
    case 13:
        switch (name[12]) {
        case 'd':
            if (memcmp(name, "last-modifie", 12) == 0)
                return H2O_TOKEN_LAST_MODIFIED;
            break;
        case 'e':
            if (memcmp(name, "content-rang", 12) == 0)
                return H2O_TOKEN_CONTENT_RANGE;
            break;
        case 'h':
            if (memcmp(name, "if-none-matc", 12) == 0)
                return H2O_TOKEN_IF_NONE_MATCH;
            break;
        case 'l':
            if (memcmp(name, "cache-contro", 12) == 0)
                return H2O_TOKEN_CACHE_CONTROL;
            if (memcmp(name, "x-reproxy-ur", 12) == 0)
                return H2O_TOKEN_X_REPROXY_URL;
            break;
        case 'n':
            if (memcmp(name, "authorizatio", 12) == 0)
                return H2O_TOKEN_AUTHORIZATION;
            break;
        case 's':
            if (memcmp(name, "accept-range", 12) == 0)
                return H2O_TOKEN_ACCEPT_RANGES;
            break;
        }
        break;
    case 14:
        switch (name[13]) {
        case 'h':
            if (memcmp(name, "content-lengt", 13) == 0)
                return H2O_TOKEN_CONTENT_LENGTH;
            break;
        case 's':
            if (memcmp(name, "http2-setting", 13) == 0)
                return H2O_TOKEN_HTTP2_SETTINGS;
            break;
        case 't':
            if (memcmp(name, "accept-charse", 13) == 0)
                return H2O_TOKEN_ACCEPT_CHARSET;
            break;
        }
        break;
    case 15:
        switch (name[14]) {
        case 'e':
            if (memcmp(name, "accept-languag", 14) == 0)
                return H2O_TOKEN_ACCEPT_LANGUAGE;
            break;
        case 'g':
            if (memcmp(name, "accept-encodin", 14) == 0)
                return H2O_TOKEN_ACCEPT_ENCODING;
            break;
        }
        break;
    case 16:
        switch (name[15]) {
        case 'e':
            if (memcmp(name, "content-languag", 15) == 0)
                return H2O_TOKEN_CONTENT_LANGUAGE;
            if (memcmp(name, "www-authenticat", 15) == 0)
                return H2O_TOKEN_WWW_AUTHENTICATE;
            break;
        case 'g':
            if (memcmp(name, "content-encodin", 15) == 0)
                return H2O_TOKEN_CONTENT_ENCODING;
            break;
        case 'n':
            if (memcmp(name, "content-locatio", 15) == 0)
                return H2O_TOKEN_CONTENT_LOCATION;
            break;
        }
        break;
    case 17:
        switch (name[16]) {
        case 'e':
            if (memcmp(name, "if-modified-sinc", 16) == 0)
                return H2O_TOKEN_IF_MODIFIED_SINCE;
            break;
        case 'g':
            if (memcmp(name, "transfer-encodin", 16) == 0)
                return H2O_TOKEN_TRANSFER_ENCODING;
            break;
        }
        break;
    case 18:
        switch (name[17]) {
        case 'e':
            if (memcmp(name, "proxy-authenticat", 17) == 0)
                return H2O_TOKEN_PROXY_AUTHENTICATE;
            break;
        }
        break;
    case 19:
        switch (name[18]) {
        case 'e':
            if (memcmp(name, "if-unmodified-sinc", 18) == 0)
                return H2O_TOKEN_IF_UNMODIFIED_SINCE;
            break;
        case 'n':
            if (memcmp(name, "content-dispositio", 18) == 0)
                return H2O_TOKEN_CONTENT_DISPOSITION;
            if (memcmp(name, "proxy-authorizatio", 18) == 0)
                return H2O_TOKEN_PROXY_AUTHORIZATION;
            break;
        }
        break;
    case 25:
        switch (name[24]) {
        case 'y':
            if (memcmp(name, "strict-transport-securit", 24) == 0)
                return H2O_TOKEN_STRICT_TRANSPORT_SECURITY;
            break;
        }
        break;
    case 27:
        switch (name[26]) {
        case 'n':
            if (memcmp(name, "access-control-allow-origi", 26) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_ALLOW_ORIGIN;
            break;
        }
        break;
    }

    return NULL;
}
