import os

import pytest

from conans.test.utils.tools import TestClient
from conans.util.files import save, load


@pytest.mark.parametrize(["plugin_path", "string_replace", "new_string"],
                         [("profile.py", "msvc", "EME_ESE_VC"),
                          ("compatibility/compatibility.py", "conanfile", "conian_file"),
                          ("compatibility/cppstd_compat.py", "conanfile", "conian_file")])
def test_migration_profile_checker_plugin(plugin_path, string_replace, new_string):
    t = TestClient()
    # Any command generates the profile and compatibility plugin files
    t.run("-v")

    profile_plugin_path = os.path.join(t.cache.plugins_path, plugin_path)
    contents = load(profile_plugin_path)

    # Let's change the version
    version_txt_file_path = os.path.join(t.cache_folder, "version.txt")
    save(version_txt_file_path, "1.0.0")

    # Do a modification to the profile plugin without changing the comment
    contents = contents.replace(string_replace, new_string)
    save(profile_plugin_path, contents)

    # Trigger the migrations
    t.run("-v")
    assert f"Migration: Successfully updated {os.path.basename(plugin_path)}" in t.out
    contents = load(profile_plugin_path)
    # Our changes are removed!!!
    assert string_replace in contents
    assert new_string not in contents

    # New client, everything new
    t2 = TestClient()
    # This generates the new plugin file
    t2.run("-v")

    # Do a modification to the profile plugin but changing the comment
    profile_plugin_path2 = os.path.join(t2.cache.plugins_path, plugin_path)
    contents = load(profile_plugin_path2)
    contents = contents.replace(string_replace, new_string)
    contents = contents.replace("This file was generated by Conan", "This file is from ACME corp, "
                                                                    "please don't touch it.")
    save(profile_plugin_path2, contents)

    # Let's change the version
    version_txt_file_path2 = os.path.join(t2.cache_folder, "version.txt")
    save(version_txt_file_path2, "1.0.0")
    # Trigger the migrations
    t2.run("-v")
    assert f"Migration: Successfully updated" not in t2.out
    contents = load(profile_plugin_path2)
    # Our Changes are kept!
    assert "This file is from ACME corp, " in contents
    assert string_replace not in contents
    assert new_string in contents
