#title:Nutz Java 编码规范 (V1.0)
#author:zozoh(zozohtnt@gmail.com)
#index:0,1
------------------------------------------------------------------------------------------
0. 规范的规范

	 # 本规范的每一条目必须无二义性，并且可执行。否则作废
	 # 本规范的条目分为两个级别:
		 * 规则 - {#F00;*R}
		 * 建议 - {#080;*S}
	 # 本规范所有的“规则”条目必须被遵守

------------------------------------------------------------------------------------------
1. 代码格式
	 # {#F00;*R}-使用统一的 Eclipse 的代码格式: [http://code.google.com/p/nutz/source/browse/trunk/doc/eclipse/nutz-eclipse-java-code-format-1.0.xml]
		 * 请从 svn 的 trunk/doc/eclipse/nutz-eclipse-java-code-format-1.0.xml 获得此文件
	 # {#080;*S}-非 Eclipse 用户请阅读上述 XML 代码自行遵守
		 * {/基本上我们没有为非 Eclipse 用户指定规范，我们还没有一个好办法}
------------------------------------------------------------------------------------------
2. 命名
	--------------------------------------------------------------------------------------
	2.1 包
		 # {#F00;*R}-包名必须全部小写，2个以内单词。
			 # {#080;*S}-最好为 1 个单数名词
		 # {#F00;*R}-所有项目的包要以 “org.nutz” 为父 包 。
	--------------------------------------------------------------------------------------
	2.2 类和接口
		 # {#080;*S}-最好为名词
		 # {#F00;*R}-命名类和接口时，需要将所有单词的首字母大写。
		 # {#F00;*R}-接口的命名不采用首字母为 I 或加上 IF 后缀的命名方式 。例 如 ：IBookDao 、 BookDaoIF 等 。
		 # {#F00;*R}-抽象类必须使用 Abstract 作为类名的前缀，而接口建议使用 Interface 作为 接口名后缀。
		 # {#F00;*R}-异常类应该使用 Exception 做为 名称 后缀。
		 # {#F00;*R}-如果是运行一次就抛弃的类，以 ing 结尾，比如Rendering
		 # {#F00;*R}-类名尽量短，但是最好不要缩写，如果缩写，必须为特别常用的类，比如 org.nutz.dao.Cnd
			 * 因为调用者书写你的类名太长，他(她)的IDE会自动替他(她)换行，他会觉得有点不爽
		 # {#F00;*R}-不要和 Java 的标准库中的类名冲突，比如 Class, Object, String 等
			 * 如果冲突，就表示你极其藐视 Java 标准库中的那个的设计
			 * 调用者需要花更多的时间和代码来明确他使用的是你的类, 而不是标准库中的那个
		 # {#080;*S}-以下情况可以允许写奇怪类名 -- {^名称简短，让人一眼不知道什么意思，用了以后一眼就能知道什么意思}
			 * 类特别常用
			 * 类非常特殊，难以归类
			 * 私有类或内部类
			 * 不推荐其他人调用的 公有、保护、默认类
				 * 起个奇怪的名字，就是不想让你关心这个类的代码
		 # {#F00;*R}-缺省接口实现应该使用 Default 名称 前缀 。例 如 ： DefaultEntityMaker。
			 * 也可以采用 Impl 作为后缀，表示这个实现为此接口的最优实现或者唯一实现
	--------------------------------------------------------------------------------------
	2.3 成员变量
		 # {#080;*S}-最好为单数名词
		 # {#F00;*R}-能 private 就不要 default，能 default 就不要 protected，最好不要 public
		 # {#F00;*R}-如果是集合或数组，用复数名词
			 * Map pets， 比 Map petMap 要好
		 # {#F00;*R}-不要用一个字母，尤其是 i，你可以用 index 或者 cursor 来代替
	--------------------------------------------------------------------------------------
	2.4 常量
		 # {#F00;*R}-命名常量（带有 final 修饰符的域）时需分隔。如 ： public final int MAX_VALUE = 30 。
	--------------------------------------------------------------------------------------
	2.5 局部变量
		 # {#F00;*R}-局域变量名要尽量短，推荐用缩写，比如 `StringBuilder sb`
		 # {#F00;*R}-总的来说局部变量请随意命名，越短越好
		 
		 比如这个就不好
		 {{{<Java>
		 public String abc(String str){
			AbcObjectSet abcObjectSet = new AbcObjectSet();
			abcObjectSet.setName(str);
			return abcObjectSet.getBrief();
		 }
		 }}}
		 而这个就很容易阅读了：
		  {{{<Java>
		 public String abc(String str){
			AbcObjectSet aos = new AbcObjectSet();
			aos.setName(str);
			return aos.getBrief();
		 }
		 }}}
		 
	--------------------------------------------------------------------------------------
	2.6 成员函数和静态函数
		 # {#F00;*R}-除了 setter / getter，其他的函数采用动词或者动名短语
		 # {#080;*S}-以下情况可以允许写奇怪函数 -- {^名称简短，让人一眼不知道什么意思，用了以后一眼就能知道什么意思}
			 # 函数特别常用
			 # 函数非常特殊
			 # 私有函数或默认函数
		 # {#080;*S}-支持链式赋值的 setter 允许写成 ，并且也可以支持同名 getter
			{{{<JAVA>
			// Setter
			public Pet name(String name){
				this.name = name;
				return this;
			}
			
			// Getter
			public String name(){
				return this.name;
			}
			}}}
------------------------------------------------------------------------------------------
3. 注释
	 # {#F00;*R}-注释必须和代码保持同步 。
	 # {#F00;*R}-注释中的第一个句子要以（英文）句号、问号或者感叹号结束。 Java成工具会将注释中的第一个句子放在方法汇\
	   总表和索引中。
	 # {#F00;*R}-如果注释中有超过一个段落，用 `<P>` 标签 分隔。
	 # {#F00;*R}-如果注释中有多个章节，用 `<H2>` 标签声明每个章节的标题。
	 # {#F00;*R}-如果注释需要换行，用 `<BR>` 标签。
	 # {#F00;*R}-示例代码以 `<PRE></PRE>` 包裹。

	--------------------------------------------------------------------------------------
	3.1  类 Java Doc 
		 # {#F00;*R}-要著名作者，格式为 @Author XiaoMing(xm@gmail.com)
		 # {#F00;*R}-继承的方法可以省略注释，但是被继承方法必须有注释。
	--------------------------------------------------------------------------------------
	3.2  函数 Java Doc 
		 # {#F00;*R}-简单的 get/set 方法可以省略注释。
		 # {#F00;*R}-继承的方法可以省略注释，但是被继承方法必须有注释。
	--------------------------------------------------------------------------------------
	3.3  字段 Java Doc 
		 * {#F00;*R}-没有更多说明了
	--------------------------------------------------------------------------------------
	3.4  函数内部注释
		 * {#F00;*R}-行注释和块注释都是可以被接受的
		 * {#F00;*R}-不要写 JAVA DOC，没意义
		 * {#F00;*R}-代码质量不好但能正常运行，或者还没有实现的代码用 “ //TODO: ”
		 * {#F00;*R}-在 if ... else .. 分支上做注释格式应该如下：
			{{{
			// comments for case A
			if(xxxx){
				//TODO you code here
			}
			/*
			 * Multipline comments for case B
			 */
			else if(xxxxx){
				//TODO you code here
			}
			// comments for default case
			else{
				//TODO you code here
			}
			}}}
------------------------------------------------------------------------------------------
4. 编程
	 # {#F00;*R}-你的每一次提交，必须都是编译通过的
	 # {#F00;*R}-你的每一次提交，最好都是通过 JUnit 测试的
		 * 除非有特别的情况 -- 比如你要和其他人分享的修改
	 # {#F00;*R}-无论任何时候，同样的功能，一段更短的代码，总比更长的代码要好
		 * 这里的“短”，主要指的是“逻辑”短，而不是“字符长度”短
	 # {#F00;*R}-删掉一段代码的贡献，比增加一段代码的贡献要大，至少不比它小
	 # {#F00;*R}-避免过度设计
		 * 先让代码能工作，然后重构成为优美的代码
		 * 你需要知道，“接口”固定了架构，“类” 不是，当它进化为接口的时候就固定了
		 * 代码结构设计请遵循《[http://blog.sina.com.cn/s/blog_4b19fa3701000720.html 草坪原则]》
------------------------------------------------------------------------------------------
5. 单元测试
	 # {#F00;*R}-用例名请用 "{#00F;*长名}" - 一句话，用下划线`_`代替空白
		 * 通过这个名字，基本可以了解测试是干什么的
	 # {#F00;*R}-主要接口和实现类要尽可能多的被用例覆盖
