#title: 过滤字段
#index:0,1

为什么需要过滤字段
	 某些时候，尤其是在更新对象的时候，用户希望忽略某些字段。通过注解 [annotations.man Nutz.Dao 实体注解] {#A74;*@Readonly} 可以达到
	 这个目的。但是更多的时候，对于 POJO 对象，只有在运行时，用户的程序才能决定哪些字段更新，哪些不更新。{#A74;*@Readonly} 注解可就达不到这个
	 目的了。

	 怎么办呢？ Nutz.Dao 提供了类似于 [dynamic_table_name.man 动态表名] 的解决办法。

如何过滤字段的例子
	如下代码，将只更新 Pet 的 id 和 name 字段：
	{{{<JAVA>
	FieldFilter.create(Pet.class, "id|name").run(new Atom() {
		public void run() {
			Pet pet = dao.fetch(Pet.class, 24);
			pet.setName("ABC");
			pet.setNickname("XiaoBai");
			dao.update(pet);
		}
	});
	}}}

关于 FieldFilter 
	类 org.nutz.dao.FieldFilter  提供了静态创建函数 create。 对于 FieldFilter 类的实例，也提供了 set 方法，可以设置什么字段可以被过滤。又提供
	run 函数，接受一个 org.nutz.trans.Atom 类型的参数。

	<funcs_field_filter.png>

	在调用 run 函数之前，你需要通过 set 方法（或者直接 FilterFilter.create 传入的参数）你可以设定一组名值对，其中以 POJO 的 `Class<?>` 为键，以
	一个 FieldMatcher 对象为值。 FieldMatcher 对象有三个字段：
	
	<funcs_field_matcher.png>

	实际上，FieldFilter 记录了一组配置的信息，对于每个 POJO 对象，都有三个值
	 # actived
	 # locked
	 # ignoreNull
	其中，actived 和 locked 是 [http://java.sun.com/javase/6/docs/api/java/util/regex/Pattern.html java.util.regex.Pattern]（{#080;_正则表达式}）型字段。
	匹配的是一个 POJO 的的字段名。
	 # 如果 actived 不为 null，没有被其匹配上的字段在 Nutz.Dao 操作的时候会被忽略
	 # 如果 locked 不为 null，被其匹配上的字段在 Nutz.Dao 操作的时候会被忽略
	 # 如果 ignoreNull 为 true， 在 Nutz.Dao 操作的时候， 值为 null 的字段会被忽略
	
	你可以根据自己的需要，按照 POJO 类型来设置具体哪些字段被忽略。