#title:交叉事务
#index:0
-----------------------------------------------------------------------------------------

{{{
函数 A
	数据操作 1;
	数据操作 2;

函数 B
	数据操作 3;
	-> 函数 A();

函数 C
	数据操作 4;
	-> 函数 A();
}}}

则称，A 为 B,C 的交叉操作。
如果，A,B,C 都需要保证事务性，则 A 为 B, C 的交叉事务

Nutz.Dao 的原子操作支持事务嵌套，所以你可以这么实现这三个函数：
{{{
函数 A
	Trans.exec(new Atom(){
		public void run(){
			数据操作 1;
			数据操作 2;
		}
	});

函数 B
	Trans.exec(new Atom(){
		public void run(){
			数据操作 3;
			-> 函数 A();
		}
	});

函数 C
	Trans.exec(new Atom(){
		public void run(){
			数据操作 4;
			-> 函数 A();
		}
	});
}}}

那么，这三个函数都是事务性的。
就是说，只有最外层的事务是起作用的，被包裹的事务会“融化”在上层事务里