#title: AOP -- 声明式切片
#author:wendal(wendal1985@gmail.com)
#index:0,1

声明拦截器
	 * 你需要有一个拦截器对象，如果你愿意，你当然可以有不止一个拦截器对象。
	 * 将这个对象声明在你的配置文件里，就像一个普通的对象一样
	
在对象的方法中声明切片
	 * 在你要拦截的方法上，声明 @Aop 注解
	 * 方法所在的对象必须是容器中的对象
	 * @Aop 注解接受数目可变的字符串，每个字符串都是一个拦截器的名称,即必须在ioc中声明这个拦截器

最简单的一个拦截器
     {{{
         public class MyMethodInterceptor implements MethodInterceptor {
                
                public void filter(InterceptorChain chain) throws Throwable {
                		System.out.println("咦?这个方法执行了!");
                		chain.doChain();// 继续执行其他拦截器
                		System.out.println("这个方法执行完成了!");
                }
         }
     }}}
     
     {{{
     public class MyClass {
               
               @Aop("myMethodInterceptor")
               public void oneMethod(){
                   //Do something
                   System.out.println("没人知道我在干什么的!");
               }
     
     }
     }}}
     将会打印
     {{{
     咦?这个方法执行了!
     没人知道我在干什么的!
     这个方法执行完成了!
     }}}
     很简洁,对吧? 这就是NutAop
     
已经为你准备好的拦截器
    * org.nutz.aop.interceptor.LoggingMethodInterceptor 添加日志记录
    * org.nutz.aop.interceptor.TransactionInterceptor 添加事务