#title:主模块-子模块-入口函数
#author:zozoh(zozohtnt@gmail.com)
#index:0,1
------------------------------------------------------------------------
主模块
	
	任何一个类都可以作为主模块，只要你将其配置在 web.xml 中，这样的设计主要是为了方便
	一些非 JSP/Servlet 标注的 web 服务器整合 Nutz.mvc 框架。
	
	在主模块中，你可以声明如下的注解：
	
	 * [#@Modules_-_声明应用的所有子模块 @Modules - 声明应用的所有子模块]
	 * [#@IocBy_-_设置应用所采用的_Ioc_容器 @IocBy - 设置应用所采用的 Ioc 容器]
	 * [#@SetupBy_-_应用启动以及关闭时的额外处理 @SetupBy - 应用启动以及关闭时的额外处理]
	 * [#@Views_-_自定义的扩展视图 @Views - 自定义的扩展视图]
	 * [#@Localization_-_应用的本地化字符串设定 @Localization - 应用的本地化字符串设定]
	 * [#入口函数 所有入口函数上支持的注解]
		 * 声明在主模块模块的注解，将作为所有[#入口函数 入口函数]的默认配置
		 * 在[#子模块 子模块]中的定义更为优先
	
	--------------------------------------------------------------------
	@Modules - 声明应用的所有子模块
		
		指定子模块
		{{{
		@Modules({ UserModule.class, PetModule.class})
		public class MainModule {
			...
		}}}
		
		自动搜索子模块
		{{{
		@Modules(scanPackage = true)
		public class MainModule {
			...
		}}}
		将自动搜索主模块所在的包（包括子包）下所有的类，如果有类包括了一个以上的
		[#入口函数 入口函数]将被认为是模块类
		
		半自动搜索子模块
		{{{
		@Modules(value={Abc.class, Xyz.class}, scanPackage = true)
		public class MainModule {
			...
		}}}
		将自动搜索主模块类，Abc.class，Xyz.class 所在的包（包括子包）下所有的
		类，如果有类包括了一个以上的[#入口函数 入口函数]将被认为是模块类
		
	--------------------------------------------------------------------
	@IocBy - 设置应用所采用的 Ioc 容器
		
		声明了 Ioc 容器的获取方式，详情请参看 [with_ioc.man 同 Ioc 容器一起工作] 一节
		
	--------------------------------------------------------------------
	@SetupBy - 应用启动以及关闭时的额外处理
		
		在整个应用启动或者关闭时，你想做一些额外的处理工作，你可以实现一个
		org.nutz.mvc.Setup 接口，并将其配置在[#主模块 主模块]上
		{{{
		@SetupBy(MyAppSetup.class)
		public class MainModule {
			...
		}}}
	
	--------------------------------------------------------------------
	@Views - 自定义的扩展视图
	
		Nutz.Mvc 允许你定制自己的[view.man 视图]，如何使用这个注解，请参看
		[view.man#定制自己的视图 视图>定制自己的视图] 一节
	
	--------------------------------------------------------------------
	@Localization - 应用的本地化字符串设定
	
		Nutz.Mvc 允许你定制自己的本地化字符串存取方式，同时它也提供了默认的本地化字符
		串存取方式，请参看 [localization.man 本地化字符串] 一节
	
------------------------------------------------------------------------
子模块
	
	任何类都可以作为子模块，只要通过
	[#@Modules_-_声明应用的所有子模块 @Modules 注解]	声明到[#配置主模块 主模块]上即可
	
	在子模块，你可以声明
	
	 * [with_ioc.man @InjectName 使用 Ioc 容器管理本模块]
	 * [#入口函数 所有入口函数上支持的注解]
		 * 声明在子模块的注解，将作为所有[#入口函数 入口函数]的默认配置
	 
------------------------------------------------------------------------
入口函数

	子模块中任何函数，只要是 public 的，且不是 static 的，都可以作为入口函数
	标记入口函数的方法是在其上标注注解 [#@At_-_入口函数对应的_URL @At]
	
	在入口函数上，你可以声明如下注解：
	
	 * [#@At_-_入口函数对应的_URL @At - 入口函数对应的 URL]
	 * [#@Ok_-_成功视图 @Ok - 成功视图]
	 * [#@Fail_-_失败视图 @Fail - 失败视图]
	 * [#@AdaptBy_-_HTTP_参数适配方式 @AdaptBy - HTTP 参数适配方式]
	 * [#@Filter_-_过滤器 @Filter - 过滤器]
	 * [#@Encoding_-_输入输出编码 @Encoding - 输入输出编码]
	
	@At - 入口函数对应的 URL
		只有标记了这个注解的函数才被认为是[#入口函数 入口函数]，例如
		{{{
		@At("/my/abc")
		public void someFunc(){
			...
		}}}
		你也可以为该函数声明多个 URL 
		{{{
		@At({"/my/abc", "/my/xyz"})
		public void someFunc(){
			...
		}}}
		
		 * 你也可以为其声明路径参数，详细情况请参看 [http_adaptor.man#路径参数 适配器>路径参数] 一节
		 * 如果，你想详细了解 URL 映射的细节，请参看 [url_mapping.man URL 映射] 一节。
		
		
	@Ok - 成功视图
		声明了入口函数的成功视图，即如果入口函数正常执行，将会通过这个视图将函数返回值渲染到 HTTP 响应中。
		当然，如果你的函数直接返回的就是一个视图对象，那么就不会使用成功视图（而是你返回的视图对象）来渲染
		HTTP 响应
		详细的介绍，请参看 [view.man 视图] 一节
		
	@Fail - 失败视图
		声明了入口函数的失败视图，即如果入口函数抛出异常，将会通过这个视图将异常渲染到 HTTP 响应中
		详细的介绍，请参看 [view.man 视图] 一节
	
	@AdaptBy - HTTP 参数适配方式
		将 HTTP 请求参数转变成你当前入口函数的参数的过程叫做 {*适配}，这个注解就是声明这个适配器。
		如果你没有声明这个注解，默认的会采用 PairAdaptor 来适配 HTTP 请求参数。
		详细的介绍，请参看[http_adaptor.man 适配器] 一节
	
	@Filter - 过滤器
		详细介绍请参看 [action_filter.man 过滤器] 一节		
		
	@Encoding - 输入输出编码
		定义 HTTP 请求的输入输出编码，这个注解通常是会定义在 [#主模块 主模块] 上面，从而
		保证整个应用有统一的输入输出设定
		
		如果你不定义，默认的，Nutz.Mvc 会采用 {*UTF-8} 作为输入输出的编码
		{{{
		@Encoding(input="UTF-8",output="UTF-8")
		}}}
