#title:zDoc 概述
#index:0,2

我为什么要建立 zDoc 项目?
	开源项目最需要的（同时也是最缺乏的）就是丰富全面的文档。在建立开源项目 [http://nutz.googlecode.com Nutz] 的时候，我深刻的体会到了这一点。
	为此，经过思考，我认为只要做到下面两件事：
	 # 让每篇文档很容易写
	 # 让每篇文档可以同时被多人写
	那么，对在开源项目的文档写作方面的工作，会有很大帮助的。
	
	根据多年惨痛的文档写作经验我得出了如下两个结论：

	*  类似 Word 的桌面文档工具并不适合多人协同工作
		* 除非你给MS纳钱，架个 SharePoint 类的服务器
		* 文档的改动历史追踪很困难
		* 跨平台性不太好（因为兼容性的问题）
	* 在线文档应用并不适写庞大的文档
		* Google Doc 之类的，当文档大的时候，编辑起来会很慢
		* 总有意外的小Bug，而且通常很恼人
	
	所以，我必须构建自己的文档写作方式。我注意到两个事实：
	 # 对于文档变动的管理，我想现在的版本控制系统已经做的足够好了（比如 SVN, Git, Mercurial）。
	 # 市面上所有的操作系统都会对纯文本文件（尤其是 UTF-8）支持的很好。（比如 Windows的Nodepad++，Editplus,Ultra-Edit 以及 Linux 下的 Vim 等）
	所以，我打算将这两个事实充分利用起来。尤其幸运的是我本人就是一名程序员，于是我便是建立了一个小小的文本文件解析渲染器 -- zDoc。

	
zDoc 要达到的目标
	* 我将使用任何一款我喜欢的{*纯文本编辑器}来编辑我的文档
		* 所以我可以利用 SVN 等工具来管理版本，协作编写文档
	* 我的文档将包含文字，以及 B/I/S 等格式信息
	* 利用缩进来划分文档的结构
	* 可以生成文档目录索引
	* 支持超链接，包括文档内部和外部
	* 支持图片
		* 流行的图片
		* 支持 Icon
		* 可自定义大小
	* 支持输出的格式
		* PDF
		* HTML (browser from local)
		* HTML (browser from web)
		* Google Wikie
	* 文档可以 include 另外一个文档 

如何使用 zDoc
	设置运行环境
		zDoc 提供了命令行程序，使用它之前你需要做如下设定
		# 在发布包里面找到 run 目录
		# 打开其中的 win 目录或者 linux 目录({_依你自己的操作系统而定})
		# 修改脚本文件 zdoc ( {_Windows 下为 zdoc.bat} ) -- 你需要修改三个变量
			# JAVA_HOME 指向你的 Java 安装的根目录（这个目录下有 lib 子目录，其内有 tools.jar, dt.jar 以及 rt.jar）
			# NUTZ_HOME 指向 Nutz 的核心 jar 包: {_可从此处下载=>} [http://nutz.googlecode.com]
			# ZDOC_HOME 指向 Nutz.Doc 的运行 jar 包: {_可从此处下载=>} [http://nutzdoc.googlecode.com]
		# 修改运行路径
			* {*Windows} 用户可以将 run 目录加入到你的系统环境变量 {#00A;*%PATH%} 中去
			* {*Linux} 用户，可以将 zdoc 脚本文件链接至 ~/bin 目录下。
				* 请确保此脚本文件权限为可执行
					{{{<bash>
					chmod +x ./zdoc
					}}}
	将 zDoc 转换成 HTML
		{*命令格式}
		{{{
		 zdoc html [源目录] [目标目录]
		}}}
		{*说明}
		 * 这三个参数缺一不可
		 * 第一个参数表示要转换成 HTML
		 * 第二个参数声明了zDoc源目录
			 * 该目录下如果有 index.xml，将能更为精确的控制生成的 html 目录索引
			 * 请看 [index_xml.man zDoc 目录转换中的索引文件--index.xml的语法]
			 * 你的 zdoc 文件必须以 .man 或者 .zdoc 为后缀名，大小写不敏感
			 * 更多的关于目录转换的细节请参看 [dir_convert.man 目录转换细则]
		 * 第三个参数为目标输出的目录
		
		{*比如}
		{{{
		zdoc html /folder/abc /output/abc
		}}}
		会将目录 /folder/abc 所有的 zdoc 文档转换成 HTML 文档，并输出到 /output/abc 目录下
		
	将 zDoc 转换成 Goolge wiki
		Google code  是很多开源项目理想的开发平台。 它提供了 wiki 功能。 如果你建立一个 wiki 页面，在它的版本控制服务的目录内，会出现
		一个 wiki 的目录，通常，是在 /trunk/wiki 下。
		
		Google code 的 wiki 格式非常简单，易于理解，Google 为其提供了较强大的页面渲染支持。所以将 zDoc 直接渲染成 Google wiki 对大多数
		在 Google code 上的开源项目是很有用的，你需要执行如下格式的命令
	
		{*命令格式}
		{{{
		zdoc gwiki [源目录] [目标目录] [索引文件名] [图片地址前缀]
		}}}
		{*说明}
		 * 第一个参数表示要转换成 Goolge Wiki
		 * 第二个参数声明了zDoc源目录
			 * 该目录下如果有 index.xml，将能更为精确的控制生成的目录索引
			 * 请看 [index_xml.man zDoc 目录转换中的索引文件--index.xml的语法]
		 * 第三个参数指明 wiki 目录， zDoc 将会在这个目录下生成所有的 .wiki 文件
		 * 第四个参数为索引文件名，请参看 [http://code.google.com/p/support/wiki/WikiSyntax#Navigation Google wiki 关于目录索引的描述]
			 * zDoc 会替你生成这个索引文件
			 * 如果你写 null，zDoc 将不会生成这个文件
		 * 第五个参数有些奇怪，因为 Google wiki 并不支持图片存储，它只支持图片引用。所以你的文档中如果有图片，必须要存放在某一个可被\
		   互联网访问到的地址上
			 * 这个参数也不是必须的
			 * 如果你声明了这个参数，所有的 zDoc 文档中引用的本地图片
				 * 将会被目标目录根录下一个叫 {*wiki_imgs} 的目录下，你可以用 ftp 工具，将图片上传到你指定的地址
				 * 生成后的 wiki 文件，图片地址将指向你声明的地址
				 * 如果你的图片重名，zDoc 将自动为你改名（按顺序增加数字后缀）
		
		{*比如}
		{{{
		zdoc gwiki /folder/abc /output/abc wiki_index_page http://www.my.com/wiki/img
		}}}
		会将目录 /folder/abc 所有的 zdoc 文档转换成 Google wiki 文档，并输出到 /output/abc 目录下。并会根据 index.xml （如果没有，根据文件）
		生成一个索引 wiki 页，文件名为 wiki_index_page.wiki。所有的本地图片都会被打入压缩包 /output/abc/wiki_images.zip，并且所有的本地图片
		地址都将变成 http://www.my.com/wiki/img/xxxx.xxx
	
	将 zDoc 转换成 PDF 文件
		PDF 是一个非常通用的文档格式。如果你通过 zDoc 建立一组文件，你就可以用如下命令生成 PDF 文件
		{{{
		zdoc pdf [source dir] [target pdf path]
		}}}
		{*说明}
		 * 第一个参数表示要转换成 PDF 文档
		 * 第二个参数声明了zDoc源目录
			 * 该目录下如果有 index.xml，将能更为精确的控制生成的目录索引
			 * 请看 [index_xml.man zDoc 目录转换中的索引文件--index.xml的语法]
		 * 第三个参数指明一个 PDF 的文件，如果该文件不存在，会被自动创建，否则会被覆盖。
		
		这里还需要注意的是，因为 PDF 输出，zDoc 依赖的是 iText 项目，你需要
		 # iText-2.X.X.jar
		 # iTextAsian.jar - 用来支持中文
		 # 在你的 CLASSPATH 内，放置一个字体文件，名字为 {*pdf_font.ttf} 或者 {*pdf_font.ttc}
			 * 这个文件必须放置在 CLASSPATH 的根，即，同 Log4j.properties 同级，比如：
			{{{
			 [My Class Folder]
			    [com]
				   [my]
				       Abc.class
					   Main.class
			    log4j.properties
				pdf_font.ttf
			}}}
			 * {*.ttf} 字体文件更优先
		
		{*比如}
		{{{
		zdoc pdf /home/peter/myDoc /home/peter/myPdf.pdf
		}}}
		会将目录 /home/peter/myDoc 所有的 zDoc 文档转换成一个大的 PDF 文件 /home/peter/myPdf.pdf

其他
	 * 关于 zdoc 文件详细的语法，请参看 [syntax.man zDoc 的语法说明]
	 * 关于目录转换的细则，请参看 [dir_convert.man 目录转换细则] 以及 [index_xml.man 使用 index.xml 作为索引文件]
	 * zDoc 已经被我应用到具体的工作中，比如写作界面设计文档，以后如果我打算写小说，也会使用 zDoc。
	 
	 总之，一个文本编辑器，一个 SVN 服务器就可以多人协作，写出漂亮的文档，这种感觉会很美妙的。
				
			
	