#title: zDoc语法
#index:0,1
--------------------------------------------------------------------------------------------
什么是zDoc文档
	* zDoc 是纯文本的文档
	* zDoc 必须是 UTF-8 编码的
	* 它以"行"为单位进行文档解析
--------------------------------------------------------------------------------------------
标题与段落
	{{{<zDoc>
	这里是标题
		这里是内容

		这里是二级标题
			这里是内容

		二级标题可
		以折行
			紧跟着一个缩进内容就可以
	}}}
	* 缩进的行是它上一行的{*子}
	* 拥有{*子}的行就是标题行
	* zDoc 理论上拥有无限层次的标题行
--------------------------------------------------------------------------------------------
无序列表
	{{{<zDoc>
	 * 项目 A
		 * 项目 A1
		 * 项目 A2
	 * 项目 B
	}}}
	 * 格式段落以 `* ` (星号+空格) 或者 (空格+星号+空格) 开头
	 * 连续的这样的段落为一个列表
--------------------------------------------------------------------------------------------
有序列表
	{{{<zDoc>
	 # 项目 A
		 # 项目 A1
		 # 项目 A2
	 # 项目 B
	}}}
	 * 格式段落以 `# ` (星号+空格) 或者 (空格+星号+空格) 开头
	 * 连续的这样的段落为一个有序列表，生成器会自动为你生成序号
--------------------------------------------------------------------------------------------
超链接
	* 在行内 被方括弧`[`和`]`包裹起来的就是超链接
	* `[http://www.google.com]` 将显示成 [http://www.google.com]
	* `[http://www.google.com Google]` 将显示成 [http://www.google.com Google]
	* `[http://www.google.com text with whitespace]` 将显示成 [http://www.google.com text with whitespace]
	* `[http://nutz.googlecode.com <http://code.google.com/p/nutz/logo?logo_id=1239077401>]` 将显示成
		[http://nutz.googlecode.com <http://code.google.com/p/nutz/logo?logo_id=1239077401>]
--------------------------------------------------------------------------------------------
逃逸字符
	* 被字符 `` 包括起来的内容将不做格式转换
	* 连续两个 ````  将表示一个 ``
--------------------------------------------------------------------------------------------
文字及样式
	zDoc 支持如下字体样式，暂时不支持下划线，以及字体颜色
	|| {*名称}		|| {*zDoc 语法}			|| {*文本}				||
	|| 粗体			|| `{*some text}`		|| {*some text}			||
	|| 斜体			|| `{/some text}`		|| {/some text}			||
	|| 下划线		|| `{_some text}`		|| {_some text}			||
	|| 穿越线		|| `{~some text}`		|| {~some text}			||
	|| 红色斜体		|| `{#F00;_some text}`	|| {#F00;_some text}	||
	|| 穿越线斜体	|| `{*/~some text}`		|| {*/~some text}		||
	|| 标注			|| `txt{^sup}`			|| txt{^sup}			||
	|| 底注			|| `txt{,sub}`			|| txt{,sub}			||
	{_#080;各个格式的组合，顺序没有限制}
--------------------------------------------------------------------------------------------
图片
	格式为
	{{{
	<[宽x高:]图片地址>
	}}}
	* 在行内，被 `<` 和 `>` 包括起来文字将表示一个图片地址
	* 这个地址如果以 http:// 或者 https:// 开头，将作为远程图片地址
	* 否则将作为本地图片
		* 本地图片必须存在
		* 如果本地图片存在，将被{#900;*相对拷贝}
		* 所谓{#900;*相对拷贝}指
			* 如果图片地址为绝对地址，则保持不变
			* 如果图片地址为相对地址，则相对于输出位置，拷贝图片，以使图片链接生效
	
	比如
	{{{
	图片：<../logo.png>
	}}}
	将显示成:

	图片：<../logo.png>

	当然，我们可以控制图片的大小
	{{{
	图片：<60x15:../logo.png>
	}}}
	将显示成:

	图片：<60x15:../logo.png>

	{#F00;*注意}，你必须同时写出图片的宽度和高度。
--------------------------------------------------------------------------------------------
分隔线
	* 任何行内内容全部为减号 `-` ，并且数量不少于5个，将被认为是分隔线
	* 比如如果一行內容为
		{{{<zDoc>
		-----
		}}}
		如果输出成 HTML 代码，则为
		{{{<HTML>
		<div class="hr"></div>
		}}}
--------------------------------------------------------------------------------------------
代码
	* 以 `{{{` 开始的行，下面所有的行都被认为是代码，一直到 `}}}` 开始的行为止
	* `{{{<java>` 表示代码的类型为java源代码
		* 你可以随便输入你的代码类型，比如 C#, Python, SQL, HTML 等等
	比如

	`{{{<Javascript>`

	`function abc(msg){`

	 `alert(msg);`

	`}`

	`}}}`
	
	将显示为:
	{{{<Javascript>
	function abc(msg){
	alert(msg);
	}
	}}}
--------------------------------------------------------------------------------------------
表格
	* 以 || 开始，并以 || 结束的行，被认为是表格行
	* 连续的表格行被认为是一个表格
	* 符号 || 之间的内容被认为是一个单元格
		比如
		{{{<zDoc>
		||A||{*B}||[http://www.google.com Google]||
		||X||{*YYY}||[http://www.apache.org Apache]||
		}}}
		将显示成：
		||A||{*B}||[http://www.google.com Google]||
		||X||{*YYY}||[http://www.apache.org Apache]||
--------------------------------------------------------------------------------------------
目录索引
	* 在文档任何行写 `#index:3` 将会在该位置生成目录
		* 其中 3 表示目录级别到第3层
	* {#A00;*层数是以 0 开始的}
	* 声明 `#index:0,3` 表示目录级别为第0层到第3层
--------------------------------------------------------------------------------------------
文档属性
	|| {*zDoc 语法}			|| {*说明}															||
	|| `#title:文档标题`	|| 声明文档标题，如  `#title:今天是个好日子`														||
	|| `#author:文档作者`	|| 声明文档作者，格式为：{#0AA;作者名(电子邮件)}  其中 {#0AA;*(电子邮件)} 可选，如 `#author:zozoh<zozoh@mail.com>`	||
