/**
This package contains tutorials for most of functionality provided by aedi framework.
See source code as well for runnable examples.

$(OL
    $(LI $(LINK2 /aedi/examples/minimal.html, minimal))
    $(LI $(LINK2 /aedi/examples/dependencies.html, dependencies))
    $(LI $(LINK2 /aedi/examples/named_dependencies.html, named_dependencies))
    $(LI $(LINK2 /aedi/examples/configuration_primitives.html, configuration_primitives))
    $(LI $(LINK2 /aedi/examples/multiple_containers.html, multiple_containers))
    $(LI $(LINK2 /aedi/examples/value_container.html, value_container))
    $(LI $(LINK2 /aedi/examples/memory_management.html, memory_management))
    $(LI $(LINK2 /aedi/examples/annotation_configuration.html, annotation_configuration))
    $(LI $(LINK2 /aedi/examples/decorating_containers.html, decorating_containers))
    $(LI $(LINK2 /aedi/examples/extending_containers.html, extending_containers))
    $(LI $(LINK2 /aedi/examples/extending_factory.html, extending_factory))
    $(LI $(LINK2 /aedi/examples/extending_generic_factory.html, extending_generic_factory))
)
License:
    Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:

    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

Authors:
    Alexandru Ermicioi
**/

module examples;

public import annotation_configuration;
public import configuration_primitives;
public import decorating_containers;
public import dependencies;
public import extending_containers;
public import extending_factory;
public import extending_generic_factory;
public import memory_management;
public import minimal;
public import multiple_containers;
public import named_dependencies;
public import value_container;