/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:

	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/

module aermicioi.aedi.container.application_container;

import aermicioi.aedi.container.aggregate_container;
import aermicioi.aedi.container.value_container;
import aermicioi.aedi.container;
import aermicioi.aedi.storage;
import aermicioi.aedi.exception;

import std.range.interfaces;
import std.typecons;

/**
Application container

A default container that provides singleton, and prototype containers as well as a storage for
already instantiated component. It should be sufficient for usages, when no specific hierarchy of storages
is required.

**/
class ApplicationContainer : AggregateContainer {

    public {

		/**
		 * Default constructor for ApplicationContainer
		**/
        this() {
			import std.traits : fullyQualifiedName;
			import aermicioi.aedi.factory.factory : ObjectFactory;
			auto singleton = new SingletonContainer;
			auto prototype = new PrototypeContainer;
			auto parameters = new ValueContainer;

            this.set(singleton, "singleton");
			this.set(singleton, fullyQualifiedName!(Storage!(ObjectFactory, string)));
			this.set(singleton, fullyQualifiedName!SingletonContainer);
            this.set(prototype, "prototype");
			this.set(prototype, fullyQualifiedName!PrototypeContainer);
            this.set(parameters, "parameters");
			this.set(parameters, fullyQualifiedName!ValueContainer);
        }
    }
}