/**

License:
	Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:

    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

Authors:
	Alexandru Ermicioi
**/
module aermicioi.aedi.container.container;

import aermicioi.aedi.factory.factory;
import aermicioi.aedi.storage.locator;
import aermicioi.aedi.storage.storage;
import aermicioi.aedi.storage.alias_aware;

/**
Interface for objects that instantiate and manage the lifetime of objects in it.
**/
interface Container : Locator!(Object, string) {

    public {

        /**
        Sets up the internal state of container.

        Sets up the internal state of container (Ex, for singleton container it will spawn all objects that locator contains).
        **/
        Container instantiate();

        /**
        Destruct all managed components.

        Destruct all managed components. The method denotes the end of container lifetime, and therefore destruction of all managed components
        by it.
        **/
        Container terminate();
    }
}

/**
 Buildable/configurable instantiatiator with factories, and aliasing.
**/
interface ConfigurableContainer : Container, Storage!(ObjectFactory, string), AliasAware!(string), FactoryLocator!ObjectFactory {

}

/**
Provide an interface for accessing factories used by containers to instantiate component.
**/
interface FactoryLocator(T : Factory!Z, Z) {
    import std.range.interfaces : InputRange;
    import std.typecons : Tuple;

    public {

        /**
        Get factory for constructed component identified by identity.

        Get factory for constructed component identified by identity.
        Params:
        	identity = the identity of component that factory constructs.

        Throws:
        	NotFoundException when factory for it is not found.

        Returns:
        	T the factory for constructed component.
        **/
        T getFactory(string identity);

        /**
        Get all factories available in container.

        Get all factories available in container.

        Returns:
        	InputRange!(Tuple!(T, string)) a tuple of factory => identity.
        **/
        InputRange!(Tuple!(T, string)) getFactories();
    }
}