/**


License:
	Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:

    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

Authors:
	Alexandru Ermicioi
**/
module aermicioi.aedi.factory.factory;

import aermicioi.aedi.storage.allocator_aware;
import aermicioi.aedi.storage.locator_aware;
import aermicioi.aedi.storage.locator;

/**
Interface for objects able to create some instance of type T.

Intent of this interface is to provide a single entry for objects, able to
instantiate something.
**/
interface Factory(T) : LocatorAware!(), AllocatorAware!() {

	public {

		/**
		Instantiates component of type T.

		Returns:
			T instantiated component.
		**/
		T factory();

        /**
        Destructs a component of type T.

        Params:
            component = component that is to ve destroyed.
        **/
        void destruct(ref T component);

		@property {

		    /**
    		Get the type info of T that is created.

    		Returns:
    			TypeInfo object of created component.
    		**/
    		TypeInfo type() @safe nothrow const;
		}
	}
}

alias ObjectFactory = Factory!Object;

/**
A mixin that implements a destruct delegating mechanism to decorated factory
**/
mixin template DestructDecoratorMixin(T : Factory!Z, Z) {

    /**
    Destructs a component of type T.

    Params:
        component = component that is to ve destroyed.
    **/
    void destruct(ref Z component) {

        this.decorated.destruct(component);
    }
}

/**
A mixin that implements a factory delegating mechanism to decorated factory
**/
mixin template FactoryDecoratorMixin(T : Factory!Z, Z) {

    /**
    Instantiates component of type T.

    Returns:
        T instantiated component.
    **/
    Z factory() {
        return this.decorated.factory();
    }
}