/**
The package provides a set interfaces that standardise the implementation
of Factory objects. It provides as well a basic set of such objects.
 
The containers defined in container package use them to construct
the objects contained in them. 

See:
$(UL
    $(LI factory.d -> provides basic interface for foactories that can be stored in 
    library containers (DI containers). Implement a new kind of factory only when
    a totally different instantiation logic is required comparing to default one in 
    this package. )
    $(LI generic_factory.d -> provides a set of interfaces that allows to split instantiation
    logic in smaller parts, that are encapsulated in respective objects. It provides
    a default implementation of GenericFactory which is an extension of Factory interface
    that permits to build instantiation logic out of smaller parts. Use/create classes 
    implementing interfaces provided here when, only a part of instantiation logic is
    required to modify, or add. )
    )

Note:
    Default implementations when encounter a LocatorReference in argument list for a 
    constructor or method, interprets it as a reference to an object located in
    container, and therefore fetches it from container and uses it as argument instead
    of LocatorReference object.
    
License:
	Boost Software License - Version 1.0 - August 17th, 2003
    
    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:
    
    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

Authors:
	Alexandru Ermicioi
**/
module aermicioi.aedi.factory;

public import aermicioi.aedi.factory.factory;
public import aermicioi.aedi.factory.generic_factory;
public import aermicioi.aedi.factory.decorating_factory;
public import aermicioi.aedi.factory.proxy_factory;
public import aermicioi.aedi.factory.reference;
public import aermicioi.aedi.factory.wrapping_factory;