/**
Aedi, a dependency injection library.

Aedi is a dependency injection library. It does provide a set of containers that do
IoC, and an interface to configure application components (structs, objects, etc.) 

$(BIG $(B Aim: ))

The aim of library is to provide a dependency injection solution that is
feature rich, easy to use, easy to learn, and easy to extend up to your needs.

$(BIG $(B Why should it be used: ))
$(UL
    $(LI Decouples components in your application. )
    $(LI Decreases hassle with application components setup (wiring and creation) )
    $(LI Increases code reusability (since no dependencies are created in dependent objects.) )
    $(LI Allows easier to test code that is dependent on other components )
    $(LI Eases the implementation single responsibility principle in components )
    )
    
$(BIG $(B When should it be used: ))
$(UL
    $(LI When an application has to be highly configurable. )
    $(LI When an application has a high number of interdependent components. )
    $(LI When doing unit testing of highly dependent components. )
    )
    
$(BIG $(B How should it be used: ))

It's simple:

$(UL
    $(LI Create a container )
    $(LI Register an application component. Any data (struct, object, union, etc) is treated as application component. )
    $(LI Write a wiring configuration )
    $(LI Repeat process for other components. )
    $(LI Boot container )
)

First of all a container should be created:
---------------
    SingletonContainer container = new SingletonContainer;
---------------

Container is responsible for storing, and managing application's components.

Next, register component into container:
---------------
    container.register!Color
---------------

Component is registered by calling .register method on container with type of component.
Note, that in example we do not end the statement. That's because component should be 
configured next:
---------------
        .set!"r"(cast(ubyte) 250)
        .set!"g"(cast(ubyte) 210)
        .set!"b"(cast(ubyte) 255);
---------------

.set method configures component properties to specific values (setter injection in other words).
Note the example ends in `;` which means that it's end of statement and Color registration/configuration.
Once components are registered and configured, container needs to be booted (instantiated):
---------------
    container.instantiate();
---------------

Container during boot operation, will do various stuff, including creation and wiring of components
between them. It's important to call `container.instantiate()` after all application's components 
have been registered into container, otherwise it is not guaranteed that application will work correctly.

Once container is booted, components in it are available for use. 
To fetch it use locate method like in following example:
--------------- 
container.locate!Color.writeln;
---------------

Try running the minimal example from examples folder, the output of example will 
be the Color that was registered in container:
---------------
Color is:	Color(250, 210, 255)
---------------

License:
	Boost Software License - Version 1.0 - August 17th, 2003
    
    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:
    
    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

Authors:
	Alexandru Ermicioi
**/
module aermicioi.aedi;

public import aermicioi.aedi.exception;
public import aermicioi.aedi.configurer;
public import aermicioi.aedi.factory;
public import aermicioi.aedi.container;
public import aermicioi.aedi.storage;