/**
The purpose of package, is to provide common interface for locating, storing,
aliasing of object. It does provide interface for objects that are implementing
service locator pattern.

There is a basic implementation of such object ObjectStorage.

Example:
---------------
    auto storage = new ObjectStorage!()();
    storage.set(new Object, "some object id");
    storage.get("some object id");
    storage.remove("some object id");
---------------

It does provide an interface for compositing multiple locators into one
composited locator. An object implementing it is AggregateLocatorImpl!().

Example:
----------------
    auto locator = new AggregateLocatorImpl!()();
    locator.set(new ObjectStorage!(), "first");
    locator.set(new ObjectStorage!(), "second");
    locator.get("some object id");
----------------

It does provide an interface for aliasing an object identifier to another
identifier, and resolving the alias of it.

Example:
----------------
    auto storage = new ObjectStorage!()();
    storage.set(new Object, "some object");
    storage.link("some object", "an alias");
    assert(storage.resolve("an alias") == "some object");
    assert(storage.get("an alias") == storage.get("some object");
----------------

See:
$(UL
    $(LI storage.d -> module that contains the object storage interface.
        It is used in library to declare containers as able to save Factory
        for objects that are registered in containers.)
    $(LI locator.d -> module that contains the object locator interface.
        It is used in library to decliare containers as able to locate
        objects required by your application, or other objects that depend on
        required object. It provides an interface for aggregate locator, as well
        as a convenient function for automatic cast of objects from Locators to
        desired type. )
    $(LI alias_aware.d -> module that declares interface for aliasing capabilities. )
    )

License:
	Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:

    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

Authors:
	Alexandru Ermicioi
**/
module aermicioi.aedi.storage;

public import aermicioi.aedi.storage.aggregate_locator;
public import aermicioi.aedi.storage.alias_aware;
public import aermicioi.aedi.storage.allocator_aware;
public import aermicioi.aedi.storage.decorator;
public import aermicioi.aedi.storage.locator;
public import aermicioi.aedi.storage.locator_aware;
public import aermicioi.aedi.storage.object_storage;
public import aermicioi.aedi.storage.storage;
public import aermicioi.aedi.storage.wrapper;