/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:
	
	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/
module aermicioi.aedi.test.container.subscribable_container;

import aermicioi.aedi.container.subscribable_container;
import aermicioi.aedi.test.fixture;
import aermicioi.aedi.container.singleton_container;
import std.algorithm;
import std.typecons;
import std.exception;

unittest {
    SubscribableContainer!SingletonContainer container = new SubscribableContainer!SingletonContainer;
    scope(exit) container.terminate;
    container.decorated = new SingletonContainer;
    
    assert(container.decorated !is null);
    
    auto f = new MockFactory!MockObject;
    auto f1 = new MockFactory!MockObject;
    
    container.set(f, "mock");
    container.set(f1, "mock1");
    
    assert(container.get("mock") !is null);
    
    container.subscribe(ContainerInstantiationEventType.pre, {
        assert(container.getFactory("mock1") !is null);
    });
    
    container.subscribe(ContainerInstantiationEventType.post, {
        assertThrown(container.getFactory("mock") !is null);
    });
    
    container.link("mock", "alias");
    assert(container.resolve("alias") == "mock");
    container.unlink("alias");
    assert(container.resolve("alias") != "mock");
    
    assert(container.getFactories().map!(
            a => a[1].among(
                    "mock",
                    "mock1"
            ) && (a[0] !is null)
        ).fold!((a, b) => (a == true) && (b > 0))(true));
    
    container.remove("mock");
    assert(!container.has("mock"));
    
    container.instantiate;
}