/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:
	
	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/
module aermicioi.aedi.test.container.tuple_container;

import aermicioi.aedi.container.tuple_container;
import aermicioi.aedi.container.value_container;
import aermicioi.aedi.test.fixture;
import aermicioi.aedi.storage.wrapper;
import aermicioi.aedi.exception.circular_reference_exception;
import aermicioi.aedi.exception.not_found_exception;
import aermicioi.aedi.exception.di_exception;
import aermicioi.aedi.storage.locator;
import std.algorithm;
import std.typecons;
import std.exception;

unittest {
    ValueContainer first = new ValueContainer;
    ValueContainer second = new ValueContainer;
    TupleContainer!(ValueContainer, ValueContainer) container = new TupleContainer!(ValueContainer, ValueContainer)(first, second);
    scope(exit) container.terminate;
    
    first.set(new WrapperImpl!int(10), "mock");
    first.set(new WrapperImpl!int(11), "mock1");
    
    second.set(new WrapperImpl!int(21), "mock1");
    second.set(new WrapperImpl!int(20), "mock2");
    
    assert(
        all!((a) => container.has(a))
        (
            ["mock", "mock1", "mock2"]
        )
    );
    
    assert(!container.has("unkown"));
    
    assert(container.locate!int("mock") == 10);
    assert(container.locate!int("mock1") == 11);
    assert(container.locate!int("mock2") == 20);
    
    assert(container[0].locate!int("mock1") == 11);
    assert(container[1].locate!int("mock1") == 21);
    
    assertNotThrown!AediException(container.instantiate());
    assertThrown!NotFoundException(container.get("unknwon"));
}
