/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:
	
	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/
module aermicioi.aedi.test.factory.decorating_factory;

import aermicioi.aedi.storage.object_storage;
import aermicioi.aedi.test.fixture;
import aermicioi.aedi.factory.decorating_factory;
import aermicioi.aedi.exception.di_exception;
import aermicioi.aedi.factory.wrapping_factory;
import std.exception;

unittest {
    MockFactory!MockObject ofactory = new MockFactory!MockObject;
    auto factory = new WrappingFactory!(MockFactory!MockObject)(ofactory);
    ObjectStorage!() locator = new ObjectStorage!();
    factory.locator = locator;
    
    assert(factory.decorated is ofactory);
    assert(factory.type is typeid(MockObject));
    assert(ofactory.locator_ is locator);
    assert(factory.factory() !is null);
}

unittest {
    MockFactory!MockObject ofactory = new MockFactory!MockObject;
    TaggableFactoryDecorator!(Object, string) factory = new TaggableFactoryDecorator!(Object, string)();
    ObjectStorage!() locator = new ObjectStorage!();
    
    factory.decorated = ofactory;
    factory.locator = locator;
    factory.tag("test");
    factory.tag("test1");
    factory.tag("test2");
    assert(factory.tags == ["test", "test1", "test2"]);

    factory.untag("test1");
    assert(factory.tags == ["test", "test2"]);

    factory.tags = ["tagged", "tagged1"];
    assert(factory.tags == ["tagged", "tagged1"]);
    
    assert(factory.decorated is ofactory);
    assert(factory.type is typeid(MockObject));
    assert(ofactory.locator_ is locator);
    assert(factory.factory() !is null);
}

unittest {
    import std.conv;
    RegistrationAwareDecoratingFactory!Object factory = new RegistrationAwareDecoratingFactory!Object;
    
    factory.line = 20;
    factory.file = "some/hyphotetical/folder";
    factory.decorated = new MockFailingFactory!MockObject;
    
    assertThrown!AediException(
        factory.factory,
    );
    
    assert(factory.line == 20);
    assert(factory.file == "some/hyphotetical/folder");
    assert(factory.type is typeid(MockObject));
}