/**
License:
    Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization
    obtaining a copy of the software and accompanying documentation covered by
    this license (the "Software") to use, reproduce, display, distribute,
    execute, and transmit the Software, and to prepare derivative works of the
    Software, and to permit third-parties to whom the Software is furnished to
    do so, all subject to the following:
    
    The copyright notices in the Software and this entire statement, including
    the above license grant, this restriction and the following disclaimer,
    must be included in all copies of the Software, in whole or in part, and
    all derivative works of the Software, unless such copies or derivative
    works are solely in the form of machine-executable object code generated by
    a source language processor.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
   
Authors:
    Alexandru Ermicioi
**/
module aermicioi.aedi.test.factory.proxy_factory;

import aermicioi.aedi.storage.locator : locate;
import aermicioi.aedi.factory.proxy_factory;
import aermicioi.aedi.storage.object_storage;
import aermicioi.aedi.storage.wrapper;
import aermicioi.aedi.test.fixture;
import aermicioi.aedi.exception.invalid_cast_exception;

import std.exception;

unittest {
    auto container = new ObjectStorage!();
    auto container2 = new ObjectStorage!();
    container.set(new MockObject(), "mock.object");
    container2.set(new MockObject(), "mock.object.the_second");
    auto notAProxy = new MockObject();
    
    auto proxyFactory = new ProxyFactory!(MockObject)("mock.object", container);
    
    MockObject proxied = proxyFactory.factory;
    assert((cast(Proxy!MockObject) proxied) !is null);
    assertNotThrown!InvalidCastException(proxyFactory.destruct(proxied));
    assertThrown!InvalidCastException(proxyFactory.destruct(notAProxy));

    proxyFactory.factory().imethod(10, 5);
    assert(container.locate!MockObject("mock.object").property == 5);

    auto wrapper = new ProxyObjectWrappingFactory!MockObject(proxyFactory);
    wrapper.identity = "mock.object.the_second";
    wrapper.locator = container2;
    wrapper.source = container2;

    proxied = cast(MockObject) wrapper.factory();
    proxied.imethod(10, 4);
    assert(container2.locate!MockObject("mock.object.the_second").property == 6);
    assert((cast(Proxy!MockObject) wrapper.factory()) !is null);

    auto obj = cast(Object) proxied;
    assertNotThrown!InvalidCastException(wrapper.destruct(obj));
    obj = cast(Object) notAProxy;
    assertThrown!InvalidCastException(wrapper.destruct(obj));

    assert(wrapper.type is typeid(Proxy!MockObject));
    assert(wrapper.locator is container2);
    assert(wrapper.source is container2);
    assert(wrapper.identity == "mock.object.the_second");
}