/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:
	
	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/
module aermicioi.aedi.test.factory.wrapping_factory;

import aermicioi.aedi.container.singleton_container;
import aermicioi.aedi.factory.wrapping_factory;
import aermicioi.aedi.storage.wrapper;
import std.exception;
import std.experimental.allocator;
import aermicioi.aedi.exception.invalid_cast_exception;

import aermicioi.aedi.test.fixture;

unittest
{
    MockValueFactory!MockStruct sfact = new MockValueFactory!MockStruct;
    MockValueFactory!MockObject ofact = new MockValueFactory!MockObject;
    
    WrappingFactory!(MockValueFactory!MockStruct) swrapper = new WrappingFactory!(
            MockValueFactory!MockStruct)(sfact);
    WrappingFactory!(MockValueFactory!MockObject) owrapper = new WrappingFactory!(
            MockValueFactory!MockObject)(ofact);

    auto screated = swrapper.factory();
    auto ocreated = owrapper.factory();

    assertNotThrown!InvalidCastException(swrapper.destruct(screated));
    assertNotThrown!InvalidCastException(owrapper.destruct(ocreated));

    screated = swrapper.factory();
    ocreated = owrapper.factory();

    assertThrown!InvalidCastException(owrapper.destruct(screated));
    assertThrown!InvalidCastException(swrapper.destruct(ocreated));
}

unittest
{
    SingletonContainer container = new SingletonContainer;
    MockValueFactory!MockStruct fact = new MockValueFactory!MockStruct;
    WrappingFactory!(MockValueFactory!MockStruct) wrapper = new WrappingFactory!(
            MockValueFactory!MockStruct)(fact);

    wrapper.locator = container;

    assert(wrapper.type == typeid(MockStruct));
    assert(wrapper.factory.classinfo == typeid(WrapperImpl!MockStruct));
}

unittest
{
    SingletonContainer container = new SingletonContainer;
    MockValueFactory!ubyte fact = new MockValueFactory!ubyte;
    WrappingFactory!(MockValueFactory!ubyte) wrapper = new WrappingFactory!(MockValueFactory!ubyte)(
            fact);

    wrapper.locator = container;

    assert(wrapper.type == typeid(ubyte));
    assert(wrapper.factory.classinfo == typeid(CastableWrapperImpl!(ubyte,
            ushort, uint, ulong, short, int, long, float, double)));
}

unittest
{
    import aermicioi.aedi.factory.generic_factory;
    import aermicioi.aedi.factory.factory;

    DefferredExecutioner executioner = new DefferredExecutionerImpl;
    SingletonContainer container = new SingletonContainer;
    scope(exit) container.terminate;

    CircularFactoryMock!MockObject first = new CircularFactoryMock!MockObject();
    CircularFactoryMock!MockObject second = new CircularFactoryMock!MockObject();
    DefferedProxyWrapper!(Factory!MockObject) defferedF = new DefferedProxyWrapper!(Factory!MockObject)(first);
    DefferedProxyWrapper!(Factory!MockObject) defferedS = new DefferedProxyWrapper!(Factory!MockObject)(second);
    
    first.locator = container;
    first.referenced = "second";
    second.locator = container;
    second.referenced = "first";
    defferedF.executioner = executioner;
    defferedS.executioner = executioner;

    container.set(new WrappingFactory!(DefferedProxyWrapper!(Factory!MockObject))(defferedF), "first");
    container.set(new WrappingFactory!(DefferedProxyWrapper!(Factory!MockObject))(defferedS), "second");

    Object mock = container.get("first");

    import std.stdio;
    assert(first.fetched !is null);
    assert(first.fetched !is mock);
    assert(cast (DefferedProxy!MockObject) first.fetched !is null);
    executioner.execute;
    auto proxy = (cast(MockObject) first.fetched);
    auto original = cast(MockObject) container.get("second");

    proxy.imethod(1, 10);
    assert(original.property == proxy.property);
}
