/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:
	
	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/

module aermicioi.aedi.test.storage.aggregate_locator;

import aermicioi.aedi.storage.object_storage;
import aermicioi.aedi.storage.aggregate_locator;
import aermicioi.aedi.test.fixture;
import aermicioi.aedi.exception.not_found_exception;
import std.exception;

unittest {
    auto aggregate = new AggregateLocatorImpl!(Object);
    auto russianSpeakers = new ObjectStorage!(Object);
    auto frenchSpeakers = new ObjectStorage!(Object);
    auto romanianSpeakers = new ObjectStorage!(Object);
    
    frenchSpeakers.set(new Person("Ali Ababuiev", 20), "ali");
    
    assert(!aggregate.hasLocator("russian"));
    assert(!aggregate.hasLocator("french"));
    assert(!aggregate.hasLocator("romanian"));
    
    aggregate.set(russianSpeakers, "russian");
    aggregate.set(frenchSpeakers, "french");
    aggregate.set(romanianSpeakers, "romanian");
    
    assert(aggregate.hasLocator("russian"));
    assert(aggregate.hasLocator("french"));
    assert(aggregate.hasLocator("romanian"));
    
    assert(aggregate.getLocator("russian") is russianSpeakers);
    
    aggregate.remove("russian");
    assert(!aggregate.hasLocator("russian"));
    assertThrown!NotFoundException(aggregate.getLocator("russian"));
    
    assert(aggregate.get("ali") !is null);
    assert(aggregate.get("ali").classinfo is typeid(Person));
    
    assert(aggregate.get("romanian") !is null);
    assert(aggregate.get("romanian").classinfo is typeid(ObjectStorage!Object));
    
    assertThrown(aggregate.get("russian"));
    
    assert(aggregate.has("ali"));
    assert(aggregate.has("romanian"));
    assert(!aggregate.has("russian"));
    
    import std.algorithm;
    assert(aggregate.getLocators().map!(
            a => a[1].among(
                    "french",
                    "romanian"
            ) && (a[0] !is null)
        ).fold!((a, b) => (a == true) && (b > 0))(true));
}