/**
License:
	Boost Software License - Version 1.0 - August 17th, 2003

	Permission is hereby granted, free of charge, to any person or organization
	obtaining a copy of the software and accompanying documentation covered by
	this license (the "Software") to use, reproduce, display, distribute,
	execute, and transmit the Software, and to prepare derivative works of the
	Software, and to permit third-parties to whom the Software is furnished to
	do so, all subject to the following:
	
	The copyright notices in the Software and this entire statement, including
	the above license grant, this restriction and the following disclaimer,
	must be included in all copies of the Software, in whole or in part, and
	all derivative works of the Software, unless such copies or derivative
	works are solely in the form of machine-executable object code generated by
	a source language processor.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
	SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
	FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.

Authors:
	aermicioi
**/
module aermicioi.aedi.test.storage.locator;

import aermicioi.aedi.storage.locator;
import aermicioi.aedi.storage.object_storage;
import aermicioi.aedi.storage.wrapper;
import aermicioi.aedi.test.fixture;
import aermicioi.aedi.exception.invalid_cast_exception;
import std.exception;

unittest {
    ObjectStorage!(Object, string) storage = new ObjectStorage!(Object, string);
    auto john = new MockObject();
    auto mary = new MockObject();
    auto katty = new MockObject();
    
    storage.set(john, "john");
    storage.set(mary, "mary");
    storage.set(katty, "katty");
    storage.link("katty", "aermicioi.aedi.test.fixture.MockObject");
    storage.set(new WrapperImpl!(MockStruct)(MockStruct(10)), "alien");
    storage.set(new WrapperImpl!(MockExternObject)(new MockExternObject(10)), "c++alien");
    storage.set(new WrapperImpl!(MockExternInterface)(new MockExternObject(10)), "c++alienInterface");
	storage.set(new CastableWrapperImpl!(ubyte, short, int, long)(10), "castable.com");
    
    assert(storage.locate!MockObject("john") is john);
    assertThrown!InvalidCastException(storage.locate!MockObjectFactoryMethod("john"));
    
    assert(storage.locate!MockInterface("john") is john);
    assert(storage.locate!MockExternInterface("c++alienInterface") !is null);
    assertThrown!InvalidCastException(storage.locate!MockExternInterface("c++alien"));
    
    assert(storage.locate!MockStruct("alien") == MockStruct(10));
    assertThrown!InvalidCastException(storage.locate!int("alien"));

	assert(storage.locate!ubyte("castable.com") == cast(ubyte) 10);
	assert(storage.locate!short("castable.com") == cast(short) 10);
	assert(storage.locate!int("castable.com") == cast(int) 10);
	assert(storage.locate!long("castable.com") == cast(long) 10);

	assertThrown(storage.locate!ushort("castable.com"));
    
    assert(storage.locate!MockObject is katty);
}
