// Code generated by go run main.go hardfork.json hardfork_gen.go; DO NOT EDIT.

package config

import (
	"fmt"
	"reflect"
	
	"github.com/aergoio/aergo/types"
)

var (
	MainNetHardforkConfig = &HardforkConfig{
		V2: types.BlockNo(19611555),
	}
	TestNetHardforkConfig = &HardforkConfig{
		V2: types.BlockNo(18714241),
	}
	AllEnabledHardforkConfig = &HardforkConfig{
		V2: types.BlockNo(0),
	}
)

const hardforkConfigTmpl = `[hardfork]
v2 = "{{.Hardfork.V2}}"
`

type HardforkConfig struct {
	V2 types.BlockNo `mapstructure:"v2" description:"a block number of the hardfork version 2"`
}

type HardforkDbConfig map[string]types.BlockNo

func (c *HardforkConfig) IsV2Fork(h types.BlockNo) bool {
	return isFork(c.V2, h)
}

func (c *HardforkConfig) CheckCompatibility(dbCfg HardforkDbConfig, h types.BlockNo) error {
	if err := c.validate(); err != nil {
		return err
	}
	if (isFork(c.V2, h) || isFork(dbCfg["V2"], h)) && c.V2 != dbCfg["V2"] {
		return newForkError("V2", h, c.V2, dbCfg["V2"])
	}
	return checkOlderNode(2, h, dbCfg)
}

func (c *HardforkConfig) Version(h types.BlockNo) int32 {
	v := reflect.ValueOf(*c)
	for i := v.NumField() - 1; i >= 0; i-- {
		if v.Field(i).Uint() <= h {
			return int32(i + 2)
		}
	}
	return int32(0)
}

func (c *HardforkConfig) validate() error {
	prev := uint64(0)
	v := reflect.ValueOf(*c)
	for i := 0; i < v.NumField(); i++ {
		curr := v.Field(i).Uint()
		if prev > curr {
			return fmt.Errorf("version %d has a lower block number: %d, %d(v%d)", i+2, curr, prev, i+1)
		}
		prev = curr
	}
	return nil
}
