// Code generated by protoc-gen-go. DO NOT EDIT.
// source: rpc.proto

package types

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type CommitStatus int32

const (
	CommitStatus_TX_OK                   CommitStatus = 0
	CommitStatus_TX_NONCE_TOO_LOW        CommitStatus = 1
	CommitStatus_TX_ALREADY_EXISTS       CommitStatus = 2
	CommitStatus_TX_INVALID_HASH         CommitStatus = 3
	CommitStatus_TX_INVALID_SIGN         CommitStatus = 4
	CommitStatus_TX_INVALID_FORMAT       CommitStatus = 5
	CommitStatus_TX_INSUFFICIENT_BALANCE CommitStatus = 6
	CommitStatus_TX_HAS_SAME_NONCE       CommitStatus = 7
	CommitStatus_TX_INTERNAL_ERROR       CommitStatus = 9
)

var CommitStatus_name = map[int32]string{
	0: "TX_OK",
	1: "TX_NONCE_TOO_LOW",
	2: "TX_ALREADY_EXISTS",
	3: "TX_INVALID_HASH",
	4: "TX_INVALID_SIGN",
	5: "TX_INVALID_FORMAT",
	6: "TX_INSUFFICIENT_BALANCE",
	7: "TX_HAS_SAME_NONCE",
	9: "TX_INTERNAL_ERROR",
}
var CommitStatus_value = map[string]int32{
	"TX_OK":                   0,
	"TX_NONCE_TOO_LOW":        1,
	"TX_ALREADY_EXISTS":       2,
	"TX_INVALID_HASH":         3,
	"TX_INVALID_SIGN":         4,
	"TX_INVALID_FORMAT":       5,
	"TX_INSUFFICIENT_BALANCE": 6,
	"TX_HAS_SAME_NONCE":       7,
	"TX_INTERNAL_ERROR":       9,
}

func (x CommitStatus) String() string {
	return proto.EnumName(CommitStatus_name, int32(x))
}
func (CommitStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{0}
}

type VerifyStatus int32

const (
	VerifyStatus_VERIFY_STATUS_OK             VerifyStatus = 0
	VerifyStatus_VERIFY_STATUS_SIGN_NOT_MATCH VerifyStatus = 1
	VerifyStatus_VERIFY_STATUS_INVALID_HASH   VerifyStatus = 2
)

var VerifyStatus_name = map[int32]string{
	0: "VERIFY_STATUS_OK",
	1: "VERIFY_STATUS_SIGN_NOT_MATCH",
	2: "VERIFY_STATUS_INVALID_HASH",
}
var VerifyStatus_value = map[string]int32{
	"VERIFY_STATUS_OK":             0,
	"VERIFY_STATUS_SIGN_NOT_MATCH": 1,
	"VERIFY_STATUS_INVALID_HASH":   2,
}

func (x VerifyStatus) String() string {
	return proto.EnumName(VerifyStatus_name, int32(x))
}
func (VerifyStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{1}
}

// BlockchainStatus is current status of blockchain
type BlockchainStatus struct {
	BestBlockHash        []byte     `protobuf:"bytes,1,opt,name=best_block_hash,json=bestBlockHash,proto3" json:"best_block_hash,omitempty"`
	BestHeight           uint64     `protobuf:"varint,2,opt,name=best_height,json=bestHeight" json:"best_height,omitempty"`
	ConsensusInfo        string     `protobuf:"bytes,3,opt,name=consensus_info,json=consensusInfo" json:"consensus_info,omitempty"`
	BestChainIdHash      []byte     `protobuf:"bytes,4,opt,name=best_chain_id_hash,json=bestChainIdHash,proto3" json:"best_chain_id_hash,omitempty"`
	ChainInfo            *ChainInfo `protobuf:"bytes,5,opt,name=chain_info,json=chainInfo" json:"chain_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BlockchainStatus) Reset()         { *m = BlockchainStatus{} }
func (m *BlockchainStatus) String() string { return proto.CompactTextString(m) }
func (*BlockchainStatus) ProtoMessage()    {}
func (*BlockchainStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{0}
}
func (m *BlockchainStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlockchainStatus.Unmarshal(m, b)
}
func (m *BlockchainStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlockchainStatus.Marshal(b, m, deterministic)
}
func (dst *BlockchainStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockchainStatus.Merge(dst, src)
}
func (m *BlockchainStatus) XXX_Size() int {
	return xxx_messageInfo_BlockchainStatus.Size(m)
}
func (m *BlockchainStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockchainStatus.DiscardUnknown(m)
}

var xxx_messageInfo_BlockchainStatus proto.InternalMessageInfo

func (m *BlockchainStatus) GetBestBlockHash() []byte {
	if m != nil {
		return m.BestBlockHash
	}
	return nil
}

func (m *BlockchainStatus) GetBestHeight() uint64 {
	if m != nil {
		return m.BestHeight
	}
	return 0
}

func (m *BlockchainStatus) GetConsensusInfo() string {
	if m != nil {
		return m.ConsensusInfo
	}
	return ""
}

func (m *BlockchainStatus) GetBestChainIdHash() []byte {
	if m != nil {
		return m.BestChainIdHash
	}
	return nil
}

func (m *BlockchainStatus) GetChainInfo() *ChainInfo {
	if m != nil {
		return m.ChainInfo
	}
	return nil
}

type ChainId struct {
	Magic                string   `protobuf:"bytes,1,opt,name=magic" json:"magic,omitempty"`
	Public               bool     `protobuf:"varint,2,opt,name=public" json:"public,omitempty"`
	Mainnet              bool     `protobuf:"varint,3,opt,name=mainnet" json:"mainnet,omitempty"`
	Consensus            string   `protobuf:"bytes,4,opt,name=consensus" json:"consensus,omitempty"`
	Version              int32    `protobuf:"varint,5,opt,name=version" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChainId) Reset()         { *m = ChainId{} }
func (m *ChainId) String() string { return proto.CompactTextString(m) }
func (*ChainId) ProtoMessage()    {}
func (*ChainId) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{1}
}
func (m *ChainId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChainId.Unmarshal(m, b)
}
func (m *ChainId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChainId.Marshal(b, m, deterministic)
}
func (dst *ChainId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChainId.Merge(dst, src)
}
func (m *ChainId) XXX_Size() int {
	return xxx_messageInfo_ChainId.Size(m)
}
func (m *ChainId) XXX_DiscardUnknown() {
	xxx_messageInfo_ChainId.DiscardUnknown(m)
}

var xxx_messageInfo_ChainId proto.InternalMessageInfo

func (m *ChainId) GetMagic() string {
	if m != nil {
		return m.Magic
	}
	return ""
}

func (m *ChainId) GetPublic() bool {
	if m != nil {
		return m.Public
	}
	return false
}

func (m *ChainId) GetMainnet() bool {
	if m != nil {
		return m.Mainnet
	}
	return false
}

func (m *ChainId) GetConsensus() string {
	if m != nil {
		return m.Consensus
	}
	return ""
}

func (m *ChainId) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// ChainInfo returns chain configuration
type ChainInfo struct {
	Id                   *ChainId `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BpNumber             uint32   `protobuf:"varint,2,opt,name=bpNumber" json:"bpNumber,omitempty"`
	Maxblocksize         uint64   `protobuf:"varint,3,opt,name=maxblocksize" json:"maxblocksize,omitempty"`
	Maxtokens            []byte   `protobuf:"bytes,4,opt,name=maxtokens,proto3" json:"maxtokens,omitempty"`
	Stakingminimum       []byte   `protobuf:"bytes,5,opt,name=stakingminimum,proto3" json:"stakingminimum,omitempty"`
	Totalstaking         []byte   `protobuf:"bytes,6,opt,name=totalstaking,proto3" json:"totalstaking,omitempty"`
	Gasprice             []byte   `protobuf:"bytes,7,opt,name=gasprice,proto3" json:"gasprice,omitempty"`
	Nameprice            []byte   `protobuf:"bytes,8,opt,name=nameprice,proto3" json:"nameprice,omitempty"`
	Totalvotingpower     []byte   `protobuf:"bytes,9,opt,name=totalvotingpower,proto3" json:"totalvotingpower,omitempty"`
	Votingreward         []byte   `protobuf:"bytes,10,opt,name=votingreward,proto3" json:"votingreward,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChainInfo) Reset()         { *m = ChainInfo{} }
func (m *ChainInfo) String() string { return proto.CompactTextString(m) }
func (*ChainInfo) ProtoMessage()    {}
func (*ChainInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{2}
}
func (m *ChainInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChainInfo.Unmarshal(m, b)
}
func (m *ChainInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChainInfo.Marshal(b, m, deterministic)
}
func (dst *ChainInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChainInfo.Merge(dst, src)
}
func (m *ChainInfo) XXX_Size() int {
	return xxx_messageInfo_ChainInfo.Size(m)
}
func (m *ChainInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ChainInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ChainInfo proto.InternalMessageInfo

func (m *ChainInfo) GetId() *ChainId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ChainInfo) GetBpNumber() uint32 {
	if m != nil {
		return m.BpNumber
	}
	return 0
}

func (m *ChainInfo) GetMaxblocksize() uint64 {
	if m != nil {
		return m.Maxblocksize
	}
	return 0
}

func (m *ChainInfo) GetMaxtokens() []byte {
	if m != nil {
		return m.Maxtokens
	}
	return nil
}

func (m *ChainInfo) GetStakingminimum() []byte {
	if m != nil {
		return m.Stakingminimum
	}
	return nil
}

func (m *ChainInfo) GetTotalstaking() []byte {
	if m != nil {
		return m.Totalstaking
	}
	return nil
}

func (m *ChainInfo) GetGasprice() []byte {
	if m != nil {
		return m.Gasprice
	}
	return nil
}

func (m *ChainInfo) GetNameprice() []byte {
	if m != nil {
		return m.Nameprice
	}
	return nil
}

func (m *ChainInfo) GetTotalvotingpower() []byte {
	if m != nil {
		return m.Totalvotingpower
	}
	return nil
}

func (m *ChainInfo) GetVotingreward() []byte {
	if m != nil {
		return m.Votingreward
	}
	return nil
}

// ChainStats corresponds to a chain statistics report.
type ChainStats struct {
	Report               string   `protobuf:"bytes,1,opt,name=report" json:"report,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChainStats) Reset()         { *m = ChainStats{} }
func (m *ChainStats) String() string { return proto.CompactTextString(m) }
func (*ChainStats) ProtoMessage()    {}
func (*ChainStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{3}
}
func (m *ChainStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChainStats.Unmarshal(m, b)
}
func (m *ChainStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChainStats.Marshal(b, m, deterministic)
}
func (dst *ChainStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChainStats.Merge(dst, src)
}
func (m *ChainStats) XXX_Size() int {
	return xxx_messageInfo_ChainStats.Size(m)
}
func (m *ChainStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ChainStats.DiscardUnknown(m)
}

var xxx_messageInfo_ChainStats proto.InternalMessageInfo

func (m *ChainStats) GetReport() string {
	if m != nil {
		return m.Report
	}
	return ""
}

type Input struct {
	Hash                 []byte   `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	Address              [][]byte `protobuf:"bytes,2,rep,name=address,proto3" json:"address,omitempty"`
	Value                []byte   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	Script               []byte   `protobuf:"bytes,4,opt,name=script,proto3" json:"script,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Input) Reset()         { *m = Input{} }
func (m *Input) String() string { return proto.CompactTextString(m) }
func (*Input) ProtoMessage()    {}
func (*Input) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{4}
}
func (m *Input) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Input.Unmarshal(m, b)
}
func (m *Input) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Input.Marshal(b, m, deterministic)
}
func (dst *Input) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Input.Merge(dst, src)
}
func (m *Input) XXX_Size() int {
	return xxx_messageInfo_Input.Size(m)
}
func (m *Input) XXX_DiscardUnknown() {
	xxx_messageInfo_Input.DiscardUnknown(m)
}

var xxx_messageInfo_Input proto.InternalMessageInfo

func (m *Input) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *Input) GetAddress() [][]byte {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Input) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Input) GetScript() []byte {
	if m != nil {
		return m.Script
	}
	return nil
}

type Output struct {
	Index                uint32   `protobuf:"varint,1,opt,name=index" json:"index,omitempty"`
	Address              []byte   `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	Value                []byte   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	Script               []byte   `protobuf:"bytes,4,opt,name=script,proto3" json:"script,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Output) Reset()         { *m = Output{} }
func (m *Output) String() string { return proto.CompactTextString(m) }
func (*Output) ProtoMessage()    {}
func (*Output) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{5}
}
func (m *Output) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Output.Unmarshal(m, b)
}
func (m *Output) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Output.Marshal(b, m, deterministic)
}
func (dst *Output) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Output.Merge(dst, src)
}
func (m *Output) XXX_Size() int {
	return xxx_messageInfo_Output.Size(m)
}
func (m *Output) XXX_DiscardUnknown() {
	xxx_messageInfo_Output.DiscardUnknown(m)
}

var xxx_messageInfo_Output proto.InternalMessageInfo

func (m *Output) GetIndex() uint32 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *Output) GetAddress() []byte {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Output) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Output) GetScript() []byte {
	if m != nil {
		return m.Script
	}
	return nil
}

type Empty struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Empty) Reset()         { *m = Empty{} }
func (m *Empty) String() string { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()    {}
func (*Empty) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{6}
}
func (m *Empty) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Empty.Unmarshal(m, b)
}
func (m *Empty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Empty.Marshal(b, m, deterministic)
}
func (dst *Empty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Empty.Merge(dst, src)
}
func (m *Empty) XXX_Size() int {
	return xxx_messageInfo_Empty.Size(m)
}
func (m *Empty) XXX_DiscardUnknown() {
	xxx_messageInfo_Empty.DiscardUnknown(m)
}

var xxx_messageInfo_Empty proto.InternalMessageInfo

type SingleBytes struct {
	Value                []byte   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SingleBytes) Reset()         { *m = SingleBytes{} }
func (m *SingleBytes) String() string { return proto.CompactTextString(m) }
func (*SingleBytes) ProtoMessage()    {}
func (*SingleBytes) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{7}
}
func (m *SingleBytes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SingleBytes.Unmarshal(m, b)
}
func (m *SingleBytes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SingleBytes.Marshal(b, m, deterministic)
}
func (dst *SingleBytes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SingleBytes.Merge(dst, src)
}
func (m *SingleBytes) XXX_Size() int {
	return xxx_messageInfo_SingleBytes.Size(m)
}
func (m *SingleBytes) XXX_DiscardUnknown() {
	xxx_messageInfo_SingleBytes.DiscardUnknown(m)
}

var xxx_messageInfo_SingleBytes proto.InternalMessageInfo

func (m *SingleBytes) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type SingleString struct {
	Value                string   `protobuf:"bytes,1,opt,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SingleString) Reset()         { *m = SingleString{} }
func (m *SingleString) String() string { return proto.CompactTextString(m) }
func (*SingleString) ProtoMessage()    {}
func (*SingleString) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{8}
}
func (m *SingleString) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SingleString.Unmarshal(m, b)
}
func (m *SingleString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SingleString.Marshal(b, m, deterministic)
}
func (dst *SingleString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SingleString.Merge(dst, src)
}
func (m *SingleString) XXX_Size() int {
	return xxx_messageInfo_SingleString.Size(m)
}
func (m *SingleString) XXX_DiscardUnknown() {
	xxx_messageInfo_SingleString.DiscardUnknown(m)
}

var xxx_messageInfo_SingleString proto.InternalMessageInfo

func (m *SingleString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type AccountAddress struct {
	Value                []byte   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountAddress) Reset()         { *m = AccountAddress{} }
func (m *AccountAddress) String() string { return proto.CompactTextString(m) }
func (*AccountAddress) ProtoMessage()    {}
func (*AccountAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{9}
}
func (m *AccountAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccountAddress.Unmarshal(m, b)
}
func (m *AccountAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccountAddress.Marshal(b, m, deterministic)
}
func (dst *AccountAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountAddress.Merge(dst, src)
}
func (m *AccountAddress) XXX_Size() int {
	return xxx_messageInfo_AccountAddress.Size(m)
}
func (m *AccountAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountAddress.DiscardUnknown(m)
}

var xxx_messageInfo_AccountAddress proto.InternalMessageInfo

func (m *AccountAddress) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type AccountAndRoot struct {
	Account              []byte   `protobuf:"bytes,1,opt,name=Account,proto3" json:"Account,omitempty"`
	Root                 []byte   `protobuf:"bytes,2,opt,name=Root,proto3" json:"Root,omitempty"`
	Compressed           bool     `protobuf:"varint,3,opt,name=Compressed" json:"Compressed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountAndRoot) Reset()         { *m = AccountAndRoot{} }
func (m *AccountAndRoot) String() string { return proto.CompactTextString(m) }
func (*AccountAndRoot) ProtoMessage()    {}
func (*AccountAndRoot) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{10}
}
func (m *AccountAndRoot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccountAndRoot.Unmarshal(m, b)
}
func (m *AccountAndRoot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccountAndRoot.Marshal(b, m, deterministic)
}
func (dst *AccountAndRoot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountAndRoot.Merge(dst, src)
}
func (m *AccountAndRoot) XXX_Size() int {
	return xxx_messageInfo_AccountAndRoot.Size(m)
}
func (m *AccountAndRoot) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountAndRoot.DiscardUnknown(m)
}

var xxx_messageInfo_AccountAndRoot proto.InternalMessageInfo

func (m *AccountAndRoot) GetAccount() []byte {
	if m != nil {
		return m.Account
	}
	return nil
}

func (m *AccountAndRoot) GetRoot() []byte {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *AccountAndRoot) GetCompressed() bool {
	if m != nil {
		return m.Compressed
	}
	return false
}

type Peer struct {
	Address              *PeerAddress        `protobuf:"bytes,1,opt,name=address" json:"address,omitempty"`
	Bestblock            *NewBlockNotice     `protobuf:"bytes,2,opt,name=bestblock" json:"bestblock,omitempty"`
	State                int32               `protobuf:"varint,3,opt,name=state" json:"state,omitempty"`
	Hidden               bool                `protobuf:"varint,4,opt,name=hidden" json:"hidden,omitempty"`
	LashCheck            int64               `protobuf:"varint,5,opt,name=lashCheck" json:"lashCheck,omitempty"`
	Selfpeer             bool                `protobuf:"varint,6,opt,name=selfpeer" json:"selfpeer,omitempty"`
	Version              string              `protobuf:"bytes,7,opt,name=version" json:"version,omitempty"`
	Certificates         []*AgentCertificate `protobuf:"bytes,8,rep,name=certificates" json:"certificates,omitempty"`
	AcceptedRole         PeerRole            `protobuf:"varint,9,opt,name=acceptedRole,enum=types.PeerRole" json:"acceptedRole,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Peer) Reset()         { *m = Peer{} }
func (m *Peer) String() string { return proto.CompactTextString(m) }
func (*Peer) ProtoMessage()    {}
func (*Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{11}
}
func (m *Peer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Peer.Unmarshal(m, b)
}
func (m *Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Peer.Marshal(b, m, deterministic)
}
func (dst *Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Peer.Merge(dst, src)
}
func (m *Peer) XXX_Size() int {
	return xxx_messageInfo_Peer.Size(m)
}
func (m *Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_Peer proto.InternalMessageInfo

func (m *Peer) GetAddress() *PeerAddress {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Peer) GetBestblock() *NewBlockNotice {
	if m != nil {
		return m.Bestblock
	}
	return nil
}

func (m *Peer) GetState() int32 {
	if m != nil {
		return m.State
	}
	return 0
}

func (m *Peer) GetHidden() bool {
	if m != nil {
		return m.Hidden
	}
	return false
}

func (m *Peer) GetLashCheck() int64 {
	if m != nil {
		return m.LashCheck
	}
	return 0
}

func (m *Peer) GetSelfpeer() bool {
	if m != nil {
		return m.Selfpeer
	}
	return false
}

func (m *Peer) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Peer) GetCertificates() []*AgentCertificate {
	if m != nil {
		return m.Certificates
	}
	return nil
}

func (m *Peer) GetAcceptedRole() PeerRole {
	if m != nil {
		return m.AcceptedRole
	}
	return PeerRole_LegacyVersion
}

type PeerList struct {
	Peers                []*Peer  `protobuf:"bytes,1,rep,name=peers" json:"peers,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerList) Reset()         { *m = PeerList{} }
func (m *PeerList) String() string { return proto.CompactTextString(m) }
func (*PeerList) ProtoMessage()    {}
func (*PeerList) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{12}
}
func (m *PeerList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PeerList.Unmarshal(m, b)
}
func (m *PeerList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PeerList.Marshal(b, m, deterministic)
}
func (dst *PeerList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList.Merge(dst, src)
}
func (m *PeerList) XXX_Size() int {
	return xxx_messageInfo_PeerList.Size(m)
}
func (m *PeerList) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList proto.InternalMessageInfo

func (m *PeerList) GetPeers() []*Peer {
	if m != nil {
		return m.Peers
	}
	return nil
}

type ListParams struct {
	Hash                 []byte   `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	Height               uint64   `protobuf:"varint,2,opt,name=height" json:"height,omitempty"`
	Size                 uint32   `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
	Offset               uint32   `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
	Asc                  bool     `protobuf:"varint,5,opt,name=asc" json:"asc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListParams) Reset()         { *m = ListParams{} }
func (m *ListParams) String() string { return proto.CompactTextString(m) }
func (*ListParams) ProtoMessage()    {}
func (*ListParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{13}
}
func (m *ListParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListParams.Unmarshal(m, b)
}
func (m *ListParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListParams.Marshal(b, m, deterministic)
}
func (dst *ListParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListParams.Merge(dst, src)
}
func (m *ListParams) XXX_Size() int {
	return xxx_messageInfo_ListParams.Size(m)
}
func (m *ListParams) XXX_DiscardUnknown() {
	xxx_messageInfo_ListParams.DiscardUnknown(m)
}

var xxx_messageInfo_ListParams proto.InternalMessageInfo

func (m *ListParams) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *ListParams) GetHeight() uint64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *ListParams) GetSize() uint32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *ListParams) GetOffset() uint32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListParams) GetAsc() bool {
	if m != nil {
		return m.Asc
	}
	return false
}

type PageParams struct {
	Offset               uint32   `protobuf:"varint,1,opt,name=offset" json:"offset,omitempty"`
	Size                 uint32   `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PageParams) Reset()         { *m = PageParams{} }
func (m *PageParams) String() string { return proto.CompactTextString(m) }
func (*PageParams) ProtoMessage()    {}
func (*PageParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{14}
}
func (m *PageParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PageParams.Unmarshal(m, b)
}
func (m *PageParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PageParams.Marshal(b, m, deterministic)
}
func (dst *PageParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PageParams.Merge(dst, src)
}
func (m *PageParams) XXX_Size() int {
	return xxx_messageInfo_PageParams.Size(m)
}
func (m *PageParams) XXX_DiscardUnknown() {
	xxx_messageInfo_PageParams.DiscardUnknown(m)
}

var xxx_messageInfo_PageParams proto.InternalMessageInfo

func (m *PageParams) GetOffset() uint32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *PageParams) GetSize() uint32 {
	if m != nil {
		return m.Size
	}
	return 0
}

type BlockBodyPaged struct {
	Total                uint32     `protobuf:"varint,1,opt,name=total" json:"total,omitempty"`
	Offset               uint32     `protobuf:"varint,2,opt,name=offset" json:"offset,omitempty"`
	Size                 uint32     `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
	Body                 *BlockBody `protobuf:"bytes,4,opt,name=body" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BlockBodyPaged) Reset()         { *m = BlockBodyPaged{} }
func (m *BlockBodyPaged) String() string { return proto.CompactTextString(m) }
func (*BlockBodyPaged) ProtoMessage()    {}
func (*BlockBodyPaged) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{15}
}
func (m *BlockBodyPaged) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlockBodyPaged.Unmarshal(m, b)
}
func (m *BlockBodyPaged) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlockBodyPaged.Marshal(b, m, deterministic)
}
func (dst *BlockBodyPaged) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockBodyPaged.Merge(dst, src)
}
func (m *BlockBodyPaged) XXX_Size() int {
	return xxx_messageInfo_BlockBodyPaged.Size(m)
}
func (m *BlockBodyPaged) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockBodyPaged.DiscardUnknown(m)
}

var xxx_messageInfo_BlockBodyPaged proto.InternalMessageInfo

func (m *BlockBodyPaged) GetTotal() uint32 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *BlockBodyPaged) GetOffset() uint32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *BlockBodyPaged) GetSize() uint32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *BlockBodyPaged) GetBody() *BlockBody {
	if m != nil {
		return m.Body
	}
	return nil
}

type BlockBodyParams struct {
	Hashornumber         []byte      `protobuf:"bytes,1,opt,name=hashornumber,proto3" json:"hashornumber,omitempty"`
	Paging               *PageParams `protobuf:"bytes,2,opt,name=paging" json:"paging,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BlockBodyParams) Reset()         { *m = BlockBodyParams{} }
func (m *BlockBodyParams) String() string { return proto.CompactTextString(m) }
func (*BlockBodyParams) ProtoMessage()    {}
func (*BlockBodyParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{16}
}
func (m *BlockBodyParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlockBodyParams.Unmarshal(m, b)
}
func (m *BlockBodyParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlockBodyParams.Marshal(b, m, deterministic)
}
func (dst *BlockBodyParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockBodyParams.Merge(dst, src)
}
func (m *BlockBodyParams) XXX_Size() int {
	return xxx_messageInfo_BlockBodyParams.Size(m)
}
func (m *BlockBodyParams) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockBodyParams.DiscardUnknown(m)
}

var xxx_messageInfo_BlockBodyParams proto.InternalMessageInfo

func (m *BlockBodyParams) GetHashornumber() []byte {
	if m != nil {
		return m.Hashornumber
	}
	return nil
}

func (m *BlockBodyParams) GetPaging() *PageParams {
	if m != nil {
		return m.Paging
	}
	return nil
}

type BlockHeaderList struct {
	Blocks               []*Block `protobuf:"bytes,1,rep,name=blocks" json:"blocks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BlockHeaderList) Reset()         { *m = BlockHeaderList{} }
func (m *BlockHeaderList) String() string { return proto.CompactTextString(m) }
func (*BlockHeaderList) ProtoMessage()    {}
func (*BlockHeaderList) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{17}
}
func (m *BlockHeaderList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlockHeaderList.Unmarshal(m, b)
}
func (m *BlockHeaderList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlockHeaderList.Marshal(b, m, deterministic)
}
func (dst *BlockHeaderList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockHeaderList.Merge(dst, src)
}
func (m *BlockHeaderList) XXX_Size() int {
	return xxx_messageInfo_BlockHeaderList.Size(m)
}
func (m *BlockHeaderList) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockHeaderList.DiscardUnknown(m)
}

var xxx_messageInfo_BlockHeaderList proto.InternalMessageInfo

func (m *BlockHeaderList) GetBlocks() []*Block {
	if m != nil {
		return m.Blocks
	}
	return nil
}

type BlockMetadata struct {
	Hash                 []byte       `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	Header               *BlockHeader `protobuf:"bytes,2,opt,name=header" json:"header,omitempty"`
	Txcount              int32        `protobuf:"varint,3,opt,name=txcount" json:"txcount,omitempty"`
	Size                 int64        `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BlockMetadata) Reset()         { *m = BlockMetadata{} }
func (m *BlockMetadata) String() string { return proto.CompactTextString(m) }
func (*BlockMetadata) ProtoMessage()    {}
func (*BlockMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{18}
}
func (m *BlockMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlockMetadata.Unmarshal(m, b)
}
func (m *BlockMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlockMetadata.Marshal(b, m, deterministic)
}
func (dst *BlockMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockMetadata.Merge(dst, src)
}
func (m *BlockMetadata) XXX_Size() int {
	return xxx_messageInfo_BlockMetadata.Size(m)
}
func (m *BlockMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BlockMetadata proto.InternalMessageInfo

func (m *BlockMetadata) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *BlockMetadata) GetHeader() *BlockHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *BlockMetadata) GetTxcount() int32 {
	if m != nil {
		return m.Txcount
	}
	return 0
}

func (m *BlockMetadata) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type BlockMetadataList struct {
	Blocks               []*BlockMetadata `protobuf:"bytes,1,rep,name=blocks" json:"blocks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BlockMetadataList) Reset()         { *m = BlockMetadataList{} }
func (m *BlockMetadataList) String() string { return proto.CompactTextString(m) }
func (*BlockMetadataList) ProtoMessage()    {}
func (*BlockMetadataList) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{19}
}
func (m *BlockMetadataList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlockMetadataList.Unmarshal(m, b)
}
func (m *BlockMetadataList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlockMetadataList.Marshal(b, m, deterministic)
}
func (dst *BlockMetadataList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockMetadataList.Merge(dst, src)
}
func (m *BlockMetadataList) XXX_Size() int {
	return xxx_messageInfo_BlockMetadataList.Size(m)
}
func (m *BlockMetadataList) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockMetadataList.DiscardUnknown(m)
}

var xxx_messageInfo_BlockMetadataList proto.InternalMessageInfo

func (m *BlockMetadataList) GetBlocks() []*BlockMetadata {
	if m != nil {
		return m.Blocks
	}
	return nil
}

type CommitResult struct {
	Hash                 []byte       `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	Error                CommitStatus `protobuf:"varint,2,opt,name=error,enum=types.CommitStatus" json:"error,omitempty"`
	Detail               string       `protobuf:"bytes,3,opt,name=detail" json:"detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommitResult) Reset()         { *m = CommitResult{} }
func (m *CommitResult) String() string { return proto.CompactTextString(m) }
func (*CommitResult) ProtoMessage()    {}
func (*CommitResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{20}
}
func (m *CommitResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResult.Unmarshal(m, b)
}
func (m *CommitResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResult.Marshal(b, m, deterministic)
}
func (dst *CommitResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResult.Merge(dst, src)
}
func (m *CommitResult) XXX_Size() int {
	return xxx_messageInfo_CommitResult.Size(m)
}
func (m *CommitResult) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResult.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResult proto.InternalMessageInfo

func (m *CommitResult) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *CommitResult) GetError() CommitStatus {
	if m != nil {
		return m.Error
	}
	return CommitStatus_TX_OK
}

func (m *CommitResult) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

type CommitResultList struct {
	Results              []*CommitResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CommitResultList) Reset()         { *m = CommitResultList{} }
func (m *CommitResultList) String() string { return proto.CompactTextString(m) }
func (*CommitResultList) ProtoMessage()    {}
func (*CommitResultList) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{21}
}
func (m *CommitResultList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResultList.Unmarshal(m, b)
}
func (m *CommitResultList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResultList.Marshal(b, m, deterministic)
}
func (dst *CommitResultList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResultList.Merge(dst, src)
}
func (m *CommitResultList) XXX_Size() int {
	return xxx_messageInfo_CommitResultList.Size(m)
}
func (m *CommitResultList) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResultList.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResultList proto.InternalMessageInfo

func (m *CommitResultList) GetResults() []*CommitResult {
	if m != nil {
		return m.Results
	}
	return nil
}

type VerifyResult struct {
	Tx                   *Tx          `protobuf:"bytes,1,opt,name=tx" json:"tx,omitempty"`
	Error                VerifyStatus `protobuf:"varint,2,opt,name=error,enum=types.VerifyStatus" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *VerifyResult) Reset()         { *m = VerifyResult{} }
func (m *VerifyResult) String() string { return proto.CompactTextString(m) }
func (*VerifyResult) ProtoMessage()    {}
func (*VerifyResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{22}
}
func (m *VerifyResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VerifyResult.Unmarshal(m, b)
}
func (m *VerifyResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VerifyResult.Marshal(b, m, deterministic)
}
func (dst *VerifyResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyResult.Merge(dst, src)
}
func (m *VerifyResult) XXX_Size() int {
	return xxx_messageInfo_VerifyResult.Size(m)
}
func (m *VerifyResult) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyResult.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyResult proto.InternalMessageInfo

func (m *VerifyResult) GetTx() *Tx {
	if m != nil {
		return m.Tx
	}
	return nil
}

func (m *VerifyResult) GetError() VerifyStatus {
	if m != nil {
		return m.Error
	}
	return VerifyStatus_VERIFY_STATUS_OK
}

type Personal struct {
	Passphrase           string   `protobuf:"bytes,1,opt,name=passphrase" json:"passphrase,omitempty"`
	Account              *Account `protobuf:"bytes,2,opt,name=account" json:"account,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Personal) Reset()         { *m = Personal{} }
func (m *Personal) String() string { return proto.CompactTextString(m) }
func (*Personal) ProtoMessage()    {}
func (*Personal) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{23}
}
func (m *Personal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Personal.Unmarshal(m, b)
}
func (m *Personal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Personal.Marshal(b, m, deterministic)
}
func (dst *Personal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Personal.Merge(dst, src)
}
func (m *Personal) XXX_Size() int {
	return xxx_messageInfo_Personal.Size(m)
}
func (m *Personal) XXX_DiscardUnknown() {
	xxx_messageInfo_Personal.DiscardUnknown(m)
}

var xxx_messageInfo_Personal proto.InternalMessageInfo

func (m *Personal) GetPassphrase() string {
	if m != nil {
		return m.Passphrase
	}
	return ""
}

func (m *Personal) GetAccount() *Account {
	if m != nil {
		return m.Account
	}
	return nil
}

type ImportFormat struct {
	Wif                  *SingleBytes `protobuf:"bytes,1,opt,name=wif" json:"wif,omitempty"`
	Oldpass              string       `protobuf:"bytes,2,opt,name=oldpass" json:"oldpass,omitempty"`
	Newpass              string       `protobuf:"bytes,3,opt,name=newpass" json:"newpass,omitempty"`
	Keystore             *SingleBytes `protobuf:"bytes,4,opt,name=keystore" json:"keystore,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportFormat) Reset()         { *m = ImportFormat{} }
func (m *ImportFormat) String() string { return proto.CompactTextString(m) }
func (*ImportFormat) ProtoMessage()    {}
func (*ImportFormat) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{24}
}
func (m *ImportFormat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportFormat.Unmarshal(m, b)
}
func (m *ImportFormat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportFormat.Marshal(b, m, deterministic)
}
func (dst *ImportFormat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportFormat.Merge(dst, src)
}
func (m *ImportFormat) XXX_Size() int {
	return xxx_messageInfo_ImportFormat.Size(m)
}
func (m *ImportFormat) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportFormat.DiscardUnknown(m)
}

var xxx_messageInfo_ImportFormat proto.InternalMessageInfo

func (m *ImportFormat) GetWif() *SingleBytes {
	if m != nil {
		return m.Wif
	}
	return nil
}

func (m *ImportFormat) GetOldpass() string {
	if m != nil {
		return m.Oldpass
	}
	return ""
}

func (m *ImportFormat) GetNewpass() string {
	if m != nil {
		return m.Newpass
	}
	return ""
}

func (m *ImportFormat) GetKeystore() *SingleBytes {
	if m != nil {
		return m.Keystore
	}
	return nil
}

type Staking struct {
	Amount               []byte   `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	When                 uint64   `protobuf:"varint,2,opt,name=when" json:"when,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Staking) Reset()         { *m = Staking{} }
func (m *Staking) String() string { return proto.CompactTextString(m) }
func (*Staking) ProtoMessage()    {}
func (*Staking) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{25}
}
func (m *Staking) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Staking.Unmarshal(m, b)
}
func (m *Staking) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Staking.Marshal(b, m, deterministic)
}
func (dst *Staking) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Staking.Merge(dst, src)
}
func (m *Staking) XXX_Size() int {
	return xxx_messageInfo_Staking.Size(m)
}
func (m *Staking) XXX_DiscardUnknown() {
	xxx_messageInfo_Staking.DiscardUnknown(m)
}

var xxx_messageInfo_Staking proto.InternalMessageInfo

func (m *Staking) GetAmount() []byte {
	if m != nil {
		return m.Amount
	}
	return nil
}

func (m *Staking) GetWhen() uint64 {
	if m != nil {
		return m.When
	}
	return 0
}

type Vote struct {
	Candidate            []byte   `protobuf:"bytes,1,opt,name=candidate,proto3" json:"candidate,omitempty"`
	Amount               []byte   `protobuf:"bytes,2,opt,name=amount,proto3" json:"amount,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Vote) Reset()         { *m = Vote{} }
func (m *Vote) String() string { return proto.CompactTextString(m) }
func (*Vote) ProtoMessage()    {}
func (*Vote) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{26}
}
func (m *Vote) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vote.Unmarshal(m, b)
}
func (m *Vote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vote.Marshal(b, m, deterministic)
}
func (dst *Vote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vote.Merge(dst, src)
}
func (m *Vote) XXX_Size() int {
	return xxx_messageInfo_Vote.Size(m)
}
func (m *Vote) XXX_DiscardUnknown() {
	xxx_messageInfo_Vote.DiscardUnknown(m)
}

var xxx_messageInfo_Vote proto.InternalMessageInfo

func (m *Vote) GetCandidate() []byte {
	if m != nil {
		return m.Candidate
	}
	return nil
}

func (m *Vote) GetAmount() []byte {
	if m != nil {
		return m.Amount
	}
	return nil
}

type VoteParams struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Count                uint32   `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VoteParams) Reset()         { *m = VoteParams{} }
func (m *VoteParams) String() string { return proto.CompactTextString(m) }
func (*VoteParams) ProtoMessage()    {}
func (*VoteParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{27}
}
func (m *VoteParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoteParams.Unmarshal(m, b)
}
func (m *VoteParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoteParams.Marshal(b, m, deterministic)
}
func (dst *VoteParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoteParams.Merge(dst, src)
}
func (m *VoteParams) XXX_Size() int {
	return xxx_messageInfo_VoteParams.Size(m)
}
func (m *VoteParams) XXX_DiscardUnknown() {
	xxx_messageInfo_VoteParams.DiscardUnknown(m)
}

var xxx_messageInfo_VoteParams proto.InternalMessageInfo

func (m *VoteParams) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VoteParams) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type AccountVoteInfo struct {
	Staking              *Staking    `protobuf:"bytes,1,opt,name=staking" json:"staking,omitempty"`
	Voting               []*VoteInfo `protobuf:"bytes,2,rep,name=voting" json:"voting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AccountVoteInfo) Reset()         { *m = AccountVoteInfo{} }
func (m *AccountVoteInfo) String() string { return proto.CompactTextString(m) }
func (*AccountVoteInfo) ProtoMessage()    {}
func (*AccountVoteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{28}
}
func (m *AccountVoteInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccountVoteInfo.Unmarshal(m, b)
}
func (m *AccountVoteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccountVoteInfo.Marshal(b, m, deterministic)
}
func (dst *AccountVoteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountVoteInfo.Merge(dst, src)
}
func (m *AccountVoteInfo) XXX_Size() int {
	return xxx_messageInfo_AccountVoteInfo.Size(m)
}
func (m *AccountVoteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountVoteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AccountVoteInfo proto.InternalMessageInfo

func (m *AccountVoteInfo) GetStaking() *Staking {
	if m != nil {
		return m.Staking
	}
	return nil
}

func (m *AccountVoteInfo) GetVoting() []*VoteInfo {
	if m != nil {
		return m.Voting
	}
	return nil
}

type VoteInfo struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Candidates           []string `protobuf:"bytes,2,rep,name=candidates" json:"candidates,omitempty"`
	Amount               string   `protobuf:"bytes,3,opt,name=amount" json:"amount,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VoteInfo) Reset()         { *m = VoteInfo{} }
func (m *VoteInfo) String() string { return proto.CompactTextString(m) }
func (*VoteInfo) ProtoMessage()    {}
func (*VoteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{29}
}
func (m *VoteInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoteInfo.Unmarshal(m, b)
}
func (m *VoteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoteInfo.Marshal(b, m, deterministic)
}
func (dst *VoteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoteInfo.Merge(dst, src)
}
func (m *VoteInfo) XXX_Size() int {
	return xxx_messageInfo_VoteInfo.Size(m)
}
func (m *VoteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VoteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VoteInfo proto.InternalMessageInfo

func (m *VoteInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VoteInfo) GetCandidates() []string {
	if m != nil {
		return m.Candidates
	}
	return nil
}

func (m *VoteInfo) GetAmount() string {
	if m != nil {
		return m.Amount
	}
	return ""
}

type VoteList struct {
	Votes                []*Vote  `protobuf:"bytes,1,rep,name=votes" json:"votes,omitempty"`
	Id                   string   `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VoteList) Reset()         { *m = VoteList{} }
func (m *VoteList) String() string { return proto.CompactTextString(m) }
func (*VoteList) ProtoMessage()    {}
func (*VoteList) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{30}
}
func (m *VoteList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoteList.Unmarshal(m, b)
}
func (m *VoteList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoteList.Marshal(b, m, deterministic)
}
func (dst *VoteList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoteList.Merge(dst, src)
}
func (m *VoteList) XXX_Size() int {
	return xxx_messageInfo_VoteList.Size(m)
}
func (m *VoteList) XXX_DiscardUnknown() {
	xxx_messageInfo_VoteList.DiscardUnknown(m)
}

var xxx_messageInfo_VoteList proto.InternalMessageInfo

func (m *VoteList) GetVotes() []*Vote {
	if m != nil {
		return m.Votes
	}
	return nil
}

func (m *VoteList) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type NodeReq struct {
	Timeout              []byte   `protobuf:"bytes,1,opt,name=timeout,proto3" json:"timeout,omitempty"`
	Component            []byte   `protobuf:"bytes,2,opt,name=component,proto3" json:"component,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeReq) Reset()         { *m = NodeReq{} }
func (m *NodeReq) String() string { return proto.CompactTextString(m) }
func (*NodeReq) ProtoMessage()    {}
func (*NodeReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{31}
}
func (m *NodeReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeReq.Unmarshal(m, b)
}
func (m *NodeReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeReq.Marshal(b, m, deterministic)
}
func (dst *NodeReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeReq.Merge(dst, src)
}
func (m *NodeReq) XXX_Size() int {
	return xxx_messageInfo_NodeReq.Size(m)
}
func (m *NodeReq) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeReq.DiscardUnknown(m)
}

var xxx_messageInfo_NodeReq proto.InternalMessageInfo

func (m *NodeReq) GetTimeout() []byte {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *NodeReq) GetComponent() []byte {
	if m != nil {
		return m.Component
	}
	return nil
}

type Name struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	BlockNo              uint64   `protobuf:"varint,2,opt,name=blockNo" json:"blockNo,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Name) Reset()         { *m = Name{} }
func (m *Name) String() string { return proto.CompactTextString(m) }
func (*Name) ProtoMessage()    {}
func (*Name) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{32}
}
func (m *Name) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Name.Unmarshal(m, b)
}
func (m *Name) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Name.Marshal(b, m, deterministic)
}
func (dst *Name) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Name.Merge(dst, src)
}
func (m *Name) XXX_Size() int {
	return xxx_messageInfo_Name.Size(m)
}
func (m *Name) XXX_DiscardUnknown() {
	xxx_messageInfo_Name.DiscardUnknown(m)
}

var xxx_messageInfo_Name proto.InternalMessageInfo

func (m *Name) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Name) GetBlockNo() uint64 {
	if m != nil {
		return m.BlockNo
	}
	return 0
}

type NameInfo struct {
	Name                 *Name    `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Owner                []byte   `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	Destination          []byte   `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NameInfo) Reset()         { *m = NameInfo{} }
func (m *NameInfo) String() string { return proto.CompactTextString(m) }
func (*NameInfo) ProtoMessage()    {}
func (*NameInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{33}
}
func (m *NameInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NameInfo.Unmarshal(m, b)
}
func (m *NameInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NameInfo.Marshal(b, m, deterministic)
}
func (dst *NameInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NameInfo.Merge(dst, src)
}
func (m *NameInfo) XXX_Size() int {
	return xxx_messageInfo_NameInfo.Size(m)
}
func (m *NameInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NameInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NameInfo proto.InternalMessageInfo

func (m *NameInfo) GetName() *Name {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *NameInfo) GetOwner() []byte {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (m *NameInfo) GetDestination() []byte {
	if m != nil {
		return m.Destination
	}
	return nil
}

type PeersParams struct {
	NoHidden             bool     `protobuf:"varint,1,opt,name=noHidden" json:"noHidden,omitempty"`
	ShowSelf             bool     `protobuf:"varint,2,opt,name=showSelf" json:"showSelf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeersParams) Reset()         { *m = PeersParams{} }
func (m *PeersParams) String() string { return proto.CompactTextString(m) }
func (*PeersParams) ProtoMessage()    {}
func (*PeersParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{34}
}
func (m *PeersParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PeersParams.Unmarshal(m, b)
}
func (m *PeersParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PeersParams.Marshal(b, m, deterministic)
}
func (dst *PeersParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeersParams.Merge(dst, src)
}
func (m *PeersParams) XXX_Size() int {
	return xxx_messageInfo_PeersParams.Size(m)
}
func (m *PeersParams) XXX_DiscardUnknown() {
	xxx_messageInfo_PeersParams.DiscardUnknown(m)
}

var xxx_messageInfo_PeersParams proto.InternalMessageInfo

func (m *PeersParams) GetNoHidden() bool {
	if m != nil {
		return m.NoHidden
	}
	return false
}

func (m *PeersParams) GetShowSelf() bool {
	if m != nil {
		return m.ShowSelf
	}
	return false
}

type KeyParams struct {
	Key                  []string `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyParams) Reset()         { *m = KeyParams{} }
func (m *KeyParams) String() string { return proto.CompactTextString(m) }
func (*KeyParams) ProtoMessage()    {}
func (*KeyParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{35}
}
func (m *KeyParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyParams.Unmarshal(m, b)
}
func (m *KeyParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyParams.Marshal(b, m, deterministic)
}
func (dst *KeyParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyParams.Merge(dst, src)
}
func (m *KeyParams) XXX_Size() int {
	return xxx_messageInfo_KeyParams.Size(m)
}
func (m *KeyParams) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyParams.DiscardUnknown(m)
}

var xxx_messageInfo_KeyParams proto.InternalMessageInfo

func (m *KeyParams) GetKey() []string {
	if m != nil {
		return m.Key
	}
	return nil
}

type ServerInfo struct {
	Status               map[string]string      `protobuf:"bytes,1,rep,name=status" json:"status,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Config               map[string]*ConfigItem `protobuf:"bytes,2,rep,name=config" json:"config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ServerInfo) Reset()         { *m = ServerInfo{} }
func (m *ServerInfo) String() string { return proto.CompactTextString(m) }
func (*ServerInfo) ProtoMessage()    {}
func (*ServerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{36}
}
func (m *ServerInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerInfo.Unmarshal(m, b)
}
func (m *ServerInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerInfo.Marshal(b, m, deterministic)
}
func (dst *ServerInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerInfo.Merge(dst, src)
}
func (m *ServerInfo) XXX_Size() int {
	return xxx_messageInfo_ServerInfo.Size(m)
}
func (m *ServerInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ServerInfo proto.InternalMessageInfo

func (m *ServerInfo) GetStatus() map[string]string {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ServerInfo) GetConfig() map[string]*ConfigItem {
	if m != nil {
		return m.Config
	}
	return nil
}

type ConfigItem struct {
	Props                map[string]string `protobuf:"bytes,2,rep,name=props" json:"props,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ConfigItem) Reset()         { *m = ConfigItem{} }
func (m *ConfigItem) String() string { return proto.CompactTextString(m) }
func (*ConfigItem) ProtoMessage()    {}
func (*ConfigItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{37}
}
func (m *ConfigItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigItem.Unmarshal(m, b)
}
func (m *ConfigItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigItem.Marshal(b, m, deterministic)
}
func (dst *ConfigItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigItem.Merge(dst, src)
}
func (m *ConfigItem) XXX_Size() int {
	return xxx_messageInfo_ConfigItem.Size(m)
}
func (m *ConfigItem) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigItem.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigItem proto.InternalMessageInfo

func (m *ConfigItem) GetProps() map[string]string {
	if m != nil {
		return m.Props
	}
	return nil
}

type EventList struct {
	Events               []*Event `protobuf:"bytes,1,rep,name=events" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventList) Reset()         { *m = EventList{} }
func (m *EventList) String() string { return proto.CompactTextString(m) }
func (*EventList) ProtoMessage()    {}
func (*EventList) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{38}
}
func (m *EventList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventList.Unmarshal(m, b)
}
func (m *EventList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventList.Marshal(b, m, deterministic)
}
func (dst *EventList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventList.Merge(dst, src)
}
func (m *EventList) XXX_Size() int {
	return xxx_messageInfo_EventList.Size(m)
}
func (m *EventList) XXX_DiscardUnknown() {
	xxx_messageInfo_EventList.DiscardUnknown(m)
}

var xxx_messageInfo_EventList proto.InternalMessageInfo

func (m *EventList) GetEvents() []*Event {
	if m != nil {
		return m.Events
	}
	return nil
}

// info and bps is json string
type ConsensusInfo struct {
	Type                 string   `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Info                 string   `protobuf:"bytes,2,opt,name=info" json:"info,omitempty"`
	Bps                  []string `protobuf:"bytes,3,rep,name=bps" json:"bps,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConsensusInfo) Reset()         { *m = ConsensusInfo{} }
func (m *ConsensusInfo) String() string { return proto.CompactTextString(m) }
func (*ConsensusInfo) ProtoMessage()    {}
func (*ConsensusInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{39}
}
func (m *ConsensusInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConsensusInfo.Unmarshal(m, b)
}
func (m *ConsensusInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConsensusInfo.Marshal(b, m, deterministic)
}
func (dst *ConsensusInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConsensusInfo.Merge(dst, src)
}
func (m *ConsensusInfo) XXX_Size() int {
	return xxx_messageInfo_ConsensusInfo.Size(m)
}
func (m *ConsensusInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ConsensusInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ConsensusInfo proto.InternalMessageInfo

func (m *ConsensusInfo) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ConsensusInfo) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

func (m *ConsensusInfo) GetBps() []string {
	if m != nil {
		return m.Bps
	}
	return nil
}

type EnterpriseConfigKey struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnterpriseConfigKey) Reset()         { *m = EnterpriseConfigKey{} }
func (m *EnterpriseConfigKey) String() string { return proto.CompactTextString(m) }
func (*EnterpriseConfigKey) ProtoMessage()    {}
func (*EnterpriseConfigKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{40}
}
func (m *EnterpriseConfigKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnterpriseConfigKey.Unmarshal(m, b)
}
func (m *EnterpriseConfigKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnterpriseConfigKey.Marshal(b, m, deterministic)
}
func (dst *EnterpriseConfigKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnterpriseConfigKey.Merge(dst, src)
}
func (m *EnterpriseConfigKey) XXX_Size() int {
	return xxx_messageInfo_EnterpriseConfigKey.Size(m)
}
func (m *EnterpriseConfigKey) XXX_DiscardUnknown() {
	xxx_messageInfo_EnterpriseConfigKey.DiscardUnknown(m)
}

var xxx_messageInfo_EnterpriseConfigKey proto.InternalMessageInfo

func (m *EnterpriseConfigKey) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

type EnterpriseConfig struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	On                   bool     `protobuf:"varint,2,opt,name=on" json:"on,omitempty"`
	Values               []string `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnterpriseConfig) Reset()         { *m = EnterpriseConfig{} }
func (m *EnterpriseConfig) String() string { return proto.CompactTextString(m) }
func (*EnterpriseConfig) ProtoMessage()    {}
func (*EnterpriseConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_rpc_8d86ee9ecec344df, []int{41}
}
func (m *EnterpriseConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnterpriseConfig.Unmarshal(m, b)
}
func (m *EnterpriseConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnterpriseConfig.Marshal(b, m, deterministic)
}
func (dst *EnterpriseConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnterpriseConfig.Merge(dst, src)
}
func (m *EnterpriseConfig) XXX_Size() int {
	return xxx_messageInfo_EnterpriseConfig.Size(m)
}
func (m *EnterpriseConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_EnterpriseConfig.DiscardUnknown(m)
}

var xxx_messageInfo_EnterpriseConfig proto.InternalMessageInfo

func (m *EnterpriseConfig) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *EnterpriseConfig) GetOn() bool {
	if m != nil {
		return m.On
	}
	return false
}

func (m *EnterpriseConfig) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func init() {
	proto.RegisterType((*BlockchainStatus)(nil), "types.BlockchainStatus")
	proto.RegisterType((*ChainId)(nil), "types.ChainId")
	proto.RegisterType((*ChainInfo)(nil), "types.ChainInfo")
	proto.RegisterType((*ChainStats)(nil), "types.ChainStats")
	proto.RegisterType((*Input)(nil), "types.Input")
	proto.RegisterType((*Output)(nil), "types.Output")
	proto.RegisterType((*Empty)(nil), "types.Empty")
	proto.RegisterType((*SingleBytes)(nil), "types.SingleBytes")
	proto.RegisterType((*SingleString)(nil), "types.SingleString")
	proto.RegisterType((*AccountAddress)(nil), "types.AccountAddress")
	proto.RegisterType((*AccountAndRoot)(nil), "types.AccountAndRoot")
	proto.RegisterType((*Peer)(nil), "types.Peer")
	proto.RegisterType((*PeerList)(nil), "types.PeerList")
	proto.RegisterType((*ListParams)(nil), "types.ListParams")
	proto.RegisterType((*PageParams)(nil), "types.PageParams")
	proto.RegisterType((*BlockBodyPaged)(nil), "types.BlockBodyPaged")
	proto.RegisterType((*BlockBodyParams)(nil), "types.BlockBodyParams")
	proto.RegisterType((*BlockHeaderList)(nil), "types.BlockHeaderList")
	proto.RegisterType((*BlockMetadata)(nil), "types.BlockMetadata")
	proto.RegisterType((*BlockMetadataList)(nil), "types.BlockMetadataList")
	proto.RegisterType((*CommitResult)(nil), "types.CommitResult")
	proto.RegisterType((*CommitResultList)(nil), "types.CommitResultList")
	proto.RegisterType((*VerifyResult)(nil), "types.VerifyResult")
	proto.RegisterType((*Personal)(nil), "types.Personal")
	proto.RegisterType((*ImportFormat)(nil), "types.ImportFormat")
	proto.RegisterType((*Staking)(nil), "types.Staking")
	proto.RegisterType((*Vote)(nil), "types.Vote")
	proto.RegisterType((*VoteParams)(nil), "types.VoteParams")
	proto.RegisterType((*AccountVoteInfo)(nil), "types.AccountVoteInfo")
	proto.RegisterType((*VoteInfo)(nil), "types.VoteInfo")
	proto.RegisterType((*VoteList)(nil), "types.VoteList")
	proto.RegisterType((*NodeReq)(nil), "types.NodeReq")
	proto.RegisterType((*Name)(nil), "types.Name")
	proto.RegisterType((*NameInfo)(nil), "types.NameInfo")
	proto.RegisterType((*PeersParams)(nil), "types.PeersParams")
	proto.RegisterType((*KeyParams)(nil), "types.KeyParams")
	proto.RegisterType((*ServerInfo)(nil), "types.ServerInfo")
	proto.RegisterMapType((map[string]*ConfigItem)(nil), "types.ServerInfo.ConfigEntry")
	proto.RegisterMapType((map[string]string)(nil), "types.ServerInfo.StatusEntry")
	proto.RegisterType((*ConfigItem)(nil), "types.ConfigItem")
	proto.RegisterMapType((map[string]string)(nil), "types.ConfigItem.PropsEntry")
	proto.RegisterType((*EventList)(nil), "types.EventList")
	proto.RegisterType((*ConsensusInfo)(nil), "types.ConsensusInfo")
	proto.RegisterType((*EnterpriseConfigKey)(nil), "types.EnterpriseConfigKey")
	proto.RegisterType((*EnterpriseConfig)(nil), "types.EnterpriseConfig")
	proto.RegisterEnum("types.CommitStatus", CommitStatus_name, CommitStatus_value)
	proto.RegisterEnum("types.VerifyStatus", VerifyStatus_name, VerifyStatus_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for AergoRPCService service

type AergoRPCServiceClient interface {
	// Returns the current state of this node
	NodeState(ctx context.Context, in *NodeReq, opts ...grpc.CallOption) (*SingleBytes, error)
	// Returns node metrics according to request
	Metric(ctx context.Context, in *MetricsRequest, opts ...grpc.CallOption) (*Metrics, error)
	// Returns current blockchain status (best block's height and hash)
	Blockchain(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*BlockchainStatus, error)
	// Returns current blockchain's basic information
	GetChainInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ChainInfo, error)
	// Returns current chain statistics
	ChainStat(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ChainStats, error)
	// Returns list of Blocks without body according to request
	ListBlockHeaders(ctx context.Context, in *ListParams, opts ...grpc.CallOption) (*BlockHeaderList, error)
	// Returns list of block metadata (hash, header, and number of transactions) according to request
	ListBlockMetadata(ctx context.Context, in *ListParams, opts ...grpc.CallOption) (*BlockMetadataList, error)
	// Returns a stream of new blocks as they get added to the blockchain
	ListBlockStream(ctx context.Context, in *Empty, opts ...grpc.CallOption) (AergoRPCService_ListBlockStreamClient, error)
	// Returns a stream of new block's metadata as they get added to the blockchain
	ListBlockMetadataStream(ctx context.Context, in *Empty, opts ...grpc.CallOption) (AergoRPCService_ListBlockMetadataStreamClient, error)
	// Return a single block incl. header and body, queried by hash or number
	GetBlock(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*Block, error)
	// Return a single block's metdata (hash, header, and number of transactions), queried by hash or number
	GetBlockMetadata(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*BlockMetadata, error)
	// Return a single block's body, queried by hash or number and list parameters
	GetBlockBody(ctx context.Context, in *BlockBodyParams, opts ...grpc.CallOption) (*BlockBodyPaged, error)
	// Return a single transaction, queried by transaction hash
	GetTX(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*Tx, error)
	// Return information about transaction in block, queried by transaction hash
	GetBlockTX(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*TxInBlock, error)
	// Return transaction receipt, queried by transaction hash
	GetReceipt(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*Receipt, error)
	// Return ABI stored at contract address
	GetABI(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*ABI, error)
	// Sign and send a transaction from an unlocked account
	SendTX(ctx context.Context, in *Tx, opts ...grpc.CallOption) (*CommitResult, error)
	// Sign transaction with unlocked account
	SignTX(ctx context.Context, in *Tx, opts ...grpc.CallOption) (*Tx, error)
	// Verify validity of transaction
	VerifyTX(ctx context.Context, in *Tx, opts ...grpc.CallOption) (*VerifyResult, error)
	// Commit a signed transaction
	CommitTX(ctx context.Context, in *TxList, opts ...grpc.CallOption) (*CommitResultList, error)
	// Return state of account
	GetState(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*State, error)
	// Return state of account, including merkle proof
	GetStateAndProof(ctx context.Context, in *AccountAndRoot, opts ...grpc.CallOption) (*AccountProof, error)
	// Create a new account in this node
	CreateAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*Account, error)
	// Return list of accounts in this node
	GetAccounts(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*AccountList, error)
	// Lock account in this node
	LockAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*Account, error)
	// Unlock account in this node
	UnlockAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*Account, error)
	// Import account to this node
	ImportAccount(ctx context.Context, in *ImportFormat, opts ...grpc.CallOption) (*Account, error)
	// Export account stored in this node as wif format
	ExportAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*SingleBytes, error)
	// Export account stored in this node as keystore format
	ExportAccountKeystore(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*SingleBytes, error)
	// Query a contract method
	QueryContract(ctx context.Context, in *Query, opts ...grpc.CallOption) (*SingleBytes, error)
	// Query contract state
	QueryContractState(ctx context.Context, in *StateQuery, opts ...grpc.CallOption) (*StateQueryProof, error)
	// Return list of peers of this node and their state
	GetPeers(ctx context.Context, in *PeersParams, opts ...grpc.CallOption) (*PeerList, error)
	// Return result of vote
	GetVotes(ctx context.Context, in *VoteParams, opts ...grpc.CallOption) (*VoteList, error)
	// Return staking, voting info for account
	GetAccountVotes(ctx context.Context, in *AccountAddress, opts ...grpc.CallOption) (*AccountVoteInfo, error)
	// Return staking information
	GetStaking(ctx context.Context, in *AccountAddress, opts ...grpc.CallOption) (*Staking, error)
	// Return name information
	GetNameInfo(ctx context.Context, in *Name, opts ...grpc.CallOption) (*NameInfo, error)
	// Returns a stream of event as they get added to the blockchain
	ListEventStream(ctx context.Context, in *FilterInfo, opts ...grpc.CallOption) (AergoRPCService_ListEventStreamClient, error)
	// Returns list of event
	ListEvents(ctx context.Context, in *FilterInfo, opts ...grpc.CallOption) (*EventList, error)
	// Returns configs and statuses of server
	GetServerInfo(ctx context.Context, in *KeyParams, opts ...grpc.CallOption) (*ServerInfo, error)
	// Returns status of consensus and bps
	GetConsensusInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ConsensusInfo, error)
	// Returns enterprise config
	GetEnterpriseConfig(ctx context.Context, in *EnterpriseConfigKey, opts ...grpc.CallOption) (*EnterpriseConfig, error)
	// Return a status of changeCluster enterprise tx,  queried by requestID
	GetConfChangeProgress(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*ConfChangeProgress, error)
}

type aergoRPCServiceClient struct {
	cc *grpc.ClientConn
}

func NewAergoRPCServiceClient(cc *grpc.ClientConn) AergoRPCServiceClient {
	return &aergoRPCServiceClient{cc}
}

func (c *aergoRPCServiceClient) NodeState(ctx context.Context, in *NodeReq, opts ...grpc.CallOption) (*SingleBytes, error) {
	out := new(SingleBytes)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/NodeState", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) Metric(ctx context.Context, in *MetricsRequest, opts ...grpc.CallOption) (*Metrics, error) {
	out := new(Metrics)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/Metric", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) Blockchain(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*BlockchainStatus, error) {
	out := new(BlockchainStatus)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/Blockchain", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetChainInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ChainInfo, error) {
	out := new(ChainInfo)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetChainInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ChainStat(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ChainStats, error) {
	out := new(ChainStats)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ChainStat", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ListBlockHeaders(ctx context.Context, in *ListParams, opts ...grpc.CallOption) (*BlockHeaderList, error) {
	out := new(BlockHeaderList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ListBlockHeaders", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ListBlockMetadata(ctx context.Context, in *ListParams, opts ...grpc.CallOption) (*BlockMetadataList, error) {
	out := new(BlockMetadataList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ListBlockMetadata", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ListBlockStream(ctx context.Context, in *Empty, opts ...grpc.CallOption) (AergoRPCService_ListBlockStreamClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_AergoRPCService_serviceDesc.Streams[0], c.cc, "/types.AergoRPCService/ListBlockStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &aergoRPCServiceListBlockStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AergoRPCService_ListBlockStreamClient interface {
	Recv() (*Block, error)
	grpc.ClientStream
}

type aergoRPCServiceListBlockStreamClient struct {
	grpc.ClientStream
}

func (x *aergoRPCServiceListBlockStreamClient) Recv() (*Block, error) {
	m := new(Block)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aergoRPCServiceClient) ListBlockMetadataStream(ctx context.Context, in *Empty, opts ...grpc.CallOption) (AergoRPCService_ListBlockMetadataStreamClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_AergoRPCService_serviceDesc.Streams[1], c.cc, "/types.AergoRPCService/ListBlockMetadataStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &aergoRPCServiceListBlockMetadataStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AergoRPCService_ListBlockMetadataStreamClient interface {
	Recv() (*BlockMetadata, error)
	grpc.ClientStream
}

type aergoRPCServiceListBlockMetadataStreamClient struct {
	grpc.ClientStream
}

func (x *aergoRPCServiceListBlockMetadataStreamClient) Recv() (*BlockMetadata, error) {
	m := new(BlockMetadata)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aergoRPCServiceClient) GetBlock(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*Block, error) {
	out := new(Block)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetBlock", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetBlockMetadata(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*BlockMetadata, error) {
	out := new(BlockMetadata)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetBlockMetadata", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetBlockBody(ctx context.Context, in *BlockBodyParams, opts ...grpc.CallOption) (*BlockBodyPaged, error) {
	out := new(BlockBodyPaged)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetBlockBody", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetTX(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*Tx, error) {
	out := new(Tx)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetTX", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetBlockTX(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*TxInBlock, error) {
	out := new(TxInBlock)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetBlockTX", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetReceipt(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*Receipt, error) {
	out := new(Receipt)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetReceipt", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetABI(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*ABI, error) {
	out := new(ABI)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetABI", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) SendTX(ctx context.Context, in *Tx, opts ...grpc.CallOption) (*CommitResult, error) {
	out := new(CommitResult)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/SendTX", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) SignTX(ctx context.Context, in *Tx, opts ...grpc.CallOption) (*Tx, error) {
	out := new(Tx)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/SignTX", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) VerifyTX(ctx context.Context, in *Tx, opts ...grpc.CallOption) (*VerifyResult, error) {
	out := new(VerifyResult)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/VerifyTX", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) CommitTX(ctx context.Context, in *TxList, opts ...grpc.CallOption) (*CommitResultList, error) {
	out := new(CommitResultList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/CommitTX", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetState(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*State, error) {
	out := new(State)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetState", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetStateAndProof(ctx context.Context, in *AccountAndRoot, opts ...grpc.CallOption) (*AccountProof, error) {
	out := new(AccountProof)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetStateAndProof", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) CreateAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/CreateAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetAccounts(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*AccountList, error) {
	out := new(AccountList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetAccounts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) LockAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/LockAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) UnlockAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/UnlockAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ImportAccount(ctx context.Context, in *ImportFormat, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ImportAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ExportAccount(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*SingleBytes, error) {
	out := new(SingleBytes)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ExportAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ExportAccountKeystore(ctx context.Context, in *Personal, opts ...grpc.CallOption) (*SingleBytes, error) {
	out := new(SingleBytes)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ExportAccountKeystore", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) QueryContract(ctx context.Context, in *Query, opts ...grpc.CallOption) (*SingleBytes, error) {
	out := new(SingleBytes)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/QueryContract", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) QueryContractState(ctx context.Context, in *StateQuery, opts ...grpc.CallOption) (*StateQueryProof, error) {
	out := new(StateQueryProof)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/QueryContractState", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetPeers(ctx context.Context, in *PeersParams, opts ...grpc.CallOption) (*PeerList, error) {
	out := new(PeerList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetPeers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetVotes(ctx context.Context, in *VoteParams, opts ...grpc.CallOption) (*VoteList, error) {
	out := new(VoteList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetVotes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetAccountVotes(ctx context.Context, in *AccountAddress, opts ...grpc.CallOption) (*AccountVoteInfo, error) {
	out := new(AccountVoteInfo)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetAccountVotes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetStaking(ctx context.Context, in *AccountAddress, opts ...grpc.CallOption) (*Staking, error) {
	out := new(Staking)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetStaking", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetNameInfo(ctx context.Context, in *Name, opts ...grpc.CallOption) (*NameInfo, error) {
	out := new(NameInfo)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetNameInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) ListEventStream(ctx context.Context, in *FilterInfo, opts ...grpc.CallOption) (AergoRPCService_ListEventStreamClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_AergoRPCService_serviceDesc.Streams[2], c.cc, "/types.AergoRPCService/ListEventStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &aergoRPCServiceListEventStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AergoRPCService_ListEventStreamClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type aergoRPCServiceListEventStreamClient struct {
	grpc.ClientStream
}

func (x *aergoRPCServiceListEventStreamClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aergoRPCServiceClient) ListEvents(ctx context.Context, in *FilterInfo, opts ...grpc.CallOption) (*EventList, error) {
	out := new(EventList)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/ListEvents", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetServerInfo(ctx context.Context, in *KeyParams, opts ...grpc.CallOption) (*ServerInfo, error) {
	out := new(ServerInfo)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetServerInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetConsensusInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ConsensusInfo, error) {
	out := new(ConsensusInfo)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetConsensusInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetEnterpriseConfig(ctx context.Context, in *EnterpriseConfigKey, opts ...grpc.CallOption) (*EnterpriseConfig, error) {
	out := new(EnterpriseConfig)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetEnterpriseConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aergoRPCServiceClient) GetConfChangeProgress(ctx context.Context, in *SingleBytes, opts ...grpc.CallOption) (*ConfChangeProgress, error) {
	out := new(ConfChangeProgress)
	err := grpc.Invoke(ctx, "/types.AergoRPCService/GetConfChangeProgress", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for AergoRPCService service

type AergoRPCServiceServer interface {
	// Returns the current state of this node
	NodeState(context.Context, *NodeReq) (*SingleBytes, error)
	// Returns node metrics according to request
	Metric(context.Context, *MetricsRequest) (*Metrics, error)
	// Returns current blockchain status (best block's height and hash)
	Blockchain(context.Context, *Empty) (*BlockchainStatus, error)
	// Returns current blockchain's basic information
	GetChainInfo(context.Context, *Empty) (*ChainInfo, error)
	// Returns current chain statistics
	ChainStat(context.Context, *Empty) (*ChainStats, error)
	// Returns list of Blocks without body according to request
	ListBlockHeaders(context.Context, *ListParams) (*BlockHeaderList, error)
	// Returns list of block metadata (hash, header, and number of transactions) according to request
	ListBlockMetadata(context.Context, *ListParams) (*BlockMetadataList, error)
	// Returns a stream of new blocks as they get added to the blockchain
	ListBlockStream(*Empty, AergoRPCService_ListBlockStreamServer) error
	// Returns a stream of new block's metadata as they get added to the blockchain
	ListBlockMetadataStream(*Empty, AergoRPCService_ListBlockMetadataStreamServer) error
	// Return a single block incl. header and body, queried by hash or number
	GetBlock(context.Context, *SingleBytes) (*Block, error)
	// Return a single block's metdata (hash, header, and number of transactions), queried by hash or number
	GetBlockMetadata(context.Context, *SingleBytes) (*BlockMetadata, error)
	// Return a single block's body, queried by hash or number and list parameters
	GetBlockBody(context.Context, *BlockBodyParams) (*BlockBodyPaged, error)
	// Return a single transaction, queried by transaction hash
	GetTX(context.Context, *SingleBytes) (*Tx, error)
	// Return information about transaction in block, queried by transaction hash
	GetBlockTX(context.Context, *SingleBytes) (*TxInBlock, error)
	// Return transaction receipt, queried by transaction hash
	GetReceipt(context.Context, *SingleBytes) (*Receipt, error)
	// Return ABI stored at contract address
	GetABI(context.Context, *SingleBytes) (*ABI, error)
	// Sign and send a transaction from an unlocked account
	SendTX(context.Context, *Tx) (*CommitResult, error)
	// Sign transaction with unlocked account
	SignTX(context.Context, *Tx) (*Tx, error)
	// Verify validity of transaction
	VerifyTX(context.Context, *Tx) (*VerifyResult, error)
	// Commit a signed transaction
	CommitTX(context.Context, *TxList) (*CommitResultList, error)
	// Return state of account
	GetState(context.Context, *SingleBytes) (*State, error)
	// Return state of account, including merkle proof
	GetStateAndProof(context.Context, *AccountAndRoot) (*AccountProof, error)
	// Create a new account in this node
	CreateAccount(context.Context, *Personal) (*Account, error)
	// Return list of accounts in this node
	GetAccounts(context.Context, *Empty) (*AccountList, error)
	// Lock account in this node
	LockAccount(context.Context, *Personal) (*Account, error)
	// Unlock account in this node
	UnlockAccount(context.Context, *Personal) (*Account, error)
	// Import account to this node
	ImportAccount(context.Context, *ImportFormat) (*Account, error)
	// Export account stored in this node as wif format
	ExportAccount(context.Context, *Personal) (*SingleBytes, error)
	// Export account stored in this node as keystore format
	ExportAccountKeystore(context.Context, *Personal) (*SingleBytes, error)
	// Query a contract method
	QueryContract(context.Context, *Query) (*SingleBytes, error)
	// Query contract state
	QueryContractState(context.Context, *StateQuery) (*StateQueryProof, error)
	// Return list of peers of this node and their state
	GetPeers(context.Context, *PeersParams) (*PeerList, error)
	// Return result of vote
	GetVotes(context.Context, *VoteParams) (*VoteList, error)
	// Return staking, voting info for account
	GetAccountVotes(context.Context, *AccountAddress) (*AccountVoteInfo, error)
	// Return staking information
	GetStaking(context.Context, *AccountAddress) (*Staking, error)
	// Return name information
	GetNameInfo(context.Context, *Name) (*NameInfo, error)
	// Returns a stream of event as they get added to the blockchain
	ListEventStream(*FilterInfo, AergoRPCService_ListEventStreamServer) error
	// Returns list of event
	ListEvents(context.Context, *FilterInfo) (*EventList, error)
	// Returns configs and statuses of server
	GetServerInfo(context.Context, *KeyParams) (*ServerInfo, error)
	// Returns status of consensus and bps
	GetConsensusInfo(context.Context, *Empty) (*ConsensusInfo, error)
	// Returns enterprise config
	GetEnterpriseConfig(context.Context, *EnterpriseConfigKey) (*EnterpriseConfig, error)
	// Return a status of changeCluster enterprise tx,  queried by requestID
	GetConfChangeProgress(context.Context, *SingleBytes) (*ConfChangeProgress, error)
}

func RegisterAergoRPCServiceServer(s *grpc.Server, srv AergoRPCServiceServer) {
	s.RegisterService(&_AergoRPCService_serviceDesc, srv)
}

func _AergoRPCService_NodeState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).NodeState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/NodeState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).NodeState(ctx, req.(*NodeReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_Metric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).Metric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/Metric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).Metric(ctx, req.(*MetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_Blockchain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).Blockchain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/Blockchain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).Blockchain(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetChainInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetChainInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetChainInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetChainInfo(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ChainStat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ChainStat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ChainStat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ChainStat(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ListBlockHeaders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ListBlockHeaders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ListBlockHeaders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ListBlockHeaders(ctx, req.(*ListParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ListBlockMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ListBlockMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ListBlockMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ListBlockMetadata(ctx, req.(*ListParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ListBlockStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AergoRPCServiceServer).ListBlockStream(m, &aergoRPCServiceListBlockStreamServer{stream})
}

type AergoRPCService_ListBlockStreamServer interface {
	Send(*Block) error
	grpc.ServerStream
}

type aergoRPCServiceListBlockStreamServer struct {
	grpc.ServerStream
}

func (x *aergoRPCServiceListBlockStreamServer) Send(m *Block) error {
	return x.ServerStream.SendMsg(m)
}

func _AergoRPCService_ListBlockMetadataStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AergoRPCServiceServer).ListBlockMetadataStream(m, &aergoRPCServiceListBlockMetadataStreamServer{stream})
}

type AergoRPCService_ListBlockMetadataStreamServer interface {
	Send(*BlockMetadata) error
	grpc.ServerStream
}

type aergoRPCServiceListBlockMetadataStreamServer struct {
	grpc.ServerStream
}

func (x *aergoRPCServiceListBlockMetadataStreamServer) Send(m *BlockMetadata) error {
	return x.ServerStream.SendMsg(m)
}

func _AergoRPCService_GetBlock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetBlock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetBlock",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetBlock(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetBlockMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetBlockMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetBlockMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetBlockMetadata(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetBlockBody_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BlockBodyParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetBlockBody(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetBlockBody",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetBlockBody(ctx, req.(*BlockBodyParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetTX_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetTX(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetTX",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetTX(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetBlockTX_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetBlockTX(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetBlockTX",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetBlockTX(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetReceipt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetReceipt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetReceipt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetReceipt(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetABI_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetABI(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetABI",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetABI(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_SendTX_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Tx)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).SendTX(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/SendTX",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).SendTX(ctx, req.(*Tx))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_SignTX_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Tx)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).SignTX(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/SignTX",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).SignTX(ctx, req.(*Tx))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_VerifyTX_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Tx)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).VerifyTX(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/VerifyTX",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).VerifyTX(ctx, req.(*Tx))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_CommitTX_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TxList)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).CommitTX(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/CommitTX",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).CommitTX(ctx, req.(*TxList))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetState(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetStateAndProof_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountAndRoot)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetStateAndProof(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetStateAndProof",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetStateAndProof(ctx, req.(*AccountAndRoot))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_CreateAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Personal)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).CreateAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/CreateAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).CreateAccount(ctx, req.(*Personal))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetAccounts(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_LockAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Personal)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).LockAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/LockAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).LockAccount(ctx, req.(*Personal))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_UnlockAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Personal)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).UnlockAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/UnlockAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).UnlockAccount(ctx, req.(*Personal))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ImportAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportFormat)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ImportAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ImportAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ImportAccount(ctx, req.(*ImportFormat))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ExportAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Personal)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ExportAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ExportAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ExportAccount(ctx, req.(*Personal))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ExportAccountKeystore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Personal)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ExportAccountKeystore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ExportAccountKeystore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ExportAccountKeystore(ctx, req.(*Personal))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_QueryContract_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Query)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).QueryContract(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/QueryContract",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).QueryContract(ctx, req.(*Query))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_QueryContractState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StateQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).QueryContractState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/QueryContractState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).QueryContractState(ctx, req.(*StateQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetPeers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeersParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetPeers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetPeers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetPeers(ctx, req.(*PeersParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetVotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VoteParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetVotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetVotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetVotes(ctx, req.(*VoteParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetAccountVotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountAddress)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetAccountVotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetAccountVotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetAccountVotes(ctx, req.(*AccountAddress))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetStaking_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountAddress)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetStaking(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetStaking",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetStaking(ctx, req.(*AccountAddress))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetNameInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Name)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetNameInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetNameInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetNameInfo(ctx, req.(*Name))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_ListEventStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FilterInfo)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AergoRPCServiceServer).ListEventStream(m, &aergoRPCServiceListEventStreamServer{stream})
}

type AergoRPCService_ListEventStreamServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type aergoRPCServiceListEventStreamServer struct {
	grpc.ServerStream
}

func (x *aergoRPCServiceListEventStreamServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _AergoRPCService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FilterInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).ListEvents(ctx, req.(*FilterInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetServerInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KeyParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetServerInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetServerInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetServerInfo(ctx, req.(*KeyParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetConsensusInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetConsensusInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetConsensusInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetConsensusInfo(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetEnterpriseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnterpriseConfigKey)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetEnterpriseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetEnterpriseConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetEnterpriseConfig(ctx, req.(*EnterpriseConfigKey))
	}
	return interceptor(ctx, in, info, handler)
}

func _AergoRPCService_GetConfChangeProgress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SingleBytes)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AergoRPCServiceServer).GetConfChangeProgress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.AergoRPCService/GetConfChangeProgress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AergoRPCServiceServer).GetConfChangeProgress(ctx, req.(*SingleBytes))
	}
	return interceptor(ctx, in, info, handler)
}

var _AergoRPCService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.AergoRPCService",
	HandlerType: (*AergoRPCServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NodeState",
			Handler:    _AergoRPCService_NodeState_Handler,
		},
		{
			MethodName: "Metric",
			Handler:    _AergoRPCService_Metric_Handler,
		},
		{
			MethodName: "Blockchain",
			Handler:    _AergoRPCService_Blockchain_Handler,
		},
		{
			MethodName: "GetChainInfo",
			Handler:    _AergoRPCService_GetChainInfo_Handler,
		},
		{
			MethodName: "ChainStat",
			Handler:    _AergoRPCService_ChainStat_Handler,
		},
		{
			MethodName: "ListBlockHeaders",
			Handler:    _AergoRPCService_ListBlockHeaders_Handler,
		},
		{
			MethodName: "ListBlockMetadata",
			Handler:    _AergoRPCService_ListBlockMetadata_Handler,
		},
		{
			MethodName: "GetBlock",
			Handler:    _AergoRPCService_GetBlock_Handler,
		},
		{
			MethodName: "GetBlockMetadata",
			Handler:    _AergoRPCService_GetBlockMetadata_Handler,
		},
		{
			MethodName: "GetBlockBody",
			Handler:    _AergoRPCService_GetBlockBody_Handler,
		},
		{
			MethodName: "GetTX",
			Handler:    _AergoRPCService_GetTX_Handler,
		},
		{
			MethodName: "GetBlockTX",
			Handler:    _AergoRPCService_GetBlockTX_Handler,
		},
		{
			MethodName: "GetReceipt",
			Handler:    _AergoRPCService_GetReceipt_Handler,
		},
		{
			MethodName: "GetABI",
			Handler:    _AergoRPCService_GetABI_Handler,
		},
		{
			MethodName: "SendTX",
			Handler:    _AergoRPCService_SendTX_Handler,
		},
		{
			MethodName: "SignTX",
			Handler:    _AergoRPCService_SignTX_Handler,
		},
		{
			MethodName: "VerifyTX",
			Handler:    _AergoRPCService_VerifyTX_Handler,
		},
		{
			MethodName: "CommitTX",
			Handler:    _AergoRPCService_CommitTX_Handler,
		},
		{
			MethodName: "GetState",
			Handler:    _AergoRPCService_GetState_Handler,
		},
		{
			MethodName: "GetStateAndProof",
			Handler:    _AergoRPCService_GetStateAndProof_Handler,
		},
		{
			MethodName: "CreateAccount",
			Handler:    _AergoRPCService_CreateAccount_Handler,
		},
		{
			MethodName: "GetAccounts",
			Handler:    _AergoRPCService_GetAccounts_Handler,
		},
		{
			MethodName: "LockAccount",
			Handler:    _AergoRPCService_LockAccount_Handler,
		},
		{
			MethodName: "UnlockAccount",
			Handler:    _AergoRPCService_UnlockAccount_Handler,
		},
		{
			MethodName: "ImportAccount",
			Handler:    _AergoRPCService_ImportAccount_Handler,
		},
		{
			MethodName: "ExportAccount",
			Handler:    _AergoRPCService_ExportAccount_Handler,
		},
		{
			MethodName: "ExportAccountKeystore",
			Handler:    _AergoRPCService_ExportAccountKeystore_Handler,
		},
		{
			MethodName: "QueryContract",
			Handler:    _AergoRPCService_QueryContract_Handler,
		},
		{
			MethodName: "QueryContractState",
			Handler:    _AergoRPCService_QueryContractState_Handler,
		},
		{
			MethodName: "GetPeers",
			Handler:    _AergoRPCService_GetPeers_Handler,
		},
		{
			MethodName: "GetVotes",
			Handler:    _AergoRPCService_GetVotes_Handler,
		},
		{
			MethodName: "GetAccountVotes",
			Handler:    _AergoRPCService_GetAccountVotes_Handler,
		},
		{
			MethodName: "GetStaking",
			Handler:    _AergoRPCService_GetStaking_Handler,
		},
		{
			MethodName: "GetNameInfo",
			Handler:    _AergoRPCService_GetNameInfo_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _AergoRPCService_ListEvents_Handler,
		},
		{
			MethodName: "GetServerInfo",
			Handler:    _AergoRPCService_GetServerInfo_Handler,
		},
		{
			MethodName: "GetConsensusInfo",
			Handler:    _AergoRPCService_GetConsensusInfo_Handler,
		},
		{
			MethodName: "GetEnterpriseConfig",
			Handler:    _AergoRPCService_GetEnterpriseConfig_Handler,
		},
		{
			MethodName: "GetConfChangeProgress",
			Handler:    _AergoRPCService_GetConfChangeProgress_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListBlockStream",
			Handler:       _AergoRPCService_ListBlockStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListBlockMetadataStream",
			Handler:       _AergoRPCService_ListBlockMetadataStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListEventStream",
			Handler:       _AergoRPCService_ListEventStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "rpc.proto",
}

func init() { proto.RegisterFile("rpc.proto", fileDescriptor_rpc_8d86ee9ecec344df) }

var fileDescriptor_rpc_8d86ee9ecec344df = []byte{
	// 2612 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x59, 0xdd, 0x73, 0x1b, 0xb7,
	0x11, 0x27, 0x29, 0x51, 0x22, 0x97, 0xa4, 0x44, 0xc1, 0xb2, 0xad, 0xb0, 0x89, 0xa3, 0xa2, 0x6e,
	0xa2, 0xb8, 0x89, 0x1a, 0xd3, 0x49, 0x9a, 0x7e, 0x25, 0xa5, 0x18, 0xda, 0xe2, 0x58, 0xa6, 0x54,
	0x90, 0x71, 0x95, 0x97, 0xb2, 0xa7, 0x3b, 0x90, 0xbc, 0x11, 0x79, 0x77, 0xb9, 0x03, 0xf5, 0x91,
	0x99, 0x3e, 0xf5, 0xa9, 0xff, 0x41, 0x67, 0xfa, 0x5f, 0xf5, 0xbd, 0xd3, 0xfe, 0x29, 0x1d, 0x2c,
	0x80, 0xfb, 0xa0, 0xce, 0x9d, 0xba, 0x6f, 0xb7, 0x8b, 0xdf, 0x7e, 0x01, 0x8b, 0xc5, 0x02, 0x07,
	0xd5, 0x30, 0xb0, 0x0f, 0x83, 0xd0, 0x17, 0x3e, 0x29, 0x8b, 0xdb, 0x80, 0x47, 0xad, 0xe6, 0xc5,
	0xdc, 0xb7, 0x2f, 0xed, 0x99, 0xe5, 0x7a, 0x6a, 0xa0, 0xd5, 0xb0, 0x6c, 0xdb, 0x5f, 0x7a, 0x42,
	0x93, 0xe0, 0xf9, 0x0e, 0xd7, 0xdf, 0xd5, 0xa0, 0x1d, 0xe8, 0xcf, 0xfa, 0x82, 0x8b, 0xd0, 0xb5,
	0x0d, 0x28, 0xb4, 0x26, 0x5a, 0x80, 0xfe, 0xbb, 0x08, 0xcd, 0xa3, 0x58, 0xe9, 0x50, 0x58, 0x62,
	0x19, 0x91, 0x0f, 0x60, 0xfb, 0x82, 0x47, 0x62, 0x8c, 0xd6, 0xc6, 0x33, 0x2b, 0x9a, 0xed, 0x15,
	0xf7, 0x8b, 0x07, 0x75, 0xd6, 0x90, 0x6c, 0x84, 0x1f, 0x5b, 0xd1, 0x8c, 0xbc, 0x0f, 0x35, 0xc4,
	0xcd, 0xb8, 0x3b, 0x9d, 0x89, 0xbd, 0xd2, 0x7e, 0xf1, 0x60, 0x9d, 0x81, 0x64, 0x1d, 0x23, 0x87,
	0xfc, 0x14, 0xb6, 0x6c, 0xdf, 0x8b, 0xb8, 0x17, 0x2d, 0xa3, 0xb1, 0xeb, 0x4d, 0xfc, 0xbd, 0xb5,
	0xfd, 0xe2, 0x41, 0x95, 0x35, 0x62, 0x6e, 0xdf, 0x9b, 0xf8, 0xe4, 0x67, 0x40, 0x50, 0x0f, 0xfa,
	0x30, 0x76, 0x1d, 0x65, 0x72, 0x1d, 0x4d, 0xa2, 0x27, 0x5d, 0x39, 0xd0, 0x77, 0xd0, 0xe8, 0xcf,
	0x01, 0x34, 0x4e, 0xea, 0x2b, 0xef, 0x17, 0x0f, 0x6a, 0xed, 0xe6, 0x21, 0xce, 0xcf, 0xa1, 0xc2,
	0x79, 0x13, 0x9f, 0x55, 0x6d, 0xf3, 0x49, 0xff, 0x5a, 0x84, 0x4d, 0xad, 0x80, 0xec, 0x42, 0x79,
	0x61, 0x4d, 0x5d, 0x1b, 0xe3, 0xa9, 0x32, 0x45, 0x90, 0x07, 0xb0, 0x11, 0x2c, 0x2f, 0xe6, 0xae,
	0x8d, 0x21, 0x54, 0x98, 0xa6, 0xc8, 0x1e, 0x6c, 0x2e, 0x2c, 0xd7, 0xf3, 0xb8, 0x40, 0xbf, 0x2b,
	0xcc, 0x90, 0xe4, 0x5d, 0xa8, 0xc6, 0x21, 0xa0, 0xa3, 0x55, 0x96, 0x30, 0xa4, 0xdc, 0x15, 0x0f,
	0x23, 0xd7, 0xf7, 0xd0, 0xbf, 0x32, 0x33, 0x24, 0xfd, 0x57, 0x09, 0xaa, 0xb1, 0x93, 0xe4, 0x11,
	0x94, 0x5c, 0x07, 0x5d, 0xa9, 0xb5, 0xb7, 0x32, 0x21, 0x38, 0xac, 0xe4, 0x3a, 0xa4, 0x05, 0x95,
	0x8b, 0x60, 0xb0, 0x5c, 0x5c, 0xf0, 0x10, 0x3d, 0x6b, 0xb0, 0x98, 0x26, 0x14, 0xea, 0x0b, 0xeb,
	0x06, 0x57, 0x28, 0x72, 0x7f, 0xe0, 0xe8, 0xe0, 0x3a, 0xcb, 0xf0, 0xa4, 0x97, 0x0b, 0xeb, 0x46,
	0xf8, 0x97, 0xdc, 0x8b, 0xf4, 0x74, 0x26, 0x0c, 0xf2, 0x01, 0x6c, 0x45, 0xc2, 0xba, 0x74, 0xbd,
	0xe9, 0xc2, 0xf5, 0xdc, 0xc5, 0x72, 0x81, 0xce, 0xd6, 0xd9, 0x0a, 0x57, 0x5a, 0x12, 0xbe, 0xb0,
	0xe6, 0x9a, 0xbd, 0xb7, 0x81, 0xa8, 0x0c, 0x4f, 0x7a, 0x3a, 0xb5, 0xa2, 0x20, 0x74, 0x6d, 0xbe,
	0xb7, 0x89, 0xe3, 0x31, 0x2d, 0xbd, 0xf0, 0xac, 0x05, 0x57, 0x83, 0x15, 0xe5, 0x45, 0xcc, 0x20,
	0x4f, 0xa0, 0x89, 0x9a, 0xae, 0x7c, 0xe1, 0x7a, 0xd3, 0xc0, 0xbf, 0xe6, 0xe1, 0x5e, 0x15, 0x41,
	0x77, 0xf8, 0xd2, 0x13, 0x45, 0x86, 0xfc, 0xda, 0x0a, 0x9d, 0x3d, 0x50, 0x9e, 0xa4, 0x79, 0xf4,
	0x31, 0x40, 0xd7, 0xa4, 0x72, 0x24, 0x57, 0x36, 0xe4, 0x81, 0x1f, 0x0a, 0xbd, 0xe0, 0x9a, 0xa2,
	0x36, 0x94, 0xfb, 0x5e, 0xb0, 0x14, 0x84, 0xc0, 0x7a, 0x2a, 0xbf, 0xf1, 0x5b, 0x2e, 0x9f, 0xe5,
	0x38, 0x21, 0x8f, 0xa2, 0xbd, 0xd2, 0xfe, 0xda, 0x41, 0x9d, 0x19, 0x52, 0xa6, 0xcf, 0x95, 0x35,
	0x5f, 0xaa, 0xd9, 0xae, 0x33, 0x45, 0x48, 0x23, 0x91, 0x1d, 0xba, 0x81, 0xd0, 0x73, 0xac, 0x29,
	0x3a, 0x81, 0x8d, 0xd3, 0xa5, 0x90, 0x56, 0x76, 0xa1, 0xec, 0x7a, 0x0e, 0xbf, 0x41, 0x33, 0x0d,
	0xa6, 0x88, 0xac, 0x9d, 0xe2, 0xff, 0x6f, 0x67, 0x13, 0xca, 0xbd, 0x45, 0x20, 0x6e, 0xe9, 0x4f,
	0xa0, 0x36, 0x74, 0xbd, 0xe9, 0x9c, 0x1f, 0xdd, 0x0a, 0x9e, 0xd2, 0x52, 0x4c, 0x69, 0xa1, 0x8f,
	0xa1, 0xae, 0x40, 0x43, 0x11, 0xca, 0xa5, 0xcb, 0xa0, 0xaa, 0x06, 0xf5, 0x01, 0x6c, 0x75, 0x54,
	0x65, 0xe9, 0xac, 0xfa, 0x94, 0xd1, 0xf6, 0xc7, 0x04, 0xe7, 0x39, 0xcc, 0xf7, 0x85, 0x8c, 0x4a,
	0x73, 0x34, 0xd2, 0x90, 0x72, 0xae, 0x25, 0x42, 0x07, 0x8b, 0xdf, 0xe4, 0x11, 0x40, 0xd7, 0x5f,
	0x04, 0xd2, 0x02, 0x77, 0xf4, 0x2e, 0x4b, 0x71, 0xe8, 0x3f, 0x4b, 0xb0, 0x7e, 0xc6, 0x79, 0x48,
	0x3e, 0x4e, 0x26, 0x4b, 0x6d, 0x18, 0xa2, 0x37, 0x8c, 0x1c, 0xd5, 0x3e, 0x26, 0x13, 0xf8, 0x0c,
	0xaa, 0xb2, 0x6e, 0xe0, 0x56, 0x40, 0x7b, 0xb5, 0xf6, 0x7d, 0x8d, 0x1f, 0xf0, 0x6b, 0xac, 0x60,
	0x03, 0x5f, 0xb8, 0x36, 0x67, 0x09, 0x4e, 0x46, 0x18, 0x09, 0x4b, 0xa8, 0x59, 0x2f, 0x33, 0x45,
	0xc8, 0x59, 0x9f, 0xb9, 0x8e, 0xc3, 0x3d, 0x9c, 0xf5, 0x0a, 0xd3, 0x94, 0x4c, 0xeb, 0xb9, 0x15,
	0xcd, 0xba, 0x33, 0x6e, 0x5f, 0xe2, 0xce, 0x59, 0x63, 0x09, 0x43, 0x6e, 0x88, 0x88, 0xcf, 0x27,
	0x01, 0xe7, 0x21, 0x6e, 0x98, 0x0a, 0x8b, 0xe9, 0x74, 0x79, 0xd8, 0xc4, 0x39, 0x37, 0x24, 0xf9,
	0x35, 0xd4, 0x6d, 0x1e, 0x0a, 0x77, 0xe2, 0xda, 0x96, 0xe0, 0xd1, 0x5e, 0x65, 0x7f, 0xed, 0xa0,
	0xd6, 0x7e, 0xa8, 0x3d, 0xef, 0x4c, 0xb9, 0x27, 0xba, 0xc9, 0x38, 0xcb, 0x80, 0xc9, 0x33, 0xa8,
	0x5b, 0xb6, 0xcd, 0x03, 0xc1, 0x1d, 0xe6, 0xcf, 0x39, 0xee, 0xa2, 0xad, 0xf6, 0x76, 0x6a, 0x9a,
	0x24, 0x9b, 0x65, 0x40, 0xf4, 0x13, 0xa8, 0xc8, 0x91, 0x13, 0x37, 0x12, 0xe4, 0xc7, 0x50, 0x96,
	0xfe, 0xc9, 0x09, 0x96, 0x66, 0x6b, 0x69, 0x49, 0x35, 0x42, 0xaf, 0x00, 0x24, 0xf4, 0xcc, 0x0a,
	0xad, 0x45, 0x94, 0xbb, 0x79, 0xe4, 0x74, 0xa5, 0x8f, 0x03, 0x4d, 0x49, 0x6c, 0x5c, 0xa7, 0x1a,
	0x0c, 0xbf, 0x25, 0xd6, 0x9f, 0x4c, 0x22, 0xae, 0x12, 0xba, 0xc1, 0x34, 0x45, 0x9a, 0xb0, 0x66,
	0x45, 0x36, 0x4e, 0x6a, 0x85, 0xc9, 0x4f, 0xfa, 0x25, 0xc0, 0x99, 0x35, 0xe5, 0xda, 0x6e, 0x22,
	0x57, 0xcc, 0xc8, 0x19, 0x1b, 0xa5, 0xc4, 0x06, 0xbd, 0x81, 0x2d, 0x5c, 0xee, 0x23, 0xdf, 0xb9,
	0x95, 0x2a, 0xf0, 0x0c, 0xc0, 0xca, 0x62, 0x36, 0x23, 0x12, 0x29, 0x9d, 0xa5, 0x5c, 0x9d, 0x69,
	0xbf, 0x1f, 0xc3, 0xfa, 0x85, 0xef, 0xdc, 0xa2, 0xd7, 0xc9, 0xe1, 0x13, 0x9b, 0x61, 0x38, 0x4a,
	0xff, 0x04, 0xdb, 0x29, 0xcb, 0xe8, 0x38, 0x85, 0xba, 0x9c, 0x24, 0x3f, 0xf4, 0x54, 0x51, 0x57,
	0x13, 0x97, 0xe1, 0x91, 0x8f, 0x60, 0x23, 0xb0, 0xa6, 0xb2, 0xd0, 0xaa, 0xbc, 0xdd, 0x31, 0xcb,
	0x10, 0xc7, 0xcf, 0x34, 0x80, 0xfe, 0x42, 0x5b, 0x38, 0xe6, 0x96, 0xa3, 0xd7, 0xf0, 0x31, 0x6c,
	0xa8, 0xfa, 0xaf, 0x17, 0xb1, 0x9e, 0x76, 0x8e, 0xe9, 0x31, 0xfa, 0x67, 0x68, 0x20, 0xe3, 0x15,
	0x17, 0x96, 0x63, 0x09, 0x2b, 0x77, 0x25, 0x9f, 0xc8, 0x95, 0x94, 0x8a, 0xb5, 0x23, 0x24, 0xad,
	0x4a, 0x99, 0x64, 0x1a, 0x21, 0x53, 0x5a, 0xdc, 0xa8, 0x4d, 0xaf, 0x36, 0x8f, 0x21, 0xe3, 0xf9,
	0x5b, 0xc7, 0x1d, 0xa2, 0xd6, 0xa4, 0x03, 0x3b, 0x19, 0xf3, 0xe8, 0xf9, 0xc7, 0x2b, 0x9e, 0xef,
	0xa6, 0xcd, 0x19, 0x64, 0x1c, 0x01, 0x87, 0x7a, 0xd7, 0x5f, 0x2c, 0x5c, 0xc1, 0x78, 0xb4, 0x9c,
	0xe7, 0xd7, 0xf1, 0x8f, 0xa0, 0xcc, 0xc3, 0xd0, 0x57, 0xfe, 0x6f, 0xb5, 0xef, 0x99, 0x13, 0x16,
	0xe5, 0x54, 0xab, 0xc3, 0x14, 0x42, 0xae, 0xbe, 0xc3, 0x85, 0xe5, 0xce, 0x75, 0x83, 0xa2, 0x29,
	0xda, 0x81, 0x66, 0xda, 0x0c, 0x3a, 0xfa, 0x09, 0x6c, 0x86, 0x48, 0x19, 0x4f, 0xb3, 0x8a, 0x15,
	0x92, 0x19, 0x0c, 0x1d, 0x41, 0xfd, 0x35, 0x0f, 0xdd, 0xc9, 0xad, 0xf6, 0xf4, 0x1d, 0x28, 0x89,
	0x1b, 0x5d, 0xc3, 0xaa, 0x5a, 0x72, 0x74, 0xc3, 0x4a, 0xe2, 0xe6, 0x4d, 0x0e, 0x2b, 0xf1, 0x8c,
	0xc3, 0x74, 0x24, 0xf7, 0x6d, 0x18, 0xf9, 0x9e, 0x35, 0x97, 0x35, 0x34, 0xb0, 0xa2, 0x28, 0x98,
	0x85, 0x56, 0x64, 0xca, 0x78, 0x8a, 0x43, 0x0e, 0x60, 0x53, 0x77, 0x89, 0x7a, 0x25, 0x4d, 0xaf,
	0xa1, 0x0b, 0x33, 0x33, 0xc3, 0xf4, 0x6f, 0x45, 0xa8, 0xf7, 0x17, 0xf2, 0x84, 0x7c, 0xee, 0x87,
	0x0b, 0x4b, 0xa6, 0xd3, 0xda, 0xb5, 0x3b, 0x59, 0xa9, 0xb8, 0xa9, 0x33, 0x86, 0xc9, 0x61, 0xb9,
	0xfa, 0xfe, 0xdc, 0x91, 0x16, 0xd1, 0x40, 0x95, 0x19, 0x52, 0x8e, 0x78, 0xfc, 0x1a, 0x47, 0xd4,
	0xc4, 0x1a, 0x92, 0x1c, 0x42, 0xe5, 0x92, 0xdf, 0x46, 0xc2, 0x0f, 0xb9, 0xde, 0x47, 0x79, 0xea,
	0x63, 0x0c, 0xfd, 0x1c, 0x36, 0x87, 0xba, 0xd9, 0x78, 0x00, 0x1b, 0xd6, 0x22, 0x75, 0xc0, 0x68,
	0x4a, 0xe6, 0xc0, 0xf5, 0x8c, 0x7b, 0xba, 0xf0, 0xe0, 0x37, 0xfd, 0x0d, 0xac, 0xbf, 0xf6, 0x05,
	0x36, 0x21, 0xb6, 0xe5, 0x39, 0xae, 0x23, 0xeb, 0xbb, 0x12, 0x4b, 0x18, 0x29, 0x8d, 0xa5, 0xb4,
	0x46, 0xda, 0x06, 0x90, 0xd2, 0x7a, 0xf7, 0x6e, 0xc5, 0xed, 0x5a, 0x15, 0xdb, 0xb3, 0x5d, 0x28,
	0x27, 0xb3, 0xda, 0x60, 0x8a, 0xa0, 0x0e, 0x6c, 0xeb, 0x79, 0x95, 0xa2, 0xd8, 0xe7, 0x1d, 0xc0,
	0xa6, 0x69, 0x9e, 0xb2, 0xcd, 0x9e, 0x8e, 0x88, 0x99, 0x61, 0xf2, 0x21, 0x6c, 0xa8, 0x6e, 0x06,
	0x3b, 0x8f, 0x5a, 0x5c, 0xbd, 0x8d, 0x2a, 0xa6, 0x87, 0x29, 0x83, 0x4a, 0xac, 0x7e, 0xd5, 0xaf,
	0x47, 0x00, 0x71, 0x68, 0xaa, 0x85, 0xa9, 0xb2, 0x14, 0x27, 0x15, 0xad, 0x4e, 0x76, 0x1d, 0xed,
	0x6f, 0x95, 0x4e, 0x73, 0x16, 0x5c, 0xf9, 0x52, 0x3c, 0x7b, 0x16, 0xc8, 0x71, 0xa6, 0x46, 0xb4,
	0xd9, 0x92, 0x31, 0x4b, 0x3b, 0xb0, 0x39, 0xf0, 0x1d, 0xce, 0xf8, 0xf7, 0x58, 0x0e, 0xdc, 0x05,
	0xf7, 0x97, 0x71, 0x0f, 0xa0, 0x49, 0xd5, 0x38, 0x2f, 0x02, 0xdf, 0xe3, 0xf1, 0x64, 0x27, 0x0c,
	0xfa, 0x19, 0xac, 0x0f, 0xac, 0x05, 0x97, 0x2b, 0x29, 0x3b, 0x44, 0x1d, 0x13, 0x7e, 0x4b, 0x9d,
	0x17, 0xea, 0xdc, 0xd6, 0x0b, 0x6c, 0x48, 0x6a, 0x43, 0x45, 0x4a, 0xe1, 0x5c, 0xbc, 0x9f, 0x92,
	0x4c, 0xdc, 0x96, 0xc3, 0x5a, 0xcd, 0x2e, 0x94, 0xfd, 0x6b, 0x4f, 0x17, 0xb5, 0x3a, 0x53, 0x04,
	0xd9, 0x87, 0x9a, 0xc3, 0x23, 0xe1, 0x7a, 0x96, 0x90, 0xc7, 0xb2, 0x6a, 0xbb, 0xd2, 0x2c, 0xda,
	0x83, 0x9a, 0x3c, 0x08, 0x23, 0x9d, 0x0b, 0x2d, 0xa8, 0x78, 0xfe, 0xb1, 0xea, 0x0b, 0x8a, 0xea,
	0x7c, 0x37, 0x34, 0x9e, 0xfd, 0x33, 0xff, 0x7a, 0xc8, 0xe7, 0x13, 0x7d, 0xa1, 0x88, 0x69, 0xfa,
	0x1e, 0x54, 0x5f, 0x72, 0x73, 0x1c, 0x34, 0x61, 0xed, 0x92, 0xdf, 0xe2, 0x14, 0x57, 0x99, 0xfc,
	0xa4, 0x7f, 0x29, 0x01, 0x0c, 0x79, 0x78, 0xc5, 0x43, 0x8c, 0xe6, 0x73, 0xd8, 0x88, 0x70, 0xdb,
	0xeb, 0x65, 0x78, 0xcf, 0xe4, 0x4d, 0x0c, 0x39, 0x54, 0x65, 0xa1, 0xe7, 0x89, 0xf0, 0x96, 0x69,
	0xb0, 0x14, 0xb3, 0x7d, 0x6f, 0xe2, 0x9a, 0x2c, 0xca, 0x11, 0xeb, 0xe2, 0xb8, 0x16, 0x53, 0xe0,
	0xd6, 0x2f, 0xa1, 0x96, 0xd2, 0x96, 0x78, 0x57, 0xd4, 0xde, 0x25, 0x2d, 0x60, 0x29, 0xd5, 0x2a,
	0xfe, 0xaa, 0xf4, 0x65, 0xb1, 0x75, 0x02, 0xb5, 0x94, 0xc6, 0x1c, 0xd1, 0x0f, 0xd3, 0xa2, 0xc9,
	0xa1, 0xa6, 0x84, 0xfa, 0x82, 0x2f, 0x52, 0xda, 0xe8, 0x0f, 0xb2, 0x29, 0x34, 0x03, 0xa4, 0x0d,
	0xe5, 0x20, 0xf4, 0x83, 0x48, 0x07, 0xf3, 0xee, 0x1d, 0xd1, 0xc3, 0x33, 0x39, 0xac, 0x62, 0x51,
	0xd0, 0x96, 0xec, 0x17, 0x62, 0xe6, 0xdb, 0x44, 0x42, 0x9f, 0x42, 0xb5, 0x77, 0xc5, 0x3d, 0x61,
	0x4e, 0x53, 0x2e, 0x89, 0xd5, 0xd3, 0x14, 0x11, 0x4c, 0x8f, 0xd1, 0x3e, 0x34, 0xba, 0x99, 0xfb,
	0x2c, 0x81, 0x75, 0x89, 0x33, 0xe9, 0x2b, 0xbf, 0x25, 0x0f, 0x2f, 0xac, 0xca, 0x20, 0x7e, 0x4b,
	0xbf, 0x2e, 0x02, 0x59, 0x19, 0x71, 0xfd, 0x2f, 0x82, 0x88, 0x7e, 0x08, 0xf7, 0x7a, 0x9e, 0xe0,
	0x61, 0x10, 0xba, 0x11, 0x57, 0x11, 0xbe, 0xe4, 0x39, 0x01, 0xd0, 0x13, 0x68, 0xae, 0x02, 0x73,
	0xc2, 0xdc, 0x82, 0x92, 0xef, 0xe9, 0x1c, 0x2c, 0xf9, 0x9e, 0xdc, 0xf9, 0x18, 0xa9, 0xb1, 0xa9,
	0xa9, 0x27, 0xff, 0x28, 0x9a, 0xe3, 0x54, 0xbf, 0x00, 0x54, 0xa1, 0x3c, 0x3a, 0x1f, 0x9f, 0xbe,
	0x6c, 0x16, 0xc8, 0x2e, 0x34, 0x47, 0xe7, 0xe3, 0xc1, 0xe9, 0xa0, 0xdb, 0x1b, 0x8f, 0x4e, 0x4f,
	0xc7, 0x27, 0xa7, 0x7f, 0x68, 0x16, 0xc9, 0x7d, 0xd8, 0x19, 0x9d, 0x8f, 0x3b, 0x27, 0xac, 0xd7,
	0xf9, 0xe6, 0xbb, 0x71, 0xef, 0xbc, 0x3f, 0x1c, 0x0d, 0x9b, 0x25, 0x72, 0x0f, 0xb6, 0x47, 0xe7,
	0xe3, 0xfe, 0xe0, 0x75, 0xe7, 0xa4, 0xff, 0xcd, 0xf8, 0xb8, 0x33, 0x3c, 0x6e, 0xae, 0xad, 0x30,
	0x87, 0xfd, 0x17, 0x83, 0xe6, 0xba, 0x56, 0x60, 0x98, 0xcf, 0x4f, 0xd9, 0xab, 0xce, 0xa8, 0x59,
	0x26, 0x3f, 0x82, 0x87, 0xc8, 0x1e, 0x7e, 0xfb, 0xfc, 0x79, 0xbf, 0xdb, 0xef, 0x0d, 0x46, 0xe3,
	0xa3, 0xce, 0x49, 0x67, 0xd0, 0xed, 0x35, 0x37, 0xb4, 0xcc, 0x71, 0x67, 0x38, 0x1e, 0x76, 0x5e,
	0xf5, 0x94, 0x4f, 0xcd, 0xcd, 0x58, 0xd5, 0xa8, 0xc7, 0x06, 0x9d, 0x93, 0x71, 0x8f, 0xb1, 0x53,
	0xd6, 0xac, 0x3e, 0x99, 0x98, 0x83, 0x57, 0xc7, 0xb4, 0x0b, 0xcd, 0xd7, 0x3d, 0xd6, 0x7f, 0xfe,
	0xdd, 0x78, 0x38, 0xea, 0x8c, 0xbe, 0x1d, 0xaa, 0xf0, 0xf6, 0xe1, 0xdd, 0x2c, 0x57, 0xfa, 0x37,
	0x1e, 0x9c, 0x8e, 0xc6, 0xaf, 0x3a, 0xa3, 0xee, 0x71, 0xb3, 0x48, 0x1e, 0x41, 0x2b, 0x8b, 0xc8,
	0x84, 0x57, 0x6a, 0xff, 0x9d, 0xc0, 0x76, 0x87, 0x87, 0x53, 0x9f, 0x9d, 0x75, 0xe5, 0x0e, 0x93,
	0xb7, 0xda, 0xa7, 0x50, 0x95, 0xb5, 0x70, 0x88, 0x37, 0x08, 0x53, 0xed, 0x75, 0x75, 0x6c, 0xe5,
	0x1c, 0x74, 0xb4, 0x40, 0x9e, 0xc2, 0xc6, 0x2b, 0x7c, 0xa5, 0x21, 0xe6, 0xa6, 0xa2, 0xc8, 0x88,
	0xf1, 0xef, 0x97, 0x3c, 0x12, 0xad, 0xad, 0x2c, 0x9b, 0x16, 0xc8, 0xe7, 0x00, 0xc9, 0xdb, 0x0d,
	0x89, 0x93, 0x53, 0xde, 0x05, 0x5b, 0x0f, 0xd3, 0xed, 0x53, 0xea, 0x71, 0x87, 0x16, 0xc8, 0xa7,
	0x50, 0x7f, 0xc1, 0x45, 0xf2, 0x0c, 0x91, 0x15, 0xbc, 0xf3, 0x96, 0x42, 0x0b, 0xe4, 0x50, 0xbf,
	0x5a, 0x48, 0x15, 0x2b, 0xf0, 0x9d, 0x34, 0x1c, 0x2f, 0xdd, 0xb4, 0x40, 0xbe, 0x86, 0xa6, 0xdc,
	0x3f, 0xa9, 0x4e, 0x31, 0x22, 0x06, 0x98, 0xdc, 0x1f, 0x5a, 0x0f, 0xee, 0x76, 0x94, 0x72, 0x94,
	0x16, 0xc8, 0x11, 0xec, 0xc4, 0x0a, 0xe2, 0x26, 0x35, 0x47, 0xc3, 0x5e, 0x5e, 0x93, 0xa8, 0x75,
	0x3c, 0x85, 0xed, 0x58, 0xc7, 0x50, 0x84, 0xdc, 0x5a, 0xac, 0xb8, 0x9e, 0xe9, 0x8d, 0x69, 0xe1,
	0xd3, 0x22, 0xe9, 0xc0, 0xc3, 0x3b, 0x66, 0x73, 0x45, 0x73, 0x9b, 0x53, 0x54, 0x71, 0x08, 0x95,
	0x17, 0x5c, 0x69, 0x20, 0x39, 0x0b, 0xbd, 0x6a, 0x94, 0x7c, 0x05, 0x4d, 0x83, 0x4f, 0xba, 0xf1,
	0x1c, 0xb9, 0x37, 0x58, 0x24, 0x5f, 0xe3, 0x62, 0xc6, 0x17, 0x0d, 0xf2, 0x60, 0xf5, 0x36, 0xa2,
	0x67, 0xea, 0xfe, 0x5d, 0xfe, 0x94, 0x3b, 0xb4, 0x40, 0x0e, 0xa0, 0xfc, 0x82, 0x8b, 0xd1, 0x79,
	0xae, 0xd5, 0xa4, 0x41, 0xa5, 0x05, 0xf2, 0x19, 0x80, 0x31, 0xf5, 0x06, 0x78, 0x33, 0x86, 0xf7,
	0x3d, 0x13, 0x60, 0x1b, 0xa5, 0x18, 0xb7, 0xb9, 0x1b, 0x88, 0x5c, 0x29, 0x93, 0xd8, 0x1a, 0x43,
	0x0b, 0xf2, 0xea, 0xf1, 0x82, 0x8b, 0xce, 0x51, 0x3f, 0x17, 0x0f, 0xa6, 0x7d, 0x3d, 0xea, 0x2b,
	0xec, 0x90, 0x7b, 0xce, 0xe8, 0x9c, 0x24, 0xce, 0xb6, 0xf2, 0x5a, 0x72, 0x2a, 0x37, 0xfb, 0xc6,
	0xd0, 0x9d, 0x7a, 0x59, 0x6c, 0x26, 0xc6, 0x8f, 0xa1, 0xa2, 0x8a, 0x46, 0xbe, 0xbe, 0x74, 0x27,
	0x8f, 0x33, 0x52, 0x51, 0x16, 0x46, 0xe7, 0xa4, 0x11, 0xa3, 0x65, 0x0a, 0xc5, 0xfb, 0x6f, 0xf5,
	0xfa, 0x80, 0xbb, 0x49, 0xa6, 0x88, 0xaa, 0x0d, 0xff, 0x2d, 0x45, 0x10, 0x41, 0x0b, 0xe4, 0x77,
	0x98, 0x22, 0x48, 0x75, 0x3c, 0xe7, 0x2c, 0xf4, 0xfd, 0x49, 0x5c, 0x23, 0xb2, 0x8f, 0x2f, 0xb1,
	0x9f, 0x9a, 0x8d, 0x58, 0x5c, 0x83, 0x46, 0x37, 0xe4, 0x52, 0x5e, 0x3f, 0xc5, 0x24, 0xaf, 0x02,
	0xea, 0x0e, 0xd1, 0x5a, 0xb9, 0x12, 0xe0, 0xf6, 0xa9, 0xc9, 0x35, 0x50, 0x74, 0xb4, 0x92, 0xff,
	0x24, 0x0b, 0xd7, 0x81, 0x7d, 0x0a, 0xb5, 0x13, 0xdf, 0xbe, 0x7c, 0x0b, 0x23, 0x6d, 0x68, 0x7c,
	0xeb, 0xcd, 0xdf, 0x4e, 0xe6, 0x0b, 0x68, 0xa8, 0x3b, 0x8a, 0x91, 0x31, 0x41, 0xa7, 0x6f, 0x2e,
	0xf9, 0x72, 0xbd, 0x9b, 0xb4, 0xdc, 0x1d, 0x5b, 0xf9, 0x85, 0xf9, 0x2b, 0xb8, 0x9f, 0x91, 0x7b,
	0xa9, 0xaf, 0x24, 0xff, 0xab, 0xfc, 0x33, 0x68, 0xfc, 0x7e, 0xc9, 0xc3, 0xdb, 0xae, 0xef, 0x89,
	0xd0, 0xb2, 0x93, 0x02, 0x8a, 0xdc, 0x37, 0x08, 0x75, 0x80, 0x64, 0x84, 0x54, 0xb6, 0xec, 0xa4,
	0x33, 0x43, 0x89, 0x3f, 0xb8, 0xc3, 0x32, 0x8b, 0xfe, 0x14, 0xd3, 0x0c, 0x9b, 0x56, 0x92, 0x7e,
	0x2c, 0xd3, 0x2d, 0x6c, 0x2b, 0xfd, 0x32, 0x14, 0x2f, 0xa0, 0x14, 0x79, 0x8d, 0xed, 0xfd, 0x4e,
	0xaa, 0xe5, 0x5f, 0x91, 0x30, 0xb7, 0x04, 0x2c, 0xd4, 0xdb, 0x49, 0x96, 0x28, 0xc1, 0xd5, 0xd4,
	0x54, 0x4f, 0x72, 0xb1, 0xa3, 0x2b, 0x97, 0x23, 0x75, 0x8c, 0xa9, 0xfc, 0xc6, 0x2b, 0xd0, 0x1b,
	0xc4, 0x57, 0xae, 0x4c, 0xb4, 0x40, 0x3e, 0xc1, 0x04, 0x8d, 0x3b, 0xff, 0x74, 0xaf, 0x1f, 0x7b,
	0x6a, 0x46, 0x71, 0xf9, 0xf1, 0x38, 0xc0, 0xd6, 0x4d, 0xd7, 0x74, 0x13, 0xe2, 0x73, 0x77, 0x2e,
	0x54, 0x5f, 0xdc, 0xca, 0x74, 0x78, 0x58, 0xd0, 0x9f, 0xa9, 0x27, 0x2f, 0x64, 0x44, 0x79, 0x22,
	0xcd, 0xb4, 0x88, 0x9e, 0x96, 0x2f, 0xa0, 0x21, 0x43, 0x4a, 0x3a, 0x79, 0x03, 0x8a, 0x9b, 0xff,
	0xf8, 0xe0, 0x4c, 0x40, 0xb4, 0x40, 0xbe, 0xc4, 0xad, 0x9e, 0xed, 0x26, 0xf3, 0x4f, 0x9e, 0x0c,
	0x86, 0x16, 0xc8, 0x09, 0xdc, 0x7b, 0xc1, 0xc5, 0x9d, 0x9e, 0xb0, 0x65, 0x84, 0xef, 0x76, 0x95,
	0x71, 0x89, 0x5a, 0x1d, 0xa3, 0x05, 0x72, 0x0c, 0xf7, 0x95, 0x1f, 0x93, 0xee, 0xcc, 0xf2, 0xa6,
	0xfc, 0x2c, 0xf4, 0xa7, 0xf8, 0xb0, 0x9a, 0x57, 0xaf, 0xde, 0x49, 0x75, 0xe4, 0x59, 0x38, 0x2d,
	0x5c, 0x6c, 0xe0, 0x7f, 0xa6, 0x67, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff, 0xc7, 0x7d, 0x4d, 0x37,
	0xcd, 0x1a, 0x00, 0x00,
}
