<?php

/**
 * @package   Elabftw\Elabftw
 * @author    Nicolas CARPi <nico-git@deltablot.email>
 * @copyright 2012 Nicolas CARPi
 * @license   https://www.gnu.org/licenses/agpl-3.0.html AGPL-3.0
 * @see       https://www.elabftw.net Official website
 */

declare(strict_types=1);

namespace Elabftw\Exceptions;

use Exception;

/**
 * Throw this if the device token is not valid
 */
final class InvalidDeviceTokenException extends Exception
{
    public function __construct()
    {
        parent::__construct(_('This browser cannot login anymore because of too many failed attempts.'));
    }
}
