# System.Data.SqlClient

``` diff
+namespace System.Data.SqlClient {
+    public enum ApplicationIntent {
+        ReadOnly = 1,
+        ReadWrite = 0,
+    }
+    public enum SortOrder {
+        Ascending = 0,
+        Descending = 1,
+        Unspecified = -1,
+    }
+    public sealed class SqlBulkCopy : IDisposable {
+        public SqlBulkCopy(SqlConnection connection);
+        public SqlBulkCopy(SqlConnection connection, SqlBulkCopyOptions copyOptions, SqlTransaction externalTransaction);
+        public SqlBulkCopy(string connectionString);
+        public SqlBulkCopy(string connectionString, SqlBulkCopyOptions copyOptions);
+        public int BatchSize { get; set; }
+        public int BulkCopyTimeout { get; set; }
+        public SqlBulkCopyColumnMappingCollection ColumnMappings { get; }
+        public string DestinationTableName { get; set; }
+        public bool EnableStreaming { get; set; }
+        public int NotifyAfter { get; set; }
+        public event SqlRowsCopiedEventHandler SqlRowsCopied;
+        public void Close();
+        void System.IDisposable.Dispose();
+        public void WriteToServer(DbDataReader reader);
+        public Task WriteToServerAsync(DbDataReader reader);
+        public Task WriteToServerAsync(DbDataReader reader, CancellationToken cancellationToken);
+    }
+    public sealed class SqlBulkCopyColumnMapping {
+        public SqlBulkCopyColumnMapping();
+        public SqlBulkCopyColumnMapping(int sourceColumnOrdinal, int destinationOrdinal);
+        public SqlBulkCopyColumnMapping(int sourceColumnOrdinal, string destinationColumn);
+        public SqlBulkCopyColumnMapping(string sourceColumn, int destinationOrdinal);
+        public SqlBulkCopyColumnMapping(string sourceColumn, string destinationColumn);
+        public string DestinationColumn { get; set; }
+        public int DestinationOrdinal { get; set; }
+        public string SourceColumn { get; set; }
+        public int SourceOrdinal { get; set; }
+    }
+    public sealed class SqlBulkCopyColumnMappingCollection : ICollection, IEnumerable, IList {
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public SqlBulkCopyColumnMapping this[int index] { get; }
+        public SqlBulkCopyColumnMapping Add(SqlBulkCopyColumnMapping bulkCopyColumnMapping);
+        public SqlBulkCopyColumnMapping Add(int sourceColumnIndex, int destinationColumnIndex);
+        public SqlBulkCopyColumnMapping Add(int sourceColumnIndex, string destinationColumn);
+        public SqlBulkCopyColumnMapping Add(string sourceColumn, int destinationColumnIndex);
+        public SqlBulkCopyColumnMapping Add(string sourceColumn, string destinationColumn);
+        public void Clear();
+        public bool Contains(SqlBulkCopyColumnMapping value);
+        public void CopyTo(SqlBulkCopyColumnMapping[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(SqlBulkCopyColumnMapping value);
+        public void Insert(int index, SqlBulkCopyColumnMapping value);
+        public void Remove(SqlBulkCopyColumnMapping value);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public enum SqlBulkCopyOptions {
+        CheckConstraints = 2,
+        Default = 0,
+        FireTriggers = 16,
+        KeepIdentity = 1,
+        KeepNulls = 8,
+        TableLock = 4,
+        UseInternalTransaction = 32,
+    }
+    public sealed class SqlClientFactory : DbProviderFactory {
+        public static readonly SqlClientFactory Instance;
+        public override DbCommand CreateCommand();
+        public override DbConnection CreateConnection();
+        public override DbConnectionStringBuilder CreateConnectionStringBuilder();
+        public override DbParameter CreateParameter();
+    }
+    public sealed class SqlCommand : DbCommand {
+        public SqlCommand();
+        public SqlCommand(string cmdText);
+        public SqlCommand(string cmdText, SqlConnection connection);
+        public SqlCommand(string cmdText, SqlConnection connection, SqlTransaction transaction);
+        public override string CommandText { get; set; }
+        public override int CommandTimeout { get; set; }
+        public override CommandType CommandType { get; set; }
+        public new SqlConnection Connection { get; set; }
+        protected override DbConnection DbConnection { get; set; }
+        protected override DbParameterCollection DbParameterCollection { get; }
+        protected override DbTransaction DbTransaction { get; set; }
+        public override bool DesignTimeVisible { get; set; }
+        public new SqlParameterCollection Parameters { get; }
+        public new SqlTransaction Transaction { get; set; }
+        public override UpdateRowSource UpdatedRowSource { get; set; }
+        public event StatementCompletedEventHandler StatementCompleted;
+        public override void Cancel();
+        protected override DbParameter CreateDbParameter();
+        public new SqlParameter CreateParameter();
+        protected override void Dispose(bool disposing);
+        protected override DbDataReader ExecuteDbDataReader(CommandBehavior behavior);
+        protected override Task<DbDataReader> ExecuteDbDataReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public override int ExecuteNonQuery();
+        public override Task<int> ExecuteNonQueryAsync(CancellationToken cancellationToken);
+        public new SqlDataReader ExecuteReader();
+        public new SqlDataReader ExecuteReader(CommandBehavior behavior);
+        public new Task<SqlDataReader> ExecuteReaderAsync();
+        public new Task<SqlDataReader> ExecuteReaderAsync(CommandBehavior behavior);
+        public new Task<SqlDataReader> ExecuteReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public new Task<SqlDataReader> ExecuteReaderAsync(CancellationToken cancellationToken);
+        public override object ExecuteScalar();
+        public override Task<object> ExecuteScalarAsync(CancellationToken cancellationToken);
+        public XmlReader ExecuteXmlReader();
+        public Task<XmlReader> ExecuteXmlReaderAsync();
+        public Task<XmlReader> ExecuteXmlReaderAsync(CancellationToken cancellationToken);
+        public override void Prepare();
+    }
+    public sealed class SqlConnection : DbConnection {
+        public SqlConnection();
+        public SqlConnection(string connectionString);
+        public Guid ClientConnectionId { get; }
+        public override string ConnectionString { get; set; }
+        public override int ConnectionTimeout { get; }
+        public override string Database { get; }
+        public override string DataSource { get; }
+        public bool FireInfoMessageEventOnUserErrors { get; set; }
+        public int PacketSize { get; }
+        public override string ServerVersion { get; }
+        public override ConnectionState State { get; }
+        public bool StatisticsEnabled { get; set; }
+        public string WorkstationId { get; }
+        public event SqlInfoMessageEventHandler InfoMessage;
+        protected override DbTransaction BeginDbTransaction(IsolationLevel isolationLevel);
+        public new SqlTransaction BeginTransaction();
+        public new SqlTransaction BeginTransaction(IsolationLevel iso);
+        public SqlTransaction BeginTransaction(IsolationLevel iso, string transactionName);
+        public SqlTransaction BeginTransaction(string transactionName);
+        public override void ChangeDatabase(string database);
+        public static void ClearAllPools();
+        public static void ClearPool(SqlConnection connection);
+        public override void Close();
+        public new SqlCommand CreateCommand();
+        protected override DbCommand CreateDbCommand();
+        protected override void Dispose(bool disposing);
+        public override void Open();
+        public override Task OpenAsync(CancellationToken cancellationToken);
+        public void ResetStatistics();
+        public IDictionary RetrieveStatistics();
+    }
+    public sealed class SqlConnectionStringBuilder : DbConnectionStringBuilder {
+        public SqlConnectionStringBuilder();
+        public SqlConnectionStringBuilder(string connectionString);
+        public ApplicationIntent ApplicationIntent { get; set; }
+        public string ApplicationName { get; set; }
+        public string AttachDBFilename { get; set; }
+        public int ConnectRetryCount { get; set; }
+        public int ConnectRetryInterval { get; set; }
+        public int ConnectTimeout { get; set; }
+        public string CurrentLanguage { get; set; }
+        public string DataSource { get; set; }
+        public bool Encrypt { get; set; }
+        public string FailoverPartner { get; set; }
+        public string InitialCatalog { get; set; }
+        public bool IntegratedSecurity { get; set; }
+        public override ICollection Keys { get; }
+        public int LoadBalanceTimeout { get; set; }
+        public int MaxPoolSize { get; set; }
+        public int MinPoolSize { get; set; }
+        public bool MultipleActiveResultSets { get; set; }
+        public bool MultiSubnetFailover { get; set; }
+        public int PacketSize { get; set; }
+        public string Password { get; set; }
+        public bool PersistSecurityInfo { get; set; }
+        public bool Pooling { get; set; }
+        public bool Replication { get; set; }
+        public override object this[string keyword] { get; set; }
+        public bool TrustServerCertificate { get; set; }
+        public string TypeSystemVersion { get; set; }
+        public string UserID { get; set; }
+        public bool UserInstance { get; set; }
+        public override ICollection Values { get; }
+        public string WorkstationID { get; set; }
+        public override void Clear();
+        public override bool ContainsKey(string keyword);
+        public override bool Remove(string keyword);
+        public override bool ShouldSerialize(string keyword);
+        public override bool TryGetValue(string keyword, out object value);
+    }
+    public class SqlDataReader : DbDataReader, IDisposable {
+        protected SqlConnection Connection { get; }
+        public override int Depth { get; }
+        public override int FieldCount { get; }
+        public override bool HasRows { get; }
+        public override bool IsClosed { get; }
+        public override int RecordsAffected { get; }
+        public override object this[int i] { get; }
+        public override object this[string name] { get; }
+        public override int VisibleFieldCount { get; }
+        public override bool GetBoolean(int i);
+        public override byte GetByte(int i);
+        public override long GetBytes(int i, long dataIndex, byte[] buffer, int bufferIndex, int length);
+        public override char GetChar(int i);
+        public override long GetChars(int i, long dataIndex, char[] buffer, int bufferIndex, int length);
+        public override string GetDataTypeName(int i);
+        public override DateTime GetDateTime(int i);
+        public virtual DateTimeOffset GetDateTimeOffset(int i);
+        public override Decimal GetDecimal(int i);
+        public override double GetDouble(int i);
+        public override IEnumerator GetEnumerator();
+        public override Type GetFieldType(int i);
+        public override T GetFieldValue<T>(int i);
+        public override Task<T> GetFieldValueAsync<T>(int i, CancellationToken cancellationToken);
+        public override float GetFloat(int i);
+        public override Guid GetGuid(int i);
+        public override short GetInt16(int i);
+        public override int GetInt32(int i);
+        public override long GetInt64(int i);
+        public override string GetName(int i);
+        public override int GetOrdinal(string name);
+        public override Type GetProviderSpecificFieldType(int i);
+        public override object GetProviderSpecificValue(int i);
+        public override int GetProviderSpecificValues(object[] values);
+        public virtual SqlBinary GetSqlBinary(int i);
+        public virtual SqlBoolean GetSqlBoolean(int i);
+        public virtual SqlByte GetSqlByte(int i);
+        public virtual SqlBytes GetSqlBytes(int i);
+        public virtual SqlChars GetSqlChars(int i);
+        public virtual SqlDateTime GetSqlDateTime(int i);
+        public virtual SqlDecimal GetSqlDecimal(int i);
+        public virtual SqlDouble GetSqlDouble(int i);
+        public virtual SqlGuid GetSqlGuid(int i);
+        public virtual SqlInt16 GetSqlInt16(int i);
+        public virtual SqlInt32 GetSqlInt32(int i);
+        public virtual SqlInt64 GetSqlInt64(int i);
+        public virtual SqlMoney GetSqlMoney(int i);
+        public virtual SqlSingle GetSqlSingle(int i);
+        public virtual SqlString GetSqlString(int i);
+        public virtual object GetSqlValue(int i);
+        public virtual int GetSqlValues(object[] values);
+        public virtual SqlXml GetSqlXml(int i);
+        public override Stream GetStream(int i);
+        public override string GetString(int i);
+        public override TextReader GetTextReader(int i);
+        public virtual TimeSpan GetTimeSpan(int i);
+        public override object GetValue(int i);
+        public override int GetValues(object[] values);
+        public virtual XmlReader GetXmlReader(int i);
+        public override bool IsDBNull(int i);
+        public override Task<bool> IsDBNullAsync(int i, CancellationToken cancellationToken);
+        public override bool NextResult();
+        public override Task<bool> NextResultAsync(CancellationToken cancellationToken);
+        public override bool Read();
+        public override Task<bool> ReadAsync(CancellationToken cancellationToken);
+    }
+    public sealed class SqlError {
+        public byte Class { get; }
+        public int LineNumber { get; }
+        public string Message { get; }
+        public int Number { get; }
+        public string Procedure { get; }
+        public string Server { get; }
+        public string Source { get; }
+        public byte State { get; }
+        public override string ToString();
+    }
+    public sealed class SqlErrorCollection : ICollection, IEnumerable {
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public SqlError this[int index] { get; }
+        public void CopyTo(Array array, int index);
+        public void CopyTo(SqlError[] array, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public sealed class SqlException : DbException {
+        public byte Class { get; }
+        public Guid ClientConnectionId { get; }
+        public SqlErrorCollection Errors { get; }
+        public int LineNumber { get; }
+        public int Number { get; }
+        public string Procedure { get; }
+        public string Server { get; }
+        public override string Source { get; }
+        public byte State { get; }
+        public override string ToString();
+    }
+    public sealed class SqlInfoMessageEventArgs : EventArgs {
+        public SqlErrorCollection Errors { get; }
+        public string Message { get; }
+        public string Source { get; }
+        public override string ToString();
+    }
+    public delegate void SqlInfoMessageEventHandler(object sender, SqlInfoMessageEventArgs e);
+    public sealed class SqlParameter : DbParameter {
+        public SqlParameter();
+        public SqlParameter(string parameterName, SqlDbType dbType);
+        public SqlParameter(string parameterName, SqlDbType dbType, int size);
+        public SqlParameter(string parameterName, SqlDbType dbType, int size, string sourceColumn);
+        public SqlParameter(string parameterName, object value);
+        public SqlCompareOptions CompareInfo { get; set; }
+        public override DbType DbType { get; set; }
+        public override ParameterDirection Direction { get; set; }
+        public override bool IsNullable { get; set; }
+        public int LocaleId { get; set; }
+        public int Offset { get; set; }
+        public override string ParameterName { get; set; }
+        public new byte Precision { get; set; }
+        public new byte Scale { get; set; }
+        public override int Size { get; set; }
+        public override string SourceColumn { get; set; }
+        public override bool SourceColumnNullMapping { get; set; }
+        public SqlDbType SqlDbType { get; set; }
+        public object SqlValue { get; set; }
+        public string TypeName { get; set; }
+        public override object Value { get; set; }
+        public string XmlSchemaCollectionDatabase { get; set; }
+        public string XmlSchemaCollectionName { get; set; }
+        public string XmlSchemaCollectionOwningSchema { get; set; }
+        public override void ResetDbType();
+        public void ResetSqlDbType();
+        public override string ToString();
+    }
+    public sealed class SqlParameterCollection : DbParameterCollection {
+        public override int Count { get; }
+        public override object SyncRoot { get; }
+        public new SqlParameter this[int index] { get; set; }
+        public new SqlParameter this[string parameterName] { get; set; }
+        public SqlParameter Add(SqlParameter value);
+        public override int Add(object value);
+        public SqlParameter Add(string parameterName, SqlDbType sqlDbType);
+        public SqlParameter Add(string parameterName, SqlDbType sqlDbType, int size);
+        public override void AddRange(Array values);
+        public void AddRange(SqlParameter[] values);
+        public SqlParameter AddWithValue(string parameterName, object value);
+        public override void Clear();
+        public bool Contains(SqlParameter value);
+        public override bool Contains(object value);
+        public override bool Contains(string value);
+        public override void CopyTo(Array array, int index);
+        public void CopyTo(SqlParameter[] array, int index);
+        public override IEnumerator GetEnumerator();
+        protected override DbParameter GetParameter(int index);
+        protected override DbParameter GetParameter(string parameterName);
+        public int IndexOf(SqlParameter value);
+        public override int IndexOf(object value);
+        public override int IndexOf(string parameterName);
+        public void Insert(int index, SqlParameter value);
+        public override void Insert(int index, object value);
+        public void Remove(SqlParameter value);
+        public override void Remove(object value);
+        public override void RemoveAt(int index);
+        public override void RemoveAt(string parameterName);
+        protected override void SetParameter(int index, DbParameter value);
+        protected override void SetParameter(string parameterName, DbParameter value);
+    }
+    public class SqlRowsCopiedEventArgs : EventArgs {
+        public SqlRowsCopiedEventArgs(long rowsCopied);
+        public bool Abort { get; set; }
+        public long RowsCopied { get; }
+    }
+    public delegate void SqlRowsCopiedEventHandler(object sender, SqlRowsCopiedEventArgs e);
+    public sealed class SqlTransaction : DbTransaction {
+        public new SqlConnection Connection { get; }
+        protected override DbConnection DbConnection { get; }
+        public override IsolationLevel IsolationLevel { get; }
+        public override void Commit();
+        protected override void Dispose(bool disposing);
+        public override void Rollback();
+        public void Rollback(string transactionName);
+        public void Save(string savePointName);
+    }
+}
```

