# System

``` diff
 namespace System {
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct IntPtr : IEquatable<IntPtr>, ISerializable {
-        bool System.IEquatable<System.IntPtr>.Equals(IntPtr value);
+        bool System.IEquatable<System.IntPtr>.Equals(IntPtr other);
     }
     public static class Math {
+        public static double Acosh(double d);
+        public static double Asinh(double d);
+        public static double Atanh(double d);
+        public static double Cbrt(double d);
     }
     public static class MathF {
+        public static float Acosh(float x);
+        public static float Asinh(float x);
+        public static float Atanh(float x);
+        public static float Cbrt(float x);
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Memory<T> {
+        public Memory(MemoryManager<T> manager, int start, int length);
+        public static Memory<T> CreateFromPinnedArray(T[] array, int start, int length);
-        public static implicit operator Memory<T> (ArraySegment<T> arraySegment);
+        public static implicit operator Memory<T> (ArraySegment<T> segment);
+        public MemoryHandle Pin();
-        public MemoryHandle Retain(bool pin=false);

+        public override string ToString();
-        public bool TryGetArray(out ArraySegment<T> arraySegment);

     }
     public static class MemoryExtensions {
-        public static ReadOnlySpan<byte> AsBytes<T>(this ReadOnlySpan<T> source) where T : struct;

-        public static Span<byte> AsBytes<T>(this Span<T> source) where T : struct;

+        public static ReadOnlyMemory<char> AsMemory(this string text);
+        public static ReadOnlyMemory<char> AsMemory(this string text, int start);
+        public static ReadOnlyMemory<char> AsMemory(this string text, int start, int length);
+        public static Memory<T> AsMemory<T>(this ArraySegment<T> segment);
+        public static Memory<T> AsMemory<T>(this ArraySegment<T> segment, int start);
+        public static Memory<T> AsMemory<T>(this ArraySegment<T> segment, int start, int length);
+        public static Memory<T> AsMemory<T>(this T[] array);
+        public static Memory<T> AsMemory<T>(this T[] array, int start);
+        public static Memory<T> AsMemory<T>(this T[] array, int start, int length);
-        public static ReadOnlyMemory<char> AsReadOnlyMemory(this string text);

-        public static ReadOnlyMemory<char> AsReadOnlyMemory(this string text, int start);

-        public static ReadOnlyMemory<char> AsReadOnlyMemory(this string text, int start, int length);

-        public static ReadOnlyMemory<T> AsReadOnlyMemory<T>(this Memory<T> memory);

-        public static ReadOnlySpan<char> AsReadOnlySpan(this string text);

-        public static ReadOnlySpan<char> AsReadOnlySpan(this string text, int start);

-        public static ReadOnlySpan<char> AsReadOnlySpan(this string text, int start, int length);

-        public static ReadOnlySpan<T> AsReadOnlySpan<T>(this ArraySegment<T> arraySegment);

-        public static ReadOnlySpan<T> AsReadOnlySpan<T>(this Span<T> span);

-        public static ReadOnlySpan<T> AsReadOnlySpan<T>(this T[] array);

+        public static ReadOnlySpan<char> AsSpan(this string text);
+        public static ReadOnlySpan<char> AsSpan(this string text, int start);
+        public static ReadOnlySpan<char> AsSpan(this string text, int start, int length);
-        public static Span<T> AsSpan<T>(this ArraySegment<T> arraySegment);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, int start);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, int start, int length);
+        public static Span<T> AsSpan<T>(this T[] array, int start);
+        public static Span<T> AsSpan<T>(this T[] array, int start, int length);
+        public static int CompareTo(this ReadOnlySpan<char> span, ReadOnlySpan<char> other, StringComparison comparisonType);
+        public static bool Contains(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
-        public static void CopyTo<T>(this T[] array, Memory<T> destination);
+        public static void CopyTo<T>(this T[] source, Memory<T> destination);
-        public static void CopyTo<T>(this T[] array, Span<T> destination);
+        public static void CopyTo<T>(this T[] source, Span<T> destination);
+        public static bool EndsWith(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static bool Equals(this ReadOnlySpan<char> span, ReadOnlySpan<char> other, StringComparison comparisonType);
+        public static int IndexOf(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static bool IsWhiteSpace(this ReadOnlySpan<char> span);
-        public static ReadOnlySpan<TTo> NonPortableCast<TFrom, TTo>(this ReadOnlySpan<TFrom> source) where TFrom : struct where TTo : struct;

-        public static Span<TTo> NonPortableCast<TFrom, TTo>(this Span<TFrom> source) where TFrom : struct where TTo : struct;

-        public static bool Overlaps<T>(this ReadOnlySpan<T> first, ReadOnlySpan<T> second);
+        public static bool Overlaps<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other);
-        public static bool Overlaps<T>(this ReadOnlySpan<T> first, ReadOnlySpan<T> second, out int elementOffset);
+        public static bool Overlaps<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other, out int elementOffset);
-        public static bool Overlaps<T>(this Span<T> first, ReadOnlySpan<T> second);
+        public static bool Overlaps<T>(this Span<T> span, ReadOnlySpan<T> other);
-        public static bool Overlaps<T>(this Span<T> first, ReadOnlySpan<T> second, out int elementOffset);
+        public static bool Overlaps<T>(this Span<T> span, ReadOnlySpan<T> other, out int elementOffset);
-        public static int SequenceCompareTo<T>(this ReadOnlySpan<T> first, ReadOnlySpan<T> second) where T : IComparable<T>;
+        public static int SequenceCompareTo<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IComparable<T>;
-        public static int SequenceCompareTo<T>(this Span<T> first, ReadOnlySpan<T> second) where T : IComparable<T>;
+        public static int SequenceCompareTo<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IComparable<T>;
-        public static bool SequenceEqual<T>(this ReadOnlySpan<T> first, ReadOnlySpan<T> second) where T : IEquatable<T>;
+        public static bool SequenceEqual<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>;
-        public static bool SequenceEqual<T>(this Span<T> first, ReadOnlySpan<T> second) where T : IEquatable<T>;
+        public static bool SequenceEqual<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>;
+        public static bool StartsWith(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static int ToLower(this ReadOnlySpan<char> source, Span<char> destination, CultureInfo culture);
+        public static int ToLowerInvariant(this ReadOnlySpan<char> source, Span<char> destination);
+        public static int ToUpper(this ReadOnlySpan<char> source, Span<char> destination, CultureInfo culture);
+        public static int ToUpperInvariant(this ReadOnlySpan<char> source, Span<char> destination);
+        public static ReadOnlySpan<char> Trim(this ReadOnlySpan<char> span);
+        public static ReadOnlySpan<char> Trim(this ReadOnlySpan<char> span, char trimChar);
+        public static ReadOnlySpan<char> Trim(this ReadOnlySpan<char> span, ReadOnlySpan<char> trimChars);
+        public static ReadOnlySpan<char> TrimEnd(this ReadOnlySpan<char> span);
+        public static ReadOnlySpan<char> TrimEnd(this ReadOnlySpan<char> span, char trimChar);
+        public static ReadOnlySpan<char> TrimEnd(this ReadOnlySpan<char> span, ReadOnlySpan<char> trimChars);
+        public static ReadOnlySpan<char> TrimStart(this ReadOnlySpan<char> span);
+        public static ReadOnlySpan<char> TrimStart(this ReadOnlySpan<char> span, char trimChar);
+        public static ReadOnlySpan<char> TrimStart(this ReadOnlySpan<char> span, ReadOnlySpan<char> trimChars);
-        public static bool TryGetString(this ReadOnlyMemory<char> readOnlyMemory, out string text, out int start, out int length);

     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct ReadOnlyMemory<T> {
-        public static implicit operator ReadOnlyMemory<T> (ArraySegment<T> arraySegment);
+        public static implicit operator ReadOnlyMemory<T> (ArraySegment<T> segment);
+        public MemoryHandle Pin();
-        public MemoryHandle Retain(bool pin=false);

+        public override string ToString();
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct ReadOnlySpan<T> {
-        public static ReadOnlySpan<T> DangerousCreate(object obj, ref T objectData, int length);

-        public static implicit operator ReadOnlySpan<T> (ArraySegment<T> arraySegment);
+        public static implicit operator ReadOnlySpan<T> (ArraySegment<T> segment);
+        public override string ToString();
     }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SequencePosition : IEquatable<SequencePosition> {
+        public SequencePosition(object @object, int integer);
+        public override bool Equals(object obj);
+        public bool Equals(SequencePosition other);
+        public override int GetHashCode();
+        public int GetInteger();
+        public object GetObject();
+        public static bool operator ==(SequencePosition left, SequencePosition right);
+        public static bool operator !=(SequencePosition left, SequencePosition right);
+    }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Span<T> {
-        public static Span<T> DangerousCreate(object obj, ref T objectData, int length);

-        public static implicit operator Span<T> (ArraySegment<T> arraySegment);
+        public static implicit operator Span<T> (ArraySegment<T> segment);
+        public override string ToString();
     }
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
+        public static StringComparer Create(CultureInfo culture, CompareOptions options);
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct UIntPtr : IEquatable<UIntPtr>, ISerializable {
-        bool System.IEquatable<System.UIntPtr>.Equals(UIntPtr value);
+        bool System.IEquatable<System.UIntPtr>.Equals(UIntPtr other);
     }
 }
```

